<?php

/************************************************************************/
/* PHP-NUKE: Web Portal System                                          */
/* ===========================                                          */
/*                                                                      */
/* Copyright (c) 2002 by Francisco Burzi                                */
/* http://phpnuke.org                                                   */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

if (!eregi("modules.php", $PHP_SELF)) {
	die ("You can't access this file directly...");
}

require_once("mainfile.php");
$module_name = basename(dirname(__FILE__));
get_lang($module_name);
$userpage = 1;

include("modules/$module_name/navbar.php");

function userCheck($uname, $email) {
    global $stop, $user_prefix, $dbi;
    if ((!$email) || ($email=="") || (!eregi("^[_\.0-9a-z-]+@([0-9a-z][0-9a-z-]+\.)+[a-z]{2,6}$",$email))) $stop = "<center>"._ERRORINVEMAIL."</center><br>";
    if (strrpos($email,' ') > 0) $stop = "<center>"._ERROREMAILSPACES."</center>";
    if ((!$uname) || ($uname=="") || (ereg("[^a-zA-Z0-9_-]",$uname))) $stop = "<center>"._ERRORINVNICK."</center><br>";
    if (strlen($uname) > 25) $stop = "<center>"._NICK2LONG."</center>";
    if (eregi("^((root)|(adm)|(linux)|(webmaster)|(admin)|(god)|(administrator)|(administrador)|(nobody)|(anonymous)|(anonimo)|(annimo)|(operator))$",$uname)) $stop = "<center>"._NAMERESERVED."";
    if (strrpos($uname,' ') > 0) $stop = "<center>"._NICKNOSPACES."</center>";
    if (sql_num_rows(sql_query("select uname from ".$user_prefix."_users where uname='$uname'", $dbi), $dbi) > 0) $stop = "<center>"._NICKTAKEN."</center><br>";
    if (sql_num_rows(sql_query("select email from ".$user_prefix."_users where email='$email'", $dbi), $dbi) > 0) $stop = "<center>"._EMAILREGISTERED."</center><br>";
    return($stop);
}

function makePass() {
    $cons = "bcdfghjklmnpqrstvwxyz";
    $vocs = "aeiou";
    for ($x=0; $x < 6; $x++) {
	mt_srand ((double) microtime() * 1000000);
	$con[$x] = substr($cons, mt_rand(0, strlen($cons)-1), 1);
	$voc[$x] = substr($vocs, mt_rand(0, strlen($vocs)-1), 1);
    }
    $makepass = $con[0] . $voc[0] .$con[2] . $con[1] . $voc[1] . $con[3] . $voc[3] . $con[4];
    return($makepass);
}

function confirmNewUser($uname, $email, $url, $user_avatar, $user_icq, $user_occ, $user_from, $user_intrest, $user_sig, $user_viewemail, $user_aim, $user_yim, $user_msnm) {
    global $stop, $EditedMessage, $sitename, $module_name;
    include("header.php");
    filter_text($uname);
    $uname = $EditedMessage;
    if($user_viewemail == 1) {
	$user_viewemail = "1";
    } else {
	$user_viewemail = "0";
    }
    userCheck($uname, $email);
    if (!$stop) {
	title("$sitename: "._USERREGLOGIN."");
	OpenTable();
	echo "<center><b>"._USERFINALSTEP."</b><br><br>$uname, "._USERCHECKDATA."</center><br><br>";
	echo "<b>"._UUSERNAME.":</b> $uname<br>"
	    ."<b>"._EMAIL.":</b> $email<br>"; 
	if (($user_avatar) || ($user_avatar!="")) echo "<b>"._AVATAR.":</b> <img src=\"images/forum/avatar/$user_avatar\" alt=\"\"><br>";
	if (($url) || ($url!="")) echo "<b>"._WEBSITE.":</b> $url<br>";
	if (($user_icq) || ($user_icq!="")) echo "<b>"._ICQ.":</b> $user_icq<br>";			
	if (($user_aim) || ($user_aim!="")) echo "<b>"._AIM.":</b> $user_aim<br>";
	if (($user_yim) || ($user_yim!="")) echo "<b>"._YIM.":</b> $user_yim<br>";
	if (($user_msnm) || ($user_msnm!="")) echo "<b>"._MSNM.":</b> $user_msnm<br>";
	if (($user_from) || ($user_from!="")) echo "<b>"._LOCATION.":</b> $user_from<br>";
	if (($user_occ) || ($user_occ!="")) echo "<b>"._OCCUPATION.":</b> $user_occ<br>";
	if (($user_intrest) || ($user_intrest!="")) echo "<b>"._INTERESTS.":</b> $user_intrest<br>";			
	if (($user_sig) || ($user_sig!="")) echo "<b>"._SIGNATURE.":</b> $user_sig<br>";
	echo "<form action=\"modules.php?name=$module_name\" method=\"post\">"
	    ."<input type=\"hidden\" name=\"uname\" value=\"$uname\">"
	    ."<input type=\"hidden\" name=\"email\" value=\"$email\">"
	    ."<input type=\"hidden\" name=\"user_avatar\" value=\"$user_avatar\">"
	    ."<input type=\"hidden\" name=\"user_icq\" value=\"$user_icq\">"
	    ."<input type=\"hidden\" name=\"url\" value=\"$url\">"
	    ."<input type=\"hidden\" name=\"user_from\" value=\"$user_from\">"
	    ."<input type=\"hidden\" name=\"user_occ\" value=\"$user_occ\">"
	    ."<input type=\"hidden\" name=\"user_intrest\" value=\"$user_intrest\">"
	    ."<input type=\"hidden\" name=\"user_sig\" value=\"$user_sig\">"
	    ."<input type=\"hidden\" name=\"user_aim\" value=\"$user_aim\">"
	    ."<input type=\"hidden\" name=\"user_yim\" value=\"$user_yim\">"
	    ."<input type=\"hidden\" name=\"user_msnm\" value=\"$user_msnm\">"
	    ."<input type=\"hidden\" name=\"user_viewemail\" value=\"$user_viewemail\">"
	    ."<input type=\"hidden\" name=\"op\" value=\"finish\"><br><br>"
	    ."<input type=\"submit\" value=\""._FINISH."\"> &nbsp;&nbsp;"._GOBACK."</form>";
	CloseTable();
    } else {
	OpenTable();
	echo "<center><font class=\"title\"><b>Registration Error!</b></font><br><br>";
	echo "<font class=\"content\">$stop<br>"._GOBACK."</font></center>";
	CloseTable();
    }
    include("footer.php");
}

function finishNewUser($uname, $email, $url, $user_avatar, $user_icq, $user_occ, $user_from, $user_intrest, $user_sig, $user_viewemail, $user_aim, $user_yim, $user_msnm) {
    global $stop, $makepass, $EditedMessage, $adminmail, $sitename, $Default_Theme, $user_prefix, $dbi, $storyhome;
    include("header.php");
    userCheck($uname, $email);
    $user_regdate = date("M d, Y");
    if (!isset($stop)) {
	$makepass=makepass();
	$cryptpass = md5($makepass);
	$result = sql_query("insert into ".$user_prefix."_users values (NULL,'','$uname','$email','','$url','$user_avatar','$user_regdate','$user_icq','$user_occ','$user_from','$user_intrest','$user_sig','$user_viewemail','','$user_aim','$user_yim','$user_msnm','$cryptpass','$storyhome','','0','0','0','','0','','$Default_Theme','$commentlimit','0','0','0','0','0','1','1','0')", $dbi);
	if(!$result) {
	    echo ""._ERROR."<br>";
	} else {
	    $message = ""._WELCOMETO." $sitename!\n\n"._YOUUSEDEMAIL." ($email) "._TOREGISTER." $sitename. "._FOLLOWINGMEM."\n\n"._UNICKNAME." $uname\n"._UPASSWORD." $makepass";
	    $subject=""._USERPASS4." $uname";
	    $from="$adminmail";
	    mail($email, $subject, $message, "From: $from\nX-Mailer: PHP/" . phpversion());
	    title("$sitename: "._USERREGLOGIN."");
	    OpenTable();
	    echo "<center><b>"._ACCOUNTCREATED."</b><br><br>";
	    echo ""._YOUAREREGISTERED.""
	        ."<br><br>"
		.""._YOUCANLOGIN."<br><br>"
		.""._THANKSUSER." $sitename!</center>";
	    CloseTable();
	}
    } else {
	echo "$stop";
    }
    include("footer.php");
}

function userinfo($uname, $bypass=0, $hid=0, $url=0) {
    global $user, $cookie, $sitename, $prefix, $user_prefix, $dbi, $admin, $broadcast_msg, $my_headlines, $module_name;
    $result = sql_query("select uid, femail, url, bio, user_avatar, user_icq, user_aim, user_yim, user_msnm, user_from, user_occ, user_intrest, user_sig, pass, newsletter from ".$user_prefix."_users where uname='$uname'", $dbi);
    $userinfo = sql_fetch_array($result, $dbi);
    if(!$bypass) cookiedecode($user);
    include("header.php");
    OpenTable();
    echo "<center>";
    if(($uname == $cookie[1]) AND ($userinfo[pass] == $cookie[2])) {
	echo "<font class=\"option\">$uname, "._WELCOMETO." $sitename!</font><br><br>";
	echo "<font class=\"content\">"._THISISYOURPAGE."</font></center><br><br>";
	nav(1);
	echo "<br><br>";
    } else {
	echo "<font class=\"title\">"._PERSONALINFO.": $uname</font></center><br><br>";
    }
    if ($userinfo[url]) {
	if (!eregi("http://", $userinfo[url])) {
	    $userinfo[url] = "http://$userinfo[url]";
	}
    }
    if((sql_num_rows($result, $dbi)==1) && ($userinfo[url] || $userinfo[femail] || $userinfo[bio] || $userinfo[user_avatar] || $userinfo[user_icq] || $userinfo[user_aim] || $userinfo[user_yim] || $userinfo[user_msnm] || $userinfo[user_location] || $userinfo[user_occ] || $userinfo[user_intrest] || $userinfo[user_sig])) {
	echo "<center><font class=\"content\">";
	if ($userinfo[user_avatar]) echo "<img src=\"images/forum/avatar/$userinfo[user_avatar]\" alt=\"\"><br>\n";
	if ($userinfo[url] != "http://" AND $userinfo[url] != "") { echo ""._MYHOMEPAGE." <a href=\"$userinfo[url]\" target=\"new\">$userinfo[url]</a><br>\n"; }
	if ($userinfo[femail]) { echo ""._MYEMAIL." <a href=\"mailto:$userinfo[femail]\">$userinfo[femail]</a><br>\n"; }
	if ($userinfo[user_icq]) echo ""._ICQ.": $userinfo[user_icq]<br>\n";
	if ($userinfo[user_aim]) echo ""._AIM.": $userinfo[user_aim]<br>\n";
	if ($userinfo[user_yim]) echo ""._YIM.": $userinfo[user_yim]<br>\n";
	if ($userinfo[user_msnm]) echo ""._MSNM.": $userinfo[user_msnm]<br>\n";
	if ($userinfo[user_from]) echo ""._LOCATION.": $userinfo[user_from]<br>\n";
	if ($userinfo[user_occ]) echo ""._OCCUPATION.": $userinfo[user_occ]<br>\n";
	if ($userinfo[user_intrest]) echo ""._INTERESTS.": $userinfo[user_intrest]<br>\n";
	$userinfo[user_sig] = nl2br($userinfo[user_sig]);
	if ($userinfo[user_sig]) echo "<br><b>"._SIGNATURE.":</b><br>$userinfo[user_sig]<br>\n";
	if ($userinfo[bio]) { echo "<br><b>"._EXTRAINFO.":</b><br>$userinfo[bio]<br>\n"; }
	$result = sql_query("select username from ".$prefix."_session where username='$uname'", $dbi);
	list($username) = sql_fetch_row($result, $dbi);
	if ($username == "") {
	    $online = _OFFLINE;
	} else {
	    $online = _ONLINE;
	}
	echo ""._USERSTATUS.": <b>$online</b><br>\n";
	if (($userinfo[newsletter] == 1) AND ($uname == $cookie[1]) AND ($userinfo[pass] == $cookie[2]) OR (is_admin($admin) AND ($userinfo[newsletter] == 1))) {
	    echo "<i>"._SUBSCRIBED."</i><br>";
	} elseif (($userinfo[newsletter] == 0) AND ($uname == $cookie[1]) AND ($userinfo[pass] == $cookie[2]) OR (is_admin($admin) AND ($userinfo[newsletter] == 0))) {
	    echo "<i>"._NOTSUBSCRIBED."</i><br>";
	}
	if (is_active("Journal") AND $cookie[1] != $uname) {
	    $result = sql_query("select jid from ".$prefix."_journal where aid='$uname' AND status='yes' order by pdate,jid DESC limit 0,1", $dbi);
	    list($jid) = sql_fetch_row($result, $dbi);
	    if ($jid != "" AND isset($jid)) {
		echo "[ <a href=\"modules.php?name=Journal&amp;file=search&amp;bywhat=aid&amp;forwhat=$uname\">"._READMYJOURNAL."</a> ]<br>";
	    }
	}
	if (is_admin($admin)) {
	    echo "[ <a href=\"admin.php?op=modifyUser&chng_uid=$userinfo[uid]\">"._EDITUSER."</a> ]<br>";
	}
	if (((is_user($user) AND $cookie[1] != $uname) OR is_admin($admin)) AND is_active("Private_Messages")) { echo "<br>[ <a href=\"modules.php?name=Private_Messages&amp;file=reply&amp;send=1&amp;uname=$uname\">"._USENDPRIVATEMSG." $uname</a> ]<br>\n"; }
	echo "</center></font>";
    } else {
	echo "<center>"._NOINFOFOR." $uname</center>";
    }
    CloseTable();
    if ($my_headlines == 1 AND ($uname == $cookie[1]) AND ($userinfo[pass] == $cookie[2])) {
    echo "<br>";
    OpenTable();
    echo "<center><b>"._MYHEADLINES."</b><br><br>"
	.""._SELECTASITE."<br><br>"
	."<form action=\"modules.php?name=$module_name\" method=\"post\">"
	."<input type=\"hidden\" name=\"op\" value=\"userinfo\">"
	."<input type=\"hidden\" name=\"uname\" value=\"$uname\">"
	."<input type=\"hidden\" name=\"bypass\" value=\"$bypass\">"
	."<input type=\"hidden\" name=\"url\" value=\"0\">"
	."<select name=\"hid\" onChange='submit()'>\n"
	."<option value=\"0\">"._SELECTASITE2."</option>";
    $headl = sql_query("select hid, sitename from ".$prefix."_headlines order by sitename", $dbi);
    while(list($nhid, $hsitename) = sql_fetch_row($headl, $dbi)) {
	if ($hid == $nhid ) {
	    $sel = "selected";
	} else {
	    $sel = "";
	}
	echo "<option value=\"$nhid\" $sel>$hsitename</option>\n";
    }
    echo "</select></form>"
	.""._ORTYPEURL."<br><br>"
	."<form action=\"modules.php?name=$module_name\" method=\"post\">"
	."<input type=\"hidden\" name=\"op\" value=\"userinfo\">"
	."<input type=\"hidden\" name=\"uname\" value=\"$uname\">"
	."<input type=\"hidden\" name=\"bypass\" value=\"$bypass\">"
	."<input type=\"hidden\" name=\"hid\" value=\"0\">"
	."<input type=\"text\" name=\"url\" size=\"40\" maxlength=\"200\" value=\"http://\">&nbsp;&nbsp;"
	."<input type=\"submit\" value=\""._GO."\"></form>"
	."</center><br>";
    if ($hid != 0 OR ($hid == 0 AND $url != "0" AND $url != "http://") AND $url != "") {
	if ($hid != 0) {
    	    $result = sql_query("select sitename, headlinesurl from ".$prefix."_headlines where hid='$hid'", $dbi);
	    list($nsitename, $url) = sql_fetch_row($result, $dbi);
	    $title = $nsitename;
	    $siteurl = eregi_replace("http://", "", $url);
	    $siteurl = explode("/", $siteurl);
	} else {
	    if (!ereg("http://", $url)) {
		$url = "http://$url";
	    }
	    $siteurl = eregi_replace("http://", "", $url);
	    $siteurl = explode("/", $siteurl);
	    $title = "http://$siteurl[0]";
	}
	$rdf = parse_url($url);
	$fp = fsockopen($rdf['host'], 80, $errno, $errstr, 15);
	if (!$fp) {
    	    $content = "<center><font class=\"content\">"._RSSPROBLEM."</font></center>";
	}
	if ($fp) {
    	    fputs($fp, "GET " . $rdf['path'] . "?" . $rdf['query'] . " HTTP/1.0\r\n");
    	    fputs($fp, "HOST: " . $rdf['host'] . "\r\n\r\n");
    	    $string	= "";
    	    while(!feof($fp)) {
		$pagetext = fgets($fp,300);
		$string .= chop($pagetext);
	    }
	    fputs($fp,"Connection: close\r\n\r\n");
	    fclose($fp);
	    $items = explode("</item>",$string);
	    $content = "<font class=\"content\">";
	    for ($i=0;$i<10;$i++) {
		$link = ereg_replace(".*<link>","",$items[$i]);
		$link = ereg_replace("</link>.*","",$link);
		$title2 = ereg_replace(".*<title>","",$items[$i]);
		$title2 = ereg_replace("</title>.*","",$title2);
		if ($items[$i] == "" AND $cont != 1) {
	    	    $content = "<center>"._RSSPROBLEM."</center>";
		} else {
	    	    if (strcmp($link,$title2) AND $items[$i] != "") {
	    		$cont = 1;
			$content .= "<img src=\"images/arrow.gif\" border=\"0\" hspace=\"5\"><a href=\"$link\" target=\"new\">$title2</a><br>\n";
		    }
		}
	    }
	}
	if ($content != "") {
	    OpenTable2();
	    echo "<center><b>"._HEADLINESFROM." <a href=\"http://$siteurl[0]\" target=\"new\">$title</a></b></center><br>";
	    echo "$content";
	    CloseTable2();
	} elseif (($cont == 0) OR ($content == "")) {
	    OpenTable2();
	    echo "<center>"._RSSPROBLEM."</center><br>";
	    CloseTable2();
	}
	echo "<br>";
    }
    CloseTable();
    }
    if ($broadcast_msg == 1 AND ($uname == $cookie[1]) AND ($userinfo[pass] == $cookie[2])) {
	echo "<br>";
	OpenTable();
	echo "<center><b>"._BROADCAST."</b><br><br>"._BROADCASTTEXT."<br><br>"
	    ."<form action=\"modules.php?name=$module_name\" method=\"post\">"
	    ."<input type=\"hidden\" name=\"who\" value=\"$uname\">"
	    ."<input type=\"hidden\" name=\"op\" value=\"broadcast\">"
	    ."<input type=\"text\" size=\"60\" maxlength=\"255\" name=\"the_message\">&nbsp;&nbsp;<input type=\"submit\" value=\""._SEND."\">"
	    ."</form></center>";
	CloseTable();
    }
    if (is_active("Private_Messages") AND ($uname == $cookie[1]) AND ($userinfo[pass] == $cookie[2])) {
	echo "<br>";
	OpenTable();
	echo "<center><b>"._PRIVATEMESSAGES."</b><br><br>";
	$result2 = sql_query("select to_userid from ".$prefix."_priv_msgs where to_userid='$userinfo[uid]'", $dbi);
	$numrow = sql_num_rows($result2, $dbi);
	if (is_active("Members_List")) {
	    $mem_list = "<a href=\"modules.php?name=Members_List\">"._BROWSEUSERS."</a>";
	} else {
	    $mem_list = "";
	}
	if (is_active("Search")) {
	    $mod_search = "<a href=\"modules.php?name=Search&amp;type=users\">"._SEARCHUSERS."</a>";
	} else {
	    $mod_search = "";
	}
	if ($mem_list != "" AND $mod_search != "") { $a = " | "; } else { $a = ""; }
	if ($mem_list != "" OR $mod_search != "") {
	    $links = "[ $mem_list $a $mod_search ]";
	} elseif ($mem_list == "" AND $mod_search == "") {
	    $links = "";
	}
	echo ""._YOUHAVE." <a href=\"modules.php?name=Private_Messages\"><b>$numrow</b></a> "._PRIVATEMSG."<br><br>"
	    ."<form action=\"modules.php?name=Private_Messages\" method=\"post\">"
	    .""._USENDPRIVATEMSG.": <input type=\"text\" name=\"uname\" size=\"20\">&nbsp;&nbsp;$links"
	    ."<input type=\"hidden\" name=\"file\" value=\"reply\">"
	    ."<input type=\"hidden\" name=\"send\" value=\"1\">"
	    ."</form></center>";
	CloseTable();
    }
    echo "<br>";
    OpenTable();
    echo "<b>"._LAST10COMMENTS." $uname:</b><br>";
    $result = sql_query("select tid, sid, subject from ".$prefix."_comments where name='$uname' order by tid DESC limit 0,10", $dbi);
    while(list($tid, $sid, $subject) = sql_fetch_row($result, $dbi)) {
        echo "<li><a href=\"modules.php?name=News&file=article&thold=-1&mode=flat&order=0&sid=$sid#$tid\">$subject</a><br>";
    }
    CloseTable();
    echo "<br>";
    OpenTable();
    echo "<b>"._LAST10SUBMISSIONS." $uname:</b><br>";
    $result = sql_query("select sid, title from ".$prefix."_stories where informant='$uname' order by sid DESC limit 0,10", $dbi);
    while(list($sid, $title) = sql_fetch_row($result, $dbi)) {
        echo "<li><a href=\"modules.php?name=News&file=article&sid=$sid\">$title</a><br>";
    }
    CloseTable();
    include("footer.php");
}

function main($user) {
    global $stop, $module_name;
    if(!is_user($user)) {
	include("header.php");
	if ($stop) {
	    OpenTable();
	    echo "<center><font class=\"title\"><b>"._LOGININCOR."</b></font></center>\n";
	    CloseTable();
	    echo "<br>\n";
	} else {
	    OpenTable();
	    echo "<center><font class=\"title\"><b>"._USERREGLOGIN."</b></font></center>\n";
	    CloseTable();
	    echo "<br>\n";
	}
	if (!is_user($user)) {
	    OpenTable();
	    echo "<form action=\"modules.php?name=$module_name\" method=\"post\">\n"
		."<b>"._USERLOGIN."</b><br><br>\n"
		."<table border=\"0\"><tr><td>\n"
		.""._NICKNAME.":</td><td><input type=\"text\" name=\"uname\" size=\"15\" maxlength=\"25\"></td></tr>\n"
		."<tr><td>"._PASSWORD.":</td><td><input type=\"password\" name=\"pass\" size=\"15\" maxlength=\"20\"></td></tr></table>\n"
		."<input type=\"hidden\" name=\"op\" value=\"login\">\n"
		."<input type=\"submit\" value=\""._LOGIN."\"></form><br>\n\n"
		."<center><font class=\"content\">[ <a href=\"modules.php?name=$module_name&amp;op=pass_lost\">"._PASSWORDLOST."</a> | <a href=\"modules.php?name=$module_name&amp;op=new_user\">"._REGNEWUSER."</a> ]</font></center>\n";
	    CloseTable();
	}
	include("footer.php");
    } elseif (is_user($user)) {
        global $cookie;
        cookiedecode($user);
        userinfo($cookie[1]);
    }
}

function new_user() {
    global $my_headlines, $module_name;
    if (!is_user($user)) {
	include("header.php");
	OpenTable();
	echo "<center><font class=\"title\"><b>"._USERREGLOGIN."</b></font></center>\n";
	CloseTable();
	echo "<br>\n";
	OpenTable();
	echo "<form name=\"Register\" action=\"modules.php?name=$module_name\" method=\"post\">\n"
    	    ."<b>"._REGNEWUSER."</b><br><br>\n"
	    ."<table cellpadding=\"0\" cellspacing=\"10\" border=\"0\">\n"
    	    ."<tr><td>"._NICKNAME.":</td><td><input type=\"text\" name=\"uname\" size=\"30\" maxlength=\"25\"> <font class=\"tiny\">"._REQUIRED."</font></td></tr>\n"
    	    ."<tr><td>"._EMAIL.":</td><td><input type=\"text\" name=\"email\" size=\"30\" maxlength=\"255\"> <font class=\"tiny\">"._REQUIRED."</font></td></tr>\n"
    	    ."<tr><td>"._WEBSITE.":</td><td><input type=\"text\" name=\"url\" size=\"30\" maxlength=\"255\"></td></tr>\n"
    	    ."<tr><td>"._AVATAR.":</td><td>[ <a href=\"modules.php?name=$module_name&amp;op=avatarlist\">"._LIST."</a> ]&nbsp;&nbsp;\n"
    	    ."<select name=\"user_avatar\" onChange=\"showimage()\">\n";
        $direktori = "images/forum/avatar";
        $handle=opendir($direktori);
        while ($file = readdir($handle)) {
	    $filelist[] = $file;
        }
        asort($filelist);
	while (list ($key, $file) = each ($filelist)) {
	    if (ereg("blank", $file)) {
		$sel = "selected";
	    } else {
		$sel = "";
	    }
	    ereg(".gif|.jpg",$file);
	    if ($file == "." || $file == "..") {
	        $a=1;
	    } else {
		echo "<option value=\"$file\" $sel>$file</option>\n";
    	    }
	}
	echo "</select>&nbsp;&nbsp;<img src=\"images/forum/avatar/blank.gif\" name=\"avatar\" width=\"32\" height=\"32\" alt=\"\">\n"
    	    ."</td></tr>\n"
    	    ."<tr><td>"._ICQ.":</td><td><input type=\"text\" name=\"user_icq\" size=\"20\" maxlength=\"20\"></td></tr>\n"
    	    ."<tr><td>"._AIM.":</td><td><input type=\"text\" name=\"user_aim\" size=\"20\" maxlength=\"20\"></td></tr>\n"							
    	    ."<tr><td>"._YIM.":</td><td><input type=\"text\" name=\"user_yim\" size=\"20\" maxlength=\"20\"></td></tr>\n"
    	    ."<tr><td>"._MSNM.":</td><td><input type=\"text\" name=\"user_msnm\" size=\"20\" maxlength=\"20\"></td></tr>\n"
    	    ."<tr><td>"._LOCATION.":</td><td><input type=\"text\" name=\"user_from\" size=\"25\" maxlength=\"60\"></td></tr>\n"
    	    ."<tr><td>"._OCCUPATION.":</td><td><input type=\"text\" name=\"user_occ\" size=\"25\" maxlength=\"60\"></td></tr>\n"
    	    ."<tr><td>"._INTERESTS.":</td><td><input type=\"text\" name=\"user_intrest\" size=\"25\" maxlength=\"255\"></td></tr>\n"
    	    ."<tr><td>"._OPTION.":</td><td><INPUT TYPE=\"CHECKBOX\" NAME=\"user_viewemail\" VALUE=\"1\"> "._ALLOWEMAILVIEW."</td></tr>\n"
	    ."<tr><td>"._SIGNATURE.":</td><td><TEXTAREA NAME=\"user_sig\" ROWS=\"6\" COLS=\"45\"></TEXTAREA></td></tr>\n"
	    ."<tr><td>\n"
	    ."<input type=\"hidden\" name=\"op\" value=\"new user\">\n"
    	    ."<input type=\"submit\" value=\""._NEWUSER."\">\n"
    	    ."</td></tr></table>\n"
	    ."</form>\n"
	    ."<br>\n"
    	    .""._PASSWILLSEND."<br><br>\n"
    	    .""._COOKIEWARNING."<br>\n"
    	    .""._ASREGUSER."<br>\n"
	    ."<ul>\n"
    	    ."<li>"._ASREG1."\n"
    	    ."<li>"._ASREG2."\n"
    	    ."<li>"._ASREG3."\n"
    	    ."<li>"._ASREG4."\n"
    	    ."<li>"._ASREG5."\n";
	$handle=opendir('themes');
	    while ($file = readdir($handle)) {
	    if ((!ereg("[.]",$file) AND file_exists("themes/$file/theme.php"))) {
		$thmcount++;
	    }
	}
	closedir($handle);
    	if ($thmcount > 1) {
	    echo "<li>"._ASREG6."\n";
	}
	$result = sql_query("select custom_title from ".$prefix."_modules WHERE active='1' AND view='1'", $dbi);
	while (list($custom_title) = sql_fetch_row($result, $dbi)) {
	    if ($custom_title != "") {
		echo "<li>"._ACCESSTO." $custom_title\n";
	    }
	}
	$result = sql_query("select title from ".$prefix."_blocks WHERE active='1' AND view='1'", $dbi);
	while (list($b_title) = sql_fetch_row($result, $dbi)) {
	    if ($b_title != "") {
		echo "<li>"._ACCESSTO." $b_title\n";
	    }
	}
	if (is_active("Journal")) {
	    echo "<li>"._CREATEJOURNAL."\n";
	}
	if ($my_headlines == 1) {
	    echo "<li>"._READHEADLINES."\n";
	}
    	echo "<li>"._ASREG7."\n"
	    ."</ul>\n"
    	    .""._REGISTERNOW."<br>\n"
    	    .""._WEDONTGIVE."<br><br>\n"
	    ."<center><font class=\"content\">[ <a href=\"modules.php?name=$module_name\">"._USERLOGIN."</a> | <a href=\"modules.php?name=$module_name&amp;op=pass_lost\">"._PASSWORDLOST."</a> ]</font></center>\n";
	CloseTable();
	include("footer.php");
    } elseif (is_user($user)) {
	global $cookie;
	cookiedecode($user);
	userinfo($cookie[1]);
    }
}

function pass_lost() {
    global $user, $module_name;
    if (!is_user($user)) {
	include("header.php");
	OpenTable();
	echo "<center><font class=\"title\"><b>"._USERREGLOGIN."</b></font></center>\n";
	CloseTable();
	echo "<br>\n";
	OpenTable();
	echo "<b>"._PASSWORDLOST."</b><br><br>\n"
    	    .""._NOPROBLEM."<br><br>\n"
	    ."<form action=\"modules.php?name=$module_name\" method=\"post\">\n"
	    ."<table border=\"0\"><tr><td>\n"
    	    .""._NICKNAME.":</td><td><input type=\"text\" name=\"uname\" size=\"15\" maxlength=\"25\"></td></tr>\n"
    	    ."<tr><td>"._CONFIRMATIONCODE.":</td><td><input type=\"text\" name=\"code\" size=\"11\" maxlength=\"10\"></td></tr></table><br>\n"
    	    ."<input type=\"hidden\" name=\"op\" value=\"mailpasswd\">\n"
    	    ."<input type=\"submit\" value=\""._SENDPASSWORD."\"></form><br>\n"
	    ."<center><font class=\"content\">[ <a href=\"modules.php?name=$module_name\">"._USERLOGIN."</a> | <a href=\"modules.php?name=$module_name&amp;op=new_user\">"._REGNEWUSER."</a> ]</font></center>\n";
	CloseTable();
	include("footer.php");
    } elseif(is_user($user)) {
	global $cookie;
	cookiedecode($user);
	userinfo($cookie[1]);
    }
}

function logout() {
    global $prefix, $dbi, $user, $cookie;
    cookiedecode($user);
    $r_uname = $cookie[1];
    setcookie("user");
    include("header.php");
    OpenTable();
    echo "<center><font class=\"option\"><b>"._YOUARELOGGEDOUT."</b></font></center>";
    CloseTable();
    $result = sql_query("delete from ".$prefix."_session where username='$r_uname'", $dbi);
    include("footer.php");
}

function mail_password($uname, $code) {
    global $sitename, $adminmail, $nukeurl, $user_prefix, $dbi, $module_name;
    $result = sql_query("select email, pass from ".$user_prefix."_users where (uname='$uname')", $dbi);
    if(!$result) {
	include("header.php");
	OpenTable();
	echo "<center>"._SORRYNOUSERINFO."</center>";
	CloseTable();
	include("footer.php");
    } else {
	$host_name = getenv("REMOTE_ADDR");
	list($email, $pass) = sql_fetch_row($result, $dbi);
	$areyou = substr($pass, 0, 10);
	if ($areyou==$code) {
	    $newpass=makepass();
	    $message = ""._USERACCOUNT." '$uname' "._AT." $sitename "._HASTHISEMAIL."  "._AWEBUSERFROM." $host_name "._HASREQUESTED."\n\n"._YOURNEWPASSWORD." $newpass\n\n "._YOUCANCHANGE." $nukeurl/modules.php?name=$module_name\n\n"._IFYOUDIDNOTASK."";
	    $subject = ""._USERPASSWORD4." $uname";
	    mail($email, $subject, $message, "From: $adminmail\nX-Mailer: PHP/" . phpversion());
	    /* Next step: add the new password to the database */
	    $cryptpass = md5($newpass);
	    $query="update ".$user_prefix."_users set pass='$cryptpass' where uname='$uname'";
	    if(!sql_query($query, $dbi)) {
	    	echo ""._UPDATEFAILED."";
	    }
	    include ("header.php");
	    OpenTable();
	    echo "<center>"._PASSWORD4." $uname "._MAILED."</center>";
	    CloseTable();
	    include ("footer.php");
	/* If no Code, send it */
	} else {
	    $result = sql_query("select email, pass from ".$user_prefix."_users where (uname='$uname')", $dbi);
	    if(!$result) {
		include ("header.php");
		OpenTable();
	        echo "<center>"._SORRYNOUSERINFO."</center>";
		CloseTable();
		include ("footer.php");
	    } else {
	        $host_name = getenv("REMOTE_ADDR");
	        list($email, $pass) = sql_fetch_row($result, $dbi);
	        $areyou = substr($pass, 0, 10);
    		$message = ""._USERACCOUNT." '$uname' "._AT." $sitename "._HASTHISEMAIL." "._AWEBUSERFROM." $host_name "._CODEREQUESTED."\n\n"._YOURCODEIS." $areyou \n\n"._WITHTHISCODE." $nukeurl/modules.php?name=$module_name&op=pass_lost\n"._IFYOUDIDNOTASK2."";
		$subject=""._CODEFOR." $uname";
		mail($email, $subject, $message, "From: $adminmail\nX-Mailer: PHP/" . phpversion());
		include ("header.php");
		OpenTable();
		echo "<center>"._CODEFOR." $uname "._MAILED."<br><br>"._GOBACK."</center>";
		CloseTable();
		include ("footer.php");
    	    }		
	}
    }
}

function docookie($setuid, $setuname, $setpass, $setstorynum, $setumode, $setuorder, $setthold, $setnoscore, $setublockon, $settheme, $setcommentmax) {
    $info = base64_encode("$setuid:$setuname:$setpass:$setstorynum:$setumode:$setuorder:$setthold:$setnoscore:$setublockon:$settheme:$setcommentmax");
    setcookie("user","$info",time()+2592000);
}

function login($uname, $pass) {
    global $setinfo, $user_prefix, $dbi, $module_name;
    $result = sql_query("select pass, uid, storynum, umode, uorder, thold, noscore, ublockon, theme, commentmax from ".$user_prefix."_users where uname='$uname'", $dbi);
    $setinfo = sql_fetch_array($result, $dbi);
    if ((sql_num_rows($result, $dbi)==1) AND ($setinfo[uid] != 1) AND ($setinfo[pass] != "")) {
	$dbpass=$setinfo[pass];
	$non_crypt_pass = $pass;
  	$old_crypt_pass = crypt($pass,substr($dbpass,0,2));
	$new_pass = md5($pass);
	if (($dbpass == $non_crypt_pass) OR ($dbpass == $old_crypt_pass)) {
	    sql_query("update ".$user_prefix."_users set pass='$new_pass' WHERE uname='$uname'", $dbi);
	    $result = sql_query("select pass from ".$user_prefix."_users where uname='$uname'", $dbi);
	    list($dbpass) = sql_fetch_row($result, $dbi);
	}
	if ($dbpass != $new_pass) {
            Header("Location: modules.php?name=$module_name&stop=1");
    	    return;
	}
	docookie($setinfo[uid], $uname, $new_pass, $setinfo[storynum], $setinfo[umode], $setinfo[uorder], $setinfo[thold], $setinfo[noscore], $setinfo[ublockon], $setinfo[theme], $setinfo[commentmax]);
	Header("Location: modules.php?name=$module_name&op=userinfo&bypass=1&uname=$uname");
    } else {
	Header("Location: modules.php?name=$module_name&stop=1");
    }
}

function edituser() {
    global $user, $userinfo, $cookie, $module_name;
    getusrinfo($user);
    if (($userinfo[uname] != $cookie[1]) AND ($userinfo[pass] != $cookie[2])) {
    include("header.php");
    OpenTable();
    echo "<center><font class=\"title\"><b>"._PERSONALINFO."</b></font></center>";
    CloseTable();
    echo "<br>";    
    OpenTable();
    nav();
    CloseTable();
    echo "<br>";
    if (!eregi("http://",$userinfo[url])) {
	$userinfo[url] = "http://$userinfo[url]";
    }
    OpenTable();
    echo "<table cellpadding=\"8\" border=\"0\"><tr><td>"
	."<form name=\"Register\" action=\"modules.php?name=$module_name\" method=\"post\">"
	."<b>"._UREALNAME."</b> "._OPTIONAL."<br>"
	."<input type=\"text\" name=\"realname\" value=\"$userinfo[name]\" size=\"30\" maxlength=\"60\"><br><br>"
	."<b>"._UREALEMAIL."</b> "._REQUIRED."<br>"
	.""._EMAILNOTPUBLIC."<br>"
	."<input type=\"text\" name=\"email\" value=\"$userinfo[email]\" size=\"30\" maxlength=\"255\"><br><br>"
	."<b>"._UFAKEMAIL."</b> "._OPTIONAL."<br>"
	.""._EMAILPUBLIC."<br>"
	."<input type=\"text\" name=\"femail\" value=\"$userinfo[femail]\" size=\"30\" maxlength=\"255\"><br><br>"
	."<b>"._YOURHOMEPAGE."</b> "._OPTIONAL."<br>"
	."<input type=\"text\" name=\"url\" value=\"$userinfo[url]\" size=\"30\" maxlength=\"255\"><br><br>"
	."<b>"._YOURAVATAR."</b> "._OPTIONAL."<br>[ <a href=\"modules.php?name=$module_name&amp;op=avatarlist\">"._LIST."</a> ]&nbsp;&nbsp;"
	."<select name=\"user_avatar\" onChange=\"showimage()\">"
	."<option value=\"$userinfo[user_avatar]\">$userinfo[user_avatar]</option>";
    $direktori = "images/forum/avatar";
    $handle=opendir($direktori);
    while ($file = readdir($handle)) {
	$filelist[] = $file;
    }
    asort($filelist);
    while (list ($key, $file) = each ($filelist)) {
	ereg(".gif|.jpg",$file);
	if ($file == "." || $file == "..") {
	    $a=1;
	} else {
	    echo "<option value=\"$file\">$file</option>";
	}
    }
    echo "</select>&nbsp;&nbsp;<img src=\"images/forum/avatar/$userinfo[user_avatar]\" name=\"avatar\" width=\"32\" height=\"32\" alt=\"\">"
	."<br><br>"
	."<b>"._RECEIVENEWSLETTER."</b> &nbsp;&nbsp;";
    if ($userinfo[newsletter] == 1) {
	echo "<input type=\"radio\" name=\"newsletter\" value=\"1\" checked>"._YES." &nbsp;"
	    ."<input type=\"radio\" name=\"newsletter\" value=\"0\">"._NO."";
    } elseif ($userinfo[newsletter] == 0) {
	echo "<input type=\"radio\" name=\"newsletter\" value=\"1\">"._YES." &nbsp;"
	    ."<input type=\"radio\" name=\"newsletter\" value=\"0\" checked>"._NO."";
    }
    echo "<br><br>"
	."<b>"._YICQ."</b> "._OPTIONAL."<br>"
	."<input type=\"text\" name=\"user_icq\" value=\"$userinfo[user_icq]\" size=\"30\" maxlength=\"100\"><br><br>"
	."<b>"._YAIM."</b> "._OPTIONAL."<br>"
	."<input type=\"text\" name=\"user_aim\" value=\"$userinfo[user_aim]\" size=\"30\" maxlength=\"100\"><br><br>"
	."<b>"._YYIM."</b> "._OPTIONAL."<br>"
	."<input type=\"text\" name=\"user_yim\" value=\"$userinfo[user_yim]\" size=\"30\" maxlength=\"100\"><br><br>"
	."<b>"._YMSNM."</b> "._OPTIONAL."<br>"
	."<input type=\"text\" name=\"user_msnm\" value=\"$userinfo[user_msnm]\" size=\"30\" maxlength=\"100\"><br><br>"
	."<b>"._YLOCATION."</b> "._OPTIONAL."<br>"
	."<input type=\"text\" name=\"user_from\" value=\"$userinfo[user_from]\" size=\"30\" maxlength=\"100\"><br><br>"
	."<b>"._YOCCUPATION."</b> "._OPTIONAL."<br>"
	."<input type=\"text\" name=\"user_occ\" value=\"$userinfo[user_occ]\" size=\"30\" maxlength=\"100\"><br><br>"
	."<b>"._YINTERESTS."</b> "._OPTIONAL."<br>"
	."<input type=\"text\" name=\"user_intrest\" value=\"$userinfo[user_intrest]\" size=\"30\" maxlength=\"100\"><br><br>"
	."<b>"._SIGNATURE."</b> "._OPTIONAL."<br>"
	.""._255CHARMAX."<br>"
	."<textarea wrap=\"virtual\" cols=\"50\" rows=\"5\" name=\"user_sig\">$userinfo[user_sig]</textarea><br>"
	."<br><br>"
	."<b>"._EXTRAINFO."</b> "._OPTIONAL."<br>"
	.""._CANKNOWABOUT."<br>"
	."<textarea wrap=\"virtual\" cols=\"50\" rows=\"5\" name=\"bio\">$userinfo[bio]</textarea>"
	."<br><br>"
	."<b>"._PASSWORD."</b> "._TYPENEWPASSWORD."<br>"
	."<input type=\"password\" name=\"pass\" size=\"10\" maxlength=\"20\">&nbsp;&nbsp;<input type=\"password\" name=\"vpass\" size=\"10\" maxlength=\"20\">"
	."<br><br>"
	."<input type=\"hidden\" name=\"uname\" value=\"$userinfo[uname]\">"
	."<input type=\"hidden\" name=\"uid\" value=\"$userinfo[uid]\">"
	."<input type=\"hidden\" name=\"op\" value=\"saveuser\">"
	."<input type=\"submit\" value=\""._SAVECHANGES."\">"
	."</form></td></tr></table>";
    CloseTable();
    include("footer.php");
    } else {
	main($user);
    }
}


function saveuser($uid, $realname, $uname, $email, $femail, $url, $pass, $vpass, $bio, $user_avatar, $user_icq, $user_occ, $user_from, $user_intrest, $user_sig, $user_aim, $user_yim, $user_msnm, $attach, $newsletter) {
    global $user, $cookie, $userinfo, $EditedMessage, $user_prefix, $dbi, $module_name;
    cookiedecode($user);
    $check = $cookie[1];
    $check2 = $cookie[2];
    $result = sql_query("select uid, pass from ".$user_prefix."_users where uname='$check'", $dbi);
    list($vuid, $ccpass) = sql_fetch_row($result, $dbi);
    if (($uid == $vuid) AND ($check2 == $ccpass)) {
	if (!eregi("http://", $url)) {
	    $url = "http://$url";
	}
	if ((isset($pass)) && ("$pass" != "$vpass")) {
	    echo "<center>"._PASSDIFFERENT."</center>";
	} elseif (($pass != "") && (strlen($pass) < $minpass)) {
	    echo "<center>"._YOUPASSMUSTBE." <b>$minpass</b> "._CHARLONG."</center>";
	} else {
	    if ($bio) { filter_text($bio); $bio = $EditedMessage; $bio = FixQuotes($bio); }
	    if ($pass != "") {
		cookiedecode($user);
		sql_query("LOCK TABLES ".$user_prefix."_users WRITE", $dbi);
		$pass = md5($pass);
		sql_query("update ".$user_prefix."_users set name='$realname', email='$email', femail='$femail', url='$url', pass='$pass', bio='$bio' , user_avatar='$user_avatar', user_icq='$user_icq', user_occ='$user_occ', user_from='$user_from', user_intrest='$user_intrest', user_sig='$user_sig', user_aim='$user_aim', user_yim='$user_yim', user_msnm='$user_msnm', newsletter='$newsletter' where uid='$uid'", $dbi);
		$result = sql_query("select uid, uname, pass, storynum, umode, uorder, thold, noscore, ublockon, theme from ".$user_prefix."_users where uname='$uname' and pass='$pass'", $dbi);
		if(sql_num_rows($result, $dbi)==1) {
		    $userinfo = sql_fetch_array($result, $dbi);
		    docookie($userinfo[uid],$userinfo[uname],$userinfo[pass],$userinfo[storynum],$userinfo[umode],$userinfo[uorder],$userinfo[thold],$userinfo[noscore],$userinfo[ublockon],$userinfo[theme],$userinfo[commentmax]);
		} else {
		    echo "<center>"._SOMETHINGWRONG."</center><br>";
		}
		sql_query("UNLOCK TABLES", $dbi);
	    } else {
		sql_query("update ".$user_prefix."_users set name='$realname', email='$email', femail='$femail', url='$url', bio='$bio', user_avatar='$user_avatar', user_icq='$user_icq', user_occ='$user_occ', user_from='$user_from', user_intrest='$user_intrest', user_sig='$user_sig', user_aim='$user_aim', user_yim='$user_yim', user_msnm='$user_msnm', newsletter='$newsletter' where uid='$uid'", $dbi);
	    if ($attach) {
		$a = 1;
	    } else {
		$a = 0;
	    }
	    }
	    Header("Location: modules.php?name=$module_name");
	}
    }
}

function edithome() {
    global $user, $userinfo, $Default_Theme, $cookie, $broadcast_msg, $user_news, $storyhome, $module_name;
    getusrinfo($user);
    if (($userinfo[uname] != $cookie[1]) AND ($userinfo[pass] != $cookie[2])) {
    include ("header.php");
    OpenTable();
    echo "<center><font class=\"title\"><b>"._HOMECONFIG."</b></font></center>";
    CloseTable();
    echo "<br>";    
    OpenTable();
    nav();
    CloseTable();
    echo "<br>";
    if($userinfo[theme]=="") {
        $userinfo[theme] = "$Default_Theme";
    }
    OpenTable();
    echo "<form action=\"modules.php?name=$module_name\" method=\"post\">";
    if ($user_news == 1) {
	echo "<b>"._NEWSINHOME."</b> "._MAX127." "
	    ."<input type=\"text\" name=\"storynum\" size=\"3\" maxlength=\"3\" value=\"$userinfo[storynum]\">"
	    ."<br><br>";
    } else {
	echo "<input type=\"hidden\" name=\"storynum\" value=\"$storyhome\">";
    }
    if ($userinfo[popmeson] == 1) {
        $sel1 = "checked";
        $sel2 = "";
    } elseif ($userinfo[popmeson] == 0) {
        $sel1 = "";
        $sel2 = "checked";
    }
    echo "<b>"._POPMSGACTIVE."</b> <input type=\"radio\" name=\"popmeson\" value=\"1\" $sel1> "._YES." &nbsp;&nbsp;<input type=\"radio\" name=\"popmeson\" value=\"0\" $sel2>"._NO."<br><br>";
    if ($userinfo[ublockon]==1) {
        $sel = "checked";
    }
    if ($broadcast_msg == 1) {
	if ($userinfo[broadcast] == 1) {
	    $sel1 = "checked";
	    $sel2 = "";
	} elseif ($userinfo[broadcast] == 0) {
	    $sel1 = "";
	    $sel2 = "checked";
	}
	echo "<b>"._MESSAGEACTIVATE."</b> <input type=\"radio\" name=\"broadcast\" value=\"1\" $sel1> "._YES." &nbsp;&nbsp;<input type=\"radio\" name=\"broadcast\" value=\"0\" $sel2>"._NO."<br><br>";
    } else {
	echo "<input type=\"hidden\" name=\"broadcast\" value=\"1\">";
    }
    echo "<input type=\"checkbox\" name=\"ublockon\" $sel>"
	." <b>"._ACTIVATEPERSONAL."</b>"
	."<br>"._CHECKTHISOPTION.""
	."<br>"._YOUCANUSEHTML."<br>"
	."<textarea cols=\"55\" rows=\"5\" name=\"ublock\">$userinfo[ublock]</textarea>"
	."<br><br>"
	."<input type=\"hidden\" name=\"uname\" value=\"$userinfo[uname]\">"
	."<input type=\"hidden\" name=\"uid\" value=\"$userinfo[uid]\">"
	."<input type=\"hidden\" name=\"op\" value=\"savehome\">"
	."<input type=\"submit\" value=\""._SAVECHANGES."\">"
	."</form>";
    CloseTable();
    include ("footer.php");
    } else {
	main($user);
    }
}

function chgtheme() {
    global $user, $userinfo, $Default_Theme, $cookie, $module_name;
    getusrinfo($user);
    if (($userinfo[uname] != $cookie[1]) AND ($userinfo[pass] != $cookie[2])) {
    include ("header.php");
    OpenTable();
    echo "<center><font class=\"title\"><b>"._THEMESELECTION."</b></font></center>";
    CloseTable();
    echo "<br>";
    OpenTable();
    nav();
    CloseTable();
    echo "<br>";
    OpenTable();
    echo "<center>"
	."<form action=\"modules.php?name=$module_name\" method=\"post\">"
	."<b>"._SELECTTHEME."</b><br>"
	."<select name=\"theme\">";
    $handle=opendir('themes');
    while ($file = readdir($handle)) {
	if ( (!ereg("[.]",$file) AND file_exists("themes/$file/theme.php")) ) {
		$themelist .= "$file ";
	}
    }
    closedir($handle);
    $themelist = explode(" ", $themelist);
    sort($themelist);
    for ($i=0; $i < sizeof($themelist); $i++) {
    	if($themelist[$i]!="") {
    	    echo "<option value=\"$themelist[$i]\" ";
	    if((($userinfo[theme]=="") && ($themelist[$i]=="$Default_Theme")) || ($userinfo[theme]==$themelist[$i])) echo "selected";
	    echo ">$themelist[$i]\n";
	}
    }
    if($userinfo[theme]=="") $userinfo[theme] = "$Default_Theme";
    echo "</select><br>"
	.""._THEMETEXT1."<br>"
	.""._THEMETEXT2."<br>"
	.""._THEMETEXT3."<br><br>"
	."<input type=\"hidden\" name=\"uid\" value=\"$userinfo[uid]\">"
	."<input type=\"hidden\" name=\"op\" value=\"savetheme\">"
	."<input type=\"submit\" value=\""._SAVECHANGES."\">"
	."</form>";
    CloseTable();
    include ("footer.php");
    } else {
	main($user);
    }
}


function savehome($uid, $uname, $storynum, $ublockon, $ublock, $broadcast, $popmeson) {
    global $user, $cookie, $userinfo, $user_prefix, $dbi, $module_name;
    cookiedecode($user);
    $check = $cookie[1];
    $check2 = $cookie[2];
    $result = sql_query("select uid, pass from ".$user_prefix."_users where uname='$check'", $dbi);
    list($vuid, $ccpass) = sql_fetch_row($result, $dbi);
    if (($uid == $vuid) AND ($check2 == $ccpass)) {	
	if(isset($ublockon)) $ublockon=1; else $ublockon=0;	
	$ublock = FixQuotes($ublock);
	sql_query("update ".$user_prefix."_users set storynum='$storynum', ublockon='$ublockon', ublock='$ublock', broadcast='$broadcast', popmeson='$popmeson' where uid='$uid'", $dbi);
	getusrinfo($user);
	docookie($userinfo[uid],$userinfo[uname],$userinfo[pass],$userinfo[storynum],$userinfo[umode],$userinfo[uorder],$userinfo[thold],$userinfo[noscore],$userinfo[ublockon],$userinfo[theme],$userinfo[commentmax]);
	Header("Location: modules.php?name=$module_name");
    }
}

function savetheme($uid, $theme) {
    global $user, $cookie, $userinfo, $user_prefix, $dbi, $module_name;
    cookiedecode($user);
    $check = $cookie[1];
    $check2 = $cookie[2];
    $result = sql_query("select uid, pass from ".$user_prefix."_users where uname='$check'", $dbi);
    list($vuid, $ccpass) = sql_fetch_row($result, $dbi);
    if (($uid == $vuid) AND ($check2 == $ccpass)) {
	sql_query("update ".$user_prefix."_users set theme='$theme' where uid='$uid'", $dbi);
	getusrinfo($user);
	docookie($userinfo[uid],$userinfo[uname],$userinfo[pass],$userinfo[storynum],$userinfo[umode],$userinfo[uorder],$userinfo[thold],$userinfo[noscore],$userinfo[ublockon],$userinfo[theme],$userinfo[commentmax]);
	Header("Location: modules.php?name=$module_name&theme=$theme");
    }
}

function editcomm() {
    global $user, $userinfo, $cookie, $module_name;
    getusrinfo($user);
    if (($userinfo[uname] != $cookie[1]) AND ($userinfo[pass] != $cookie[2])) {
    include ("header.php");
    OpenTable();
    echo "<center><font class=\"title\"><b>"._COMMENTSCONFIG."</b></font></center>";
    CloseTable();
    echo "<br>";    
    OpenTable();
    nav();
    CloseTable();
    echo "<br>";
    OpenTable();
    echo "<table cellpadding=\"8\" border=\"0\"><tr><td>"
	."<form action=\"modules.php?name=$module_name\" method=\"post\">"
	."<b>"._DISPLAYMODE."</b>"
	."<select name=\"umode\">";
    ?>
    <option value="nocomments" <?php if ($userinfo[umode] == 'nocomments') { echo "selected"; } ?>><?php echo _NOCOMMENTS ?>
    <option value="nested" <?php if ($userinfo[umode] == 'nested') { echo "selected"; } ?>><?php echo _NESTED ?>
    <option value="flat" <?php if ($userinfo[umode] == 'flat') { echo "selected"; } ?>><?php echo _FLAT ?>
    <option value="thread" <?php if (!isset($userinfo[umode]) || ($userinfo[umode]=="") || $userinfo[umode]=='thread') { echo "selected"; } ?>><?php echo _THREAD ?>
    </select>
    <br><br>
    <b><?php echo _SORTORDER ?></b>
    <select name="uorder">
    <option value="0" <?php if (!$userinfo[uorder]) { echo "selected"; } ?>><?php echo _OLDEST ?>
    <option value="1" <?php if ($userinfo[uorder]==1) { echo "selected"; } ?>><?php echo _NEWEST ?>
    <option value="2" <?php if ($userinfo[uorder]==2) { echo "selected"; } ?>><?php echo _HIGHEST ?>
    </select>
    <br><br>
    <b><?php echo _THRESHOLD ?></b>
    <?php echo _COMMENTSWILLIGNORED ?><br>
    <select name="thold">
    <option value="-1" <?php if ($userinfo[thold]==-1) { echo "selected"; } ?>>-1: <?php echo _UNCUT ?>
    <option value="0" <?php if ($userinfo[thold]==0) { echo "selected"; } ?>>0: <?php echo _EVERYTHING ?>
    <option value="1" <?php if ($userinfo[thold]==1) { echo "selected"; } ?>>1: <?php echo _FILTERMOSTANON ?>
    <option value="2" <?php if ($userinfo[thold]==2) { echo "selected"; } ?>>2: <?php echo _USCORE ?> +2
    <option value="3" <?php if ($userinfo[thold]==3) { echo "selected"; } ?>>3: <?php echo _USCORE ?> +3
    <option value="4" <?php if ($userinfo[thold]==4) { echo "selected"; } ?>>4: <?php echo _USCORE ?> +4
    <option value="5" <?php if ($userinfo[thold]==5) { echo "selected"; } ?>>5: <?php echo _USCORE ?> +5
    </select><br>
    <i><?php echo _SCORENOTE ?></i>
    <br><br>
    <INPUT type="checkbox" name="noscore" <?php if ($userinfo[noscore]==1) { echo "checked"; } ?>><b> <?php echo _NOSCORES ?></b> <?php echo _HIDDESCORES ?>
    <br><br>
    <b><?php echo _MAXCOMMENT ?></b> <?php echo _TRUNCATES ?><br>
    <input type="text" name="commentmax" value="<?php echo $userinfo[commentmax] ?>" size=11 maxlength=11> <?php echo _BYTESNOTE ?>
    <br><br>
    <input type="hidden" name="uname" value="<?php echo"$userinfo[uname]"; ?>">
    <input type="hidden" name="uid" value="<?php echo"$userinfo[uid]"; ?>">
    <input type="hidden" name="op" value="savecomm">
    <input type="submit" value="<?php echo _SAVECHANGES ?>">
    </form></td></tr></table>
    <?php
    CloseTable();
    echo "<br><br>";
    include ("footer.php");
    } else {
	main($user);
    }
}

function savecomm($uid, $uname, $umode, $uorder, $thold, $noscore, $commentmax) {
    global $user, $cookie, $userinfo, $user_prefix, $dbi, $module_name;
    cookiedecode($user);
    $check = $cookie[1];
    $check2 = $cookie[2];
    $result = sql_query("select uid, pass from ".$user_prefix."_users where uname='$check'", $dbi);
    list($vuid, $ccpass) = sql_fetch_row($result, $dbi);
    if (($uid == $vuid) AND ($check2 == $ccpass)) {	
	if(isset($noscore)) $noscore=1; else $noscore=0;
	sql_query("update ".$user_prefix."_users set umode='$umode', uorder='$uorder', thold='$thold', noscore='$noscore', commentmax='$commentmax' where uid='$uid'", $dbi);
	getusrinfo($user);
	docookie($userinfo[uid],$userinfo[uname],$userinfo[pass],$userinfo[storynum],$userinfo[umode],$userinfo[uorder],$userinfo[thold],$userinfo[noscore],$userinfo[ublockon],$userinfo[theme],$userinfo[commentmax]);
	Header("Location: modules.php?name=$module_name");
    }
}

function avatarlist() {
    include("header.php"); 
    Opentable(); 
    echo "<center><font class=\"option\"><b>"._AVAILABLEAVATARS."</b></font><br><br>"; 
    $direktori = "images/forum/avatar"; 
    $handle=opendir($direktori); 
    while ($file = readdir($handle)) { 
	$filelist[] = $file; 
    } 
    asort($filelist); 
    $temcount = 1; 
    while (list ($key, $file) = each ($filelist)) { 
	if (ereg(".gif",$file)) { 
	    if ($file == "." || $file == "..") {
		$a=1;
	    } else { 
		echo "<img src=\"images/forum/avatar/$file\" border=\"0\" width=\"32\" height=\"32\" alt=\"$file\" hspace=\"10\" vspace=\"10\">";
	    } 
	    if ($temcount == 10) { 
		echo "<br>"; 
		$temcount -= 10; 
	    } 
	    $temcount ++; 
	} 
    } 
    echo "<br><br><br>"
	.""._GOBACK.""
	."</center>"; 
    CloseTable(); 
    include("footer.php"); 
} 

function broadcast($the_message, $who) {
    global $prefix, $dbi, $broadcast_msg, $module_name;
    if ($broadcast_msg == 1) {
	include("header.php");
	title(""._BROADCAST."");
	OpenTable();
	$numrows = sql_num_rows(sql_query("select * from ".$prefix."_public_messages where who='$who'", $dbi), $dbi);
	$the_message = FixQuotes(filter_text($the_message, "nohtml"));
	if ($the_message != "" AND $numrows == 0) {
	    $the_time = time();
	    $result = sql_query("INSERT INTO ".$prefix."_public_messages values (NULL, '$the_message', '$the_time', '$who')", $dbi);
	    echo "<center>"._BROADCASTSENT."<br><br>[ <a href=\"modules.php?name=$module_name\">"._RETURNPAGE."</a> ]</center>";
	} else {
	    echo "<center>"._BROADCASTNOTSENT."<br><br>[ <a href=\"modules.php?name=$module_name\">"._RETURNPAGE."</a> ]</center>";
	}
	CloseTable();
	include("footer.php");
    } else {
	echo "I don't like you...";
    }
}

function my_headlines($hid, $url=0) {
    global $prefix, $dbi;
    $result = sql_query("select headlinesurl from ".$prefix."_headlines where hid='$hid'", $dbi);
    list($url) = sql_fetch_row($result, $dbi);
    $rdf = parse_url($url);
    $fp = fsockopen($rdf['host'], 80, $errno, $errstr, 15);
    if (!$fp) {
        $content = "<font class=\"content\">Problema!</font>";
        return;
    }
    if ($fp) {
        fputs($fp, "GET " . $rdf['path'] . "?" . $rdf['query'] . " HTTP/1.0\r\n");
        fputs($fp, "HOST: " . $rdf['host'] . "\r\n\r\n");
        $string	= "";
        while(!feof($fp)) {
	    $pagetext = fgets($fp,300);
	    $string .= chop($pagetext);
	}
	fputs($fp,"Connection: close\r\n\r\n");
	fclose($fp);
	$items = explode("</item>",$string);
	$content = "<font class=\"content\">";
	for ($i=0;$i<10;$i++) {
	    $link = ereg_replace(".*<link>","",$items[$i]);
	    $link = ereg_replace("</link>.*","",$link);
	    $title2 = ereg_replace(".*<title>","",$items[$i]);
	    $title2 = ereg_replace("</title>.*","",$title2);
	    if ($items[$i] == "") {
	        $content = "";
	        return;
	    } else {
	        if (strcmp($link,$title)) {
	    	    $cont = 1;
		    $content .= "<img src=\"images/arrow.gif\" border=\"0\" hspace=\"5\"><a href=\"$link\" target=\"new\">$title2</a><br>\n";
		}
	    }
	}
    }
    echo "$content";
}

switch($op) {

    case "logout":
	logout();
	break;

    case "broadcast":
	broadcast($the_message, $who);
	break;

    case "lost_pass":
	lost_pass();
	break;

    case "new user":
	confirmNewUser($uname, $email, $url, $user_avatar, $user_icq, $user_occ, $user_from, $user_intrest, $user_sig, $user_viewemail, $user_aim, $user_yim, $user_msnm);
	break;

    case "finish":
	finishNewUser($uname, $email, $url, $user_avatar, $user_icq, $user_occ, $user_from, $user_intrest, $user_sig, $user_viewemail, $user_aim, $user_yim, $user_msnm);
	break;

    case "mailpasswd":
	mail_password($uname, $code);
	break;

    case "userinfo":
	userinfo($uname, $bypass, $hid, $url);
	break;

    case "login":
	login($uname, $pass);
	break;

    case "edituser":
	edituser();
	break;

    case "saveuser":
	saveuser($uid, $realname, $uname, $email, $femail, $url, $pass, $vpass, $bio, $user_avatar, $user_icq, $user_occ, $user_from, $user_intrest, $user_sig, $user_aim, $user_yim, $user_msnm, $attach, $newsletter);
	break;

    case "edithome":
	edithome();
	break;
	
    case "chgtheme":
	chgtheme();
	break;
	
    case "savehome":
	savehome($uid, $uname, $storynum, $ublockon, $ublock, $broadcast, $popmeson);
	break;

    case "savetheme":
	savetheme($uid, $theme);
	break;

    case "avatarlist":
	avatarlist();
	break;

    case "editcomm":
	editcomm();
	break;

    case "savecomm":
	savecomm($uid, $uname, $umode, $uorder, $thold, $noscore, $commentmax);
	break;
		
    case "pass_lost":
	pass_lost();
	break;

    case "new_user":
        new_user();
        break;

    case "my_headlines":
	my_headlines($hid, $url);
	break;

    default:
	main($user);
	break;

}

?>
