#! /usr/bin/python
import sys, getopt, os, string, gdbm, struct, commands
programname = 'pimp3'
versionnumber = '0.5.8'
#insert the pathname of the folder where you store your mp3s
mp3folder = ' '
databasefile = os.environ['HOME'] + "/." + programname + ".db"
configfile = os.environ['HOME'] + "/." + programname + ".conf"

#see if the db file exists(needed in database.rebuild)
notfirsttime = 1 #used to see if this is a virgin database
command = os.environ['HOME'] + "/." + programname + ".db"
status = commands.getstatus(command)
status = string.split(status, "No")
if(len(status) > 1):
    notfirsttime = 0
try: 
    db = gdbm.open(databasefile, 'w')
except: 
    db = gdbm.open(databasefile, 'c')
try:
    del db['halt']
    db['halt'] = struct.pack('i', 1)
except:
    db['halt'] = struct.pack('i', 1)
try: 
    conf = open(configfile, 'r')
    mp3folder = conf.readline()
    mp3folder = string.strip(mp3folder)
except: 
    conf = open(configfile, 'w')
    mp3folder = raw_input('where do you store your mp3s? ')
    x = string.split(mp3folder, '/')
    count = 1
    y =  '/'+ x[0]
    while count < len(x):
	y = y + x[count] + '/'
	count = count + 1
    mp3folder = y
    print mp3folder
    del x, y, count
    conf.write(mp3folder)
    
def help():
        "print all the command line options"
	print "Usage: ", programname, " [OPTIONS]"
	print "A smart mp3 player"
	print
	print "--help        -h   print this help screen"
	print "--version     -v   print the program version"
	print "--play        -p   play the music"
	print "--rebuild     -r   rebuild the music database"
	print "--distribute  -d   rebuild the database and"
	print "                   distribute the ratings(first time only)"
	print "--setup       -s   setup the music database(rate the songs)"
	print "--make_setup  -m   make the setup file for setup"
	print "--print_amout -c   print the amount of mp3s in each category"
	print "                   this is useful to balance the load of mp3s"
	print "                   in each category. You want more in the 5"
	print "                   category than the 1 category."
	print "-two          -2   play only songs of the value 2 and above"
	print "-three        -3   play only songs of the value 3 and above"
	print "-four         -2   play only songs of the value 4 and above"
	print "-five         -3   play only songs of the value 5"
	sys.exit()
						    
def version():
    "print the version number"
    print programname, versionnumber
    sys.exit()		
	
try: optlist, args = getopt.getopt(sys.argv[1:], "lcrhvspmd2345", ["rebuild", "help",
						    "version", "setup",
						    "print_all", "play",
						"list","make_setup", "print_amount", "distribute"
						"two", "three", "four", "five"])
except:
    help()
for i in optlist:
    if i[0] in ["--rebuild", "-r"]:
	import database
	database.rebuild(db, mp3folder, programname, notfirsttime, spreadratings = 0)
    elif i[0] in ["--distribute", "-d"]:
	import database
	database.rebuild(db, mp3folder, programname, notfirsttime, spreadratings = 1)
    elif i[0] in ["--setup", "-s"]:
	import database
	database.setup(db, programname)
    elif i[0] in ["--make_setup", "-m"]:
	import database
	database.makesetup(db, mp3folder, programname)
    elif i[0] in ["--list", "-l"]:
	import database
	database.getlist(mp3folder)
    elif i[0] in ["--print_amount", "-c"]:
	import play
	play.print_amount(db)
    elif i[0] in ["--play", "-p"]:
	import play
	play.randomplay(db, 1, versionnumber)
    elif i[0] in ["--two", "-2"]:
	import play
	play.randomplay(db, 2, versionnumber)
    elif i[0] in ["--three", "-3"]:
	import play
	play.randomplay(db, 3, versionnumber)
    elif i[0] in ["--four", "-4"]:
	import play
	play.randomplay(db, 4, versionnumber)
    elif i[0] in ["--five", "-5"]:
	import play
	play.randomplay(db, 5, versionnumber)
    elif i[0] in ["--help", "-h"]:
	help()
    elif i[0] in ["--version", "-v"]:
	version()

if args != []:
    help()
