package org.jibble.pircbot;

import java.io.*;
import java.net.*;

/**
 * A Thread which is responsible for sending messages to the IRC server.
 * Messages are obtained from the outgoing message queue and sent
 * immediately if possible.  If there is a flood of messages, then to
 * avoid getting kicked from a channel, we put a small delay between
 * each one.
 *
 * @copyright Paul James Mutton, 2001-2002.
 * @author    Paul James Mutton, http://www.jibble.org/
 * @version 0.9.5 (Build time: Fri Jun 14 21:16:31 2002)
 */
public class OutputThread extends Thread {
    
    
    /**
     * Constructs an OutputThread for the underlying PircBot.  All messages
     * sent to the IRC server are sent by this OutputThread to avoid hammering
     * the server.  Messages are sent immediately if possible.  If there are
     * multiple messages queued, then there is a one second delay imposed.
     * 
     * @param bot The underlying PircBot instance.
     * @param outQueue The Queue from which we will obtain our messages.
     * @param bwriter The BufferedWriter to send lines to the IRC server.
     * 
     */
    protected OutputThread(PircBot bot, Queue outQueue) {
        _bot = bot;
        _outQueue = outQueue;
    }
    
    
    /**
     * This method starts the Thread consuming from the outgoing message
     * Queue and sending lines to the server.
     *
     */
    public void run() {
        boolean running = true;
        while (running) {
            // Small delay to prevent spamming of the channel
            try {
                Thread.sleep(_bot.getMessageDelay());
            }
            catch (InterruptedException e) {
                // Do nothing.
            }
            String line = (String)_outQueue.next();
            _bot.sendRawLine(line);
        }
    }
    
    private PircBot _bot = null;
    private Queue _outQueue = null;
    
}