!     Demonstration program for PLPLOT: 
      implicit none
      real*8 PI
      parameter (PI = 3.1415926535897932384)
      real*8 just, dx, dy, x(500), y(500), per(5),
     &  theta, theta0, dthet, theta1
      integer i, j
      character*20 text(5)
      data text / 'Maurice', 'Randy', 'Mark', 'Steve', 'Warner'/

      per(1) = 10.
      per(2) = 32.
      per(3) = 12.
      per(4) = 30.
      per(5) = 16.

! Ask user to specify the output device.

      call plinit()

      call plenv( dble (0.), dble (10.), dble (0.), dble (10.), 1, -2 )
      call plcol(2)

      theta0 = 0.
      dthet = 2*PI/500

      do 1 i = 1, 5
         x(1) = 5.
         y(1) = 5.
         j = 1
         theta1 = theta0 + 2 * PI * per(i) / 100.
         if (i .eq. 5) theta1 = 2 * PI

         do 2 theta = theta0, theta1, dthet
            j = j + 1
            x(j) = 5 + 3*cos(theta)
            y(j) = 5 + 3*sin(theta)
2        continue

         call plcol(i)
         call plpsty( mod(i+3, 8) + 1 )
         call plfill( j, x, y )
         call plcol(1)
         call plline( j, x, y )

         just = (theta0 + theta1) / 2.
         dx = .25 * cos(just)
         dy = .25 * sin(just)
         if (just .lt. PI/2 .or. just .gt. 3*PI/2) then
            just = 0.
         else 
            just = 1.
         endif
         call plptex( x(j/2)+dx, y(j/2)+dy, dble (1.), dble (0.),
     &     just, text(i) )
         theta0 = theta - dthet
1     continue

      call plfont(2)
      call plschr( dble (0.), dble (1.3))
      call plptex( dble (5.), dble (9.), dble (1.), dble (0.),
     &  dble (.5), 'Percentage of Sales' )

      call plend

      end
