#! /usr/bin/env python
# portell.py
# Description: prints a port's descr-file from whatever directory you're in.
# Author: Ryan (gt3) Kulla
# Usage: portell.py <portname>


import sys, os, shelve
from string import join


try:
	PORTELL_DB = os.environ['PORTELL_PATH']
except KeyError:
	PORTELL_DB = "/var/db/portell.db"

PORTS_DIR = "/usr/ports/"


def write_pathname(d, dirname, names):
	dirname = join(dirname.split('/')[:5], '/') # chop port path subdirs
	d[os.path.basename(dirname)] = dirname


def update_db():
	if os.access(PORTELL_DB, os.F_OK):
		os.unlink(PORTELL_DB) 
	try:
		d = shelve.open(PORTELL_DB)
		os.chmod(PORTELL_DB, 0666) 
	except:
		print "can't read or write %s. are you root?" % PORTELL_DB
		sys.exit(0)
	os.path.walk(PORTS_DIR, write_pathname, d)
	d.close()


def main():
	if len(sys.argv) != 2:
		print "usage: %s <portname>" % sys.argv[0]
		sys.exit(0)
	
	if sys.argv[1] == '-u':
		update_db()
		sys.exit(0)
	else:
		portname = sys.argv[1]

	if not os.access(PORTELL_DB, os.F_OK):
		print >> sys.stderr, "you need to create %s first." % PORTELL_DB
		print >> sys.stderr, "type: %s -u" % sys.argv[0]
		sys.exit(0)

	d = shelve.open(PORTELL_DB)

	if d.has_key(portname): 
		descr_path = d[portname] + "/pkg-descr"
		match = descr_path 
		try:
			descr_file = open(match, 'r').readlines()
			print "%s reads:\n" % descr_path
			for line in descr_file:
				print line,
		except IOError, errmsg:
			print errmsg
	else:
		print >> sys.stderr, "can't find %s" % portname

	d.close()


if __name__=='__main__':
	main()
