<?php
// $Id: pnadmin.php,v 1.6 2002/02/09 12:56:32 jgm Exp $ $Name:  $
// ----------------------------------------------------------------------
// POSTNUKE Content Management System
// Copyright (C) 2001 by the PostNuke Development Team.
// http://www.postnuke.com/
// ----------------------------------------------------------------------
// Based on:
// PHP-NUKE Web Portal System - http://phpnuke.org/
// Thatware - http://thatware.org/
// ----------------------------------------------------------------------
// LICENSE
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License (GPL)
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WIthOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// To read the license please visit http://www.gnu.org/copyleft/gpl.html
// ----------------------------------------------------------------------
// Original Author of file: 
// Purpose of file:  
// ----------------------------------------------------------------------

/**
 * main function
 */
function topx_admin_main()
{
    $output = new pnHTML();

    $output->Text(pnGetStatusMsg());

    if (!pnSecAuthAction(0, 'topx::', '::', ACCESS_DELETE)) {
        $output->Text(_TOPXNOAUTH);
        return $output->GetOutput();
    }
    $output->SetInputMode(_PNH_VERBATIMINPUT);
    $output->Text(topx_adminmenu());
    $output->SetInputMode(_PNH_PARSEINPUT);

    return $output->GetOutput();
}

function topx_adminmenu()
{
    $output = new pnHTML();

    $output->SetInputMode(_PNH_VERBATIMINPUT);
    $output->TableStart(_TOPXMODIFYCONFIG);
    $output->SetInputMode(_PNH_PARSEINPUT);

    $output->FormStart(pnModURL('topx', 'admin', 'update'));
    $output->FormHidden('authid', pnSecGenAuthKey());
    $output->BoldText(_TOPXOLDNUM .pnConfigGetVar('top'));
    $output->LineBreak(2);
    $output->Text(_TOPXSETNUM);
    $output->FormText('xtop', '', 5, 5);
    $output->LineBreak();
    $output->FormSubmit();
    $output->FormEnd();

    $output->TableEnd();

    return $output->GetOutput();

}
function topx_admin_update()
{
    list($xtop, $confirm) = pnVarCleanFromInput('xtop', 'confirm');

    if (empty($confirm)) {

        $output = new pnHTML();

	$output->SetInputMode(_PNH_VERBATIMINPUT);
        $output->Title(_TOPXCONFIRMCONFIG);
	$output->SetInputMode(_PNH_PARSEINPUT);
        $output->ConfirmAction(_TOPXCOMMIT,
                               pnModURL('topx','admin','update'),
                               _TOPXCANCEL,
                               pnModURL('topx','admin','main'), array('xtop' => $xtop));
        return $output->GetOutput();
    }
    if (!pnSecConfirmAuthKey()) {
        pnSessionSetVar('errormsg', _BADAUTHKEY);
        pnRedirect(pnModURL('topx', 'admin', 'main'));
        return true;
    }
    pnModAPILoad('topx', 'admin');

    if(pnModAPIFunc('topx',
                    'admin',
                    'update', array(xtop => $xtop))) {

        pnSessionSetVar('statusmsg', _TOPXSUCCESS);
    }
    pnRedirect(pnModURL('topx', 'admin', 'main'));

    return true;
}
?>