# $Id: Search.pm,v 1.5 2001/04/12 06:14:08 muhri Exp $
# -*- perl -*-
package Pronto::Search;
use strict;
use SelfLoader;
my $progress = undef;
my $stop = undef;
1;
__DATA__
sub search_win {
	
	my ($search_win, $combo,$tooltips);
	$tooltips = new Gtk::Tooltips();
	if ($main::prefs{'ToolTips'}) {
		$tooltips->enable();
	} else {
		$tooltips->disable();
	}	
	$tooltips->set_delay(750);		 
	$search_win = new Gtk::Window("toplevel");
	$search_win->set_policy(1,1,0);
	$search_win->set_title(_("Pronto! Search .."));
	$search_win->set_default_size('275','195');
	$search_win->signal_connect("destroy", sub { $search_win->destroy} );
	$search_win->signal_connect("delete_event" => \&Gtk::false);
	$search_win->position(-mouse);
	$search_win->show;
	$search_win->{'vbox'} = new Gtk::VBox(0,5);
	$search_win->add($search_win->{'vbox'});
	$search_win->{'vbox'}->show;
	
	$search_win->{'hbox'} = new Gtk::HBox(0,5);
	$search_win->{'hbox'}->show;
	$search_win->{'vbox'}->pack_start($search_win->{'hbox'},0,0,0);
	$search_win->{'label'} = new Gtk::Label(_(" Search by:"));
	$search_win->{'label'}->set_usize(85,10);
	$search_win->{'label'}->show;
	$combo->{'1'} = new Gtk::Combo;
	$tooltips->set_tip($combo->{'1'}->entry,_("Choose a field to search by"),"");
	my (@combo1) = ("SentFrom", "Subject", "Date","SentTo","CC","Replyf","NewMsg","Score","All");
	$combo->{'1'}->set_popdown_strings(@combo1);
	$combo->{'1'}->show;
	$combo->{'1'}->popwin->signal_connect("hide",sub { 
		if ($combo->{'1'}->entry->get_text eq "All") { 
			$search_win->{'entry'}->set_sensitive(0);
			if ($main::prefs{'DatabaseDriver'} ne "CSV") {
				$search_win->{'limit'}->set_sensitive(0);
			}
			$search_win->{'body'}->set_active(1);
		} else { 
			$search_win->{'body'}->set_active(0);
			if ($main::prefs{'DatabaseDriver'} ne "CSV") {
				$search_win->{'limit'}->set_sensitive(1)
			}
			$search_win->{'entry'}->set_sensitive(1) 
	       	}
		if ($combo->{'1'}->entry->get_text eq "SentTo") {
			${$main::message_clist->{'labels'}}[4] = "To";
	        	&main::set_labels($main::message_clist);
	        } else {
			${$main::message_clist->{'labels'}}[4] = "From";
	        	&main::set_labels($main::message_clist);
		}		
		});	
	$search_win->{'for'} = new Gtk::Label("For");
	$search_win->{'for'}->set_usize(85,10);
	$search_win->{'for'}->show;
	$search_win->{'entry'} = new Gtk::Entry;
	$search_win->{'entry'}->set_usize(170,20);
	$tooltips->set_tip($search_win->{'entry'},_("Enter your search expression here if you are looking for something after a certain word enter as %word"),"");
	$search_win->{'entry'}->show;
	$search_win->{'entry'}->signal_connect("activate" => \&do_search, $search_win, $combo);
	$search_win->{'chk1'} = new Gtk::CheckButton;
	$search_win->{'chk1'}->set_usize(16,17);
	$search_win->{'chk1'}->show;
	$search_win->{'chk1'}->signal_connect("toggled", sub {
						if ($search_win->{'chk1'}->active == 1) {
							$search_win->{'chk2'}->set_active(0);
							$combo->{'2'}->set_sensitive(1);
					      		$search_win->{'entry2'}->set_sensitive(1);
						} else {
							if ($search_win->{'chk2'}->active == 1) { 
								return 1;
						       	} else { 
						       		$combo->{'2'}->set_sensitive(0);
						       		$search_win->{'entry2'}->set_sensitive(0)
							}
					      }});
	$search_win->{'and'} = new Gtk::Label(_("And"));
	$search_win->{'and'}->show;
	$search_win->{'chk2'} = new Gtk::CheckButton;
	$search_win->{'chk2'}->signal_connect("toggled", sub {
       						if ($search_win->{'chk2'}->active == 1) { 
							$search_win->{'chk1'}->set_active(0);							      						$combo->{'2'}->set_sensitive(1);
					      		$combo->{'2'}->set_sensitive(1);
					      		$search_win->{'entry2'}->set_sensitive(1);
						} else {
							if ($search_win->{'chk1'}->active == 1) { 
								return 1; 
					      		} else { 
						       		$combo->{'2'}->set_sensitive(0);
					      	       		$search_win->{'entry2'}->set_sensitive(0);
							}
					      }});
	$search_win->{'chk2'}->set_usize(16,17);
	$search_win->{'chk2'}->show;
	$search_win->{'or'} = new Gtk::Label(_("Or "));
	$search_win->{'or'}->show;
	my (@combo2) = ("SentFrom","Sentto","CC","Date","Subject","BoxName","ReplyF","Score","NewMsg");
	$combo->{'2'} = new Gtk::Combo;
	$combo->{'2'}->set_popdown_strings(@combo2);
	$combo->{'2'}->show;
	$combo->{'2'}->popwin->signal_connect("hide", sub {
						if ($combo->{'2'}->entry->get_text eq "BoxName") {
							$search_win->{'entry2'}->hide;
						        $search_win->{'for2'}->set_text("Is");
					       		$combo->{'3'}->show;
						 } else { 
						  	$search_win->{'entry2'}->show;
						  	$search_win->{'for2'}->set_text("For");
						  	$combo->{'3'}->hide;
						 }
						  });
	$combo->{'2'}->set_sensitive(0);
	$search_win->{'for2'} = new Gtk::Label(_("For"));
	$search_win->{'for2'}->set_usize(85,10);
	$search_win->{'for2'}->show;
	$search_win->{'entry2'} = new Gtk::Entry;
      	$search_win->{'entry2'}->set_sensitive(0);
	$search_win->{'entry2'}->set_usize(170,20);
	$search_win->{'entry2'}->signal_connect("activate" =>\&do_search, $search_win, $combo);
	$search_win->{'entry2'}->show;
	$combo->{'3'} = new Gtk::Combo;
	my @boxlist = sort(keys(%main::foldernametoid));
	$combo->{'3'}->set_popdown_strings(@boxlist);
	$combo->{'3'}->hide;
	$search_win->{'limitlbl'} = new Gtk::Label(_("Limit"));
	$search_win->{'limitlbl'}->set_usize(85,10);
	$search_win->{'limitlbl'}->show;
	$search_win->{'limit'} = new Gtk::Combo;
	$tooltips->set_tip($search_win->{'limit'}->entry,_("Set the limit to number of results - not supported for CSV"),"");
	my (@limits) = ("Unlimited", "10", "20","30","40","50");
	$search_win->{'limit'}->set_popdown_strings(@limits);
	$search_win->{'limit'}->show;
	if ($main::prefs{'DatabaseDriver'} eq "CSV") {
		$search_win->{'limit'}->set_sensitive(0);
	}
	$search_win->{'bodylabel'} = new Gtk::Label(_("Search body for"));
	$search_win->{'bodylabel'}->show;
	$search_win->{'body'} = new Gtk::CheckButton;
	$search_win->{'body'}->set_usize(16,17);
	$search_win->{'body'}->show;
	$search_win->{'body'}->set_active(0);
	$search_win->{'body'}->signal_connect("toggled", sub { 
							if ($search_win->{'body'}->active) {
								$search_win->{'bodytext'}->set_sensitive(1);
			       				} else {
								$search_win->{'bodytext'}->set_sensitive(0);
							}
							});
							
	$search_win->{'bodytext'} = new Gtk::Entry;
	$tooltips->set_tip($search_win->{'bodytext'},_("Enter words to search for in the message body"));
	$search_win->{'bodytext'}->set_editable(1);
	$search_win->{'bodytext'}->set_sensitive(0);
	$search_win->{'bodytext'}->show;
	$search_win->{'bodytext'}->signal_connect("activate" => \&do_search, $search_win, $combo);
	$search_win->{'button'} = new Gtk::Button("Go");
	$tooltips->set_tip($search_win->{'button'},_("Execute Search"),"");
	$search_win->{'button'}->signal_connect("clicked" => \&do_search, $search_win, $combo);
	$search_win->{'button'}->show;
	$search_win->{'save'} = new Gtk::Button(_("Save into a vfolder"));
	$tooltips->set_tip($search_win->{'save'},_("If you are satisfied with your search results, you can save it as a VFolder for immediate retrival later on"),"");
	$search_win->{'save'}->show;
	$search_win->{'save'}->signal_connect("clicked" => \&save_vf, $search_win, $combo);
	$search_win->{'hbox'}->pack_start($search_win->{'label'},0,0,0);
	$search_win->{'hbox'}->pack_start($combo->{'1'},0,0,0);
	$search_win->{'hbox2'} = new Gtk::HBox(0,5);
	$search_win->{'hbox2'}->show;
	$search_win->{'hbox2'}->pack_start($search_win->{'for'},0,0,0);
	$search_win->{'hbox2'}->pack_start($search_win->{'entry'},0,0,0);
	$search_win->{'vbox'}->pack_start($search_win->{'hbox2'},0,0,0);
	$search_win->{'andorbox'} = new Gtk::HBox(0,5);
	$search_win->{'andorbox'}->show;
	$search_win->{'vbox'}->pack_start($search_win->{'andorbox'},0,0,0);
	$search_win->{'andorbox'}->pack_start($search_win->{'chk1'},0,0,0);
	$search_win->{'andorbox'}->pack_start($search_win->{'and'},0,0,0);
	$search_win->{'andorbox'}->pack_start($search_win->{'chk2'},0,0,0);
	$search_win->{'andorbox'}->pack_start($search_win->{'or'},0,0,0);
	$search_win->{'andorbox'}->pack_start($combo->{'2'},0,0,0);
	$search_win->{'entry2box'} = new Gtk::HBox(0,5);
        $search_win->{'entry2box'}->show;
	$search_win->{'vbox'}->pack_start($search_win->{'entry2box'},0,0,0);
	$search_win->{'entry2box'}->pack_start($search_win->{'for2'},0,0,0);
	$search_win->{'entry2box'}->pack_start($search_win->{'entry2'},0,0,0);
	$search_win->{'entry2box'}->pack_start($combo->{'3'},0,0,0);
	$search_win->{'hbox3'}=new Gtk::HBox(0,5);
	$search_win->{'hbox3'}->show;
	$search_win->{'hbox3'}->pack_start($search_win->{'limitlbl'},0,0,0);
	$search_win->{'hbox3'}->pack_start($search_win->{'limit'},0,0,0);
	$search_win->{'vbox'}->pack_start($search_win->{'hbox3'},0,0,0);
	$search_win->{'hbox4'} = new Gtk::HBox(0,5);
	$search_win->{'hbox4'}->show;
	$search_win->{'vbox'}->pack_start($search_win->{'hbox4'},0,0,0);
	$search_win->{'hbox4'}->pack_start($search_win->{'body'},0,0,0);
	$search_win->{'hbox4'}->pack_start($search_win->{'bodylabel'},0,0,0);
	$search_win->{'hbox4'}->pack_start($search_win->{'bodytext'},0,0,0);
	$search_win->{'hbox5'} = new Gtk::HBox(0,5);
	$search_win->{'hbox5'}->show;
	$search_win->{'hbox5'}->pack_start($search_win->{'button'},1,1,0);
	$search_win->{'hbox5'}->pack_start($search_win->{'save'},1,1,0);	
	$search_win->{'vbox'}->pack_start($search_win->{'hbox5'},0,0,0);
}



sub do_search {
	
	my ($widget,$search_win, $combo) = @_;
	my ($entry,$select,$limit,@field);
	my ($sql, $query, $box,@row, @selection, $row, @msg_sel, %selected, $background, $style, $paperclip, $paperclip_mask, $exclamation, $exclamation_mask, $replyf, $replyf_mask, $forwardf, $forwardf_mask,$newm,$newm_mask);
	unless ($combo->{'1'}->entry->get_text eq "All") {
		$entry = $search_win->{'entry'}->get_text;
		if ($entry eq "") { &main::err_dialog(_("Please type something in the entry box")); return 1;}
		if ($search_win->{'chk1'}->active or $search_win->{'chk2'}->active) {
			if ($combo->{'2'}->entry->get_text ne "BoxName" and $search_win->{'entry2'}->get_text eq "") { 
       		   		&main::err_dialog(_("Please type something in the and/or condition box or uncheck it !"));
		   		return 1;
			}
		}
		if ($search_win->{'body'}->get_active == 1 and $search_win->{'bodytext'}->get_text eq "") {
	      		&main::err_dialog(_("Enter some text in the body search entry"));
			return 1;
		 }

		$select = $combo->{'1'}->entry->get_text;
		$select = lc($select);
		$limit = $search_win->{'limit'}->entry->get_text;
		$box =  &Pronto::FolderTree::get_folder_id();
	 
     	}
	 
	if (!$box or $box !=1000) {
     	  	$main::folder_tree->select($main::ft_node[1000]);
	  	$main::root_window->{'button'}->show;
        }
				 
	$main::message_clist->freeze;
	$row=0;
	$main::message_clist->clear;
	
	if(-f "$main::prefs{'PixmapDir'}/paperclip.xpm") {
		($paperclip,$paperclip_mask)=Gtk::Gdk::Pixmap->create_from_xpm($main::message_clist->clist_window,$main::message_clist->style->bg('normal'),"$main::prefs{'PixmapDir'}/paperclip.xpm");
	}
	else { 
		($paperclip,$paperclip_mask)=Gtk::Gdk::Pixmap->create_from_xpm_d($main::message_clist->clist_window,$main::message_clist->style->bg('normal'),@main::dummy_pixmap);
        }
	if(-f "$main::prefs{'PixmapDir'}/exclamation.xpm") {
		($exclamation,$exclamation_mask)=Gtk::Gdk::Pixmap->create_from_xpm($main::message_clist->clist_window,$main::message_clist->style->bg('normal'),"$main::prefs{'PixmapDir'}/exclamation.xpm");
	}
	else {
		($exclamation,$exclamation_mask)=Gtk::Gdk::Pixmap->create_from_xpm_d($main::message_clist->clist_window,$main::message_clist->style->bg('normal'),@main::dummy_pixmap);
        }
	if(-f "$main::prefs{'PixmapDir'}/reply_flag.xpm") {
		($replyf,$replyf_mask)=Gtk::Gdk::Pixmap->create_from_xpm($main::message_clist->clist_window,$main::message_clist->style->bg('normal'),"$main::prefs{'PixmapDir'}/reply_flag.xpm");
	}
	else {
		($replyf,$replyf_mask)=Gtk::Gdk::Pixmap->create_from_xpm_d($main::message_clist->clist_window,$main::message_clist->style->bg('normal'),@main::dummy_pixmap);
        }
	if(-f "$main::prefs{'PixmapDir'}/forward_flag.xpm") {
		($forwardf,$forwardf_mask)=Gtk::Gdk::Pixmap->create_from_xpm($main::message_clist->clist_window,$main::message_clist->style->bg('normal'),"$main::prefs{'PixmapDir'}/forward_flag.xpm");
	}
	else {
		($forwardf,$forwardf_mask)=Gtk::Gdk::Pixmap->create_from_xpm_d($main::message_clist->clist_window,$main::message_clist->style->bg('normal'),@main::dummy_pixmap);
        }
	if(-f "$main::prefs{'PixmapDir'}/newm.xpm") {
		($newm,$newm_mask)=Gtk::Gdk::Pixmap->create_from_xpm($main::message_clist->clist_window,$main::message_clist->style->bg('normal'),"$main::prefs{'PixmapDir'}/newm.xpm");
	}
	else {
		($newm,$newm_mask)=Gtk::Gdk::Pixmap->create_from_xpm_d($main::message_clist->clist_window,$main::message_clist->style->bg('normal'),@main::dummy_pixmap);
        }
	${$main::message_clist->{'labels'}}[4] = "From";
		if ($combo->{'1'}->entry->get_text eq "All") {
			if ($main::prefs{'messageview'} eq "clist") {
				$sql = "select id,friendly,subject,date,newmsg,localdate,contenttype,priority,replyf,score from messages";
			} elsif ($main::prefs{'messageview'} eq "ctree") {
				$sql = "select msgid,inreplyto,subject,friendly,localdate,id,newmsg,replyf,priority,contenttype,score,ref from messages order by localdate";
			}
		}
		unless ($combo->{'1'}->entry->get_text eq "All") {
			if ($limit eq "Unlimited") { 
				if ($main::prefs{'messageview'} eq "clist") {
					$sql = "select id,friendly,subject,date,newmsg,localdate,contenttype,priority,replyf,score,serverstat from messages where $select like '$entry%'";
				} elsif ($main::prefs{'messageview'} eq "ctree") {
					$sql = "select msgid,inreplyto,subject,friendly,localdate,id,newmsg,replyf,priority,contenttype,score,ref,serverstat from messages where $select like '$entry%' order by localdate";
				}
			} else {
				if ($main::prefs{'messageview'} eq "clist") {
					$sql = "select id,friendly,subject,date,newmsg,localdate,contenttype,priority,replyf,score,serverstat from messages where $select like '$entry%' limit $limit";
              			} elsif ($main::prefs{'messageview'} eq "ctree") {
					$sql = "select msgid,inreplyto,subject,friendly,localdate,id,newmsg,replyf,priority,contenttype,score,ref,serverstat from messages where $select like '$entry%' order by localdate limit $limit";
				}
			}
	 	}
       
	

	if ($search_win->{'chk1'}->active) {
		my $fromcombo = $combo->{'2'}->entry->get_text;
		if ($fromcombo ne "BoxName") { 
			$fromcombo = lc($fromcombo);  
			my $condentry = $search_win->{'entry2'}->get_text;
			if ($combo->{'1'}->entry->get_text ne "All"){
			        $sql = $sql . " and $fromcombo like '$condentry%'";
			} else {
			        $sql = $sql . " where $fromcombo like '$condentry%'";
			}	
	
		} else {
       	
			my $boxname = $combo->{'3'}->entry->get_text;
			if ($combo->{'1'}->entry->get_text ne "All"){
			        $sql = $sql . " and boxid =  " .  $main::foldernametoid{$boxname};
			} else {
			        $sql = $sql . " where boxid = " . $main::foldernametoid{$boxname};
			}	
	       }
	
	if ($main::prefs{'messageview'} eq "ctree") { $sql =~ s/order by localdate//; $sql = $sql . " order by localdate";}
	if ($search_win->{'limit'}->entry->get_text ne "Unlimited") { $sql =~ s/limit $limit//; $sql = $sql . " limit $limit" }
	
	}
	
	if ($search_win->{'chk2'}->active) {
		my $fromcombo = $combo->{'2'}->entry->get_text;
		if ($fromcombo ne "BoxName") { 
			$fromcombo = lc($fromcombo);  
			my $condentry = $search_win->{'entry2'}->get_text;
       			if ($combo->{'1'}->entry->get_text ne "All"){
			        $sql = $sql . " or $fromcombo like '$condentry%'";
			} else {
			        $sql = $sql . " where $fromcombo like '$condentry%'";
			}	
		} else {
       	
			my $boxname = $combo->{'3'}->entry->get_text;
			if ($combo->{'1'}->entry->get_text ne "All"){
			        $sql = $sql . " or boxid =  " . $main::foldernametoid{$boxname};
			} else {
       			        $sql = $sql . " where boxid = " . $main::foldernametoid{$boxname};
	  	
			      }
		}	
	if ($main::prefs{'messageview'} eq "ctree") { $sql =~ s/order by localdate//; $sql = $sql . " order by localdate";}
	if ($search_win->{'limit'}->entry->get_text ne "Unlimited") { $sql =~ s/limit $limit//; $sql = $sql . " limit $limit" }
	
	}
	

	&main::set_labels($main::message_clist);
	$query = $main::conn->prepare($sql);
	$query->execute();
	
	my $rows = $query->rows;
	if ($rows == 0) { &main::err_dialog("Your search returned no results !"); }
	my $new = 0;
	if ($search_win->{'body'}->get_active == 0) { 
		$main::folder_tree->node_set_text($main::ft_node[1000], 1, $rows);
	} 
	
	my $i = 0;
	my $count = 0;
      	if ($main::prefs{'messageview'} eq "clist") {
		while (@row=$query->fetchrow_array) {		       
			if ($stop) { undef $stop; undef $progress; last; }
			if ($search_win->{'body'}->active and $search_win->{'bodytext'} ne "") {
				if (not defined $progress && !$stop) { progress();}
				$progress->{'bar'}->configure($count,0,$rows) if defined $progress;
				my $text = $search_win->{'bodytext'}->get_text;       
				#my $tmp = &main::filename_to_tree("$main::prefs{'MailDir'}/$row[0]");
	       			#open(TMP, $tmp);
				my $add = 0;
				my $io = &Pronto::Data::Message::get_source_io_handle($row[0]);				
				while ( $_ = $io->getline() ) {       					
					$progress->{'bar'}->set_value($i++) if defined $progress;
					if (/$text/i) { $add = 1; $count++;last;}	       			
					while (Gtk->events_pending) { Gtk->main_iteration }					
				}
       				if ($add != 1) { $io->close(); next }
				$io->close();
			}
			
			if (not defined $row[9]) { $row[9] = 0; }
			if ($row[9] == 0) { $row[9] = " "; }
			
	       		if (defined $row[10] && $row[10] == 1) { 
				$row[10] = _("Not Fetched"); 	# Message is still on server and has NOT been fetched.
								# 
			} elsif (defined $row[10] && ($row[10] == 2 || $row[10] == 6)) { 
				$row[10] = _("On Server"); # Message is still on server and has been fetched. 
							#
			} elsif (defined $row[10] && $row[10] == 3) { 
				$row[10] = _("To Be Deleted"); 	# Message is flagged for deletion. 
								#
			} elsif (defined $row[10] && $row[10] == 4) { 
				$row[10] = _("To Be Fetched & Deleted"); 	# Message is flagged for deletion. 
									#
			} else { 
				$row[10] = " "; # Message is not on server.
						#
			}

			$main::message_clist->insert($row,'','','',$row[9],$row[1],$row[2],&main::localdate_to_displaydate($row[5]),$row[10],$row[5]);
			if ($row[6] && ($row[6] !~ /text/i && $row[6] !~ /alternative/i && $row[6] !~ /multipart\/report/i)) {
				$main::message_clist->set_pixmap($row, 1, $paperclip, $paperclip_mask);
			}
			if (($row[7]) and ($row[7] =~ /high/i)) {
				$main::message_clist->set_pixmap($row, 0, $exclamation, $exclamation_mask);
			}
			if ($row[8]) {
				if ($row[8] == 1) {
					$main::message_clist->set_pixtext($row, 4, $row[1],1,$replyf, $replyf_mask);
				} elsif ($row[8] == 2) {
					$main::message_clist->set_pixtext($row, 4, $row[1],1,$forwardf, $forwardf_mask);
				}
			}
			if (($row[4]) and ($row[4] eq "y")) {
				$main::message_clist->set_pixmap($row, 2, $newm, $newm_mask);
				if ($main::prefs{'BoldMsg'}) {
					$main::message_clist->set_row_style($row,$main::bold);
				}	
				#$style = $main::message_clist->style->copy;
				#$style->font($fontbold);
		        	$new++
			} else {
				if ($main::prefs{'BoldMsg'}) {
					$main::message_clist->set_row_style($row,$main::normal);
				}	
			}
			if ($selected{$row[0]}) {
				$main::message_clist->select_row($row,1);
			}
			$main::message_clist->set_row_data($row, \$row[0]);
			$row++;
			}
	} elsif ($main::prefs{'messageview'} eq "ctree") {
       		my ($node);
		my (%nodes, %not_found) = ((), ());
		while (my($msgid, $inreplyto, $subject, $sentfrom, $date,$id,$newmsg,$reply,$priority,$contenttype,$score,$ref,$serverstat) = $query->fetchrow_array()) {
			if ($stop) { undef $stop; undef $progress; last; }
			if ($search_win->{'body'}->active and $search_win->{'bodytext'} ne "") {
				if (not defined $progress && !$stop) { progress() }
				$progress->{'bar'}->configure($count,0,$rows) if defined $progress;
				my $text = $search_win->{'bodytext'}->get_text;       
			#my $tmp = &main::filename_to_tree("$main::prefs{'MailDir'}/$id");
		       	#open(TMP, $tmp);
				my $add = 0;
				my $io = &Pronto::Data::Message::get_source_io_handle($id);
				while ( $_ = $io->getline() ) {
       					$progress->{'bar'}->set_value($i++) if defined $progress;
					if (/$text/i) { $add = 1; $count++; last;}
					while (Gtk->events_pending) { Gtk->main_iteration }
				}
		
		       		if ($add != 1) { $io->close(); next }
		       		$io->close();
		       }
			
			my $sub =  $subject;
			$sub =~ s!\bre(:|\b)\s+!!gi;
			if (!$score) { $score = 0 }
			if ($score == 0) { $score = " "; }
			#shut CSV up
			if ($main::prefs{'DatabaseDriver'} eq "CSV") {
				if (not defined $reply or $reply eq "") {
					 $reply = 0;
			 	}
			}	
			if (defined $serverstat && $serverstat == 1) {
				$serverstat = _("Not Fetched");	# Message is still on server and has NOT been fetched.
								# 
			} elsif (defined $serverstat && ($serverstat == 2 || $serverstat == 6)) {
				$serverstat = _("On Server"); 	# Message is still on server and has been fetched. 
								#
			} elsif (defined $serverstat && $serverstat == 3) { 
				$serverstat = _("To Be Deleted"); 	# Message is flagged for deletion. 
								#
			} elsif (defined $serverstat && $serverstat == 4) { 
				$serverstat = _("To Be Fetched & Deleted");# Message is flagged for deletion. 
									#
			} else { 
				$serverstat = " "; 	# Message is not on server.
							#
			}

			if (!$ref && !$inreplyto) { #toplevel mail
				my $title = ["",,"","",$score,$sentfrom,$subject,&main::localdate_to_displaydate($date),$serverstat,$date];
				if (defined $reply and $reply ne "" and $reply == 1) {
					$node = $main::message_clist->insert_node(undef,undef,$title,5,$replyf,$replyf_mask,$replyf,$replyf_mask,0,1);
				} elsif (defined $reply and $reply ne "" and $reply == 2) {
					$node = $main::message_clist->insert_node(undef,undef,$title,5,$forwardf,$forwardf_mask,$forwardf,$forwardf_mask,0,1);
				} else {
					$node = $main::message_clist->insert_node(undef,undef,$title,5,undef,undef,undef,undef,0,1);
				}
			$nodes{$msgid} = $node;
			$nodes{$sentfrom . $date} = $node;    
			$nodes{$sub} = $node;
			} else {
				if (!$ref && $inreplyto =~ /^(.+)\'s message of \"([^\"]+)\"/) {
					$inreplyto = "$1$2";
					$inreplyto =~ s/\"//g;
				} elsif ($ref =~ /(<[^>]+>)$/ || $inreplyto =~ /(<[^>]+>)/) {
					$inreplyto = $1;
				}
			if ($nodes{$inreplyto}) {
				my $title = ["","","",$score,$sentfrom,$subject,&main::localdate_to_displaydate($date),$serverstat,$date];
				if (defined $reply and $reply ne "" and $reply == 1) {
					$node = $main::message_clist->insert_node($nodes{$inreplyto},undef,$title,5,$replyf,$replyf_mask,$replyf,$replyf_mask,0,1);
				} elsif (defined $reply and $reply ne "" and $reply == 2) {
					$node = $main::message_clist->insert_node($nodes{$inreplyto},undef,$title,5,$forwardf,$forwardf_mask,$forwardf,$forwardf_mask,0,1);
				} else {
					$node = $main::message_clist->insert_node($nodes{$inreplyto},undef,$title,5,undef,undef,undef,undef,0,1);
				}
				$nodes{$msgid} = $node;
				$nodes{$sentfrom . $date} = $node;     
				$nodes{$sub} = $node;
			} elsif ($nodes{$sub} && $main::prefs{'GuessRejectThreads'} eq "y") {
				my $title = ["","","",$score,$sentfrom,$subject,&main::localdate_to_displaydate($date),$serverstat,$date];
				if (defined $reply and $reply == 1) {
					$node = $main::message_clist->insert_node($nodes{$sub},undef,$title,5,$replyf,$replyf_mask,$replyf,$replyf_mask,0,1);
				} elsif (defined $reply and $reply == 2) {
					$node = $main::message_clist->insert_node($nodes{$sub},undef,$title,5,$forwardf,$forwardf_mask,$forwardf,$forwardf_mask,0,1);
      				} else {
					$node = $main::message_clist->insert_node($nodes{$sub},undef,$title,5,undef,undef,undef,undef,0,1);
      				}
				$nodes{$msgid} = $node;
				$nodes{$sentfrom . $date} = $node;     
				$nodes{$sub} = $node;

			} else {
				my $title = ["","","",$score,$sentfrom,$subject,&main::localdate_to_displaydate($date),$serverstat,$date];
				if (defined $reply and $reply ne "" and $reply == 1) {
					$node = $main::message_clist->insert_node(undef,undef,$title,5,$replyf,$replyf_mask,$replyf,$replyf_mask,0,1);
				} elsif (defined $reply and $reply ne "" and $reply == 2) {
					$node = $main::message_clist->insert_node(undef,undef,$title,5,$forwardf,$forwardf_mask,$forwardf,$forwardf_mask,0,1);
				} else {
					$node = $main::message_clist->insert_node(undef,undef,$title,5,undef,undef,undef,undef,0,1);
				}
				$nodes{$msgid} = $node;
				$nodes{$sentfrom . $date} = $node;     
				$nodes{$sub} = $node;
			}
		}
        		$main::message_clist->node_set_row_data($node,\$id);
 	
      			if ($contenttype && ($contenttype !~ /text/i && $contenttype !~ /alternative/i && $contenttype !~ /multipart\/report/i)) { 
				$main::message_clist->node_set_pixmap($node, 1, $paperclip, $paperclip_mask);
      			}
       			if (($priority) and ($priority =~ /high/i)) {
				$main::message_clist->node_set_pixmap($node, 0, $exclamation, $exclamation_mask);
      			}
			if (defined $newmsg and $newmsg eq "y") {
    				$main::message_clist->node_set_pixmap($node,2,$newm,$newm_mask);
				if ($main::prefs{'BoldMsg'}) {
					$main::message_clist->node_set_row_style($node,$main::bold);
				}	
				$new++;
			} else {
				if ($main::prefs{'BoldMsg'}) {
					$main::message_clist->node_set_row_style($node,$main::normal);
				}	
	 		}
    		}
	
 	}								  
						
	if ($main::prefs{'messageview'} eq "clist") {	
		$main::message_clist->sort;
	} elsif ($main::prefs{'messageview'} eq "ctree") {
		$main::message_clist->sort_recursive( undef );
	if ($main::prefs{'threadpref'} eq "collapsed") { $main::message_clist->collapse_recursive(undef)}
       	}         
	
	@msg_sel = $main::message_clist->selection;
      	if (@msg_sel) {
		if ($main::prefs{'messageview'} eq "clist") {
			$main::message_clist->moveto($msg_sel[0],0,'0.5','0.5');
			$main::message_clist->set_focus_row($msg_sel[0]);
		}
	}
	#if (($new !=0) and ($main::prefs{'FolderNewBold'} eq "y")) {
	#$style = $main::folder_tree->style->copy;
	#$style->font($fontbold);
	#$main::folder_tree->node_set_row_style($ft_node[100], $style);
	#}
	if (defined $progress) { 
		$progress->signal_handlers_destroy();
		$progress->destroy; 
		undef $progress;
       	}
	if ($count > 0) {
		$main::folder_tree->node_set_text($main::ft_node[1000],1,$count);
	}
	$main::folder_tree->node_set_text($main::ft_node[1000],2,$new);
	$main::message_clist->thaw;
	&main::set_win_title;	
	return 1;
}

sub view_virtual_folder {
	my ($vfolder) = @_;	
	my ($body,$sql, $query, $box,@row, @selection, $row, @msg_sel, %selected, $background, $style, $paperclip, $paperclip_mask, $exclamation, $exclamation_mask, $replyf, $replyf_mask, $forwardf, $forwardf_mask,$newm,$newm_mask,$toselect,$vpos);
	my $msg = &Pronto::MessageList::get_selected_msgid();
       	if ($msg) { 
		$selected{$msg} = 1; 
       		$vpos = $main::root_window->{'sw'}->get_vadjustment if $main::HTMLWIDGET ne "XmHTML";
	}
	$main::message_clist->freeze;
	$row=0;
	$main::message_clist->clear;	
	if(-f "$main::prefs{'PixmapDir'}/paperclip.xpm") {
		($paperclip,$paperclip_mask)=Gtk::Gdk::Pixmap->create_from_xpm($main::message_clist->clist_window,$main::message_clist->style->bg('normal'),"$main::prefs{'PixmapDir'}/paperclip.xpm");
	}
	else {
		($paperclip,$paperclip_mask)=Gtk::Gdk::Pixmap->create_from_xpm_d($main::message_clist->clist_window,$main::message_clist->style->bg('normal'),@main::dummy_pixmap);
        }
        if(-f "$main::prefs{'PixmapDir'}/exclamation.xpm") {
		($exclamation,$exclamation_mask)=Gtk::Gdk::Pixmap->create_from_xpm($main::message_clist->clist_window,$main::message_clist->style->bg('normal'),"$main::prefs{'PixmapDir'}/exclamation.xpm");
	}
	else {
		($exclamation,$exclamation_mask)=Gtk::Gdk::Pixmap->create_from_xpm_d($main::message_clist->clist_window,$main::message_clist->style->bg('normal'),@main::dummy_pixmap);
        }
        if(-f "$main::prefs{'PixmapDir'}/reply_flag.xpm") {
		($replyf,$replyf_mask)=Gtk::Gdk::Pixmap->create_from_xpm($main::message_clist->clist_window,$main::message_clist->style->bg('normal'),"$main::prefs{'PixmapDir'}/reply_flag.xpm");
	}
	else {
		($replyf,$replyf_mask)=Gtk::Gdk::Pixmap->create_from_xpm_d($main::message_clist->clist_window,$main::message_clist->style->bg('normal'),@main::dummy_pixmap);
        }
        if(-f "$main::prefs{'PixmapDir'}/forward_flag.xpm") {
		($forwardf,$forwardf_mask)=Gtk::Gdk::Pixmap->create_from_xpm($main::message_clist->clist_window,$main::message_clist->style->bg('normal'),"$main::prefs{'PixmapDir'}/forward_flag.xpm");
	}
	else {
		($forwardf,$forwardf_mask)=Gtk::Gdk::Pixmap->create_from_xpm_d($main::message_clist->clist_window,$main::message_clist->style->bg('normal'),@main::dummy_pixmap);
        }
        if(-f "$main::prefs{'PixmapDir'}/newm.xpm") {
		($newm,$newm_mask)=Gtk::Gdk::Pixmap->create_from_xpm($main::message_clist->clist_window,$main::message_clist->style->bg('normal'),"$main::prefs{'PixmapDir'}/newm.xpm");	
	}
	else {
		($newm,$newm_mask)=Gtk::Gdk::Pixmap->create_from_xpm_d($main::message_clist->clist_window,$main::message_clist->style->bg('normal'),@main::dummy_pixmap);
        }
        		
	${$main::message_clist->{'labels'}}[3] = "From";
	
	&main::set_labels($main::message_clist);
	$sql = "select query,body from boxlist where id = '$vfolder'";
	
	$query = $main::conn->prepare($sql);
	$query->execute();
	($sql,$body) = $query->fetchrow_array();
	
	if ($main::prefs{'messageview'} eq "ctree") { #convert from default clist query to ctree. 
		$sql =~ s/id,/msgid,inreplyto,/g;
		$sql =~ s/localdate,//;
		$sql =~ s/friendly,subject,date/subject,friendly,localdate,id/g;
		$sql =~ s/newmsg,/newmsg,replyf,/g;
		$sql =~ s/contenttype,priority,replyf/priority,contenttype/g;
		$sql =~ s/,score/,score,ref/g;
		$sql =~ s/limit(.+)//;
		if ($1) {
			$sql = $sql . " order by localdate limit $1";
       		} else { $sql = $sql . " order by localdate"; }
	}
        
	$query = $main::conn->prepare($sql);
	$query->execute();
	my $rows = $query->rows;
	my $i=0;
	my $new = 0;
	my $count = 0;
	if ($main::prefs{'messageview'} eq "clist") {
		while (@row=$query->fetchrow_array) {
			if ($stop) { undef $stop; undef $progress; last; }
			if ($body ne  "") {
		     	if (not defined $progress && !$stop) { progress() }
			$progress->{'bar'}->configure($count,0,$rows) if defined $progress;
			#my $tmp = &main::filename_to_tree("$main::prefs{'MailDir'}/$row[0]");
       			#open(TMP, $tmp);
			my $add = 0;
			my $io = &Pronto::Data::Message::get_source_io_handle($row[0]);
			while ( $_ = $io->getline() ) {
			      $progress->{'bar'}->set_value($i++) if defined $progress;
			      if (/$body/i) { $add = 1; $count++; last;}
	       	       	      while (Gtk->events_pending) { Gtk->main_iteration }	
			}
		
				if ($add != 1) { $io->close(); next }
				$io->close();
			}
		
			if (not defined $row[9]) { $row[9] = 0; }
			if ($row[9] == 0) { $row[9] = " "; }

	       		if (defined $row[10] && $row[10] == 1) { 
				$row[10] = _("Not Fetched"); 	# Message is still on server and has NOT been fetched.
								# 
			} elsif (defined $row[10] && ($row[10] == 2 || $row[10] == 6)) { 
				$row[10] = _("On Server"); # Message is still on server and has been fetched. 
							#
			} elsif (defined $row[10] && $row[10] == 3) { 
				$row[10] = _("To Be Deleted"); 	# Message is flagged for deletion. 
								#
			} elsif (defined $row[10] && $row[10] == 4) { 
				$row[10] = _("To Be Fetched & Deleted"); 	# Message is flagged for deletion. 
									#
			} else { 
				$row[10] = " "; # Message is not on server.
						#
			}

			$main::message_clist->insert($row,'','','',$row[9],$row[1],$row[2],&main::localdate_to_displaydate($row[5]),$row[10],$row[5]);
			if ($row[6] && ($row[6] !~ /text/i && $row[6] !~ /alternative/i && $row[6] !~ /multipart\/report/i)) {
				$main::message_clist->set_pixmap($row, 1, $paperclip, $paperclip_mask);
			}
			if (($row[7]) and ($row[7] =~ /high/i)) {
				$main::message_clist->set_pixmap($row, 0, $exclamation, $exclamation_mask);
			}
			if ($row[8]) {
				if ($row[8] == 1) {
					$main::message_clist->set_pixtext($row, 4, $row[1],1,$replyf, $replyf_mask);
				} elsif ($row[8] == 2) {
					$main::message_clist->set_pixtext($row, 4, $row[1],1,$forwardf, $forwardf_mask);
				}
			}
			if (($row[4]) and ($row[4] eq "y")) {
			 	$main::message_clist->set_pixmap($row, 2, $newm, $newm_mask);
				if ($main::prefs{'BoldMsg'}) { 
					$main::message_clist->set_row_style($row,$main::bold);
				}	
		        	$new++
			} else {
				if ($main::prefs{'BoldMsg'}) {
					$main::message_clist->set_row_style($row,$main::normal);
				}	
			}

			if ($selected{$row[0]}) {
				$main::message_clist->select_row($row,1);
			}
			$main::message_clist->set_row_data($row, \$row[0]);
			$row++;
       		}

	} elsif ($main::prefs{'messageview'} eq "ctree") {
		my ($node);
		my (%nodes, %not_found) = ((), ());
		while (my($msgid, $inreplyto, $subject, $sentfrom, $date,$id,$newmsg,$reply,$priority,$contenttype,$score,$ref,$serverstat) = $query->fetchrow_array()) {
			if ($stop) { undef $stop; undef $progress; last; }		
			if ($body ne  "") {
       				if (not defined $progress && !$stop) { progress() }
				$progress->{'bar'}->configure($count,0,$rows) if defined $progress;
				#my $tmp = &main::filename_to_tree("$main::prefs{'MailDir'}/$id");
	       			#open(TMP, $tmp);
				my $add = 0;
				my $io = &Pronto::Data::Message::get_source_io_handle($id);
				while ( $_ = $io->getline() ) {
					$progress->{'bar'}->set_value($i++) if defined $progress;
					if (/$body/i) { $add = 1; $count++; last;}
	       				while (Gtk->events_pending) { Gtk->main_iteration }
			       	}
		
					if ($add != 1) { $io->close(); next }
					$io->close();
			}
			my $sub = $subject;
			$sub =~ s!\bre(:|\b)\s+!!gi;
			if (!$score) { $score = 0 }
			if ($score == 0) { $score = " "; }
			#shut CSV up
			if ($main::prefs{'DatabaseDriver'} eq "CSV") {
				if (not defined $reply or $reply eq "") {
					 $reply = 0;
			 	}
			}	
			if (defined $serverstat && $serverstat == 1) {
				$serverstat = _("Not Fetched");	# Message is still on server and has NOT been fetched.
								# 
			} elsif (defined $serverstat && ($serverstat == 2 || $serverstat == 6)) {
				$serverstat = _("On Server"); 	# Message is still on server and has been fetched. 
								#
			} elsif (defined $serverstat && $serverstat == 3) { 
				$serverstat = _("To Be Deleted"); 	# Message is flagged for deletion. 
								#
			} elsif (defined $serverstat && $serverstat == 4) { 
				$serverstat = _("To Be Fetched & Deleted");# Message is flagged for deletion. 
									#
			} else { 
				$serverstat = " "; 	# Message is not on server.
							#
			}

			if (!$ref && !$inreplyto) { #toplevel mail
				my $title = ["",,"","",$score,$sentfrom,$subject,&main::localdate_to_displaydate($date),$serverstat,$date];
				if (defined $reply and $reply ne "" and $reply == 1) {
					$node = $main::message_clist->insert_node(undef,undef,$title,5,$replyf,$replyf_mask,$replyf,$replyf_mask,0,1);
				} elsif (defined $reply and $reply ne "" and $reply == 2) {
					$node = $main::message_clist->insert_node(undef,undef,$title,5,$forwardf,$forwardf_mask,$forwardf,$forwardf_mask,0,1);
				} else {
					$node = $main::message_clist->insert_node(undef,undef,$title,5,undef,undef,undef,undef,0,1);
				}
			$nodes{$msgid} = $node;
			$nodes{$sentfrom . $date} = $node;
			$nodes{$sub} = $subject;
			} else {
				if (!$ref && $inreplyto =~ /^(.+)\'s message of \"([^\"]+)\"/) {
					$inreplyto = "$1$2";
					$inreplyto =~ s/\"//g;
				} elsif ($ref =~ /(<[^>]+>)$/ || $inreplyto =~ /(<[^>]+>)/) {
					$inreplyto = $1;
				}
			if ($nodes{$inreplyto}) {
				my $title = ["","","",$score,$sentfrom,$subject,&main::localdate_to_displaydate($date),$serverstat,$date];
				if (defined $reply and $reply ne "" and $reply == 1) {
					$node = $main::message_clist->insert_node($nodes{$inreplyto},undef,$title,5,$replyf,$replyf_mask,$replyf,$replyf_mask,0,1);
				} elsif (defined $reply and $reply ne "" and $reply == 2) {
					$node = $main::message_clist->insert_node($nodes{$inreplyto},undef,$title,5,$forwardf,$forwardf_mask,$forwardf,$forwardf_mask,0,1);
				} else {
					$node = $main::message_clist->insert_node($nodes{$inreplyto},undef,$title,5,undef,undef,undef,undef,0,1);
				}
				$nodes{$msgid} = $node;
				$nodes{$sentfrom . $date} = $node;     
				$nodes{$sub} = $node;
			} elsif ($nodes{$sub} && $main::prefs{'GuessRejectThreads'} eq "y") {
				my $title = ["","","",$score,$sentfrom,$subject,&main::localdate_to_displaydate($date),$serverstat,$date];
				if (defined $reply and $reply == 1) {
					$node = $main::message_clist->insert_node($nodes{$sub},undef,$title,5,$replyf,$replyf_mask,$replyf,$replyf_mask,0,1);
				} elsif (defined $reply and $reply == 2) {
					$node = $main::message_clist->insert_node($nodes{$sub},undef,$title,5,$forwardf,$forwardf_mask,$forwardf,$forwardf_mask,0,1);
      				} else {
					$node = $main::message_clist->insert_node($nodes{$sub},undef,$title,5,undef,undef,undef,undef,0,1);
      				}
				$nodes{$msgid} = $node;
				$nodes{$sentfrom . $date} = $node;     
				$nodes{$sub} = $node;

			} else {
				my $title = ["","","",$score,$sentfrom,$subject,&main::localdate_to_displaydate($date),$serverstat,$date];
				if (defined $reply and $reply ne "" and $reply == 1) {
					$node = $main::message_clist->insert_node(undef,undef,$title,5,$replyf,$replyf_mask,$replyf,$replyf_mask,0,1);
				} elsif (defined $reply and $reply ne "" and $reply == 2) {
					$node = $main::message_clist->insert_node(undef,undef,$title,5,$forwardf,$forwardf_mask,$forwardf,$forwardf_mask,0,1);
				} else {
					$node = $main::message_clist->insert_node(undef,undef,$title,5,undef,undef,undef,undef,0,1);
				}
				$nodes{$msgid} = $node;
				$nodes{$sentfrom . $date} = $node;     
				$nodes{$sub} = $subject;
			}
		}	     

			$main::message_clist->node_set_row_data($node,\$id);
			if ($msg && $msg == $id) { $toselect = $node } 	
      			if ($contenttype && ($contenttype !~ /text/i && $contenttype !~ /alternative/i && $contenttype !~ /multipart\/report/i)) { 
				$main::message_clist->node_set_pixmap($node, 1, $paperclip, $paperclip_mask);
      			}
       			if (($priority) and ($priority =~ /high/i)) {
				$main::message_clist->node_set_pixmap($node, 0, $exclamation, $exclamation_mask);
      			}
			if (defined $newmsg and $newmsg eq "y") {
    				if ($main::prefs{'BoldMsg'}) {
					$main::message_clist->node_set_row_style($node,$main::bold);
				}
				$main::message_clist->node_set_pixmap($node,2,$newm,$newm_mask);
				$new++;
			} else {
				if ($main::prefs{'BoldMsg'}) {
					$main::message_clist->node_set_row_style($node,$main::normal);
				}	
	 		}
    		}
	
 	}   
	
	
	
	if ($main::prefs{'messageview'} eq "clist") {
		$main::message_clist->sort;	
	} elsif ($main::prefs{'messageview'} eq "ctree") {
	 	$main::message_clist->sort_recursive( undef );
	 	if ($main::prefs{'threadpref'} eq "collapsed") { $main::message_clist->collapse_recursive(undef) }
	}

	@msg_sel = $main::message_clist->selection;
	if (@msg_sel) {
		if ($main::prefs{'messageview'} eq "clist") {
			$main::message_clist->moveto($msg_sel[0],0,'0.5','0.5');
			$main::message_clist->set_focus_row($msg_sel[0]);
		}
	}	
	if ($toselect) { #node	
      		$main::message_clist->node_moveto($toselect,2,0.5,0.5);
		my $row = $main::message_clist->get_node_position($toselect);
      		if ($row != -1) {
   			Gtk::CList::select_row($main::message_clist,$row,1);
       			Gtk::CList::set_focus_row($main::message_clist,$row);
	       	}
       	
	}
	if ($vpos) {
		$main::root_window->{'sw'}->set_vadjustment($vpos);
	}	
	if (defined $progress) { 
		$progress->signal_handlers_destroy();
		$progress->destroy; 
		undef $progress; 
       	}
	if ($body eq "") {
		$main::folder_tree->node_set_text($main::ft_node[$vfolder], 1, $rows);
	}
	if ($count > 0) {
		$main::folder_tree->node_set_text($main::ft_node[$vfolder],1,$count);
	}
	$main::folder_tree->node_set_text($main::ft_node[$vfolder],2,$new);
	$main::message_clist->thaw;
	&main::set_win_title;
	return 1;
}

sub save_vf {	
	my ($widget,$search_win,$combo) = @_;
 	my ($entry,$select,$body,$limit,$sql);
	unless ($combo->{'1'}->entry->get_text eq "All") {
 		$entry = $search_win->{'entry'}->get_text;
        	if ($entry eq "") { &main::err_dialog(_("Please type something in the entry box")); return 1;}
		if ($search_win->{'chk1'}->active or $search_win->{'chk2'}->active) { 
       	   		if ($combo->{'2'}->entry->get_text ne "BoxName" and $search_win->{'entry2'}->get_text eq "") { 
	   		&main::err_dialog(_("Please type something in the and/or condition box or uncheck it !"));
      	   		return 1;		  
                	}
	 	}
		if ($search_win->{'body'}->get_active == 1 and $search_win->{'bodytext'}->get_text eq "") {
			&main::err_dialog(_("Enter some text in the body search entry"));
			return 1;
		}
	}
	$select = $combo->{'1'}->entry->get_text;
	$select = lc($select);
	$limit = $search_win->{'limit'}->entry->get_text;
														  
	if ($combo->{'1'}->entry->get_text eq "All") {
 		$sql = "select id,friendly,subject,date,newmsg,localdate,contenttype,priority,replyf,score,serverstat from messages";
	}
	unless ($combo->{'1'}->entry->get_text eq "All") {
		if ($limit eq "Unlimited") {
			$sql = "select id,friendly,subject,date,newmsg,localdate,contenttype,priority,replyf,score,serverstat from messages where $select like '$entry%'";
		} else {
			$sql = "select id,friendly,subject,date,newmsg,localdate,contenttype,priority,replyf,score,serverstat from messages where $select like '$entry%' limit $limit";
		}
   	}
  
  
  	if ($search_win->{'chk1'}->active) {
		my $fromcombo = $combo->{'2'}->entry->get_text;
		if ($fromcombo ne "BoxName") { 
			$fromcombo = lc($fromcombo);  
			my $condentry = $search_win->{'entry2'}->get_text;
       			if ($combo->{'1'}->entry->get_text ne "All"){
			       $sql = $sql . " and $fromcombo like '$condentry%'";
			} else {
			       $sql = $sql . " where $fromcombo like '$condentry%'";
			}       
		} else {
       	
			my $boxname = $combo->{'3'}->entry->get_text;
			if ($combo->{'1'}->entry->get_text ne "All"){
			       $sql = $sql . " and boxid =  " .  $main::foldernametoid{$boxname};
			} else {
			       $sql = $sql . " where boxid = " . $main::foldernametoid{$boxname};
	  	
		        }
		}	
       if ($search_win->{'limit'}->entry->get_text ne "Unlimited") { $sql =~ s/limit $limit//; $sql = $sql . " limit $limit" }  
	}
	
       if ($search_win->{'chk2'}->active) {
		my $fromcombo = $combo->{'2'}->entry->get_text;
		if ($fromcombo ne "BoxName") { 
			$fromcombo = lc($fromcombo);  
			my $condentry = $search_win->{'entry2'}->get_text;
       			if ($combo->{'1'}->entry->get_text ne "All"){
			       $sql = $sql . " or $fromcombo like '$condentry%'";
			} else {
			       $sql = $sql . " where $fromcombo like '$condentry%'";
			}       
		} else {
       	
			my $boxname = $combo->{'3'}->entry->get_text;
			if ($combo->{'1'}->entry->get_text ne "All"){
			       $sql = $sql . " or boxid =  " . $main::foldernametoid{$boxname};
			} else {
			       $sql = $sql . " where boxid = " . $main::foldernametoid{$boxname};
			}       
	  	}
    	
	if ($search_win->{'limit'}->entry->get_text ne "Unlimited") { $sql =~ s/limit $limit//; $sql = $sql . " limit $limit" }  
       	
	}
	

  
  
  	if ($search_win->{'body'}->active and $search_win->{'bodytext'} ne "") {
        	$body = $search_win->{'bodytext'}->get_text;
   	} else { 
		$body = "";
	}


	&Pronto::FolderTree::new_folder("y",$sql,$body);
	return 1;
}	

sub progress
{

	$progress = new Gtk::Dialog();
	$progress->set_modal(1);
	$progress->set_position(-mouse);
#	$progress->signal_connect("destroy" => \&progress);
	$progress->signal_connect("destroy", sub { $stop = 1;undef $progress;});
	$progress->set_title("Searching ....");
	$progress->{'bar'} = new Gtk::ProgressBar();	
	$progress->{'bar'}->configure(0,0,0);
	$progress->{'bar'}->set_activity_mode(1);
	$progress->{'stop'} = new Gtk::Button("Stop!");
	$progress->{'stop'}->signal_connect("clicked", sub { $progress->destroy; });	
	$progress->vbox->pack_start($progress->{'bar'},1,1,0);
	$progress->action_area->pack_start($progress->{'stop'},1,1,0);
	show_all $progress;	
	while (Gtk->events_pending) { Gtk->main_iteration }

}	
1;
