# $Id: MainWindow.pm,v 1.11 2001/04/14 04:16:26 muhri Exp $
# -*- perl -*-
package Pronto::MainWindow;
use strict;
use vars qw ($FolderTreeWindow $FTDetach $FTReattach);
use SelfLoader;


sub init_main_window {

 	my ($root_menu, $rm_file, $file_menu, $fm_emtrash, $am_sep, $accel_group, $fm_save, 
 	$fm_sattach, $fm_sep1, $fm_nfldr, $fm_dfldr, $fm_sep2, $fm_exit, $rm_edit, $edit_menu, 
	$fm_wb, $em_selall, $em_clear, $em_sep2, $em_addybook, $em_options, $em_mime, $rm_mail, 
	$mail_menu, $mm_checkall, $mm_check, $mm_import, $mm_export,  $mm_sep1, $mm_newm, 
	$mm_reply, $mm_forward, $mm_edit, $mm_sep2, $mm_accts, $mm_filters, $mm_sep3, $mm_delete, 
 	$hm_help, $mm_copy, $mm_move, $mm_nextunread, $rm_help, $help_menu, $hm_about,  
 	$mm_view_header, $window, $bg,$mm_add2ab, $message_menu, $pixmap,$mask, 
 	$mm_tglhdr, $clip, $exclame, $width, $height, $rm_message, $mm_scoreup, 
 	$mm_scoredown,$mm_view_raw,$mm_view,$mm_info,$fm_emptyfolder);
	my %key_hash = &Pronto::KeyEdit::get_hash();
	my %mod;
	$mod{'Alt'} = 'mod1-mask';
        $mod{'Ctrl'} = 'control-mask';
	$mod{'None'} = 'release-mask';
#	my $fm_debug;

 	$main::root_window=new Gtk::Window("toplevel");
 	$main::root_window->set_title("Pronto $main::version");
 	$main::root_window->signal_connect("destroy" => \&main::close_app, $main::root_window);
 	$main::root_window->signal_connect("delete_event" => \&Gtk::false);

 	($width,$height) = &main::get_win_size("startUp",685,400);
 	$main::root_window->set_default_size($width,$height);
 	$main::root_window->set_policy(1,1,1);
 	$main::root_window->show;
  
 	$main::root_window->{'toolbar'} = new Gtk::Toolbar('horizontal','both');
 	$main::root_window->{'toolbar'}->set_button_relief('none');
 	$main::root_window->{'toolbar'}->set_tooltips($main::prefs{'ToolTips'});
 	$main::root_window->{'toolbar'}->border_width('2');

 	$accel_group = new Gtk::AccelGroup;
 	$main::root_window->add_accel_group($accel_group);
 	$window = $main::root_window->window;
 	$bg = $main::root_window->style->bg('normal');
 	my($icon_pixmap, $icon_mask);
 	if(-f "$main::prefs{'PixmapDir'}/pronto-icon.xpm") {
		($icon_pixmap, $icon_mask) = Gtk::Gdk::Pixmap->create_from_xpm($window,$bg, "$main::prefs{'PixmapDir'}/pronto-icon.xpm");
 	}
 	else {
		($icon_pixmap, $icon_mask) = Gtk::Gdk::Pixmap->create_from_xpm_d($window,$bg, @main::dummy_pixmap);
 	}
 	$window->set_icon(undef, $icon_pixmap, $icon_mask);
 	$window->set_icon_name("Pronto");
 	$root_menu = new Gtk::MenuBar;
 	$rm_file=new Gtk::MenuItem(_("File"));
 	$root_menu->append($rm_file);
 	$file_menu = new Gtk::Menu;
#	$fm_debug = new Gtk::MenuItem("Debug");
#	$accel_group->add( 0x064, "mod1-mask" ,['visible'], $fm_debug, "activate");
#	$fm_debug->signal_connect("activate", sub { $main::root_window->{'toolbar'}->set_tooltips(0)});
#	$file_menu->append($fm_debug);
 	$fm_wb = new Gtk::MenuItem(_("Mini Browser"));
 	$accel_group->add( $key_hash{'Mini-Browser'}, $mod{$key_hash{'Mini-Browser'.'mod'}} ,['visible'], $fm_wb, "activate");
	$fm_wb->signal_connect("activate", sub {
					 if ($main::hashtml_widget eq "CscHTML" || $main::hashtml_widget eq "GtkHTML") {	 
					 	my $child;
                                         	unless ($child = fork) {
                                         	die "cannot fork: $~" unless defined $child;
                                         	exec("prontobrowser");
					 	}
					} else {
					 	&main::err_dialog("You must be using GtkHTML or CscHTMLto run ProntoBrowser");
					 	return 1;
					}

					});
 	$file_menu->append($fm_wb);
 	$fm_save = new Gtk::MenuItem(_("Save"));
 	$accel_group->add( $key_hash{'Save'}, $mod{$key_hash{'Save'.'mod'}} ,['visible'], $fm_save, "activate"); 
 	$fm_save->signal_connect("activate" => \&Pronto::Save::save_message_as);
 	$file_menu->append($fm_save);
 	$fm_sattach = new Gtk::MenuItem(_("Save Attachments"));
 	$file_menu->append($fm_sattach);
 	$main::attach_menu = new Gtk::Menu;
 	$am_sep = new Gtk::MenuItem;
 	$main::attach_menu->append($am_sep);
 	$fm_sattach->set_submenu($main::attach_menu);
 	$fm_sattach = new Gtk::MenuItem(_("View Attachments"));
 	$file_menu->append($fm_sattach);
 	$main::view_attach_menu = new Gtk::Menu;
 	$am_sep = new Gtk::MenuItem;
	$main::view_attach_menu->append($am_sep);
        $fm_sattach->set_submenu($main::view_attach_menu);
        my $printmenu = new Gtk::Menu;
        $printmenu->{'withheader'} = new Gtk::MenuItem(_("With Raw Header"));
        $printmenu->{'withheader'}->signal_connect("activate", sub {&Pronto::Print::print_message("withheader") });
        $printmenu->{'withheader'}->show;
        $printmenu->append($printmenu->{'withheader'});
        $printmenu->{'body'} = new Gtk::MenuItem(_("Body only"));
	$printmenu->{'body'}->signal_connect("activate", sub { &Pronto::Print::print_message("body") });
        $printmenu->{'body'}->show;
        $printmenu->append($printmenu->{'body'});
 	my $fm_print = new Gtk::MenuItem(_("Print"));
 	$fm_print->set_submenu($printmenu);
 	$file_menu->append($fm_print);
	$fm_sep1 = new Gtk::MenuItem;
 	$file_menu->append($fm_sep1);
 	$fm_nfldr = new Gtk::MenuItem(_("New Folder"));
 	$fm_nfldr->signal_connect("activate" => \&Pronto::FolderTree::new_folder);
 	$file_menu->append($fm_nfldr);
 	my $fm_refltr = new Gtk::MenuItem(_("Refilter Folder"));
 	$fm_refltr->signal_connect("activate" => \&Pronto::FolderTree::refilter_folder);
	$file_menu->append($fm_refltr);
 	$fm_dfldr = new Gtk::MenuItem(_("Delete Folder"));
 	$fm_dfldr->signal_connect("activate" => \&Pronto::FolderTree::delete_folder);
 	$file_menu->append($fm_dfldr);
	$fm_emptyfolder = new Gtk::MenuItem(_("Empty Folder"));
 	$accel_group->add( $key_hash{'Empty-Folder'}, $mod{$key_hash{'Empty-Folder'.'mod'}} ,['visible'], $fm_emptyfolder, "activate");
 	$fm_emptyfolder->signal_connect("activate" => \&Pronto::FolderTree::empty_folder);
 	$file_menu->append($fm_emptyfolder);

	$fm_emtrash = new Gtk::MenuItem(_("Empty Deleted Items"));
 	$fm_emtrash->signal_connect("activate" => \&Pronto::FolderTree::empty_trash);
 	$file_menu->append($fm_emtrash);
	$fm_sep2 = new Gtk::MenuItem;
 	$file_menu->append($fm_sep2);
 	$fm_exit = new Gtk::MenuItem(_("Exit"));
 	$accel_group->add( $key_hash{'Exit'}, $mod{$key_hash{'Exit'.'mod'}} ,['visible'], $fm_exit, "activate"); 
 	$fm_exit->signal_connect("activate" => \&main::close_app, $main::root_window);
 	$file_menu->append($fm_exit);
 	$rm_file->set_submenu($file_menu);
 	$rm_edit=new Gtk::MenuItem(_("Edit"));
 	$root_menu->append($rm_edit);
 	$edit_menu = new Gtk::Menu;
 	$em_selall = new Gtk::MenuItem(_("Select All"));
 	$accel_group->add( $key_hash{'Select-All'}, $mod{$key_hash{'Select-All'.'mod'}} ,['visible'], $em_selall, "activate");
 	$em_selall->signal_connect("activate" => \&Pronto::MessageList::rw_select_all);
 	$edit_menu->append($em_selall);
 	$em_clear = new Gtk::MenuItem(_("Clear Selection"));
 	$em_clear->signal_connect("activate" => \&Pronto::MessageList::clear_selection);
 	$edit_menu->append($em_clear);
 	$em_sep2 = new Gtk::MenuItem;
 	$edit_menu->append($em_sep2);
 	$em_options = new Gtk::MenuItem(_("Options..."));
 	$accel_group->add( $key_hash{'Options'}, $mod{$key_hash{'Options'.'mod'}} ,['visible'], $em_options, "activate"); 
 	$em_options->signal_connect("activate" => \&Pronto::Config::init_config);
 	$edit_menu->append($em_options);
 	$em_mime = new Gtk::MenuItem(_("Mimetypes..."));
 	$em_mime->signal_connect("activate" => \&Pronto::TableEdit::init_win, "mimetypes");
 	$edit_menu->append($em_mime);
 	my $em_key = new Gtk::MenuItem(_("Key Bindings"));
	$em_key->signal_connect("activate" => \&Pronto::KeyEdit::init_key_editor);
	$accel_group->add ($key_hash{'KeyEdit'}, $mod{$key_hash{'KeyEdit'.'mod'}}, ['visible'], $em_key, "activate");
	$edit_menu->append($em_key);
	$em_addybook = new Gtk::MenuItem(_("Addressbook"));
 	$accel_group->add( $key_hash{'AdressBook'}, $mod{$key_hash{'AdressBook'.'mod'}} ,['visible'], $em_addybook, "activate"); 
 	$em_addybook->signal_connect("activate" => \&Pronto::AddressBook::init_win);
 	$rm_edit->set_submenu($edit_menu);
 
 	my $rm_view = new Gtk::MenuItem(_("View"));
 	$root_menu->append($rm_view);
 	#toolbar menu stuf
 	my $tb_view  = new Gtk::Menu; #view menu
 	my $tb_submenu = new Gtk::Menu; #view -> toolbar
 	my $tb_icondir = new Gtk::Menu; # view->toolbar->switchicons
 
 	$tb_view->{'Toolbar'} = new Gtk::MenuItem(_("Toolbar"));
 	$tb_view->{'Toolbar'}->set_submenu($tb_submenu);
 	$tb_view->append($tb_view->{'Toolbar'});
 
 	$tb_submenu->{'show'} = new Gtk::CheckMenuItem(_("Show"));
 	if ($main::prefs{'toolbar'} eq "n") { $tb_submenu->{'show'}->set_active('0');}
 	if ($main::prefs{'toolbar'} eq "y") { $tb_submenu->{'show'}->set_active('1');}
 	$tb_submenu->{'show'}->set_show_toggle('1');
 	$tb_submenu->append($tb_submenu->{'show'});
 
 	$tb_submenu->{'icon'} = new Gtk::RadioMenuItem(_("As Icons"));
 	$tb_submenu->{'icon'}->signal_connect("toggled", sub { $main::root_window->{'toolbar'}->set_style('icons'); $main::root_window->{'handlebox'}->queue_resize(); $main::prefs{'toolbarstyle'} = "icons";});
 	$tb_submenu->append($tb_submenu->{'icon'});

 
 	$tb_submenu->{'text'} = new Gtk::RadioMenuItem(_("As Text"), $tb_submenu->{'icon'});
 	$tb_submenu->{'text'}->signal_connect("toggled", sub { $main::root_window->{'toolbar'}->set_style('text');  $main::root_window->{'handlebox'}->queue_resize(); $main::prefs{'toolbarstyle'} = "text";});
 	$tb_submenu->append($tb_submenu->{'text'});

 
 	$tb_submenu->{'both'} = new Gtk::RadioMenuItem(_("As Both"),  $tb_submenu->{'text'});
 	$tb_submenu->{'both'}->signal_connect("toggled", sub { $main::root_window->{'toolbar'}->set_style('both');  $main::root_window->{'handlebox'}->queue_resize(); $main::prefs{'toolbarstyle'} = "both";});
 	$tb_submenu->append($tb_submenu->{'both'});
 			 
 	$tb_submenu->{'switch'} = new Gtk::MenuItem(_("Switch Icons"));
 	$tb_submenu->append($tb_submenu->{'switch'});
 	$tb_submenu->{'install'} = new Gtk::MenuItem(_("Install Icons"));
 	$tb_submenu->append($tb_submenu->{'install'});
 	$tb_submenu->{'rescan'} = new Gtk::MenuItem(_("Rescan Icon dir"));
 	$tb_submenu->append($tb_submenu->{'rescan'});
	
	my $layout_submenu = new Gtk::Menu;
	$tb_view->{'layout'} = new Gtk::MenuItem(_("Layout"));
	$tb_view->{'layout'}->set_submenu($layout_submenu);
	$tb_view->append($tb_view->{'layout'});
	$layout_submenu->{'Layout1'} = new Gtk::MenuItem(_("Switch"));
	$layout_submenu->{'Layout1'}->signal_connect("activate", sub {
							if ($main::prefs{'Layout'} == 1) {
								$main::prefs{'Layout'} = 2;
								make_layout("flag");
							} else {
								$main::prefs{'Layout'} = 1;
								$main::prefs{'startPaneHeight'} = $main::prefs{'secondPaneHeight'};
								make_layout("flag");
							}
						});	

	$layout_submenu->append($layout_submenu->{'Layout1'});
	
 	my $ft_submenu = new Gtk::Menu;
 	$tb_view->{'FolderTree'} = new Gtk::MenuItem(_("Folder Tree"));
 	$tb_view->{'FolderTree'}->set_submenu($ft_submenu);
	 $tb_view->append($tb_view->{'FolderTree'});
 	$ft_submenu->{'RecCount'} = new Gtk::CheckMenuItem(_("Recursive count"));
	if ($main::prefs{'RecMsgCount'} eq "y") { $ft_submenu->{'RecCount'}->set_active(1) }
	if ($main::prefs{'RecMsgCount'} eq "n") { $ft_submenu->{'RecCount'}->set_active(0)}
	$ft_submenu->{'RecCount'}->signal_connect("toggled" => \&toggle_count_method);
	$ft_submenu->{'RecCount'}->set_show_toggle(1);
	$ft_submenu->append($ft_submenu->{'RecCount'});
	$ft_submenu->{'Msg'} = new Gtk::CheckMenuItem(_("Msg"));
 	if ($main::prefs{'msgcolumn'} eq "n") { $ft_submenu->{'Msg'}->set_active('0');};
 	if ($main::prefs{'msgcolumn'} eq "y") { $ft_submenu->{'Msg'}->set_active('1');};
 	$ft_submenu->{'Msg'}->signal_connect("toggled" => \&toggle_column_view, \$main::folder_tree, 1, \$main::prefs{'msgcolumn'});
 	$ft_submenu->{'Msg'}->set_show_toggle('1');
	$ft_submenu->append($ft_submenu->{'Msg'});
 	$ft_submenu->{'New'} = new Gtk::CheckMenuItem(_("New"));
 	if ($main::prefs{'newcolumn'} eq "n") { $ft_submenu->{'New'}->set_active('0');};
 	if ($main::prefs{'newcolumn'} eq "y") { $ft_submenu->{'New'}->set_active('1');};
 	$ft_submenu->{'New'}->signal_connect("toggled" => \&toggle_column_view, \$main::folder_tree, 2, \$main::prefs{'newcolumn'});
 	$ft_submenu->{'New'}->set_show_toggle('1');
 	$ft_submenu->append($ft_submenu->{'New'});
 	
 	my $ml_submenu = new Gtk::Menu;
 	my $th_submenu = new Gtk::Menu;
 	$tb_view->{'MessageList'} = new Gtk::MenuItem(_("Message List"));
 	$tb_view->{'MessageList'}->set_submenu($ml_submenu);
 	$tb_view->append($tb_view->{'MessageList'});
 	$tb_view->{'threads'} = new Gtk::MenuItem(_("Threads"));
 	$tb_view->{'threads'}->set_submenu($th_submenu);
 	$th_submenu->{'switch'} = new Gtk::CheckMenuItem(_("Threaded"));
 	if ($main::prefs{'messageview'} eq "clist") { $th_submenu->{'switch'}->set_active('0') }
 	if ($main::prefs{'messageview'} eq "ctree") { $th_submenu->{'switch'}->set_active('1') }
	$th_submenu->{'switch'}->set_show_toggle('1');
	$accel_group->add($key_hash{'Toggle-Threads'}, $mod{$key_hash{'Toggle-Threads'.'mod'}}, ['visible'], $th_submenu->{'switch'}, "activate");
 	$th_submenu->append($th_submenu->{'switch'});
	$th_submenu->{'guess'} = new Gtk::CheckMenuItem(_("Guess Rejects?"));
	$th_submenu->{'guess'}->set_show_toggle(1);
	if ($main::prefs{'GuessRejectThreads'} eq "y") { $th_submenu->{'guess'}->set_active(1); }
	if ($main::prefs{'GuessRejectThreads'} eq "n") { $th_submenu->{'guess'}->set_active(0); }
	$th_submenu->{'guess'}->signal_connect("toggled" => \&toggle_guess_threads);
	$th_submenu->append($th_submenu->{'guess'});
 	$th_submenu->{'symbol'} = new Gtk::CheckMenuItem(_("Use Arrows?"));
	$th_submenu->{'symbol'}->set_show_toggle(1);
	if ($main::prefs{'arrowthreads'} eq "y") { $th_submenu->{'symbol'}->set_active(1); }
	if ($main::prefs{'arrowthreads'} eq "n") { $th_submenu->{'symbol'}->set_active(0); }
	$th_submenu->{'symbol'}->signal_connect("toggled", \&toggle_arrow_in_threads);	
	$th_submenu->append($th_submenu->{'symbol'});
	$th_submenu->{'threadbysubject'} = new Gtk::CheckMenuItem(_("Thread by Subject?"));
	$th_submenu->{'threadbysubject'}->set_show_toggle(1);
	$accel_group->add( $key_hash{'Thread-Subject'}, $mod{$key_hash{'Thread-Subject'.'mod'}} ,['visible'], $th_submenu->{'threadbysubject'}, "activate");
	if ($main::prefs{'threadbysubject'} eq "y") { $th_submenu->{'threadbysubject'}->set_active(1); }
	if ($main::prefs{'threadbysubject'} eq "n") { $th_submenu->{'threadbysubject'}->set_active(0); }
	$th_submenu->{'threadbysubject'}->signal_connect("toggled" => \&toggle_subject_thread);
	$th_submenu->append($th_submenu->{'threadbysubject'});
	$th_submenu->{'threadpref'} = new Gtk::CheckMenuItem(_("Expanded"));
 	if ($main::prefs{'threadpref'} eq "expanded") { $th_submenu->{'threadpref'}->set_active('1'); }
 	if ($main::prefs{'threadpref'} eq "collapsed") { $th_submenu->{'threadpref'}->set_active('0'); }
 	$th_submenu->{'threadpref'}->set_show_toggle('1');
 	$th_submenu->{'threadpref'}->signal_connect("toggled" => \&Pronto::MessageList::expand_threads);
 	$th_submenu->append($th_submenu->{'threadpref'});
 	$th_submenu->{'linesmenu'} = new Gtk::Menu;
	$th_submenu->{'solid'} = new Gtk::RadioMenuItem(_("Solid"));
 	$th_submenu->{'solid'}->signal_connect("toggled", sub { $main::message_clist->set_line_style('solid'); $main::folder_tree->set_line_style("solid");$main::prefs{'threadstyle'} = "solid";});
 	$th_submenu->{'linesmenu'}->append($th_submenu->{'solid'});
 	$th_submenu->{'dotted'} = new Gtk::RadioMenuItem(_("Dotted"), $th_submenu->{'solid'});
 	$th_submenu->{'dotted'}->signal_connect("toggled", sub { $main::message_clist->set_line_style("dotted"); $main::folder_tree->set_line_style("dotted");$main::prefs{'threadstyle'} = "dotted";});
 	$th_submenu->{'linesmenu'}->append($th_submenu->{'dotted'});
 	$th_submenu->{'tabbed'} = new Gtk::RadioMenuItem(_("Tabbed"), $th_submenu->{'dotted'});
 	$th_submenu->{'tabbed'}->signal_connect("toggled", sub { $main::message_clist->set_line_style("tabbed"); $main::folder_tree->set_line_style("tabbed");$main::prefs{'threadstyle'} = "tabbed";});
 	$th_submenu->{'linesmenu'}->append($th_submenu->{'tabbed'});
 	$th_submenu->{'none'} = new Gtk::RadioMenuItem(_("None"),$th_submenu->{'tabbed'});
 	$th_submenu->{'none'}->signal_connect("toggled", sub { $main::message_clist->set_line_style("none"); $main::folder_tree->set_line_style("none"); $main::prefs{'threadstyle'} = "none";});
	$th_submenu->{'linesmenu'}->append($th_submenu->{'none'});
 	$th_submenu->{'lines'} = new Gtk::MenuItem(_("Line Style"));
	$th_submenu->{'lines'}->set_submenu($th_submenu->{'linesmenu'});
	$th_submenu->append($th_submenu->{'lines'});
	$th_submenu->{'expandermenu'} = new Gtk::Menu;
	$th_submenu->{'noexpander'} = new Gtk::RadioMenuItem(_("None"));
	$th_submenu->{'noexpander'}->signal_connect("toggled", sub { $main::message_clist->set_expander_style("none"); $main::folder_tree->set_expander_style("none");$main::prefs{'expander'} = "none";});
	$th_submenu->{'circular'} = new Gtk::RadioMenuItem(_("Circular"), $th_submenu->{'noexpander'});
	$th_submenu->{'circular'}->signal_connect("toggled", sub { $main::message_clist->set_expander_style("circular"); $main::folder_tree->set_expander_style("circular"); $main::prefs{'expander'} = "circular"; });
	$th_submenu->{'triangle'} = new Gtk::RadioMenuItem(_("Triangle"), $th_submenu->{'circular'});
	$th_submenu->{'triangle'}->signal_connect("toggled", sub { $main::message_clist->set_expander_style("triangle"); $main::folder_tree->set_expander_style("triangle");$main::prefs{'expander'} = "triangle";});	
	$th_submenu->{'square'} = new Gtk::RadioMenuItem(_("Square"), $th_submenu->{'triangle'});
	$th_submenu->{'square'}->signal_connect("toggled", sub { $main::message_clist->set_expander_style("square"); $main::folder_tree->set_expander_style("square");$main::prefs{'expander'} = "square";});
	$th_submenu->{'expandermenu'}->append($th_submenu->{'noexpander'});
	$th_submenu->{'expandermenu'}->append($th_submenu->{'circular'});
	$th_submenu->{'expandermenu'}->append($th_submenu->{'triangle'});
	$th_submenu->{'expandermenu'}->append($th_submenu->{'square'});
	$th_submenu->{'Expander'} = new Gtk::MenuItem(_("Expander Style"));
	$th_submenu->{'Expander'}->set_submenu($th_submenu->{'expandermenu'});
	$th_submenu->append($th_submenu->{'Expander'});
	$ml_submenu->append($tb_view->{'threads'});
 	$th_submenu->{'switch'}->signal_connect("toggled" => \&toggle_threads, $th_submenu);
 	$ml_submenu->{'Priority'} = new Gtk::CheckMenuItem(_("Priority"));
 	if ($main::prefs{'prioritycolumn'} eq "n") { $ml_submenu->{'Priority'}->set_active('0');};
 	if ($main::prefs{'prioritycolumn'} eq "y") { $ml_submenu->{'Priority'}->set_active('1');};
 	$ml_submenu->{'Priority'}->signal_connect("toggled" => \&toggle_column_view, \$main::message_clist, 0, \$main::prefs{'prioritycolumn'});
 	$ml_submenu->{'Priority'}->set_show_toggle('1');
 	$ml_submenu->append($ml_submenu->{'Priority'});
 	$ml_submenu->{'Attachment'} = new Gtk::CheckMenuItem(_("Attachment"));
 	if ($main::prefs{'attachcolumn'} eq "n") { $ml_submenu->{'Attachment'}->set_active('0');};
 	if ($main::prefs{'attachcolumn'} eq "y") { $ml_submenu->{'Attachment'}->set_active('1');};
 	$ml_submenu->{'Attachment'}->signal_connect("toggled" => \&toggle_column_view, \$main::message_clist, 1, \$main::prefs{'attachcolumn'});
 	$ml_submenu->{'Attachment'}->set_show_toggle('1');
 	$ml_submenu->append($ml_submenu->{'Attachment'});
 	$ml_submenu->{'New'} = new Gtk::CheckMenuItem(_("New"));
 	if ($main::prefs{'msgnewcolumn'} eq "n") { $ml_submenu->{'New'}->set_active('0');};
 	if ($main::prefs{'msgnewcolumn'} eq "y") { $ml_submenu->{'New'}->set_active('1');};
 	$ml_submenu->{'New'}->signal_connect("toggled" => \&toggle_column_view, \$main::message_clist, 2, \$main::prefs{'msgnewcolumn'});
 	$ml_submenu->{'New'}->set_show_toggle('1');
 	$ml_submenu->append($ml_submenu->{'New'});
 	$ml_submenu->{'server'} = new Gtk::CheckMenuItem(_("Server"));
	if ($main::prefs{'servercolumn'} eq "n") { $ml_submenu->{'server'}->set_active(0);}
       	if ($main::prefs{'servercolumn'} eq "y") { $ml_submenu->{'server'}->set_active(1);}
	$ml_submenu->{'server'}->signal_connect("toggled" => \&toggle_column_view, \$main::message_clist, 7, \$main::prefs{'servercolumn'});
	$ml_submenu->{'server'}->set_show_toggle('1');
	$ml_submenu->append($ml_submenu->{'server'});
 	$mm_tglhdr = new Gtk::CheckMenuItem(_("Header Panel"));
 	if ($main::prefs{'HeaderBar'} eq "n") { $mm_tglhdr->set_active('0');}
 	if ($main::prefs{'HeaderBar'} eq "y") { $mm_tglhdr->set_active('1');}
 	$mm_tglhdr->set_show_toggle('1');
 	
	$FTDetach = new Gtk::MenuItem(_("Detach FolderTree"));
	$FTDetach->show();
	$tb_view->append($FTDetach);
	
	$FTReattach = new Gtk::MenuItem(_("Reattach FolderTree"));
	$FTReattach->set_sensitive(0);
	$FTReattach->show();	
	$tb_view->append($FTReattach);
	
	$FTDetach->signal_connect("activate", \&DetachFolderTree);
	$FTReattach->signal_connect("activate", \&ReAttachFolderTree);
	
	$tb_view->{'viewpane'} = new Gtk::CheckMenuItem(_("View Pane"));
 	if ($main::prefs{'viewpane'} eq "n") { $tb_view->{'viewpane'}->set_active('0');}
 	if ($main::prefs{'viewpane'} eq "y") { $tb_view->{'viewpane'}->set_active('1');}
 	$tb_view->{'viewpane'}->set_show_toggle('1');
 	
 	$tb_view->append($mm_tglhdr);
 	$tb_view->append($tb_view->{'viewpane'});
 	$rm_view->set_submenu($tb_view);      
 	$tb_submenu->{'show'}->signal_connect("toggled", sub { &toggle_toolbar($main::root_window->{'handlebox'}, $tb_submenu) });
 
 	$rm_mail=new Gtk::MenuItem(_("Mail"));
 	$root_menu->append($rm_mail);
	$rm_message=new Gtk::MenuItem(_("Message"));
 	$root_menu->append($rm_message);
 	$mail_menu = new Gtk::Menu;
 	$message_menu = new Gtk::Menu;
 	$mm_checkall = new Gtk::MenuItem(_("Send & Receive"));
 	$accel_group->add ( $key_hash{'Send-and-Receive'}, $mod{$key_hash{'Send-and-Receive'.'mod'}},['visible'], $mm_checkall, "activate");
 	$mm_checkall->signal_connect("activate" => \&main::check_mail, "all", "1");
 	$mail_menu->append($mm_checkall);
 	$mm_check = new Gtk::MenuItem(_("Check"));
 	$mail_menu->append($mm_check);
 	$mm_check->set_submenu($main::acct_menu);
 	$mm_import = new Gtk::MenuItem(_("Import"));
      	$mm_import->{'menu'} = new Gtk::Menu;
 	$mm_import->{'menu'}->{'mass'} = new Gtk::MenuItem(_("A File .."));
 	$mm_import->{'menu'}->{'mass'}->signal_connect("activate" =>\&Pronto::Import::init_import_win);
 	$mm_import->{'menu'}->append($mm_import->{'menu'}->{'mass'});
 	$mm_import->{'menu'}->{'dir'} = new Gtk::MenuItem(_("A directory"));
       	$mm_import->{'menu'}->{'dir'}->signal_connect("activate", sub { &Pronto::Import::init_import_win($mm_import->{'menu'}->{'dir'}, "recursive"); });
 	$mm_import->{'menu'}->append($mm_import->{'menu'}->{'dir'});
 	$mm_import->set_submenu($mm_import->{'menu'});
 	$mail_menu->append($mm_import);
 	$mm_export = new Gtk::MenuItem(_("Export"));
 	$mm_export->signal_connect("activate" => \&Pronto::Export::init_export_win);
 	$mail_menu->append($mm_export);
 	$mm_sep1 = new Gtk::MenuItem;
 	$mail_menu->append($mm_sep1);
 	$mm_newm = new Gtk::MenuItem(_("New Message..."));
 	$accel_group->add( $key_hash{'New-Message'}, $mod{$key_hash{'New-Message'.'mod'}} ,['visible'], $mm_newm, "activate"); 
 	$mm_newm->signal_connect("activate" => \&Pronto::Compose::init_msg_window);
 	$message_menu->append($mm_newm);
	my $reply_menu = new Gtk::Menu;
	$mm_reply = new Gtk::MenuItem(_("To Sender"));
 	$mm_reply->signal_connect("activate" => \&Pronto::Data::MessageOp::reply, "y");
	$accel_group->add( $key_hash{'Reply'}, $mod{$key_hash{'Reply'.'mod'}} ,['visible'], $mm_reply, "activate");
 	$reply_menu->append($mm_reply);
 	my $mm_reply_list = new Gtk::MenuItem(_("To list"));
	$mm_reply_list->signal_connect("activate" => \&Pronto::Data::MessageOp::reply_to_list);
	$accel_group->add($key_hash{'Reply-To-List'}, $mod{$key_hash{'Reply-To-List'.'mod'}},['visible'], $mm_reply_list,"activate");
	$reply_menu->append($mm_reply_list);
	my $reply_all = new Gtk::Menu;
	my $reply_to_all = new Gtk::MenuItem(_("To All"));
	$reply_all->{'self'} = new Gtk::MenuItem(_("Including Self"));
	$reply_all->{'self'}->signal_connect("activate" => \&Pronto::Data::MessageOp::reply_all);
	$accel_group->add( $key_hash{'Reply-All-Including-Self'}, $mod{$key_hash{'Reply-All-Including-Self'.'mod'}}, ['visible'], $reply_all->{'self'}, "activate");
	$reply_all->append($reply_all->{'self'});
	$reply_all->{'remove'} = new Gtk::MenuItem(_("Execluding Self"));
	$reply_all->{'remove'}->signal_connect("activate" => \&Pronto::Data::MessageOp::reply_all, "y");
	$accel_group->add( $key_hash{'Reply-All-Execluding-Self'}, $mod{$key_hash{'Reply-All-Execluding-Self'.'mod'}}, ['visible'], $reply_all->{'remove'}, "activate");
	$reply_all->append($reply_all->{'remove'}); 
	$reply_to_all->set_submenu($reply_all);
	my $reply = new Gtk::MenuItem(_("Reply ..."));
	$reply->set_submenu($reply_menu);
	$reply_menu->append($reply_to_all);
	$message_menu->append($reply);
	$mm_forward = new Gtk::MenuItem(_("Forward..."));
 	$accel_group->add( $key_hash{'Forward'}, $mod{$key_hash{'Forward'.'mod'}} ,['visible'], $mm_forward, "activate"); 
 	$mm_forward->signal_connect("activate" => \&Pronto::Data::MessageOp::forward);
 	$message_menu->append($mm_forward);
 	$mm_edit = new Gtk::MenuItem(_("Edit..."));
 	$mm_edit->signal_connect("activate" => \&Pronto::Data::MessageOp::edit);
 	$accel_group->add($key_hash{'Edit'}, $mod{$key_hash{'Edit'.'mod'}}, ['visible'], $mm_edit, "activate");
	$message_menu->append($mm_edit);
 	$mm_view = new Gtk::MenuItem(_("Open in a view Win"));
 	$accel_group->add( $key_hash{'View-Win'}, $mod{$key_hash{'View-Win'.'mod'}}, ['visible'], $mm_view, "activate");
	$mm_view->signal_connect("activate", sub { &Pronto::Read::message_view_win(undef,1);});
	$message_menu->append($mm_view);
	my $mm_view_html = new Gtk::MenuItem(_("Open in an HTML Widget"));
	$accel_group->add( $key_hash{'HTML-View'}, $mod{$key_hash{'HTML-View'.'mod'}},['visible'],$mm_view_html,"activate");
	$mm_view_html->signal_connect("activate", sub { &Pronto::Read::read_html() });
	$message_menu->append($mm_view_html);
	$mm_view_header = new Gtk::MenuItem(_("View Header"));
	$accel_group->add( $key_hash{'View-Header'}, $mod{$key_hash{'View-Header'.'mod'}} ,['visible'], $mm_view_header, "activate");
	$message_menu->append($mm_view_header);
 	$mm_view_raw = new Gtk::MenuItem(_("View Source"));
 	$accel_group->add( $key_hash{'View-Source'}, $mod{$key_hash{'View-Source'.'mod'}} ,['visible'], $mm_view_raw, "activate");
 	$message_menu->append($mm_view_raw);
 	$mm_nextunread = new Gtk::MenuItem(_("Next Unread Message"));
 	$accel_group->add( $key_hash{'NextUnread'},$mod{$key_hash{'NextUnread'.'mod'}} ,['visible'], $mm_nextunread, "activate");
 	$message_menu->append($mm_nextunread);
 	$mm_nextunread->signal_connect("activate" => \&Pronto::MessageList::goto_next_unread_msg);
 	$mm_add2ab = new Gtk::MenuItem(_("Add to Addressbook"));
 	$message_menu->append($mm_add2ab);
 	$mm_accts = new Gtk::MenuItem(_("Accounts..."));
 	$mm_accts->signal_connect("activate" => \&Pronto::TableEdit::init_win, "account");
 	$mail_menu->append($mm_accts);
 	$mm_filters = new Gtk::MenuItem(_("Filters..."));
 	$mm_filters->signal_connect("activate" => \&Pronto::TableEdit::init_win, "filter");
 	$mail_menu->append($mm_filters);
 	$mail_menu->append($em_addybook);
 	$mm_sep3 = new Gtk::MenuItem;
 	$message_menu->append($mm_sep3);
 	$mm_scoreup = new Gtk::MenuItem(_("Score +1"));
 	$accel_group->add( 0x02b, ["shift-mask", "mod1-mask"], ['visible'], $mm_scoreup, "activate");
 	$message_menu->append($mm_scoreup);
 	$mm_scoredown = new Gtk::MenuItem(_("Score -1"));
 	$accel_group->add( 0x02d, "mod1-mask", ['visible'], $mm_scoredown, "activate");
 	$message_menu->append($mm_scoredown);
 	my $filtermenu = new Gtk::Menu;
 	$filtermenu->{'from'} = new Gtk::MenuItem(_("Based on From"));
 	$filtermenu->{'from'}->signal_connect("activate", sub { &Pronto::Filter::filter_editwin(undef,undef,"newfromlist",undef,"from") });
 	$filtermenu->{'to'} = new Gtk::MenuItem(_("Based on To"));
 	$filtermenu->{'to'}->signal_connect("activate", sub { &Pronto::Filter::filter_editwin(undef,undef,"newfromlist",undef,"to");});
 	$filtermenu->{'subject'}=new Gtk::MenuItem(_("Based on Subject"));
 	$filtermenu->{'subject'}->signal_connect("activate", sub { &Pronto::Filter::filter_editwin(undef,undef,"newfromlist",undef,"subject");});
 	$filtermenu->append($filtermenu->{'from'});
 	$filtermenu->append($filtermenu->{'to'});
 	$filtermenu->append($filtermenu->{'subject'});
 	my $mm_filter = new Gtk::MenuItem(_("Create Filter"));
 	$mm_filter->set_submenu($filtermenu);
 	my $mm_refilter = new Gtk::MenuItem(_("Refilter Message"));
 	$mm_refilter->signal_connect("activate" => \&Pronto::Data::Message::refilter);
 	$message_menu->append($mm_refilter);
	
	$mm_delete = new Gtk::MenuItem(_("Delete"));
 	$mm_delete->signal_connect("activate" => \&Pronto::MainWindow::handle_delete_msgs);
 	$accel_group->add( $key_hash{'Delete'}, $mod{$key_hash{'Delete'.'mod'}},['visible'], $mm_delete, "activate"); 
 	$message_menu->append($mm_delete);
 	
	my $serverstatmenu = new Gtk::Menu;
	
	$serverstatmenu->{'ServerLeave'} = new Gtk::MenuItem(_("Leave on server"));
 	$serverstatmenu->{'ServerLeave'}->signal_connect("activate", sub { &Pronto::MainWindow::handle_msgs_server_status(2) });
	$serverstatmenu->{'ServerFetch'} = new Gtk::MenuItem(_("Fetch from server"));
 	$serverstatmenu->{'ServerFetch'}->signal_connect("activate", sub { &Pronto::MainWindow::handle_msgs_server_status(4) });
	$serverstatmenu->{'ServerFetchDelete'} = new Gtk::MenuItem(_("Fetch & Delete"));
 	$serverstatmenu->{'ServerFetchDelete'}->signal_connect("activate", sub { &Pronto::MainWindow::handle_msgs_server_status(5) });
	$serverstatmenu->{'ServerDelete'} = new Gtk::MenuItem(_("Delete from server"));
 	$serverstatmenu->{'ServerDelete'}->signal_connect("activate", sub { &Pronto::MainWindow::handle_msgs_server_status(3) });
 	$serverstatmenu->append($serverstatmenu->{'ServerLeave'});
 	$serverstatmenu->append($serverstatmenu->{'ServerFetch'});
 	$serverstatmenu->append($serverstatmenu->{'ServerFetchDelete'});
 	$serverstatmenu->append($serverstatmenu->{'ServerDelete'});
	my $mm_servermenu = new Gtk::MenuItem(_("Server Status"));
 	$mm_servermenu->set_submenu($serverstatmenu);
 	$message_menu->append($mm_servermenu);
	
	
 	$message_menu->append($Pronto::FolderMenus::cp_menu_items{0});
 	$message_menu->append($Pronto::FolderMenus::mv_menu_items{0});
 	$message_menu->append($mm_filter);
 	$rm_mail->set_submenu($mail_menu);
 	$rm_message->set_submenu($message_menu);
 	$rm_help=new Gtk::MenuItem(_("Help"));
 	$root_menu->append($rm_help);
 	$help_menu = new Gtk::Menu;
 	$hm_help = new Gtk::MenuItem(_("Help..."));
 	$accel_group->add( 0xFFBE, "release-mask" ,['visible'], $hm_help, "activate"); 
 	$hm_help->signal_connect("activate" => \&Pronto::Help::help_win, "index.html");
 	$help_menu->append($hm_help);
 	$mm_info = new Gtk::MenuItem(_("My Info .."));
	$mm_info->signal_connect("activate", sub { my $gtkversion = Gtk->major_version.'.'.Gtk->minor_version.'.'.Gtk->micro_version; &main::err_dialog("Perl version $]\nPronto version $main::version\nGtk+ version $gtkversion\nGtk::Perl version $Gtk::VERSION\nMIME::Parser version $MIME::Parser::VERSION\nYour HTML widget is $main::HTMLWIDGET\nYour database Driver is $main::prefs{'DatabaseDriver'}",undef,"System Info"); });
	$help_menu->append($mm_info);
	$hm_about = new Gtk::MenuItem(_("About Pronto"));
 	$hm_about->signal_connect("activate" => \&Pronto::About::init_about_dlg);
 	$help_menu->append($hm_about);
 	$rm_help->set_submenu($help_menu);
 	
	$main::root_window->{'root_vbox'}= new Gtk::VBox(0,0);
 	$main::root_window->{'root_vbox'}->pack_start($root_menu,0,0,0);

 	#make our toolbar.
 
 	&create_toolbar(undef, $main::root_window->{'toolbar'},$window,$bg); 
 	$main::root_window->{'handlebox'} = new Gtk::HandleBox;
 	$main::root_window->{'handlebox'}->add($main::root_window->{'toolbar'});
 	$main::root_window->{'root_vbox'}->pack_start($main::root_window->{'handlebox'},0,0,0);
 	
	#make layout - including read pane and clist
	
	make_layout();
	
 	$main::root_window->add($main::root_window->{'root_vbox'});
	$mm_tglhdr->signal_connect("toggled" => \&toggle_table, $main::root_window->{'tablehbox'});
	$mm_view_header->signal_connect("activate", sub {&Pronto::Read::head_view(3)});
 	$mm_view_raw->signal_connect("activate", sub {&Pronto::Read::view_raw});
	$mm_add2ab->signal_connect("activate" => \&Pronto::Data::Message::clist2ab, $main::message_clist);
 	$mm_scoreup->signal_connect("activate" => \&Pronto::Data::Message::scoring, $main::message_clist, "up");
 	$mm_scoredown->signal_connect("activate" => \&Pronto::Data::Message::scoring, $main::message_clist, "down");
 	$main::root_window->{'html_view'}->realize;
 	show_all $main::root_window;
 
	#build icondir menu 
 	my @results=&get_pixmap_dirs;
      	foreach(@results) {
	      my $hbox = new Gtk::HBox(0,0);
     	      $hbox->show;
	      if(-f @{$_}[1] . "/tb_new_mail.xpm") {
			($pixmap,$mask) = Gtk::Gdk::Pixmap->create_from_xpm($main::message_clist->clist_window,$main::message_clist->style->bg('normal'),@{$_}[1] . "/tb_new_mail.xpm");
	      }
	      else {
			($pixmap,$mask) = Gtk::Gdk::Pixmap->create_from_xpm_d($main::message_clist->clist_window,$main::message_clist->style->bg('normal'),@main::dummy_pixmap);
              }
	      my $pic = new Gtk::Pixmap($pixmap,$mask);
	      my $lbl = new Gtk::Label("   " . @{$_}[0]);
	      $lbl->show;
	      $pic->show;
	      $hbox->pack_start($pic,0,0,0);
	      $hbox->pack_start($lbl,0,0,0);
	      $tb_icondir->{'dir'} = new Gtk::MenuItem;
	      $tb_icondir->{'dir'}->add($hbox);
	      $tb_icondir->{'dir'}->signal_connect("activate" =>\&create_toolbar, $main::root_window->{'toolbar'}, $window, $bg, $main::message_clist,$main::root_window->{'attbtn'}, $main::root_window->{'button_pixmap'}, $main::root_window->{'button_mask'}, @{$_}[1], "recreate");
	      $tb_icondir->append($tb_icondir->{'dir'});
	      $tb_icondir->{'dir'}->show;
        }
  	$tb_submenu->{'switch'}->set_submenu($tb_icondir); #set it
  	#rescan icondir
  	$tb_submenu->{'rescan'}->signal_connect("activate" => 
        						      sub { 
	      							$tb_icondir->detach;
	      							$tb_icondir->destroy;
	      							$tb_icondir = new Gtk::Menu;
	      							my @results=&get_pixmap_dirs;
              							foreach(@results) {
	      								my $hbox = new Gtk::HBox(0,0);
     	      								$hbox->show;
              								my ($pixmap,$mask);
	      								if(-f @{$_}[1] . "/tb_new_mail.xpm") {
	      									($pixmap,$mask) = Gtk::Gdk::Pixmap->create_from_xpm($main::message_clist->clist_window,$main::message_clist->style->bg('normal'),@{$_}[1] . "/tb_new_mail.xpm");
	      							        }
	      								else {
										($pixmap,$mask) = Gtk::Gdk::Pixmap->create_from_xpm_d($main::message_clist->clist_window,$main::message_clist->style->bg('normal'),@main::dummy_pixmap);
              								}
              							my $pic = new Gtk::Pixmap($pixmap,$mask);
	      							my $lbl = new Gtk::Label("   " . @{$_}[0]);
	      							$lbl->show;
	      							$pic->show;
	      							$hbox->pack_start($pic,0,0,0);
	      							$hbox->pack_start($lbl,0,0,0);
	      							$tb_icondir->{'dir'} = new Gtk::MenuItem;
	      							$tb_icondir->{'dir'}->add($hbox);
	      							$tb_icondir->{'dir'}->signal_connect("activate" =>
	      								\&create_toolbar, $main::root_window->{'toolbar'}, $window, $bg, $main::message_clist, $main::root_window->{'attbtn'}, $main::root_window->{'button_pixmap'}, $main::root_window->{'button_mask'}, @{$_}[1], "recreate");
	      							$tb_icondir->append($tb_icondir->{'dir'});
	      							$tb_icondir->{'dir'}->show;
	      							$tb_submenu->{'switch'}->set_submenu($tb_icondir);
	      							}
	 							});
	$tb_submenu->{'install'}->signal_connect("activate" => \&Pronto::Config::init_browse_dlg, $tb_submenu->{'rescan'}, "install_theme");
        $tb_view->{'viewpane'}->signal_connect("toggled" => \&toggle_viewpane,  $mm_tglhdr);
       
       
	if ($main::prefs{'HeaderBar'} eq "n") { $main::root_window->{'table1'}->hide; }
 
     	if ($main::prefs{'toolbar'} eq "n") { 
         	$main::root_window->{'handlebox'}->hide; 
         	$tb_submenu->{'icon'}->set_sensitive(0);
         	$tb_submenu->{'text'}->set_sensitive(0);
         	$tb_submenu->{'both'}->set_sensitive(0);
         }
	 
	 if ($main::prefs{'viewpane'} eq "n") {
	       $main::root_window->{'nvbox'}->hide;
	       $mm_tglhdr->set_sensitive(0);
	 }
	
	$main::root_window->signal_connect("size-request" => \&main::save_win_size, "startUp", $main::root_window->window);
	$main::root_window->{'toolbar'}->set_style($main::prefs{'toolbarstyle'});
	
 	if ($main::prefs{'toolbarstyle'} eq "icons") { $tb_submenu->{'icon'}->set_active('1');}
 	if ($main::prefs{'toolbarstyle'} eq "text") { $tb_submenu->{'text'}->set_active('1');}
 	if ($main::prefs{'toolbarstyle'} eq "both") { $tb_submenu->{'both'}->set_active('1');}
 
 	if ($main::prefs{'messageview'} eq "ctree") {
		$main::message_clist->set_line_style ( $main::prefs{'threadstyle'} );
 		if ($main::prefs{'threadstyle'} eq "solid") { $th_submenu->{'solid'}->set_active('1');}
 		if ($main::prefs{'threadstyle'} eq "dotted") { $th_submenu->{'dotted'}->set_active('1');}
 		if ($main::prefs{'threadstyle'} eq "tabbed") { $th_submenu->{'tabbed'}->set_active('1');}
 		if ($main::prefs{'threadstyle'} eq "none") { $th_submenu->{'none'}->set_active('1');}
 		if ($main::prefs{'expander'} eq "none") { $th_submenu->{'noexpander'}->set_active(1);}
		if ($main::prefs{'expander'} eq "triangle") { $th_submenu->{'triangle'}->set_active(1);}
		if ($main::prefs{'expander'} eq "circular") { $th_submenu->{'circular'}->set_active(1);}
		if ($main::prefs{'expander'} eq "square") { $th_submenu->{'square'}->set_active(1);}
		
	}
	
 	if ($main::prefs{'messageview'} ne "ctree") {
  		$th_submenu->{'threadpref'}->set_sensitive(0);
  		$th_submenu->{'threadbysubject'}->set_sensitive(0);
		$th_submenu->{'guess'}->set_sensitive(0);
		$th_submenu->{'symbol'}->set_sensitive(0);
		$th_submenu->{'lines'}->set_sensitive(0);
		$th_submenu->{'Expander'}->set_sensitive(0);
	} 
 
 
 	$main::attpixmap->hide;
 	$main::root_window->{'button'}->hide;
 	&Pronto::MessageList::make_clist_sigs; 
	
	if ($main::prefs{'FTDetached'}) {
		&DetachFolderTree();
	}

	return 1;

}

sub get_pixmap_dirs {
	my ($pixpath, $tmp);
	my (@results);
	for(my $i =0;$i<2;$i++) {
		if($i == 0) {$pixpath=$main::libpath."/pixmaps";}
		if($i == 1) {$pixpath=$main::prefs{'MailDir'}."/pixmaps";}
		opendir DIR,$pixpath; 
		foreach (readdir(DIR)){
			$tmp=$pixpath."/".$_;
			if (-d $tmp && $_ !~ /^\.\.?/ && defined
				&check_pixmap_path($tmp)){ 
				push (@results, [$_, $tmp]);
			}
		}
		closedir(DIR);
	}
	return @results;
}


sub create_toolbar {
  
  	my ($widget, $toolbar, $window, $bg, $message_clist,$attbtn, $button_pixmap, $button_mask,$path, $flag) = @_;

	  if (defined $flag and $flag eq "recreate") { 
	  	$main::prefs{'PixmapDir'} = $path;
	  	#detach our menu.
	  	$main::acct_menu2->detach;
	  	#destroy toolbar items.
          	$toolbar->{'item6'}->destroy;
          	$toolbar->{'item1'}->destroy;
          	$toolbar->{'item2'}->destroy;
          	$toolbar->{'item3'}->destroy;
          	$toolbar->{'item4'}->destroy;
          	$toolbar->{'item5'}->destroy;
          	$toolbar->{'item7'}->destroy;
          	#destroy clist pixmaps..
          	$main::root_window->{'exclame'}->destroy;
	  	if(-f "$main::prefs{'PixmapDir'}/exclamation.xpm") {
          		($main::root_window->{'pixmap'},$main::root_window->{'mask'})=Gtk::Gdk::Pixmap->create_from_xpm($window,$bg,"$main::prefs{'PixmapDir'}/exclamation.xpm");
          	}
	  	else {
			($main::root_window->{'pixmap'},$main::root_window->{'mask'})=Gtk::Gdk::Pixmap->create_from_xpm_d($window,$bg,@main::dummy_pixmap);
	  	}
	  	$main::root_window->{'exclame'} = new Gtk::Pixmap($main::root_window->{'pixmap'}, $main::root_window->{'mask'});
          	$main::message_clist->set_column_widget(0, $main::root_window->{'exclame'});
          	$main::root_window->{'clip'}->destroy;
	  	if(-f "$main::prefs{'PixmapDir'}/paperclip.xpm") {
          		($main::root_window->{'clippixmap'}, $main::root_window->{'clipmask'})=Gtk::Gdk::Pixmap->create_from_xpm($window,$bg, "$main::prefs{'PixmapDir'}/paperclip.xpm");
          	}
	  	else {
			($main::root_window->{'clippixmap'}, $main::root_window->{'clipmask'})=Gtk::Gdk::Pixmap->create_from_xpm_d($window,$bg,@main::dummy_pixmap);
          	}
          	$main::root_window->{'clip'} = new Gtk::Pixmap($main::root_window->{'clippixmap'}, $main::root_window->{'clipmask'});
          	$main::message_clist->set_column_widget(1, $main::root_window->{'clip'});
          	$main::root_window->{'newmp'}->destroy;
	  	if(-f "$main::prefs{'PixmapDir'}/newm.xpm") {
	  		($main::root_window->{'newm'}, $main::root_window->{'newm_mask'})=Gtk::Gdk::Pixmap->create_from_xpm($window,$bg, "$main::prefs{'PixmapDir'}/newm.xpm");
          	}
          	else {
	  		($main::root_window->{'newm'}, $main::root_window->{'newm_mask'})=Gtk::Gdk::Pixmap->create_from_xpm_d($window,$bg, @main::dummy_pixmap);
          	}
         	 $main::root_window->{'newmp'} = new Gtk::Pixmap($main::root_window->{'newm'}, $main::root_window->{'newm_mask'});
         	 $main::message_clist->set_column_widget(2, $main::root_window->{'newmp'});
	 	#headerpanel attachement button
	  	$main::root_window->{'attbtn'}->destroy;
	  	if(-f "$main::prefs{'PixmapDir'}/ab.xpm") {
          		($button_pixmap, $button_mask) = Gtk::Gdk::Pixmap->create_from_xpm($window,$bg, "$main::prefs{'PixmapDir'}/ab.xpm");
          	}
	  	else {
			($button_pixmap, $button_mask) = Gtk::Gdk::Pixmap->create_from_xpm_d($window,$bg,@main::dummy_pixmap);
          	}
          	$main::root_window->{'attbtn'} = new Gtk::Pixmap($button_pixmap, $button_mask);
	  	$main::root_window->{'attbtn'}->show;
	  	$main::attpixmap->add($main::root_window->{'attbtn'});
	  }
	  
  	#toolbar again.  
 	$toolbar->{'item1'} = $toolbar->append_item(_("New Message"),_("Click here to send a new message"),"",&main::new_pixmap("$main::prefs{'PixmapDir'}/tb_new_mail.xpm", $window, $bg));
 	$toolbar->{'item1'}->signal_connect('clicked', \&Pronto::Compose::init_msg_window);
 	$toolbar->{'item2'} = $toolbar->append_item(_("Reply"),_("Click here to reply to this message or right click on this button for more options"),"",&main::new_pixmap("$main::prefs{'PixmapDir'}/tb_reply.xpm", $window, $bg));
 	$toolbar->{'item2'}->signal_connect('clicked', \&Pronto::Data::MessageOp::reply, "y");
 	$toolbar->{'item2'}->signal_connect("button_press_event" => \&rightclick, 1);
 	$toolbar->{'item2'}->{'popup'} = new Gtk::Menu;
 	$toolbar->{'item2'}->{'popup'}->{'sep'} = new Gtk::MenuItem;
 	$toolbar->{'item2'}->{'popup'}->{'sep'}->show;
 	$toolbar->{'item2'}->{'popup'}->append($toolbar->{'item2'}->{'popup'}->{'sep'});   
 	$toolbar->{'item2'}->{'popup'}->{'quoted'} = new Gtk::MenuItem(_("Quoted"));
 	$toolbar->{'item2'}->{'popup'}->{'quoted'}->signal_connect("activate" => \&Pronto::Data::MessageOp::reply, "y");
 	$toolbar->{'item2'}->{'popup'}->{'quoted'}->show;
 	$toolbar->{'item2'}->{'popup'}->append($toolbar->{'item2'}->{'popup'}->{'quoted'});
 	$toolbar->{'item2'}->{'popup'}->{'unquoted'} = new Gtk::MenuItem(_("Unquoted"));
 	$toolbar->{'item2'}->{'popup'}->{'unquoted'}->signal_connect("activate" => \&Pronto::Data::MessageOp::reply, "n");
 	$toolbar->{'item2'}->{'popup'}->{'unquoted'}->show;
 	$toolbar->{'item2'}->{'popup'}->append($toolbar->{'item2'}->{'popup'}->{'unquoted'});
 	$toolbar->{'item2'}->{'popup'}->{'list'} = new Gtk::MenuItem(_("To list"));
	$toolbar->{'item2'}->{'popup'}->{'list'}->signal_connect("activate" => \&Pronto::Data::MessageOp::reply_to_list);
	$toolbar->{'item2'}->{'popup'}->{'list'}->show;
	$toolbar->{'item2'}->{'popup'}->append($toolbar->{'item2'}->{'popup'}->{'list'});
	$toolbar->{'item3'} = $toolbar->append_item(_("Reply All"),_("Click here to reply-all to this message"),"",&main::new_pixmap("$main::prefs{'PixmapDir'}/tb_replyall.xpm", $window, $bg));
 	$toolbar->{'item3'}->signal_connect('clicked', \&Pronto::Data::MessageOp::reply_all, "y");
	$toolbar->{'item3'}->signal_connect("button_press_event" => \&rightclick, 1);
 	$toolbar->{'item3'}->{'popup'} = new Gtk::Menu;
 	$toolbar->{'item3'}->{'popup'}->{'sep'} = new Gtk::MenuItem;
 	$toolbar->{'item3'}->{'popup'}->{'sep'}->show;
 	$toolbar->{'item3'}->{'popup'}->append($toolbar->{'item3'}->{'popup'}->{'sep'});   
 	$toolbar->{'item3'}->{'popup'}->{'remove'} = new Gtk::MenuItem(_("Remove Self"));
 	$toolbar->{'item3'}->{'popup'}->{'remove'}->signal_connect("activate" => \&Pronto::Data::MessageOp::reply_all, "y");
 	$toolbar->{'item3'}->{'popup'}->{'remove'}->show;
 	$toolbar->{'item3'}->{'popup'}->append($toolbar->{'item3'}->{'popup'}->{'remove'});
 	$toolbar->{'item3'}->{'popup'}->{'include'} = new Gtk::MenuItem(_("Include Self"));
 	$toolbar->{'item3'}->{'popup'}->{'include'}->signal_connect("activate" => \&Pronto::Data::MessageOp::reply_all);
 	$toolbar->{'item3'}->{'popup'}->{'include'}->show;
 	$toolbar->{'item3'}->{'popup'}->append($toolbar->{'item3'}->{'popup'}->{'include'});
 	$toolbar->{'item4'} = $toolbar->append_item(_("Forward"),_("Click here to forward this message to someone"),"",&main::new_pixmap("$main::prefs{'PixmapDir'}/tb_forward.xpm", $window, $bg));
 	$toolbar->{'item4'}->signal_connect('clicked', \&Pronto::Data::MessageOp::forward);
 	$toolbar->{'item5'} = $toolbar->append_item(_("Delete"),_("Click here to delete the selected messages"),"",&main::new_pixmap("$main::prefs{'PixmapDir'}/tb_delete.xpm", $window, $bg));
 	$toolbar->{'item5'}->signal_connect('clicked', \&Pronto::MainWindow::handle_delete_msgs);
 	$toolbar->{'item6'} = $toolbar->append_item(_("Send & Receive"),_("Click here to send mail in your Outbox, if any, as well as check  all of your accounts for new mail, Or right-click for a list of accounts to check for new mail only or to send mail in outbox only."),"",&main::new_pixmap("$main::prefs{'PixmapDir'}/prefs.xpm", $window, $bg));
 	$toolbar->{'item6'}->signal_connect('clicked', \&main::check_mail, "all", "1");
 	$toolbar->{'item6'}->signal_connect("button_press_event" => \&rightclick, 1);
 	#popup menu for send and rec.
 	$toolbar->{'item6'}->{'popup'} = new Gtk::Menu;
 	$toolbar->{'item6'}->{'popup'}->{'sep'} = new Gtk::MenuItem;
 	$toolbar->{'item6'}->{'popup'}->{'sep'}->show;
 	$toolbar->{'item6'}->{'popup'}->append($toolbar->{'item6'}->{'popup'}->{'sep'});
 	$toolbar->{'item6'}->{'popup'}->{'check'} = new Gtk::MenuItem(_("Check"));
 	$toolbar->{'item6'}->{'popup'}->{'check'}->show;
 	$toolbar->{'item6'}->{'popup'}->{'check'}->set_submenu($main::acct_menu2);
 	$toolbar->{'item6'}->{'popup'}->append($toolbar->{'item6'}->{'popup'}->{'check'});
 	$toolbar->{'item6'}->{'popup'}->{'sep2'} = new Gtk::MenuItem;
 	$toolbar->{'item6'}->{'popup'}->{'sep2'}->show;
 	$toolbar->{'item6'}->{'popup'}->{'send'} = new Gtk::MenuItem(_("Send only"));
 	$toolbar->{'item6'}->{'popup'}->{'send'}->signal_connect("activate" => \&main::send_out);
 	$toolbar->{'item6'}->{'popup'}->{'send'}->show;
 	$toolbar->{'item6'}->{'popup'}->append($toolbar->{'item6'}->{'popup'}->{'send'});
 	#end popupmenu
 	$toolbar->{'item7'} = $toolbar->append_item(_("Address Book"),_("Click here to edit/add addresses"), "", &main::new_pixmap("$main::prefs{'PixmapDir'}/addressbook.xpm", $window, $bg));
 	$toolbar->{'item7'}->signal_connect('clicked', \&Pronto::AddressBook::init_win);
	
	

	if (defined $flag and $flag eq "recreate") {
	    
	        my $curfolder = &Pronto::FolderTree::get_folder_id();
	        if (!$curfolder or $curfolder == 0) { return 1; } else {  &Pronto::MessageList::refresh_messages }
  	  	my ($sp,$sm,$vp,$vm);
	  	if(-f "$main::prefs{'PixmapDir'}/search.xpm") {
			($sp,$sm)=Gtk::Gdk::Pixmap->create_from_xpm($main::root_window->window,$main::root_window->style->bg('normal'),"$main::prefs{'PixmapDir'}/search.xpm");
          	}
	  	else {
			($sp,$sm)=Gtk::Gdk::Pixmap->create_from_xpm_d($main::root_window->window,$main::root_window->style->bg('normal'),@main::dummy_pixmap);
          	}
	  	if(-f "$main::prefs{'PixmapDir'}/vfolder.xpm") {
			($vp,$vm)=Gtk::Gdk::Pixmap->create_from_xpm($main::root_window->window,$main::root_window->style->bg('normal'),"$main::prefs{'PixmapDir'}/vfolder.xpm");
	  	}
	  	else {
	        	($vp,$vm)=Gtk::Gdk::Pixmap->create_from_xpm_d($main::root_window->window,$main::root_window->style->bg('normal'),@main::dummy_pixmap);
          	}    
	    	foreach(keys(%main::folderidtoname)) {
		
			if ($_ == 100) {
		  		$main::folder_tree->node_set_pixtext($main::ft_node[$_],0,$main::folderidtoname{$_},2,$sp,$sm);
			}
		
			if ($_ > 100) {
		  		$main::folder_tree->node_set_pixtext($main::ft_node[$_],0,$main::folderidtoname{$_},2,$vp,$vm);
			}
	      }
	 }
  

	return 1;
}

sub check_pixmap_path {
	
	my ($dirname) = @_;
	my @pixmaps = ("about.xpm", "addressbook.xpm", "back.xpm", 
	"pronto-icon.xpm", "down.xpm", "exclamation.xpm", "forward_flag.xpm", 
	"go.xpm",  "paperclip.xpm", "prefs.xpm", "reply_flag.xpm", 
	 "spellcheck.xpm", "tb_delete.xpm", "tb_forward.xpm", 
	"tb_new_mail.xpm", "tb_reply.xpm", "ab.xpm", "tb_replyall.xpm", 
	"tb_send.xpm", "top.xpm", "up.xpm","search.xpm","vfolder.xpm","newm.xpm");
	
         foreach (@pixmaps) { 
	 	if (-f "$dirname/$_") { 
		 	next;
       	 	} else {
		 	return undef;
		}
	 }
	return 1;
}

sub rightclick {

	my ($widget, $data, $event) = @_;
	if (($event->{button} == 3) and ($widget->{'popup'})) {
   		$widget->{'popup'}->popup(undef,undef,$event->{button},1);
     	}
     
     return 1;
}


sub make_layout {
	
	my ($flag) = @_;
	my ($selectedmessage,$selectedfolder);
	if ($flag) {
		$selectedmessage = &Pronto::MessageList::get_last_selected_node_or_row();
		if ($main::prefs{'messageview'} eq "ctree") {
			$selectedmessage = &Pronto::MessageList::get_node_row($selectedmessage);
		}	
		$selectedfolder = &Pronto::FolderTree::get_folder_id();
		$main::root_window->{'vpane'}->destroy;
		$main::root_window->{'hpane'}->destroy;
		$main::root_window->{'scroll1'}->destroy;
		$main::root_window->{'message_vbox'}->destroy;
		$main::root_window->{'html_view'}->destroy;
	}
 	
	$main::root_window->{'vpane'} = new Gtk::VPaned;
 	$main::root_window->{'hpane'} = new Gtk::HPaned;
 	$main::root_window->{'scroll1'} = new Gtk::ScrolledWindow(undef,undef);
 	$main::root_window->{'scroll1'}->set_policy('automatic','automatic');
 	my ($swidth,$sheight) = &main::get_win_size("startPane",225,125);
	$main::root_window->{'scroll1'}->set_usize($swidth,$sheight);
 	$main::root_window->{'scroll1'}->show;
	$main::root_window->{'message_vbox'} = new Gtk::VBox(0,5);
 	$main::root_window->{'message_vbox'}->show;
 	if ($flag) {
		&Pronto::MessageList::make_clist("y"); 
		undef %main::folderidtoname;
		undef %main::foldernametoid;
		undef @main::ft_node;
		$main::folder_tree->destroy;
		&Pronto::FolderTree::init_folder_tree;
		&Pronto::FolderTree::refresh_folder_tree;		
		&Pronto::FolderTree::set_folder_style;
	} else {
		&Pronto::MessageList::make_clist();	# make our list	
 		$main::root_window->{'message_vbox'}->pack_start($main::root_window->{'scroll2'},1,1,0);
 		$main::root_window->{'message_vbox'}->pack_start($main::root_window->{'button'},0,0,0);
 	}
	$main::root_window->{'scroll1'}->add($main::folder_tree);
	# make read_pane

	($main::root_window->{'nvbox'},,$main::root_window->{'attbtn'},$main::root_window->{'button_pixmap'},$main::root_window->{'button_pixmap'},$main::root_window->{'tablehbox'}) = &Pronto::Read::init_read_pane;
 	# Standard Layout 
	###########################################################
	if ($main::prefs{'Layout'} == 1) {
		$main::root_window->{'hpane'}->add1($main::root_window->{'scroll1'});
		$main::root_window->{'hpane'}->add2($main::root_window->{'message_vbox'});
		$main::root_window->{'vpane'}->add1($main::root_window->{'hpane'});
		$main::root_window->{'vpane'}->add2($main::root_window->{'nvbox'});
		$main::root_window->{'root_vbox'}->pack_start($main::root_window->{'vpane'},1,1,0);
	}
	##########################################################
	# Folder Tree runs through the whole screen
	elsif ($main::prefs{'Layout'} == 2) {
		$main::root_window->{'hpane'}->add1($main::root_window->{'scroll1'});
		$main::root_window->{'vpane'}->add1($main::root_window->{'message_vbox'});
		$main::root_window->{'vpane'}->add2($main::root_window->{'nvbox'});
		$main::root_window->{'hpane'}->add2($main::root_window->{'vpane'});
		$main::root_window->{'root_vbox'}->pack_start($main::root_window->{'hpane'},1,1,0);
	}
	#########################################################
	$main::root_window->{'scroll1'}->signal_connect("size-allocate" => \&main::save_sizepane);
       	show_all $main::root_window;
	if ($flag) { 
		&Pronto::MessageList::make_clist_sigs;
		$main::root_window->{'button'}->hide;
		$main::attpixmap->hide;
		my $window = $main::root_window->window;
		my $bg = $main::root_window->style->bg('normal');
		# for some odd reason the toolbar does not like all this so we recreate it too :(
		&create_toolbar(undef,$main::root_window->{'toolbar'},$window,$bg,$main::message_clist,$main::root_window->{'attbtn'},$main::root_window->{'button_pixmap'},$main::root_window->{'button_mask'},$main::prefs{'PixmapDir'},"recreate");
		$main::root_window->{'toolbar'}->set_style($main::prefs{'toolbarstyle'});
		$main::root_window->{'handlebox'}->queue_resize();
		if ($main::prefs{'viewpane'} eq "n") {
			$main::root_window->{'nvbox'}->hide;
		}	
		if (defined $selectedfolder && $selectedfolder !=100) {
			$main::folder_tree->select($main::ft_node[$selectedfolder]);
			if ($main::prefs{'messageview'} eq "clist") {
				&Pronto::MessageList::refresh_messages();
			} else {
				&Pronto::MessageList::refresh_ctree("switch");
			}	
			if (defined $selectedmessage) {
				Gtk::CList::moveto($main::message_clist,$selectedmessage,0,'0.5','0.5');
				Gtk::CList::select_row($main::message_clist,$selectedmessage,0);
				Gtk::CList::set_focus_row($main::message_clist,$selectedmessage);
       				my $msgid = &Pronto::MessageList::get_selected_msgid();
				&Pronto::Read::view_message($main::conn, $msgid, $main::root_window->{'html_view'}, 1, 0, $main::attach_menu, $main::view_attach_menu, $main::root_window->{'hdr_pane'});
			}	
		}
	}
}


# signal handler for moving the currently selected messages
# inputs : widget (ignored) and destination folder id
# outputs: 1
sub handle_move_msgs {
	my ($d,$destfldr) = @_;
	my $curfolder = &Pronto::FolderTree::get_folder_id();
	if (!$curfolder) { return 1 }
	if ($curfolder == $destfldr) { return 1; }
	my (@msgids,$sql,$count);
	@msgids = &Pronto::MessageList::get_selected_msgids();
	if (!@msgids) {
		&main::err_dialog(_("No messages were selected !"));
		return;
	}	
	my $pos = &Pronto::MessageList::get_position();
	&Pronto::Data::Message::move($destfldr, @msgids);
	&Pronto::MessageList::refresh();
	&Pronto::MessageList::set_position($pos);
	$count = scalar(@msgids);
	if ($curfolder == 100) {
		my $searchcount = $main::folder_tree->node_get_text($main::ft_node[100],1);
		$searchcount = $searchcount - $count;
		$main::folder_tree->node_set_text($main::ft_node[100],1,$searchcount);
	}
	&Pronto::FolderTree::refresh_folder_tree();
	return 1;
}


# signal handler for copying the currently selected messages
# inputs : widget (ignored) and destination folder id
# outputs: 1
sub handle_copy_msgs {	
	my $destfldr = $_[1];
 	my ($curfolder, $sql, $query, @row,@msgids);
 	$curfolder = &Pronto::FolderTree::get_folder_id();
	if (!$curfolder) { return 1 }
 	if ($curfolder == $destfldr) { 
		return 1; 
 	}
 	@msgids = &Pronto::MessageList::get_selected_msgids();
	if (!@msgids) { &main::err_dialog(_("Select a Message First"));return; }
    	&Pronto::Data::Message::copy($destfldr, @msgids);
 	&Pronto::FolderTree::refresh_folder_tree; 
	return 1;
}


# signal handler for deleting the currently selected messages
# inputs : widget (ignored)
# outputs: 1
sub handle_delete_msgs {
	my (@msgids,$curfolder);
	$curfolder = &Pronto::FolderTree::get_folder_id();
	if (!$curfolder) { return 1 }
	@msgids = &Pronto::MessageList::get_selected_msgids();
	if (!@msgids) { &main::err_dialog(_("Select a Message First"));return; }
	my $pos = &Pronto::MessageList::get_position();
	if ($curfolder != 4) {
		&Pronto::Data::Message::move(4, @msgids);
	} else {
		&Pronto::Data::Message::delete(@msgids);
	}
	&Pronto::MessageList::refresh();	
	&Pronto::MessageList::set_position($pos);
	&Pronto::FolderTree::refresh_folder_tree();
	return 1;
}

# signal handler for setting the currently selected messages' server status
# inputs : handle_msgs_server_status ($setstatus)
# outputs: 1
## setstatus 0 = Msg not on server
## setstatus 1 = Msg on server and has not been fetched
## setstatus 2 = Msg on server and has been fetched
## setstatus 3 = Msg on server and is flagged to be removed in next send & recieve
## setstatus 4 = Msg on server is flagged to be fetched in next send & recieve
## setstatus 5 = Msg on server is flagged to be fetched and deleted in next send & recieve
## setstatus 6 = Msg on server and has been fetched (same as status 2 but msg 
##							was originally left to be fetched)
sub handle_msgs_server_status {
	my ($setstatus) = @_;
	my (@msgids,$curfolder);
	$curfolder = &Pronto::FolderTree::get_folder_id();
	if (!$curfolder) { return 1 }
	@msgids = &Pronto::MessageList::get_selected_msgids();
	if (!@msgids) { &main::err_dialog(_("Select a Message First")); return 1}
	my $pos = &Pronto::MessageList::get_position();
	foreach my $msgid (@msgids) {
		&Pronto::Data::Message::set_server_status($msgid, $setstatus);
	}
	&Pronto::MessageList::refresh();
	&Pronto::MessageList::set_position($pos)if (defined $pos);	
	return 1;
}
1;

__DATA__

sub toggle_table {
 
 	my ($widget, $table) = @_;
 	if ($main::prefs{'HeaderBar'} eq "y") {
  		$table->hide;
  		$main::prefs{'HeaderBar'}="n";
 	} else {
  		$table->show;
  		$main::prefs{'HeaderBar'}="y";
 }
 return 1;
}

sub toggle_viewpane {

        my ($widget, $head) = @_;
	  
	    if ($main::prefs{'viewpane'} eq "y") {
	             $main::root_window->{'nvbox'}->hide;
		     $main::prefs{'viewpane'} = "n";
		     $head->set_sensitive(0);
		     
	    } else {
	    
	    	$main::root_window->{'nvbox'}->show;
	    	$main::prefs{'viewpane'} = "y";
	    	$head->set_sensitive(1);
		&Pronto::Read::clear_widget;
    }
	    	    
return 1;

}


sub toggle_toolbar {

	my ($handlebox, $tb_submenu) = @_;

	      if ($main::prefs{'toolbar'} eq "y") { 
			$handlebox->hide; 
			$main::prefs{'toolbar'} = "n"; 
			$tb_submenu->{'icon'}->set_sensitive(0);
			$tb_submenu->{'text'}->set_sensitive(0);
			$tb_submenu->{'both'}->set_sensitive(0); 
			$tb_submenu->{'switch'}->set_sensitive(0);
  			
	 } else { 
  
		$handlebox->show; 
		$main::prefs{'toolbar'} = "y";
 		$tb_submenu->{'icon'}->set_sensitive(1);
 		$tb_submenu->{'text'}->set_sensitive(1);
 		$tb_submenu->{'both'}->set_sensitive(1);
		$tb_submenu->{'switch'}->set_sensitive(1);      
 }

return 1;

}

sub toggle_count_method {

	my ($widget) = @_;
	if ($widget->active) {
		$main::prefs{'RecMsgCount'} = "y";
	} else {
		$main::prefs{'RecMsgCount'} = "n";
	}
	
	if ($main::folder_tree) { #perhaps detached and closed?
		&Pronto::FolderTree::refresh_folder_tree;
	}
	return 1;
}

sub toggle_column_view {
	my ($widget,$list,$column,$prefs) = @_;

	if($$prefs eq 'y') {
		$$prefs = 'n';
		if (!$$list) { return; } #hidden folder tree and user changing prefs maybe?
		$$list->set_column_visibility($column,0);
	}
	else {
		$$prefs = 'y';
		if (!$$list) { return; } #hidden folder tree and user changing prefs maybe?
		$$list->set_column_visibility($column,1);
	}
	if($$list == $main::folder_tree) {
		&Pronto::FolderTree::refresh_folder_tree;
	}
}
		

sub toggle_threads {
	my ($widget,$radio) = @_;
	if ($main::prefs{'messageview'} eq "clist") {	
		$main::prefs{'messageview'} = "ctree";
		$widget->set_active('1');
		$radio->{'threadpref'}->set_sensitive(1);
		$radio->{'guess'}->set_sensitive(1);
		$radio->{'threadbysubject'}->set_sensitive(1);
		$radio->{'symbol'}->set_sensitive(1);
		$radio->{'lines'}->set_sensitive(1);
		$radio->{'Expander'}->set_sensitive(1);
	} elsif($main::prefs{'messageview'} eq "ctree") {
		$main::prefs{'messageview'} = "clist";
		$widget->set_active('0');
		$radio->{'threadpref'}->set_sensitive(0);
		$radio->{'guess'}->set_sensitive(0);
		$radio->{'threadbysubject'}->set_sensitive(0);
		$radio->{'symbol'}->set_sensitive(0);
		$radio->{'lines'}->set_sensitive(0);
		$radio->{'Expander'}->set_sensitive(0);
	}
	
	&Pronto::MessageList::make_clist("y");
	&Pronto::MessageList::make_clist_sigs;
	
	my @selection = $main::folder_tree->selection;
	if (!@selection) { 
		$main::root_window->{'button'}->hide;
		return 1;
	} else {
		&Pronto::MessageList::refresh_messages;
     }
	return 1;

}

sub toggle_arrow_in_threads
{
	my ($widget)=@_;
	if ($main::prefs{'arrowthreads'} eq "y") {
		$main::prefs{'arrowthreads'} = "n";
		$widget->set_active(0);
	} else {
		$main::prefs{'arrowthreads'} = "y";
	}
	my $box = &Pronto::FolderTree::get_folder_id();
	if (!$box) { return 1 }
	&Pronto::MessageList::refresh_ctree;
}	

sub toggle_subject_thread
{
	my ($widget) = @_;
	if ($main::prefs{'threadbysubject'} eq "y") {
		$main::prefs{'threadbysubject'} = "n";
		$widget->set_active(0);
	} else {
		$main::prefs{'threadbysubject'} = "y";
	}	
	my $box = &Pronto::FolderTree::get_folder_id();
	if (!$box) { return 1 }
	&Pronto::MessageList::refresh_ctree;
}

sub toggle_guess_threads {
        
	my ($widget) = @_;
       	if ($main::prefs{'GuessRejectThreads'} eq "y") {
		$main::prefs{'GuessRejectThreads'} = "n";
		$widget->set_active(0);
	} elsif ($main::prefs{'GuessRejectThreads'} eq "n") {
		$main::prefs{'GuessRejectThreads'} = "y";
	}
	my $box = &Pronto::FolderTree::get_folder_id();
	if (!$box) { return 1; }
	&Pronto::MessageList::refresh_ctree;

}

sub DetachFolderTree
{
	
	return if (!$main::folder_tree || defined($FolderTreeWindow));
	$FTReattach->set_sensitive(1);
	$FTDetach->set_sensitive(0);
	$FolderTreeWindow = new Gtk::Window("toplevel");
	$FolderTreeWindow->set_title("Pronto! Folders");
	$main::root_window->{'scroll1'}->reparent($FolderTreeWindow);
	$FolderTreeWindow->signal_connect("destroy", sub { 
		undef $main::folder_tree; 
		undef $main::root_window->{'scroll1'};
		undef $FolderTreeWindow;
       	});
	$FolderTreeWindow->show_all();
	$main::prefs{'FTDetached'} = 1;
	return;
}	
	
sub ReAttachFolderTree
{
	$FTReattach->set_sensitive(0);
	$FTDetach->set_sensitive(1);
	if (!$main::folder_tree) {
	       	&Pronto::FolderTree::init_folder_tree();
       	}
        if (!$main::root_window->{'scroll1'}) {
		$main::root_window->{'scroll1'} = new Gtk::ScrolledWindow(undef,undef);
		$main::root_window->{'scroll1'}->set_policy('automatic','automatic');			
		$main::root_window->{'scroll1'}->add($main::folder_tree);
		$main::root_window->{'scroll1'}->show_all();
		&Pronto::FolderTree::refresh_folder_tree();
		&Pronto::FolderTree::set_folder_style();
		$main::root_window->{'hpane'}->add($main::root_window->{'scroll1'});		
       	} else {
		return if (!$FolderTreeWindow);
		$FolderTreeWindow->signal_handlers_destroy();				
		$FolderTreeWindow->remove($main::root_window->{'scroll1'});
		#for some reason, I get a warning when I reparent.. do it the other way.
		#$main::root_window->{'scroll1'}->reparent($main::root_window->{'hpane'});
		$main::root_window->{'hpane'}->add($main::root_window->{'scroll1'});
		$FolderTreeWindow->destroy();
		undef $FolderTreeWindow;
       	}			
	$main::prefs{'FTDetached'} = 0;		
	return;	

}

1;
