# $Id: Read.pm,v 1.6 2001/04/02 03:02:19 muhri Exp $
# -*- perl -*-
package Pronto::Read;
use SelfLoader;
use strict;

sub init_read_pane
{
	my($nvbox,$lbl1,$lbl2,$lbl3,$lbl4,$lbl6,$bg);
 	if ($main::HTMLWIDGET eq "GtkHTML" || $main::HTMLWIDGET eq "CscHTML") {
  		my($popup,$url,$sep,$item);
  		$popup = new Gtk::Menu;
		if ($main::HTMLWIDGET eq "GtkHTML") {
  			$main::root_window->{'html_view'} = new Gtk::HTML;
  		} elsif ($main::HTMLWIDGET eq "CscHTML") {
			$main::root_window->{'html_view'} = new Csc::HTML;
			$main::root_window->{'html_view'}->set_default_font_face($main::prefs{'MsgFontFace'});
			$main::root_window->{'html_view'}->allow_font_switch($main::prefs{'FontSwitch'});
		}
		$main::root_window->{'html_view'}->signal_connect('url_requested' =>\&Pronto::Link::load_url);
  		$main::root_window->{'html_view'}->signal_connect('link_clicked' => \&Pronto::Link::gtkhtml_link_clicked);
		$main::root_window->{'html_view'}->signal_connect('button_press_event',\&Pronto::Read::gtkhtml_mouse_click,$popup, \$url);
  		$main::root_window->{'html_view'}->signal_connect('on_url' => sub { shift; $url = shift;});
  		$sep = new Gtk::MenuItem;
  		$popup->show;
  		$sep->show;
  		$popup->append($sep);
  		$item = new Gtk::MenuItem(_("Save As..."));
  		$item->signal_connect("activate" =>
        						sub {
                			       		my ($temp,$filename,$source,$type);
                					($temp,$source,$type) = split(/:/,$url);
                					$filename = $source;
                					$filename =~ s/^file:$main::prefs{'MailDir'}\/tmp\///g;
                					&Pronto::Save::init_fs_window(undef,$filename,$source);
        						});
  		$item->show;
  		$popup->append($item);
  		$item = new Gtk::MenuItem(_("View"));
  		$item->signal_connect("activate" =>
        						sub {
              					        my ($temp,$filename,$source,$type);
         					       ($temp,$source,$type) = split(/:/,$url);
               					        &Pronto::ViewAttachment::view_attachment(undef,$source,$type,'y');
        						});
  		$item->show;
 		$popup->append($item);
  		$item = new Gtk::MenuItem(_("View With..."));
  		$item->signal_connect("activate" =>
        						sub {
                					my ($temp,$filename,$source,$type);
                					($temp,$source,$type) = split(/:/,$url);
                					&Pronto::ViewAttachment::view_attachment(undef,$source,$type,'n');
        						});
  		$item->show;
  		$popup->append($item);
  		$main::root_window->{'html_view'}->enable_debug(0);
  		$main::root_window->{'html_view'}->set_editable(0);
  	} elsif ($main::HTMLWIDGET eq "text") {
  		my($popup,$url,$sep,$item);
  		$popup = new Gtk::Menu;
  		$sep = new Gtk::MenuItem;
   		$popup->show;
   		$sep->show;
   		$popup->append($sep);
   		$item = new Gtk::MenuItem(_("Save As..."));
   		$item->signal_connect("activate" =>
        						sub {
                					my ($temp,$filename,$source,$type);
                					($temp,$source,$type) = split(/:/,$url);
                					$filename = $source;
                					$filename =~ s/^file:$main::prefs{'MailDir'}\/tmp\///g;
                					&Pronto::Save::init_fs_window(undef,$filename,$source);
        						});
  		$item->show;
   		$popup->append($item);
   		$item = new Gtk::MenuItem(_("View"));
   		$item->signal_connect("activate" =>
        						sub {
                					my ($temp,$filename,$source,$type);
                					($temp,$source,$type) = split(/:/,$url);
                					&Pronto::ViewAttachment::view_attachment(undef,$source,$type,'y');
        						});
   		$item->show;
  		$popup->append($item);
   		$item = new Gtk::MenuItem(_("View With..."));
   		$item->signal_connect("activate" =>
        						sub {
                					my ($temp,$filename,$source,$type);
                					($temp,$source,$type) = split(/:/,$url);
                					&Pronto::ViewAttachment::view_attachment(undef,$source,$type,'n');
        						});
   		$item->show;
   		$popup->append($item);
  		$main::root_window->{'html_view'} = new Gtk::Text;
  		$main::root_window->{'html_view'}->show;
  		$main::root_window->{'html_view'}->set_editable(0);
		$main::root_window->{'html_view'}->signal_connect("button_release_event" =>\&Pronto::Read::textclick,$popup,\$url);
    	} else {
  		$main::root_window->{'html_view'} = new Gtk::XmHTML;
  		$main::root_window->{'html_view'}->set_anchor_buttons(0);
  		$main::root_window->{'html_view'}->set_allow_body_colors(1);
  		$main::root_window->{'html_view'}->set_hilight_on_enter(0);
  		$main::root_window->{'html_view'}->set_allow_font_switching(0);
  		$main::root_window->{'html_view'}->set_allow_images(1); 
  		$main::root_window->{'html_view'}->set_strict_checking(1);
  		$main::root_window->{'html_view'}->set_anchor_target_underline_type (1); 
  		$main::root_window->{'html_view'}->set_anchor_underline_type (1);
  		$main::root_window->{'html_view'}->set_anchor_visited_underline_type(1);
  		$main::root_window->{'html_view'}->set_anchor_target_underline_type (1);
  		$main::root_window->{'html_view'}->set_anchor_underline_type (1);  
  		$main::root_window->{'html_view'}->set_anchor_visited_underline_type(1);
  		$main::root_window->{'html_view'}->signal_connect('activate' => \&Pronto::Link::link_clicked);
 
 	}
 
 	$nvbox=new Gtk::VBox('0','0');
 	$main::root_window->{'table1'} = new Gtk::Table('2','4','0');
 	$main::root_window->{'table1'}->set_row_spacings('0');
 	$main::root_window->{'table1'}->set_col_spacings('0');
 	$main::root_window->{'table1'}->border_width('2');
 	$lbl1 = new Gtk::Label("To: ");
 	$lbl1->set_justify('left');
 	$lbl1->set_line_wrap('0');
 	$main::root_window->{'table1'}->attach($lbl1,'2','3','0','1',['fill'],[],'0','0');
 	$lbl1->set_alignment('0','0.5');
 	$lbl1->set_style($main::head_style);
 	$lbl2 = new Gtk::Label("From: ");
 	$lbl2->set_justify('left');
 	$lbl2->set_line_wrap('0');
 	$main::root_window->{'table1'}->attach($lbl2,'0','1','0','1',['fill'],[],'0','0');
 	$lbl2->set_alignment('0','0.5');
 	$lbl2->set_style($main::head_style);
 	$lbl3 = new Gtk::Label("CC: ");
 	$lbl3->set_justify('left');
 	$lbl3->set_line_wrap('0');
 	$main::root_window->{'table1'}->attach($lbl3,'2','3','1','2',['fill'],[],'0','0');
 	$lbl3->set_alignment('0','0.5');
 	$lbl3->set_style($main::head_style);
 	$lbl4 = new Gtk::Label("Subject: ");
 	$lbl4->set_justify('left');
 	$lbl4->set_line_wrap('0');
 	$main::root_window->{'table1'}->attach($lbl4,'0','1','1','2',['fill'],[],'0','0');
 	$lbl4->set_alignment('0','0.5');
 	$lbl4->set_style($main::head_style);
 	$lbl6 = new Gtk::Label("Date: ");
 	$lbl6->set_justify('left');
 	$lbl6->set_line_wrap('0');
	$main::root_window->{'table1'}->attach($lbl6,'0','1','2','3',['fill'],[],'0','0');
 	$lbl6->set_alignment('0','0.5');
 	$lbl6->set_style($main::head_style);
 	$main::root_window->{'table1'}->{'to_lbl'} = new Gtk::Label;
 	$main::root_window->{'table1'}->{'to_lbl'}->set_justify('left');
 	$main::root_window->{'table1'}->{'to_lbl'}->set_line_wrap('0');
 	$main::root_window->{'table1'}->attach($main::root_window->{'table1'}->{'to_lbl'},'3','4','0','1',['fill'],[],'0','0');
 	$main::root_window->{'table1'}->{'to_lbl'}->set_alignment('0','0.5');
 	$main::root_window->{'table1'}->{'from_lbl'} = new Gtk::Label;
 	$main::root_window->{'table1'}->{'from_lbl'}->set_justify('left');
 	$main::root_window->{'table1'}->{'from_lbl'}->set_line_wrap('0');
 	$main::root_window->{'table1'}->attach($main::root_window->{'table1'}->{'from_lbl'},'1','2','0','1',['expand','fill'],[],'0','0');
 	$main::root_window->{'table1'}->{'from_lbl'}->set_alignment('0','0.5');
 	$main::root_window->{'table1'}->{'subj_lbl'} = new Gtk::Label;
 	$main::root_window->{'table1'}->{'subj_lbl'}->set_justify('left');
 	$main::root_window->{'table1'}->{'subj_lbl'}->set_line_wrap('0');
 	$main::root_window->{'table1'}->attach($main::root_window->{'table1'}->{'subj_lbl'},'1','2','1','2',['expand','fill'],[],'0','0');
 	$main::root_window->{'table1'}->{'subj_lbl'}->set_alignment('0','0.5');
 	$main::root_window->{'table1'}->{'cc_lbl'} = new Gtk::Label;
 	$main::root_window->{'table1'}->{'cc_lbl'}->set_justify('left');
	$main::root_window->{'table1'}->{'cc_lbl'}->set_line_wrap('0');
 	$main::root_window->{'table1'}->attach($main::root_window->{'table1'}->{'cc_lbl'},'3','4','1','2',['fill'],[],'0','0');
 	$main::root_window->{'table1'}->{'cc_lbl'}->set_alignment('0','0.5');
 	$main::root_window->{'table1'}->{'date_lbl'} = new Gtk::Label;
 	$main::root_window->{'table1'}->{'date_lbl'}->set_justify('left');
 	$main::root_window->{'table1'}->{'date_lbl'}->set_line_wrap('0');
 	$main::root_window->{'table1'}->attach($main::root_window->{'table1'}->{'date_lbl'},'1','2','2','3',['expand','fill'],[],'0','0');
 	$main::root_window->{'table1'}->{'date_lbl'}->set_alignment('0','0.5');
 	$main::attpixmap = new Gtk::EventBox;
 	$main::attpixmap->set_events('button_press_mask');
 	$main::attpixmap->signal_connect("button_press_event" =>\&Pronto::MainWindow::rightclick, 1);
 	$main::attpixmap->{'popup'} = new Gtk::Menu;
 	$main::attach_menu2 = new Gtk::Menu;
 	$main::attpixmap->{'popup'}->show;
 	$main::attpixmap->{'popup'}->{'save'} = new Gtk::MenuItem(_("Save "));
 	$main::attpixmap->{'popup'}->{'save'}->show;
 	$main::attpixmap->{'popup'}->{'save'}->set_submenu($main::attach_menu2);
 	$main::attpixmap->{'popup'}->append($main::attpixmap->{'popup'}->{'save'});
 	$main::view_attach_menu2 = new Gtk::Menu;
 	$main::attpixmap->{'popup'}->show;
 	$main::attpixmap->{'popup'}->{'view'} = new Gtk::MenuItem(_("View "));
 	$main::attpixmap->{'popup'}->{'view'}->show;
 	$main::attpixmap->{'popup'}->{'view'}->set_submenu($main::view_attach_menu2);
 	$main::attpixmap->{'popup'}->append($main::attpixmap->{'popup'}->{'view'});
 	my ($button_pixmap, $button_mask);
 	$bg = $main::root_window->style->bg('normal');
 	if(-f "$main::prefs{'PixmapDir'}/ab.xpm") {
 		($button_pixmap, $button_mask) = Gtk::Gdk::Pixmap->create_from_xpm($main::root_window->window,$bg, "$main::prefs{'PixmapDir'}/ab.xpm");
 	}
 	else {
		($button_pixmap, $button_mask) = Gtk::Gdk::Pixmap->create_from_xpm_d($main::root_window->window,$bg, @main::dummy_pixmap);
 	}
 	$main::root_window->{'attbtn'} = new Gtk::Pixmap($button_pixmap, $button_mask);
 	$main::root_window->{'attbtn'}->show;
 	$main::attpixmap->add($main::root_window->{'attbtn'});
 	my $tablehbox = new Gtk::HBox(0,0);
 	$tablehbox->show;
 	$tablehbox->pack_start($main::root_window->{'table1'},1,1,5);
 	$tablehbox->pack_end($main::attpixmap,0,0,5);
 	$nvbox->pack_start($tablehbox,0,0,0);

 	if ($main::HTMLWIDGET eq "GtkHTML" or $main::HTMLWIDGET eq "text" or $main::HTMLWIDGET eq "CscHTML") {
 		 $main::root_window->{'sw'} = new Gtk::ScrolledWindow(undef, undef);
 		 $main::root_window->{'sw'}->set_policy('automatic', 'automatic');
 		 $main::root_window->{'sw'}->add($main::root_window->{'html_view'});
  		 $nvbox->add($main::root_window->{'sw'});
 	} else {
  		$nvbox->add($main::root_window->{'html_view'});
 	}

	return $nvbox,$main::root_window->{'attbtn'},$button_pixmap,$button_mask,$tablehbox;
}


# view_message is gonna take a msgid, and a widget, and a "content
# type"  and then its gonna work miracles on the msgid, and dump the
# part with the appropriate content type into the widget.
#
# it will also take an "attachment menu" and if found, it'll fill that
# menu with any attachments found as it mangles the message.
#
# it will also take a "header view pane" and if found, it'll fill that
# pane with relevent info (subject, to, cc, date, from)
# 
# vtype is numeric ... 1 == HTML, 2 == Text, 3 == HTML/headeronly
#                      4 == Text/headeronly
#
# quote is a flag for text output.. do we quote it? 1/0
#

sub view_message {
	my ($conn, $msgid, $output_widget, $vtype, $quote, $attach_menu, $view_attach_menu, $hdr_pane, $attach_clist, $forrep, $printh) = @_;
	my ($io, $type, $body, $num_parts, $file, $part, @inlineimages,@inlineattach, $view_part, $sql, $query, $header, @parts, $url, $image,$attach,@otherparts);
	my $font = Gtk::Gdk::Font->load($main::prefs{'FontComposer'});
	if ($main::prefs{'useGtkFontComposer'} eq "y") { $font = "" }
	# whatever called us has a header pane setup, so lets fill in it's info

       	$main::current = $msgid;
	if (defined $hdr_pane) {
	# lets suck some info in from the db about the message
		$sql = "select sentfrom, sentto, date, subject,cc,contenttype from messages where id= '$msgid'";
		$query=$conn->prepare($sql);
		$query->execute();
		my ($from, $to, $date, $subject, $cc, $ct) = $query->fetchrow_array();
		$hdr_pane->{'to_lbl'}->set_text($to);
		$hdr_pane->{'from_lbl'}->set_text($from);
		$hdr_pane->{'date_lbl'}->set_text($date);
		$hdr_pane->{'subj_lbl'}->set_text($subject);
		$hdr_pane->{'cc_lbl'}->set_text($cc);
	        if ($ct && ($ct !~ /text/i && $ct !~ /alternative/i && $ct !~ /multipart\/report/i)) { $main::attpixmap->show; } else { $main::attpixmap->hide;}
	}

	# is there a global entity object for this msgid already open?
	# if so, we use it, otherwise make a new one....

	if (not defined $main::entity{$msgid}) {
		$main::entity{$msgid} = &Pronto::Data::Message::get_parsed_mime($msgid);
	}	
	# We got an attachment menu, lets clear it out....

	if (defined $attach_menu) {
		foreach (@{$main::attach_menu->{'items'}}) {
			$_->destroy;
		}
	        foreach (@{$main::attach_menu2->{'items'}}) {
		        $_->destroy;
		}
                foreach (@{$main::view_attach_menu->{'items'}}) {
                        $_->destroy;
                }
		foreach (@{$main::view_attach_menu2->{'items'}}) {
                        $_->destroy;
                }
	}
	if (defined $main::entity{$msgid}) {
		$main::entity{$msgid}->{'usecount'}++;  # we got one more thing using this entity, so don't nuke it...
	# lets look at the display objects entity "id". if its some
	# other message, we know we are about to change messages
	# so lets decriment the usage count on that other entity
	# and if usage drops to 0 we know nothing else is using
	# it, so we can nuke it...

		if (defined $output_widget->{'entid'} && defined $main::entity{$output_widget->{'entid'}}) {
			if ($output_widget->{'entid'} != $msgid) {
				&main::destroy_entity(undef, $output_widget->{'entid'});  # destroy_entity will decrement usecount and destroy if 0
			} else {
				$main::entity{$msgid}->{'usecount'}--;  # we are displaying the same entity we had last time, so the use count shouldnt go up
			}
		}
		if (defined $output_widget->{'sigid'}) { $output_widget->signal_disconnect($output_widget->{'sigid'});}
		$output_widget->{'sigid'} = $output_widget->signal_connect('destroy' => \&main::destroy_entity, $msgid);
		$output_widget->{'entid'} = $msgid; # so we can check next time this widget gets used...
		#$output_widget->signal_connect('destroy' => \&main::destroy_entity, $msgid); # so that when the window goes away, we can clear it out
		if ($vtype > 2) {    # the viewer wants a header.....
			$body = $main::entity{$msgid}->stringify_header;
			$type = "text/plain";
		} else {        # the viewer wants the body
			$num_parts=$main::entity{$msgid}->parts;
			if ($num_parts == 0) { # single part message
				$parts[0] = $main::entity{$msgid};
			} else { # multipart message
				@parts = $main::entity{$msgid}->parts;
			}
			foreach $part (@parts) {
       				$type=$part->mime_type;
				my $rec_filename = $part->head->recommended_filename;
       				if (defined $rec_filename) {
					if (defined $attach_menu) {
						my $menuitem=new Gtk::MenuItem("$rec_filename");
						$menuitem->signal_connect("activate" => \&Pronto::Save::init_fs_window, $rec_filename, "$main::prefs{'MailDir'}/tmp/$rec_filename");
						$menuitem->show; 
						push @{$main::attach_menu->{'items'}}, $menuitem;
						$main::attach_menu->append($menuitem);
					        $menuitem=new Gtk::MenuItem("$rec_filename");
						$menuitem->show;   
						$menuitem->signal_connect("activate" => \&Pronto::Save::init_fs_window, $rec_filename, "$main::prefs{'MailDir'}/tmp/$rec_filename");
						push @{$main::attach_menu2->{'items'}}, $menuitem;
						$main::attach_menu2->append($menuitem);
						$menuitem=new Gtk::MenuItem("$rec_filename");
						$menuitem->signal_connect("activate" => \&Pronto::ViewAttachment::view_attachment, "$main::prefs{'MailDir'}/tmp/$rec_filename", $type, 'y');
                                                $menuitem->show;
                                                push @{$main::view_attach_menu->{'items'}}, $menuitem;
                                                $main::view_attach_menu->append($menuitem);
					  	$menuitem=new Gtk::MenuItem("$rec_filename");
						$menuitem->signal_connect("activate" => \&Pronto::ViewAttachment::view_attachment, "$main::prefs{'MailDir'}/tmp/$rec_filename", $type, 'y');
                                                $menuitem->show;
                                                push @{$main::view_attach_menu2->{'items'}}, $menuitem;
                                                $main::view_attach_menu2->append($menuitem);
					}
					if (defined $attach_clist && $quote != 1  && $quote !=5 && ($main::prefs{'ForwardAttachments'} eq "y" || $quote != 2) ) {
				      		my $error = 0;
						open (FILE, "$main::prefs{'MailDir'}/tmp/$rec_filename") or $error=1;
					       	my ($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size)=stat FILE;
						close FILE or $error=1;
						if ($error==0){
							$size=$size/1024;
							$attach_clist->append(("$main::prefs{'MailDir'}/tmp/$rec_filename",(sprintf("%8.2f",$size)."kb")));
						} else {
							&main::wr_debug("unable to open $rec_filename.");
						} 
					}
					if (($main::prefs{'InlineImages'} eq "y") and ($rec_filename =~ /(bmp|gif|jpg|jpeg|png)$/i)) {
						push @inlineimages, $rec_filename;
					} elsif($main::prefs{'InlineAttachments'} eq "y") {
						push @inlineattach, "$rec_filename:$type";
					}
				}
				if ($type =~ /multipart/i or $type=~ /message\/rfc/i) {   # this is a multipart part, so lets flatten
					push @parts, $part->parts;
				}
				if (($vtype == 1) and ($type =~ /text\/html/i)) {   #  we are looking for an HTML part and found one!
					if (not defined $view_part) { $view_part = $part; }  # we only want the FIRST HTML part...
				} elsif ($type =~ /text\/plain/i || $type =~/text/i) {                  # we are looking for TEXT parts...
					if (not defined $view_part) {
						$view_part = $part; 
					}  #still only want the first....
					else {
						push @otherparts,$part;
					}
				}
			}
			if (defined $view_part) {
				if ($io=$view_part->open("r")) {
 					undef $/;
 					$body = $io->getline;
 					$/ = "\n";
					$io->close;
					$type=$view_part->mime_type;
				}
				if (scalar(@otherparts)>0) {
					foreach my $extra (@otherparts) {
      						if ($io=$extra->open("r")) {
							$body=$body."\n\n --- Next Part --- \n\n";
							undef $/;
							my $next = $io->getline;
							$/ = "\n";
       							$io->close;
							$body = $body . $next;
						}
					}
				}
			} else { 
      
				$body = _("No viewable part found.");
				$type="text/plain";
			}
		}
	} else {
		$body = _("Unable to decode message. Please contact Pronto maintainers at pronto\@muhri.net.");
		$type = "text/plain";
	}
	if (($vtype == 1) or ($vtype == 3)) {   # HTML widget....
		if (($type =~ /text\/plain/i) or ($type eq "text")) {
			if ($main::HTMLWIDGET ne "text") {
				$body = &main::text2html($body, \@inlineimages);
			}
		} else {
			if (@inlineimages) {
				$image="";
				foreach (@inlineimages) {
					if ($_ ne "") {
						$url = "$main::prefs{'MailDir'}/tmp/$_";
						$image = $image . "<p>$_<br><img src=\"$url\"></p>";
					}
				}
				$body =~ s/<\/html>/$image<\/html>/;
			}
		}
		if (@inlineattach) {
			$attach="";
			foreach(@inlineattach) {
				if($_ ne "") {
					my ($filename,$type,$sql,$query,$icon);
                                        ($filename,$type) = split(/:/,$_);
					$sql = "select icon from mimetypes where mime = ?";
					$query = $conn->prepare($sql);
					$query->execute($type);	
					if(($icon) = $query->fetchrow_array()) {
						if(!(-f $icon)) {
							$icon = "$main::prefs{'PixmapDir'}/unknown.png";
						}
					}
					else {
						$icon = "$main::prefs{'PixmapDir'}/unknown.png";
					}
					$url = "file:$main::prefs{'MailDir'}/tmp/$_";
					if($main::HTMLWIDGET eq "text") {
						$attach = $attach . "$filename -> $url\n";
					}
					else {
						$attach = $attach . "<p><a href=$url>";
						if($main::prefs{'InlineIcons'} eq 'y') {
							$attach = $attach . "<img border=0 src=$icon>";
						}
						$attach = $attach . "$filename</a><br></p>";
					}
				}
			}
			if($main::HTMLWIDGET eq "text") {
				$body = $body . "\n--Attachments--\n\n$attach\n";
			}
			else {
				$body =~ s/<\/body>/$attach<\/body>/;
			}
		}
		if ($main::HTMLWIDGET eq "GtkHTML" || $main::HTMLWIDGET eq "CscHTML") {
			my $tmpfile = "$main::prefs{'MailDir'}/file.html";
			open (DUMP,">$tmpfile");
			print DUMP $body;
			close(DUMP);
			&Pronto::Link::load_url($output_widget,$tmpfile,$output_widget->begin);
		} elsif ($main::HTMLWIDGET eq "text") {
		       $output_widget->freeze;
		       $output_widget->set_point(0);
		       $output_widget->forward_delete($output_widget->get_length);
	  	       if ($main::prefs{'UseMessageColors'} eq "y") {
		       		&main::text2gtktext($body,$font,$output_widget);
		       } else {
		       		$output_widget->insert($font,"","",$body);
		       }
		       $output_widget->thaw;
		} else {
			$body = HtmlStripper->new->parse($body)->filtered_html;
			$output_widget->source($body);
		}
	} else {    # text widget
	
		if ($quote == 1) {
			if ($main::prefs{'SliceSig'}) { #slice out sig
				$body =~ s/\n\-\- \n.*//so;
			}
			
			if (defined $main::prefs{'QuoteWith'}) {
				$body = $main::prefs{'QuoteWith'}  . $body;
				$body =~ s/\n/\n$main::prefs{'QuoteWith'} /g;
			}
			
 			$sql = "select date, sentto, subject, friendly from messages where id = ?";
			$query = $conn->prepare($sql);
			$query->execute($msgid);
 			my ($quotedate, $quoteto, $quotesubject, $quotename) = ($query->fetchrow_array());
			my $prefix = $main::prefs{'QuoteHeader'};
 			$prefix =~ s/\*n/\n/g;
 			$prefix =~ s/%t/$quoteto/g;
 			$prefix =~ s/%s/$quotesubject/g;
			$prefix =~ s/%n/$quotename/g;
			$prefix =~ s/%d/$quotedate/g;
			unless (!$prefix) { $body = $prefix . "\n\n" . $body; }
			$output_widget->insert($font,'','',"$body\n");
		        return 1;
		}  
	#edit code
		if ($quote == 3) { $output_widget->insert($font,'','',"$body\n"); return 1;}

	#print code

 		if($quote == 4) {
   			$sql = "select date, replyto, sentfrom, subject, sentto from messages where id = ?";
   			$query = $conn->prepare($sql);
   			$query->execute($msgid);
   			my ($fdate, $reply, $from, $subject, $to) = ($query->fetchrow_array());
   			if (!$reply) { $reply = $from }
   			if (defined $printh and $printh eq "y") {
   				my $printheader = "  \n\n From: $reply\n To: $to\n Sent: $fdate\n Subject: $subject";
   				$body = $printheader . "\n\n" . $body;
   				$output_widget->insert('','','',"$body\n");
   			}
   			else {  $output_widget->insert('','','',"$body\n"); }
   			return 1;
		  }
							       

		# reply no quote 
		if ($quote == 5) {
	         	return 1; 
	       	}
		#forward code		
		if ($main::prefs{'ForwardHeader'} eq "y") {
			$sql = "select date, replyto, sentfrom, subject, sentto from messages where id = ?";
		        $query = $conn->prepare($sql);
		        $query->execute($msgid);
		        my ($fdate, $reply, $from, $subject, $to) = ($query->fetchrow_array());
		        if (!$reply) { $reply = $from }
		        my $forwardheader = "  \n\n--- Forwarded Message ---\n From: $reply\n To: $to\n Sent: $fdate\n Subject: $subject";
		        $body = $forwardheader . "\n\n" . $body;
			$output_widget->insert($font,'','',"$body\n");
		} else {
			$output_widget->insert($font,'','',"$body\n");
		}
	}
	return 1;
}


sub clear_widget {
        
	if (defined $main::view_window and $main::prefs{'viewpane'} eq "n") {
		$main::view_window->{'hdr_pane'}->{'to_lbl'}->set_text("");
		$main::view_window->{'hdr_pane'}->{'from_lbl'}->set_text("");
		$main::view_window->{'hdr_pane'}->{'subj_lbl'}->set_text("");
		$main::view_window->{'hdr_pane'}->{'cc_lbl'}->set_text("");
		$main::view_window->{'hdr_pane'}->{'date_lbl'}->set_text("");
	}
	
	$main::root_window->{'table1'}->{'to_lbl'}->set_text("");
	$main::root_window->{'table1'}->{'from_lbl'}->set_text("");
	$main::root_window->{'table1'}->{'subj_lbl'}->set_text("");
	$main::root_window->{'table1'}->{'cc_lbl'}->set_text("");
	$main::root_window->{'table1'}->{'date_lbl'}->set_text("");
	if ($main::attpixmap->visible) { $main::attpixmap->hide }
	if (-f "$main::prefs{'MailDir'}/empty.html" and $main::HTMLWIDGET eq "XmHTML" or $main::HTMLWIDGET eq "GtkHTML" or $main::HTMLWIDGET eq "CscHTML") {
		&clear_view;
	} else {
		open(TMP, ">$main::prefs{'MailDir'}/empty.html");
		print TMP "<html><body><body bgcolor=FFFFFF></body></html>\n";
		close TMP;
		&clear_view;
        }
	$main::current = undef if (!$main::dragging);
	return 1;
}


sub clear_view {
	
	if ($main::HTMLWIDGET eq "GtkHTML" || $main::HTMLWIDGET eq "CscHTML") {
		&Pronto::Link::load_url($main::root_window->{'html_view'}, $main::prefs{'MailDir'}."/empty.html", $main::root_window->{'html_view'}->begin);
		if (defined $main::view_window and $main::prefs{'viewpane'} eq "n") { Pronto::Link::load_url($main::view_window->{'html'},$main::prefs{'MailDir'}."/empty.html",$main::view_window->{'html'}->begin) }
	} elsif ($main::HTMLWIDGET eq "XmHTML") {
		$main::root_window->{'html_view'}->source("");
		if (defined $main::view_window and $main::prefs{'viewpane'} eq "n") { $main::view_window->{'html'}->source("");}
	} elsif ($main::HTMLWIDGET eq "text") {
		$main::root_window->{'html_view'}->freeze;
		$main::root_window->{'html_view'}->set_point(0);
		$main::root_window->{'html_view'}->forward_delete($main::root_window->{'html_view'}->get_length);
		$main::root_window->{'html_view'}->thaw;
		if (defined $main::view_window and $main::prefs{'viewpane'} eq "n") { 
			$main::view_window->{'html'}->freeze;
			$main::view_window->{'html'}->set_point(0);
			$main::view_window->{'html'}->forward_delete($main::view_window->{'html'}->get_length);
			$main::view_window->{'html'}->thaw;
		}
   	}

	return 1;

}

sub textclick {

	my ($widget, $popup, $url, $event) = @_;
	my ($position,$text,@lines);
	if ($event->{'button'} == 3) {
		$position = $widget->get_position;
	 	$text="";
		if ($position<$widget->get_length){
			my $spos=$position;
               		my $stext="";
       	 		$text=$widget->get_chars($spos,$spos+1);
       			$spos--;
	 		while ($text !~ /\s/ && $spos>=0){
	 			$stext=$text.$stext;
         			$text=$widget->get_chars($spos,$spos+1);
      				$spos--;
			}	      
       			$stext=$text.$stext if $spos<0;
			$spos=$position+1;
			$text=$widget->get_chars($spos,$spos+1);
			$spos++;
			while (defined $text && $text !~ /\s/ && $spos+1<=$widget->get_length){
				$stext.=$text;
				$text=$widget->get_chars($spos,$spos+1);
				$spos++;
			}
			$text=$stext;
	 	}
		if (!$text) { return 1 }
		@lines = split(/\n/,$text);
		foreach(@lines) {
		        if (/\bhttp:\/\/([-_=&#,;:%a-zA-Z0-9.~\/\?\$\+\@]+)/) {
				print("http://$1\n"); 
		     		&Pronto::Link::link_clicked(undef,"http://$1");
      				last;
			} elsif (/\bftp:\/\/([-_=&#;:%a-zA-Z0-9.~\/\?\$\+]+)/) {
				print("ftp://$1\n");
				&Pronto::Link::link_clicked(undef,"ftp://$1");
			} elsif (/\bfile:$main::prefs{'MailDir'}\/tmp\//) {
				print "$_\n";
				$$url = $_;
			        $popup->popup(undef, undef, $event, $event->{'time'});	
			} elsif (/([-_a-zA-Z0-9.]+\@[-_a-zA-Z0-9.]+\.[-_a-zA-Z0-9]+)/) {
				print("Mailto:$1\n");
				my (@fields);
				$fields[0] = $1;
				$fields[1] = "";
				$fields[2] = "";
				&Pronto::Compose::init_msg_window(0, undef, \@fields);
			}
		}
	} else { 
		return 1;
	}
	return 1;
}


sub gtkhtml_mouse_click {
	my ($widget, $popup, $url, $event) = @_;
    	if ($event->{'button'} != 3) {
    		return 1;
    	}
 
    	if(!defined $$url) {
    		return 1;
    	}
    
   	if($$url =~ /^file:$main::prefs{'MailDir'}\/tmp\//) {
  		 $popup->popup(undef, undef, $event, $event->{'time'});
   	}
 
	 return 1;

}


1;
__DATA__

sub message_view_win {
	
	my ($msgid, $type) = @_;
  	
	if (not defined $msgid or $msgid eq "") {
		$msgid = &Pronto::MessageList::get_selected_msgid();
	}
	if (!$msgid) { return 1; }

  	if ($type > 2) { &head_view($type);   return 1; }
  	if (defined $main::view_window and $type < 2) { 
  		&view_message($main::conn, $msgid, $main::view_window->{'html'}, $type, 0, undef, undef, $main::view_window->{'hdr_pane'});
  		return 1; 
	}
  
  	$main::view_window=new Gtk::Window("toplevel");
  	$main::view_window->set_title(_("View Message"));
  	$main::view_window->signal_connect("destroy" => sub { $main::view_window->destroy; undef $main::view_window });
  	$main::view_window->signal_connect("delete_event" => \&Gtk::false);
  	$main::view_window->set_default_size('500','400');
  	$main::view_window->set_policy(1,1,0);
  	$main::view_window->show;
  	$main::view_window->{'vbox'}= new Gtk::VBox('0','0');
  	$main::view_window->{'vbox'}->show;
  	$main::view_window->add($main::view_window->{'vbox'});
  	$main::view_window->{'hbox'} = new Gtk::HBox(0,5);
  	$main::view_window->{'hbox'}->show;
  	$main::view_window->{'hbox2'} = new Gtk::HBox(0,5);
  	$main::view_window->{'hbox2'}->show;
  	$main::view_window->{'hbox3'} = new Gtk::HBox(0,5);
  	$main::view_window->{'hbox3'}->show;
  	$main::view_window->{'hbox4'} = new Gtk::HBox(0,5);
  	$main::view_window->{'hbox4'}->show;
  	$main::view_window->{'hbox5'} = new Gtk::HBox(0,5);
  	$main::view_window->{'hbox5'}->show;
  	$main::view_window->{'vbox'}->pack_start($main::view_window->{'hbox'},0,0,0);
  	$main::view_window->{'vbox'}->pack_start($main::view_window->{'hbox2'},0,0,0);
  	$main::view_window->{'vbox'}->pack_start($main::view_window->{'hbox3'},0,0,0);
  	$main::view_window->{'vbox'}->pack_start($main::view_window->{'hbox4'},0,0,0);
  	$main::view_window->{'vbox'}->pack_start($main::view_window->{'hbox5'},0,0,0);
  	$main::view_window->{'hdr_pane'}->{'to'} = new Gtk::Label("To: ");
  	$main::view_window->{'hdr_pane'}->{'to'}->show;
  	$main::view_window->{'hdr_pane'}->{'to_lbl'} = new Gtk::Label;
  	$main::view_window->{'hdr_pane'}->{'to_lbl'}->show;
  	$main::view_window->{'hdr_pane'}->{'from'} = new Gtk::Label("From: ");
  	$main::view_window->{'hdr_pane'}->{'from'}->show;
  	$main::view_window->{'hdr_pane'}->{'from_lbl'} = new Gtk::Label;
  	$main::view_window->{'hdr_pane'}->{'from_lbl'}->show;
  	$main::view_window->{'hdr_pane'}->{'date'} = new Gtk::Label("Date: ");
  	$main::view_window->{'hdr_pane'}->{'date'}->show;
  	$main::view_window->{'hdr_pane'}->{'date_lbl'} = new Gtk::Label;
  	$main::view_window->{'hdr_pane'}->{'date_lbl'}->show;
  	$main::view_window->{'hdr_pane'}->{'subject'} = new Gtk::Label("Subject: ");
  	$main::view_window->{'hdr_pane'}->{'subject'}->show;
  	$main::view_window->{'hdr_pane'}->{'subj_lbl'} = new Gtk::Label;
  	$main::view_window->{'hdr_pane'}->{'subj_lbl'}->show;
  	$main::view_window->{'hdr_pane'}->{'cc'} = new Gtk::Label("CC: ");
  	$main::view_window->{'hdr_pane'}->{'cc'}->show;
  	$main::view_window->{'hdr_pane'}->{'cc_lbl'} = new Gtk::Label;
  	$main::view_window->{'hdr_pane'}->{'cc_lbl'}->show;
  	$main::view_window->{'hbox'}->pack_start($main::view_window->{'hdr_pane'}->{'to'},0,0,0);
  	$main::view_window->{'hbox'}->pack_start($main::view_window->{'hdr_pane'}->{'to_lbl'},0,0,0);
  	$main::view_window->{'hbox2'}->pack_start($main::view_window->{'hdr_pane'}->{'from'},0,0,0);
  	$main::view_window->{'hbox2'}->pack_start($main::view_window->{'hdr_pane'}->{'from_lbl'},0,0,0);
  	$main::view_window->{'hbox3'}->pack_start($main::view_window->{'hdr_pane'}->{'date'},0,0,0);
  	$main::view_window->{'hbox3'}->pack_start($main::view_window->{'hdr_pane'}->{'date_lbl'},0,0,0);
  	$main::view_window->{'hbox4'}->pack_start($main::view_window->{'hdr_pane'}->{'subject'},0,0,0);
  	$main::view_window->{'hbox4'}->pack_start($main::view_window->{'hdr_pane'}->{'subj_lbl'},0,0,0);
  	$main::view_window->{'hbox5'}->pack_start($main::view_window->{'hdr_pane'}->{'cc'},0,0,0);
  	$main::view_window->{'hbox5'}->pack_start($main::view_window->{'hdr_pane'}->{'cc_lbl'},0,0,0);
  	if ($main::HTMLWIDGET eq "GtkHTML" || $main::HTMLWIDGET eq "CscHTML") {
   		my ($popup,$url,$item,$sep);
   		$popup = new Gtk::Menu;
		if ($main::HTMLWIDGET eq "GtkHTML") {
   			$main::view_window->{'html'} = new Gtk::HTML;
		} elsif ($main::HTMLWIDGET eq "CscHTML") {
			$main::view_window->{'html'} = new Csc::HTML;
			$main::view_window->{'html'}->set_default_font_face($main::prefs{'MsgFontFace'});
			$main::view_window->{'html'}->allow_font_switch($main::prefs{'FontSwitch'});
		}
   		$main::view_window->{'html'}->signal_connect('url_requested' => \&Pronto::Link::load_url);
   		$main::view_window->{'html'}->signal_connect('link_clicked' => \&Pronto::Link::gtkhtml_link_clicked);
		$main::view_window->{'html'}->signal_connect('button_press_event' => \&gtkhtml_mouse_click, $popup, \$url);
   		$main::view_window->{'html'}->signal_connect('on_url' => sub { shift; $url = shift;});
   		$sep = new Gtk::MenuItem;
   		$popup->show;
   		$sep->show;
   		$popup->append($sep);
   		$item = new Gtk::MenuItem(_("Save As..."));
   		$item->signal_connect("activate" => 
					sub {
					my ($temp,$filename,$source);
					($temp,$source,$type) = split(/:/,$url);
					$filename = $source;
                			$filename =~ s/^file:$main::prefs{'MailDir'}\/tmp\///g;
                			&Pronto::Save::init_fs_window(undef,$filename,$source);
					});
   		$item->show;
   		$popup->append($item);
   		$item = new Gtk::MenuItem(_("View"));
   		$item->signal_connect("activate" =>
        				sub {
                			my ($temp,$filename,$source,$type);
                			($temp,$source,$type) = split(/:/,$url);
                			&Pronto::ViewAttachment::view_attachment(undef,$source,$type,'y');
        				});
   		$item->show;
  		$popup->append($item);
   		$item = new Gtk::MenuItem(_("View With..."));
   		$item->signal_connect("activate" =>
        				sub {
                			my ($temp,$filename,$source,$type);
                			($temp,$source,$type) = split(/:/,$url);
                			&Pronto::ViewAttachment::view_attachment(undef,$source,$type,'n');
        				});
   		$item->show;
   		$popup->append($item);
   		$main::view_window->{'html'}->set_editable(0);
   		$main::view_window->{'html'}->enable_debug(0);
   
   		my $sw = new Gtk::ScrolledWindow(undef, undef);
   		$sw->set_policy('automatic', 'automatic');
   		$sw->show;
   		$sw->add($main::view_window->{'html'});
   		$main::view_window->{'vbox'}->pack_start($sw,1,1,0);
   		$main::view_window->{'html'}->realize;
   		$main::view_window->{'html'}->show;
  
  	} elsif ($main::HTMLWIDGET eq "text") {
 		 my ($popup,$url,$item,$sep);
  		$popup = new Gtk::Menu;
  		$sep = new Gtk::MenuItem;
   		$popup->show;
   		$sep->show;
   		$popup->append($sep);
   		$item = new Gtk::MenuItem(_("Save As..."));
   		$item->signal_connect("activate" =>
        				sub {
                			my ($temp,$filename,$source,$type);
                			($temp,$source,$type) = split(/:/,$url);
                			$filename = $source;
                			$filename =~ s/^file:$main::prefs{'MailDir'}\/tmp\///g;
                			&Pronto::Save::init_fs_window(undef,$filename,$source);
        				});
   		$item->show;
   		$popup->append($item);
   		$item = new Gtk::MenuItem(_("View"));
   		$item->signal_connect("activate" =>
        				sub {
                			my ($temp,$filename,$source,$type);
                			($temp,$source,$type) = split(/:/,$url);
					&Pronto::ViewAttachment::view_attachment(undef,$source,$type,'y');
        				});
   		$item->show;
  		$popup->append($item);
   		$item = new Gtk::MenuItem(_("View With..."));
   		$item->signal_connect("activate" =>
        				sub {
                			my ($temp,$filename,$source,$type);
                			($temp,$source,$type) = split(/:/,$url);
                			&Pronto::ViewAttachment::view_attachment(undef,$source,$type,'n');
        				});
   		$item->show;
   		$popup->append($item);
  		$main::view_window->{'html'} = new Gtk::Text;
  		$main::view_window->{'html'}->show;
  		$main::view_window->{'html'}->set_editable(0);
		$main::view_window->{'html'}->signal_connect("button_release_event" =>\&textclick,$popup,\$url);
  		my $sw = new Gtk::ScrolledWindow(undef,undef);
  		$sw->set_policy('automatic','automatic');
  		$sw->show;
  		$sw->add($main::view_window->{'html'});
  		$main::view_window->{'vbox'}->pack_start($sw,1,1,0);
  
  	} else {
   		$main::view_window->{'html'} = new Gtk::XmHTML;
   		$main::view_window->{'html'}->set_anchor_buttons(0);
   		$main::view_window->{'html'}->set_allow_body_colors(1);
   		$main::view_window->{'html'}->set_hilight_on_enter(0);
   		$main::view_window->{'html'}->set_allow_font_switching(1);
   		$main::view_window->{'html'}->set_allow_images(1);
   		$main::view_window->{'html'}->set_strict_checking(1);
   		$main::view_window->{'html'}->set_anchor_target_underline_type (1);
   		$main::view_window->{'html'}->set_anchor_underline_type (1);
   		$main::view_window->{'html'}->set_anchor_visited_underline_type(1);
   		$main::view_window->{'html'}->signal_connect('activate' => \&Pronto::Link::link_clicked);
   		$main::view_window->{'html'}->show;
   		$main::view_window->{'vbox'}->pack_start($main::view_window->{'html'},1,1,0);
  	}

  	&view_message($main::conn, $msgid, $main::view_window->{'html'}, $type, 0, undef, undef, $main::view_window->{'hdr_pane'});
  
	return 1;

}

sub head_view {
        
	my ($type) = @_;
	my ($window, $vbox, $html_view,$msgid);
	$window=new Gtk::Window("toplevel");
       	$window->set_title(_("View Header"));
  	$window->signal_connect("destroy" => sub { $window->destroy; });
  	$window->signal_connect("delete_event" => \&Gtk::false);
  	$window->set_default_size('500','400');
  	$window->set_policy(1,1,0);
  	$window->show;
  	$vbox= new Gtk::VBox('0','0');
  	$vbox->show;
  	$window->add($vbox);
  	if ($main::HTMLWIDGET eq "GtkHTML" || $main::HTMLWIDGET eq "CscHTML") {
   		if ($main::HTMLWIDGET eq "GtkHTML") {
			$html_view = new Gtk::HTML;
		} elsif ($main::HTMLWIDGET eq "CscHTML") {
			$html_view = new Csc::HTML;
			$html_view->set_default_font_face($main::prefs{'MsgFontFace'});
			$html_view->allow_font_switch($main::prefs{'FontSwitch'});
		}
   		$html_view->signal_connect('url_requested' => \&Pronto::Link::load_url);
   		$html_view->signal_connect('link_clicked' => \&Pronto::Link::gtkhtml_link_clicked);
   		$html_view->set_editable(0);
   		$html_view->enable_debug(0);
   		my $sw = new Gtk::ScrolledWindow(undef, undef);
   		$sw->set_policy('automatic', 'automatic');
   		$sw->show;
   		$sw->add($html_view);
   		$vbox->pack_start($sw,1,1,0);
   		$html_view->realize;
   		$html_view->show;
  	} elsif ($main::HTMLWIDGET eq "text") {
  		$html_view = new Gtk::Text;
  		$html_view->show;
  		$html_view->set_editable(0);
  		$html_view->signal_connect("button_release_event" => \&textclick,undef,undef);
  		my $sw = new Gtk::ScrolledWindow(undef,undef);
  		$sw->set_policy('automatic','automatic');
  		$sw->show;
  		$sw->add($html_view);
  		$vbox->pack_start($sw,1,1,0);
  	} else {
   		$html_view = new Gtk::XmHTML;
        	$html_view->set_anchor_buttons(0);
   		$html_view->set_allow_body_colors(1);
   		$html_view->set_hilight_on_enter(0);
   		$html_view->set_allow_font_switching(1);
   		$html_view->set_allow_images(1);
   		$html_view->set_strict_checking(1);
   		$html_view->set_anchor_target_underline_type (1);
   		$html_view->set_anchor_underline_type (1);
   		$html_view->set_anchor_visited_underline_type(1);
   		$html_view->signal_connect('activate' => \&Pronto::Link::link_clicked);
   		$html_view->show;
   		$vbox->pack_start($html_view,1,1,0);
  	}
  
	$msgid = &Pronto::MessageList::get_selected_msgid();
  	
	&view_message($main::conn, $msgid, $html_view, $type, 0);

return 1;
}


sub view_raw {
        my ($msgid,$tmp,$win,$text,$body,$sw,@selection,$error,$popup,$sep,$url,$item,);
        $popup = new Gtk::Menu;
  	$sep = new Gtk::MenuItem;
   	$popup->show;
   	$sep->show;
   	$popup->append($sep);
   	$item = new Gtk::MenuItem(_("Save As..."));
   	$item->signal_connect("activate" =>
        			sub {
                		my ($temp,$filename,$source,$type);
                		($temp,$source,$type) = split(/:/,$url);
                		$filename = $source;
                		$filename =~ s/^file:$main::prefs{'MailDir'}\/tmp\///g;
                		&Pronto::Save::init_fs_window(undef,$filename,$source);
        			});
   	$item->show;
   	$popup->append($item);
   	$item = new Gtk::MenuItem(_("View"));
   	$item->signal_connect("activate" =>
        			sub {
               		  	 my ($temp,$filename,$source,$type);
                		($temp,$source,$type) = split(/:/,$url);
                		&Pronto::Save::view_attachment(undef,$source,$type,'y');
        			});
 	$item->show;
  	$popup->append($item);
   	$item = new Gtk::MenuItem(_("View With..."));
   	$item->signal_connect("activate" =>
        			sub {
                		my ($temp,$filename,$source,$type);
                		($temp,$source,$type) = split(/:/,$url);
                		&Pronto::ViewAttachment::view_attachment(undef,$source,$type,'n');
        			});
   	$item->show;
   	$popup->append($item);

    	$msgid = &Pronto::MessageList::get_selected_msgid();

  	my $font = Gtk::Gdk::Font->load($main::prefs{'FontComposer'});
	if ($main::prefs{'useGtkFontComposer'} eq "y") { $font = "" }
	$win = new Gtk::Window("toplevel");
	$win->set_policy(1,1,0);
	$win->set_title(_("Source view of Message ")."$msgid");
	$win->set_default_size('500','400');
	$sw=new Gtk::ScrolledWindow(undef, undef);
	$sw->show;
	$win->add($sw);
	$win->show;
	$text = new Gtk::Text;
	$text->show;
	$text->signal_connect("button_release_event" => \&textclick,$popup,\$url);
	$sw->add($text);
    	$body=&Pronto::Data::Message::get_source($msgid);
	$text->insert($font,"","",$body);
	return 1;
}

sub read_html
{
	
	if (!$main::hashtml) {
		&main::err_dialog(_("You dont have an HTML widget !"));
		return 1;
	}
	my $current_widget = $main::HTMLWIDGET;
	$main::HTMLWIDGET = $main::hashtml_widget;
	&html_view_win();
	$main::HTMLWIDGET = $current_widget;
	return 1;
}	


sub html_view_win {
	
	my ($html_window);	
       	my $msgid = &Pronto::MessageList::get_selected_msgid();
	
	if (!$msgid) { return 1; }
  
  	$html_window=new Gtk::Window("toplevel");
  	$html_window->set_title(_("View Message"));
  	$html_window->signal_connect("destroy" => sub { $html_window->destroy; });
  	$html_window->signal_connect("delete_event" => \&Gtk::false);
  	$html_window->set_default_size('500','400');
  	$html_window->set_policy(1,1,0);
  	$html_window->show;
  	$html_window->{'vbox'}= new Gtk::VBox('0','0');
  	$html_window->{'vbox'}->show;
  	$html_window->add($html_window->{'vbox'});
  	$html_window->{'hbox'} = new Gtk::HBox(0,5);
  	$html_window->{'hbox'}->show;
  	$html_window->{'hbox2'} = new Gtk::HBox(0,5);
  	$html_window->{'hbox2'}->show;
  	$html_window->{'hbox3'} = new Gtk::HBox(0,5);
  	$html_window->{'hbox3'}->show;
  	$html_window->{'hbox4'} = new Gtk::HBox(0,5);
  	$html_window->{'hbox4'}->show;
  	$html_window->{'hbox5'} = new Gtk::HBox(0,5);
  	$html_window->{'hbox5'}->show;
  	$html_window->{'vbox'}->pack_start($html_window->{'hbox'},0,0,0);
  	$html_window->{'vbox'}->pack_start($html_window->{'hbox2'},0,0,0);
  	$html_window->{'vbox'}->pack_start($html_window->{'hbox3'},0,0,0);
  	$html_window->{'vbox'}->pack_start($html_window->{'hbox4'},0,0,0);
  	$html_window->{'vbox'}->pack_start($html_window->{'hbox5'},0,0,0);
  	$html_window->{'hdr_pane'}->{'to'} = new Gtk::Label("To: ");
  	$html_window->{'hdr_pane'}->{'to'}->show;
  	$html_window->{'hdr_pane'}->{'to_lbl'} = new Gtk::Label;
  	$html_window->{'hdr_pane'}->{'to_lbl'}->show;
  	$html_window->{'hdr_pane'}->{'from'} = new Gtk::Label("From: ");
  	$html_window->{'hdr_pane'}->{'from'}->show;
  	$html_window->{'hdr_pane'}->{'from_lbl'} = new Gtk::Label;
  	$html_window->{'hdr_pane'}->{'from_lbl'}->show;
  	$html_window->{'hdr_pane'}->{'date'} = new Gtk::Label("Date: ");
  	$html_window->{'hdr_pane'}->{'date'}->show;
  	$html_window->{'hdr_pane'}->{'date_lbl'} = new Gtk::Label;
  	$html_window->{'hdr_pane'}->{'date_lbl'}->show;
  	$html_window->{'hdr_pane'}->{'subject'} = new Gtk::Label("Subject: ");
  	$html_window->{'hdr_pane'}->{'subject'}->show;
  	$html_window->{'hdr_pane'}->{'subj_lbl'} = new Gtk::Label;
  	$html_window->{'hdr_pane'}->{'subj_lbl'}->show;
  	$html_window->{'hdr_pane'}->{'cc'} = new Gtk::Label("CC: ");
  	$html_window->{'hdr_pane'}->{'cc'}->show;
  	$html_window->{'hdr_pane'}->{'cc_lbl'} = new Gtk::Label;
  	$html_window->{'hdr_pane'}->{'cc_lbl'}->show;
  	$html_window->{'hbox'}->pack_start($html_window->{'hdr_pane'}->{'to'},0,0,0);
  	$html_window->{'hbox'}->pack_start($html_window->{'hdr_pane'}->{'to_lbl'},0,0,0);
  	$html_window->{'hbox2'}->pack_start($html_window->{'hdr_pane'}->{'from'},0,0,0);
  	$html_window->{'hbox2'}->pack_start($html_window->{'hdr_pane'}->{'from_lbl'},0,0,0);
  	$html_window->{'hbox3'}->pack_start($html_window->{'hdr_pane'}->{'date'},0,0,0);
  	$html_window->{'hbox3'}->pack_start($html_window->{'hdr_pane'}->{'date_lbl'},0,0,0);
  	$html_window->{'hbox4'}->pack_start($html_window->{'hdr_pane'}->{'subject'},0,0,0);
  	$html_window->{'hbox4'}->pack_start($html_window->{'hdr_pane'}->{'subj_lbl'},0,0,0);
  	$html_window->{'hbox5'}->pack_start($html_window->{'hdr_pane'}->{'cc'},0,0,0);
  	$html_window->{'hbox5'}->pack_start($html_window->{'hdr_pane'}->{'cc_lbl'},0,0,0);
  	if ($main::HTMLWIDGET eq "GtkHTML" || $main::HTMLWIDGET eq "CscHTML") {
   		my ($popup,$url,$item,$sep);
   		$popup = new Gtk::Menu;
		if ($main::HTMLWIDGET eq "GtkHTML") {
   			$html_window->{'html'} = new Gtk::HTML;
		} elsif ($main::HTMLWIDGET eq "CscHTML") {
			$html_window->{'html'} = new Csc::HTML;
			$html_window->{'html'}->set_default_font_face($main::prefs{'MsgFontFace'});
			$html_window->{'html'}->allow_font_switch($main::prefs{'FontSwitch'});
		}
   		$html_window->{'html'}->signal_connect('url_requested' => \&Pronto::Link::load_url);
   		$html_window->{'html'}->signal_connect('link_clicked' => \&Pronto::Link::gtkhtml_link_clicked);
		$html_window->{'html'}->signal_connect('button_press_event' => \&gtkhtml_mouse_click, $popup, \$url);
   		$html_window->{'html'}->signal_connect('on_url' => sub { shift; $url = shift;});
   		$sep = new Gtk::MenuItem;
   		$popup->show;
   		$sep->show;
   		$popup->append($sep);
   		$item = new Gtk::MenuItem(_("Save As..."));
   		$item->signal_connect("activate" => 
					sub {
					my ($temp,$filename,$source,$type);
					($temp,$source,$type) = split(/:/,$url);
					$filename = $source;
                			$filename =~ s/^file:$main::prefs{'MailDir'}\/tmp\///g;
                			&Pronto::Save::init_fs_window(undef,$filename,$source);
					});
   		$item->show;
   		$popup->append($item);
   		$item = new Gtk::MenuItem(_("View"));
   		$item->signal_connect("activate" =>
        				sub {
                			my ($temp,$filename,$source,$type);
                			($temp,$source,$type) = split(/:/,$url);
                			&Pronto::ViewAttachment::view_attachment(undef,$source,$type,'y');
        				});
   		$item->show;
  		$popup->append($item);
   		$item = new Gtk::MenuItem(_("View With..."));
   		$item->signal_connect("activate" =>
        				sub {
                			my ($temp,$filename,$source,$type);
                			($temp,$source,$type) = split(/:/,$url);
                			&Pronto::ViewAttachment::view_attachment(undef,$source,$type,'n');
        				});
   		$item->show;
   		$popup->append($item);
   		$html_window->{'html'}->set_editable(0);
   		$html_window->{'html'}->enable_debug(0);
   
   		my $sw = new Gtk::ScrolledWindow(undef, undef);
   		$sw->set_policy('automatic', 'automatic');
   		$sw->show;
   		$sw->add($html_window->{'html'});
   		$html_window->{'vbox'}->pack_start($sw,1,1,0);
   		$html_window->{'html'}->realize;
   		$html_window->{'html'}->show;
    
  	} else {
  
  		$html_window->{'html'} = new Gtk::XmHTML;
   		$html_window->{'html'}->set_anchor_buttons(0);
   		$html_window->{'html'}->set_allow_body_colors(1);
   		$html_window->{'html'}->set_hilight_on_enter(0);
   		$html_window->{'html'}->set_allow_font_switching(1);
   		$html_window->{'html'}->set_allow_images(1);
   		$html_window->{'html'}->set_strict_checking(1);
   		$html_window->{'html'}->set_anchor_target_underline_type (1);
   		$html_window->{'html'}->set_anchor_underline_type (1);
   		$html_window->{'html'}->set_anchor_visited_underline_type(1);
   		$html_window->{'html'}->signal_connect('activate' => \&Pronto::Link::link_clicked);
   		$html_window->{'html'}->show;
   		$html_window->{'vbox'}->pack_start($html_window->{'html'},1,1,0);
  	}

  	&view_message($main::conn, $msgid, $html_window->{'html'}, 1, 0, undef, undef, $html_window->{'hdr_pane'});
  
	return 1;

}

1;
