/* 
 * PVM++ - A C++ library for easy use of PVM
 * Copyright (C) 1997-2001 Sebastian Wilhelmi; University of Karlsruhe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __PVM_TASKSET_II__
#define __PVM_TASKSET_II__

#include <pvm++/types.hh>
#include <pvm++/task.hh>

#include <set>

namespace Pvm
{

  /** A set of tasks on the PVM.
      
      This class represents a set of tasks on the PVM. As it is derived
      from the STL-set, all STL-features can be used. See the example
      provided with \Ref{HostSet}. */
  class TaskSet : public std::set< Task >
  {
  };
  
} // namespace Pvm

#endif /* __PVM_TASKSET_II__ */
