/* 
 * PVM++ - A C++ library for easy use of PVM
 * Copyright (C) 1997-2001 Sebastian Wilhelmi; University of Karlsruhe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __PVM_TYPES_HH__
#define __PVM_TYPES_HH__

/** Namespace for all objects of PVM++ */
namespace Pvm
{

  #define THROW(x) if (x < 0) ::Pvm::Throw (x, __FILE__, __LINE__)
  void Throw (int Error, const char *File, int Line);

  class Host;
  class Custom;
  class EmptyStruct;
  class Host;
  class HostEntry;
  class HostSet;
  class ReceiveAction;
  class Struct;
  class StructSet;
  class Task;
  class TaskEntry;
  class TaskSet;
  
  typedef void (*HandlerFunc) (const class Struct &,
			       const class Task &);
 
  /** type for the ID of a \Ref{Struct}. */
  typedef unsigned int StructId;
} // namespace Pvm

#endif /* __PVM_TYPES_HH__ */
