import _sqlite

"""Python interface to the SQLite embedded database engine."""

#-------------------------------------------------------------------------------
# Module Information
#-------------------------------------------------------------------------------

__author__ = "Michael Owens <mike@mikesclutter.com>"
__revision__ = """$Revision: 1.8 $"""[11:-2]
threadsafety = 1
apilevel = "2.0"
paramstyle = "pyformat"

# This is the version string for the current PySQLite version.
version = "0.0.2"

# This is a tuple with the same digits as the vesrion string, but it's
# suitable for comparisons of various versions.
version_info = (0, 0, 2)

#-------------------------------------------------------------------------------
# Data type support
#-------------------------------------------------------------------------------

from main import DBAPITypeObject, BaseCursor, StandardCursor, have_itercursor, \
                 Connection, PgResultSet
if have_itercursor:
    from main import IterCursor
from constants import FIELD_TYPE

STRING    = DBAPITypeObject( FIELD_TYPE.CHAR,
                             FIELD_TYPE.STRING )

BINARY    = DBAPITypeObject( FIELD_TYPE.BLOB )

INT       = DBAPITypeObject( FIELD_TYPE.SHORT,
                             FIELD_TYPE.LONG )

NUMBER    = DBAPITypeObject( FIELD_TYPE.SHORT,
                             FIELD_TYPE.LONG,
                             FIELD_TYPE.FLOAT,
                             FIELD_TYPE.DOUBLE )

DATE      = DBAPITypeObject( FIELD_TYPE.DATE )

TIME      = DBAPITypeObject( FIELD_TYPE.TIME )

TIMESTAMP = DBAPITypeObject( FIELD_TYPE.TIMESTAMP,
                             FIELD_TYPE.DATETIME )

ROWID     = DBAPITypeObject()

#-------------------------------------------------------------------------------
# Exceptions
#-------------------------------------------------------------------------------

from pysqlite_exceptions import SQLiteError, Warning, Error, InterfaceError, \
    DatabaseError, DataError, OperationalError, IntegrityError, InternalError, \
    ProgrammingError, NotSupportedError

#-------------------------------------------------------------------------------
# Global Functions
#-------------------------------------------------------------------------------

def connect(*args, **kwargs):
    return Connection(*args, **kwargs)

__all__ = ['connect','IntegrityError', 'InterfaceError', 'InternalError',
           'NotSupportedError', 'OperationalError',
           'ProgrammingError', 'Warning',
           'Connection', 'BaseCursor', 'StandardCursor', 'PgResultSet',
           'apilevel', 'paramstyle', 'threadsafety', 'version', 'version_info']

if have_itercursor:
    __all__.append('IterCursor')
