/***************************************************************************
                          qcupsprintdialog.h  -  description
                             -------------------
    begin                : Thu Jun 15 2000
    copyright            : (C) 2000 by Michael Goffioul
    email                : gofioul@imec.be
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef QCUPSPRINTDIALOG_H
#define QCUPSPRINTDIALOG_H

#include <qtcups/qcupsprintdialogbase.h>

#include <cups/cups.h>

class QCupsPrinterConfigDialog;

/**
  *@author Michael Goffioul
  */

class QCupsPrintDialog : public QCupsPrintDialogBase
{
   Q_OBJECT
public:
	enum PropertyType {
		PrinterGeneral = 0x01,
		PrinterImage   = 0x02,
		PrinterText    = 0x04,
		PrinterPS      = 0x08,
		PrinterHPGL    = 0x10,
		PrinterAll     = 0xFF
	};
	QCupsPrintDialog(QWidget *parent=0, const char *name=0, bool useInstances=true);
	~QCupsPrintDialog();

  const char* printerName();
  void getAllOptions(int& num_options, cups_option_t **options);
  void setPropertyType(int type);
  void allowCurrentPage(bool on);
  void setPrinter(const char *pd);
  void setCupsOptions(int num_options, cups_option_t *options);

protected:
  void initialize();
  void initCups();
  void closeCups();

protected slots: // Protected slots
  void collateClicked();
  void rangeEntered();
  void optionsClicked();
  void printerSelected(int index);
  void propertiesSaveClicked();
  void propertyClicked();
  void setDefaultClicked();
  virtual void done(int result);

private: // Private attributes
  QCupsPrinterConfigDialog* configdlg_;
  int destnum_;
  cups_dest_t* destinations_;
  cups_dest_t* dests_edited_;
  int propType_;
  bool useInstances_;
};

#endif
