/*-*- c++ -*-******************************************************************
 * Qwt Widget Library 
 * Copyright (C) 1997   Josef Wilgen
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *****************************************************************************/

#ifndef QWT_SCLDRAW_H
#define QWT_SCLDRAW_H

#include <qglobal.h>
#include <qstring.h>
#include "qwt_dimap.h"
#include "qwt_scldiv.h"
#include <qfont.h>
#include <qrect.h>
#include <qcolor.h>

class QPainter;
class QwtAutoScale;

/*!
  \brief A class for drawing scales

  QwtScaleDraw can be used to draw linear or logarithmic scales.
  A scale has an origin,
  an orientation and a length, which all can be specified with
  setGeometry().

  After a scale division has been specified as a QwtScaleDiv object
  using setScale(const QwtScaleDiv &s),
  or determined internally using setScale(double vmin, double vmax, int maxMajIntv, int maxMinIntv, double step = 0.0, int logarithmic = 0),
  the scale can be drawn with the QwtScaleDiv::draw() member.
*/
class QwtScaleDraw
: public QwtDiMap
{
	
public:
    enum Orientation { Bottom, Top, Left, Right, Round };

private:

    QwtScaleDiv d_scldiv;
	
    static const int minLen;
	
    Orientation d_orient;
	
    int d_xorg;
    int d_yorg;
    int d_len;
	
    int d_hpad;
    int d_vpad;
	
    int d_medLen;
    int d_majLen;
    int d_minLen;

    int d_minAngle;
    int d_maxAngle;

    double d_xCenter;
    double d_yCenter;
    double d_radius;

    char d_fmt;
    int d_prec;
	
private:

    void drawTick(QPainter *p, double val, int len) const;
    void drawBackbone(QPainter *p) const;
    void drawLabel(QPainter *p, double val) const;
	
public:
 
    // CREATORS
    QwtScaleDraw();
    
    // MANIPULATORS
    void setScale(const QwtScaleDiv &s);
    void setScale(double vmin, double vmax, int maxMajIntv, int maxMinIntv,
		  double step = 0.0, int logarithmic = 0);
    void setGeometry(int xorigin, int yorigin, int length, Orientation o);
    void setAngleRange(double angle1, double angle2);
    void setLabelFormat(char f, int prec);

    // ACCESSORS
    /*! \return scale division */
    const QwtScaleDiv& scaleDiv() const { return d_scldiv; }
    /*! \return scale orientation */
    Orientation orientation() const { return d_orient; }
    QRect maxBoundingRect(QPainter *p) const;
    int maxWidth(QPainter *p, bool worst = TRUE) const;
    int maxHeight(QPainter *p) const;
    int maxLabelWidth(QPainter *p, int worst = TRUE) const;
	void labelFormat(char &f, int &prec) const;
	
    void draw(QPainter *p) const;
};

#endif
