/*-*- c++ -*-******************************************************************
 * Qwt Widget Library 
 * Copyright (C) 1997   Josef Wilgen
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *****************************************************************************/

#ifndef QWT_PLOT_PIXFRAME_H
#define QWT_PLOT_PIXFRAME_H

#include "qwt_pixframe.h"
#include "qwt_plot_item.h"

class QwtPlotPixFrame : public QwtPixFrame, public QwtPlotItem
{
private:

    bool d_outlineEnabled;
    bool d_outlineActive;
    bool d_mousePressed;
    Qwt::Shape d_outline;

    QPen d_pen;
    QPoint d_entryPoint;
    QPoint d_lastPoint;
   
public:
    QwtPlotPixFrame(QwtPlot *parent)
       : QwtPixFrame(parent), QwtPlotItem(parent), d_pen(red){}
    void setOutlinePen(const QPen &p);
    void setOutlineStyle(Qwt::Shape os);
    void enableOutline(bool tf);

    bool outlineEnabled() const { return d_outlineEnabled; }
    Qwt::Shape outlineStyle() const { return d_outline; }
    const QPen& outlinePen() const { return d_pen; }
    
private:    
    void drawOutline(QPainter &p);

protected:
    virtual void paintEvent(QPaintEvent *e);
    virtual void mousePressEvent(QMouseEvent *e);
    virtual void mouseReleaseEvent(QMouseEvent *e);
    virtual void mouseMoveEvent(QMouseEvent *e);
};


#endif
