/*-*- c++ -*-******************************************************************
 * Qwt Widget Library 
 * Copyright (C) 1997   Josef Wilgen
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *****************************************************************************/

#ifndef QWT_SYMBOL_H
#define QWT_SYMBOL_H

#include <qglobal.h>
#include "qwt.h"
#include <qbrush.h>
#include <qpen.h>
#include <qpoint.h>
#include <qsize.h>
#include <qpntarry.h>

class QPainter;

//! A class for drawing symbols
class QwtSymbol
{
public:

    enum Style { None, Ellipse, Rect, Diamond, Triangle, DTriangle,
	UTriangle, LTriangle, RTriangle, Cross, XCross, StyleCnt }; 
    
protected:

    QBrush d_brush;
    QPen d_pen;
    QSize d_size;
    QPointArray d_pa;
    Style d_style;
    
public:

    QwtSymbol();
    QwtSymbol(Style st, const QBrush &bd, const QPen &pn, const QSize &s);
    virtual ~QwtSymbol();
    
    void setSize(const QSize &s);
    void setSize(int a, int b = -1);
    void setBrush(const QBrush& b);
    void setPen(const QPen &p);
    void setStyle (Style s);

    const QBrush& brush() const { return d_brush; }
    const QPen& pen() const { return d_pen; }
    const QSize& size() const { return d_size; }
    Style style() const { return d_style; } 
    
    void draw(QPainter *p, const QPoint &pt); 
    void draw(QPainter *p, int x, int y);
    virtual void draw(QPainter *p, const QRect &r);
    
};



#endif
