require 'net/telnet'

class ExcusePlugin < Plugin
  def help(plugin, topic="")
    "excuse => supply a random excuse"
  end
  def privmsg(m)
    begin
      host = Net::Telnet::new({
        "Host"       => "bofh.engr.wisc.edu",
        "Timeout"    => 3,
        "Port"       => 666
      })
      if(host)
        line = host.waitfor(/^Your excuse is: /)
        if(line)
          line.each_line {|l|
            if(l =~ /^Your excuse is: (.*)$/)
              m.reply $1
            end
          }
        else
          m.reply "the excuse server is down :("
        end
      else
        m.reply "the excuse server is down :("
      end
    rescue TimeoutError, ErrNo::ECONREFUSED
      m.reply "the excuse server is unreachable :("
      return
    end
  end
end

plugin = ExcusePlugin.new
plugin.register("excuse")
