#!/bin/sh

# 1 path to mesarc and mesdbc binaries
# 2 www directory
# 3 cgi name
# 4 mailbox index name
# 5 mail addres of list

if [ -z "${1}" -o -z "${2}" -o -z "${3}" -o -z "${4}" -o -z "${5}" ]; then
    echo "messarge @BABOLO http://www.links.ru/soft/messarge/"
    echo "Use:"
    echo "establi.sh <bindir> <www directory> <cgi> <mailbox index path> <mail address>"
    echo "    bindir - directory with mesarc and mesdbc binaries in it"
    echo "    www directory - directory with html files somewhere in httpd docs tree"
    echo "    cgi - name of mesbin.cgi with full path, use unique name for every maillist"
    echo "    mailbox index path - where create index for mailbox"
    echo "    mail address - address of maillist you create archive for"
    echo
    echo "Read README file for some addidional tunes"
    exit 0;
fi

cd `dirname "${0}"`

if [ ! -x "${1}/mesarc" -o ! -x "${1}/mesdbc" ]; then
    echo "Not found ${1}/mesarc or ${1}/mesdbc executables"
    exit 0;
fi

mkdir -p "${2}"
for i in *html; do
    sed -e "smesarc${1}/mesarcg" -e "slist.db${4}g" -e "smesbin.cgi${3}g" -e "slist@host${5}g" < "${i}" > "${2}/${i}"
done
echo "${2}   directory populated by html files"

mkdir -p "`dirname \"${3}\"`"
sed -e "smesarc${1}/mesarcg" -e "slist.db${4}g" < "mesbin.cgi" > "${3}"
chmod a+x "${3}"
echo "${3}   cgi script created"

mkdir -p "`dirname \"${4}\"`"
echo "`dirname \"${4}\"`   directory for index file \"${4}\" ready"

echo
echo "Now cd `dirname \"${4}\"` if use non-absolute path for mailbox"
echo "Execute please:"
echo "\"${1}/mesdbc\" -c [some flags] -f <mailbox> \"${4}\""

#

