=begin
= (({Msql}))
mSQL client class.

=== constant

--- Msql::CONFIG_GROUP_GENERAL
    For ((<Msql.get_config>)).

--- Msql::CONFIG_GROUP_SYSTEM
    For ((<Msql.get_config>)).

--- Msql::CONFIG_GROUP_W3MSQL
    For ((<Msql.get_config>)).

--- Msql::INST_DIR
    mSQL installed directory.

--- Msql::SERVER_VERSION
    mSQL server version.

--- Msql::TARGET
    mSQL target platform.

--- Msql::VERSION
    Ruby/mSQL versions.


=== class method

--- Msql.connect([host], [database_name])
    Try to connect mSQL server specified the ((|host|))
    and select database specified the ((|database_name|)).
    If you omit ((|host|)) or specified the ((|nil|)) as ((|host|)),
    then connect local mSQL server.

    ((*ex.*))

    Msql.connect 'sublime', 'artists' #=>
    connect server on host 'sublime' and select database 'artists'.

    Msql.connect nil, 'singles' #=>
    connect local server and select database 'singles'.

    Msql.connect 'frogman' #=> connect server on host 'frogman'.

    Msql.connect #=> connect local server.
    :Returns:
      *Msql: mSQL client.
    :Exceptions:
      *TypeError: ((|host|)) and/or ((|database_name|)) aren't String.
      *MsqlError: connection failed.

--- Msql.get_config(group)
    Get config values from loaded config file.
    ((|group|)) only accepts below
    *((<Msql::CONFIG_GROUP_GENERAL>)) --- "general"
    *((<Msql::CONFIG_GROUP_SYSTEM>))  --- "system"
    *((<Msql::CONFIG_GROUP_W3MSQL>))  --- "w3-msql"
    :Returns:
      *Hash: config values of specified group.
      *nil : unkown group.

--- Msql.load_config_file([conf_file])
    Load config file specified the ((|conf_file|)).
    :Exceptions:
      *TypeError: ((|conf_file|)) isn't String.
      *MsqlError: loading failed.


=== instance method

--- Msql#close
    Close the connection with the connected server.
    :Exceptions:
      *MsqlError: closing failed.

--- Msql#connect([host], [database_name])
    See ((<Msql.connect>)).
    :Exceptions:
      *TypeError: ((|host|)) and/or ((|database_name|)) aren't String.
      *MsqlError: already connected or connection failed.


--- Msql#copy_db(src_db, dest_db)
    Copy a database from the ((|src_db|)) to the ((|dest_db|)).
    ((*This is administrator operation*)).
    :Exceptions:
      *TypeError: ((|src_db|)) and/or ((|dest_db|)) aren't String.
      *MsqlError: copying failed.

--- Msql#create_db(db_name)
    Create new database named ((|db_name|)).
    ((*This is administrator operation*)).
    :Exceptions:
      *TypeError: ((|db_name|)) isn't String.
      *MsqlError: creating failed.

--- Msql#drop_db(db_name)
    Delete database named ((|db_name|)) completely.
    ((*This is administrator operation*)).
    :Exceptions:
      *TypeError: ((|db_name|)) isn't String.
      *MsqlError: droping failed.

--- Msql#database
    Get selected database name (same as specified in ((<Msql.connect>)) or
    ((<Msql#connect>)) or ((<Msql#select_db>))).
    :Returns:
      *String: database name.

--- Msql#get_host
    Get connected host name (same as specified in ((<Msql.connect>)) or ((<Msql#connect>))).
    :Returns:
      *String: host name.

--- Msql#get_host_info
    Get connected host name and connection protocol name.
    :Returns:
      *String: host name and protocol name.

--- Msql#get_sequence_info
    Get information of sequence.
    :Returns:
      *MsqlSequence: sequence info.
      *nil: no sequence exists.

--- Msql#get_server_stats
    Get states of the connected server (for console ouput).
    Output config file name, max connections, current connections, server running as user and connection table.

--- Msql#get_server_info
    Get version of the connected mSQL server.
    :Returns:
      *String: version number.

--- Msql#list_dbs
    Get all database names on the connected server.
    :Returns:
      *MsqlResult: database names.
    :Exceptions:
      *MsqlError: failed.

--- Msql#list_fields(table_name)
    Get all filed names on the table specified the ((|table_name|)).
    :Returns:
       *MsqlResult: field names.
    :Exceptions:
      *TypeError: ((|table_name|)) isn't String.
      *MsqlError: failed.

--- Msql#list_index(table_name, index)
    Get information of the ((|index|)) on the table specified the ((|table_name|)).
    :Returns:
      *MsqlResult: type of the ((|index|)) and filed names included by the ((|index|)).
    :Exceptions:
      *TypeError: ((|table_name|)) and/or ((|index|)) aren't String.
      *MsqlError: failed.

--- Msql#list_tables
    Get all table names on the connected server.
    :Returns:
      *MsqlResult: table names.
    :Exceptions:
      *MsqlError: failed.

--- Msql#move_db(src_db, dest_db)
    Move a database from the ((|src_db|)) to the ((|dest_db|)).
    ((*This is administrator operation*)).
    :Exceptions:
      *TypeError: ((|src_db|)) and ((|dest_db|)) aren't String.
      *MsqlError: moving failed.

--- Msql#query(query)
    Execute ((|query|)).
    ((*Must do ((<Msql#select_db>)) before this operaion*)).
    :Returns:
      *Integer: number of records effected by the ((|query|)).
    :Exceptions:
      *MsqlError: ((|query|)) failed.

--- Msql#reload_acls
    Reload ACL(Access Control List) file.
    ((*This is administrator operation*)).
    :Exceptions:
      *MsqlError: reloading failed.

--- Msql#select_db(db_name)
    Select database on the connected server.
    ((*Must do this before ((<Msql#query>))*)).
    :Exceptions:
      *MsqlError: selection failed.

--- Msql#shutdown
    Shutdown connected server.
    ((*This is administrator operation*)).
    :Exceptions:
      *MsqlError: shutdowning failed.

--- Msql#store_result
--- Msql#get_result
    Get query results (SELECT statement).
    ((*Must do ((<Msql#query>)) before this operaion*)).
    ((*And must do this operaion before execute next ((<Msql#query>))*)).
    :Returns:
      *MsqlResult: query results.
    :Exceptions:
      *MsqlError: failed.
=end


=begin
= (({MsqlResult}))
mSQL query result class.

=== class method

    No class method.


=== instance method

--- MsqlResult#data_seek(pos)
    Set cursor at ((|pos|)). 
    ((<MsqlResult#fetch_row>)) fetch a row at a position of the cursor.

--- MsqlResult#each_field {|field|...}
    Iterated access to each filed.
    (notice: start at cursor position)

--- MsqlResult#each_field_with_index {|field, index|...}
    Iterated access to each filed with index number.
    (notice: start at cursor position)

--- MsqlResult#each_row {|row|...}
    Iterated access to each row.
    (notice: start at cursor position)

--- MsqlResult#each_row_with_index {|row, index|...}
    Iterated access to each row with index number.
    (notice: start at cursor position)

--- MsqlResult#fetch_all_fields
    Get all fields.
    (notice: range of fields is from the cursor position to the end)
    :Returns:
      *Array: array of fields.

--- MsqlResult#fetch_all_rows
    Get all rows.
    (notice: range of rows is from the cursor position to the end)
    :Returns:
      *Array: array of rows.

--- MsqlResult#fetch_field
    Fetch one field from the result.
    :Returns:
      *MsqlField: information of the field.
         ex. As if a MsqlResult instance has a result such as
         +---------------------+-----------+
         | name                | genre     |
         +---------------------+-----------+
         | Anthony & Cleopatra | Tragedies |
         | Corilanus           | Tragedies |
         | Hamlet              | Tragedies |
         | Julius Caesar       | Tragedies |
         | King Lear           | Tragedies |
         +---------------------+-----------+
         then fetch_field returns field object of 'name'
         and the cursor move to the next 'genre' field
         (next fetch_field return this field).
      *nil: no more fileds.

--- MsqlResult#fetch_hash
    Fetch one row as hash from the result.
    :Returns:
      *Hash: key is field name and value is element.
         ex. As if a MsqlResult instance has a result such as
         +---------------------+-----------+
         | name                | genre     |
         +---------------------+-----------+
         | Anthony & Cleopatra | Tragedies |
         | Corilanus           | Tragedies |
         | Hamlet              | Tragedies |
         | Julius Caesar       | Tragedies |
         | King Lear           | Tragedies |
         +---------------------+-----------+
         then fetch_hash returns
         {"name"=>"Anthony & Cleopatra", "genre"=>"Tragedies"}
         and the cursor move to the next row.
      *nil: no more rows.

--- MsqlResult#fetch_row
    Fetch one row from the result.
    :Returns:
       *Array: array of (String) elements of each fields.
         ex. As if a MsqlResult instance has a result such as
         +---------------------+-----------+
         | name                | genre     |
         +---------------------+-----------+
         | Anthony & Cleopatra | Tragedies |
         | Corilanus           | Tragedies |
         | Hamlet              | Tragedies |
         | Julius Caesar       | Tragedies |
         | King Lear           | Tragedies |
         +---------------------+-----------+
         then fetch_row returns
         ["Anthony & Cleopatra", "Tragedies"]
         and the cursor move to the next row:
         ["Corilanus", "Tragedies"](next fetch_row return this row).
       *nil: no more rows.

--- MsqlResult#field_seek(pos)
    Set cursor at ((|pos|)). 
    ((<MsqlResult#fetch_field>)) fetch a field at a position of the cursor.

--- MsqlResult#num_fields
    Get number of fields of the results.
    :Returns:
      *Integer: number of fields.

--- MsqlResult#num_rows
    Get number of rows of the results.
    :Returns:
      *Integer: number of rows.
=end


=begin
= (({MsqlField}))
mSQL field has a information of column.

=== constant

--- MsqlField::INT_TYPE
    Field data type: integer.

--- MsqlField::CHAR_TYPE
    Field data type: charactor.

--- MsqlField::REAL_TYPE
    Field data type: real number.

--- MsqlField::IDENT_TYPE
    Field data type: identify.

--- MsqlField::NULL_TYPE
    Field data type: null.

--- MsqlField::TEXT_TYPE
    Field data type: text.

--- MsqlField::DATE_TYPE
    Field data type: date.

--- MsqlField::UINT_TYPE
    Field data type: unsigned integer.

--- MsqlField::MONEY_TYPE
    Field data type: money.

--- MsqlField::LAST_REAL_TYPE
    Field data type: last real number.

--- MsqlField::IDX_TYPE
    Field data type: index.

--- MsqlField::SYSVAR_TYPE
    Field data type: system variable.

--- MsqlField::ANY_TYPE
    Field data type: any.


=== class method

    No class method.


=== instance method

--- MsqlField#name
    Get field name.
    :Returns:
      *String: field name.

--- MsqlField#table
    Get table name.
    :Returns:
      *String: table name.

--- MsqlField#type
    Get filed type.
    :Returns:
      *Integer: filed type.
        *((<MsqlField::INT_TYPE>))
        *((<MsqlField::CHAR_TYPE>))
        *((<MsqlField::REAL_TYPE>))
        *((<MsqlField::IDENT_TYPE>))
        *((<MsqlField::NULL_TYPE>))
        *((<MsqlField::TEXT_TYPE>))
        *((<MsqlField::DATE_TYPE>))
        *((<MsqlField::UINT_TYPE>))
        *((<MsqlField::MONEY_TYPE>))
        *((<MsqlField::LAST_REAL_TYPE>))
        *((<MsqlField::IDX_TYPE>))
        *((<MsqlField::SYSVAR_TYPE>))
        *((<MsqlField::ANY_TYPE>))

--- MsqlField#length
    Get filed length.
    :Returns:
      *Integer: filed length.

--- MsqlField#flags
    Get field flags.
    Usually, access with ((<MsqlField#is_not_null>)) or ((<MsqlField#is_unique>)).
    :Returns:
      *Integer: field flags.

--- MsqlField#is_not_null
--- MsqlField#is_not_null?
    Return true if field defined as NOT NULL.
    :Returns:
      *true/false: field is 'NOT NULL' or not.

--- MsqlField#is_unique
--- MsqlField#is_unique?
    Return true if field is unique.
    Returns:
      *true/false: field is unique or not.

=end


=begin
= (({MsqlSequence}))
Sequence information.

=== class method

    No class method.


=== instance method

--- MsqlSequence#step
    Get sequence step.
    :Returns:
      *Integer: sequence step.

--- MsqlSequence#value
    Get sequence value.
    :Returns:
      *Integer: sequence value.

=end


