=begin
/****************************************************************
**
** Implementation CannonField class, Qt tutorial 10
**
****************************************************************/
=end


class  CannonField < QWidget
attr_reader:angleChanged
attr_reader:forceChanged

def initialize ( parent, name )
    super( parent, name )
    @angleChanged = RSignal.new("int")
    @forceChanged = RSignal.new("int")
    @ang = 45
    @f = 0
    setPalette( QPalette.new( QColor.new( 250, 250, 200,QColor::Rgb) ) )
    catchEvent
end


def setAngle( degrees )

    if ( degrees < 5 )
	degrees = 5
    elsif ( degrees > 70 )
	degrees = 70
    end
    if ( @ang == degrees )
	return
    end
    @ang = degrees
    repaint()
    @angleChanged.sendWith( @ang )
end

def setForce( newton)
    if ( newton < 0 )
	newton = 0
    elsif ( @f == newton )
	return
    end
    @f = newton
    @forceChanged.sendWith( @f )
end

def paintEvent( e )
    if( !e.rect().intersects(cannonRect()))
        return
    end
    cr = cannonRect()
    pix = QPixmap.new(cr.size())
    pix.fill(self,cr.topLeft())

    if (@p.nil?)
      @p = QPainter.new
    end
    @p.begin(pix)

    @p.setBrush( Qt::blue )
    @p.setPen( Qt::NoPen )

    @p.translate( 0, pix.height() - 1 )
    @p.drawPie( QRect.new(-35, -35, 70, 70), 0, 90*16 )
    @p.rotate( -@ang )
    @p.drawRect( QRect.new(33, -4, 15, 8) )
    @p.end()

    @p.begin(self)
    @p.drawPixmap(cr.topLeft(),pix)
    @p.end
end

def cannonRect
    r = QRect.new(0,0,50,50)
    r.moveBottomLeft(rect().bottomLeft())
    r
end

def sizePolicy()
    QSizePolicy.new( QSizePolicy::Expanding, QSizePolicy::Expanding )
end

end
