=begin
/****************************************************************
**
** Implementation of LCDRange class, Qt tutorial 8
**
****************************************************************/
=end

class LCDRange < QVBox
attr_reader:valueChanged

def initialize ( parent, name )
     super( parent, name )
    @valueChanged = RSignal.new("int")
    @lcd  = QLCDNumber.new( 2, self, "lcd"  )
    @slider = QSlider.new( Horizontal, self, "slider" )
    @slider.setRange( 0, 99 )
    @slider.setValue( 0 )
    @label = QLabel.new( " ", self, "label"  )
    @label.setAlignment( AlignCenter )

    connect( @slider, QSIGNAL("valueChanged(int)"),  @lcd, QSLOT("display(int)") )
    connect( @slider, QSIGNAL("valueChanged(int)"), @valueChanged)

    setFocusProxy( @slider )
#    setText(s)
end

def value()
     @slider.value()
end

def text
    return @label.text()
end

def setValue( value )
    @slider.setValue( value )
end

def setRange( minVal, maxVal )

    if ( minVal < 0 || maxVal > 99 || minVal > maxVal ) 
      qWarning( "LCDRange::setRange(%d,%d)\n"+ "\tRange must be 0..99\n"+ "\tand minVal must not be greater than maxVal", minVal, maxVal )
      return
    end
    @slider.setRange( minVal, maxVal )
end

def setText( s )

    @label.setText( s )
end
end
