# Map of Finite Sets
#
#   by Shin-ichiro Hara
#
# Version 0.93 (2002.03.12)

require "finite-set"
require "powers"

module Algebra
  class Map < Set
    include Powers

    def self.[](a = {})
      new.instance_eval do
	@body = Hash[a]
	self
      end
    end

    def self.new_a(a)
      self[Hash[*a]]
    end

    def initialize(h = {})
      @body = h
    end

    def self.empty_set(t = nil)
      m = new()
      m.target = t if t
      m
    end
    
    class << self
      alias phi empty_set
      alias null empty_set
    end

    def self.singleton(x, y)
      new(x => y)
    end

    def each(&b)
      @body.each(&b)
    end

    def empty_set(s = nil)
      type.empty_set(s)
    end
    
    alias phi empty_set
    alias null empty_set

    def dup
      m = type.new(@body.dup)
      m.target = target if target
      m
    end

    def call(x)
      @body.fetch(x)
    end

    alias act call
    alias [] call

    def append!(x, y)
      @body.store(x, y)
      self
    end

    alias []= append!

    def append(x, y)
      dup.append!(x, y)
    end

    def hash
      s = 0
      @body.each_key do |k, v|
	s ^= k.hash ^ ~(v.hash)
      end
      s
    end

    def has?(a)
      return nil unless a.is_a? Array
      @body[a.first] == a.last
    end

    def domain
      type.superclass.new(*@body.keys)
    end
    
    def image(set = nil)
      if set
	set.map_s{|k| call(k)}
      else
	type.superclass.new(*@body.values)
      end
    end

    def map_s
      s = type.superclass.phi
      each do |x, y|
	s.append!(yield(x, y))
      end
      s
    end
    
    def map_m
      s = phi
      each do |x, y|
	s.append!(* yield(x, y))
      end
      s
    end

    def inverse
      type.new(@body.invert)
    end
    
    def compose(other)  # LEFT ACTION!!!
      other.map_m{|x, y| [x, call(y)]}
    end

    alias * compose

#  module Map_common
    
    attr_accessor :target
    alias source domain
    alias codomain target
    alias codomain= target=
        
    def surjective?
      raise "target is not defined." unless @target
      image.size == target.size
    end
    
    def injective?
      image.size == source.size
    end
    
    def bijective?
      surjective? and injective?
    end
    
    def inv_image(s)
      source.separate{|x| s.has? act(x)}
    end

    def inspect
      @body.inspect
    end

    def to_s
      @body.inspect
    end
  end
end

if $0 == __FILE__
  require "permutation-group"

  a = Algebra::Set[0, 1, 2]
  b = Algebra::Set[0, 1, 2]
  (a ** b).each do |x|
    p x
  end
end
