module Powers
  def **(n)
    if n == 0
      x = Map.phi
      each {|pt| x.append(pt.first, pt.first)}
      return x
    end

    if n > 0
      m = self
    else
      n = -n
      m = self.inverse
    end

    if n == 1
      m
    else
      q , r = n.divmod 2
      x = m ** q
      x = x * x
      x = x * m if r > 0
      x
    end
  end
end
