# Splitting Field of Polynomial over Rational
#
#   by Shin-ichiro Hara
#
# Version 1.11 (2002.02.23)

require "polynomial"
require "polynomial-factor"
require "algebraic-extension-field"

module Algebra
  module SplittingField
    def decompose(pre_facts = nil, var_obj = "a")
      poly = self
      # poly may have duplicate roots
      ext_field = poly.ground
      
      polys = pre_facts ? pre_facts.dup : poly.factorize
      roots = []
      addelems = []
      fac = Factors.new
      poly_exps = []
      
      while fn = polys.shift
	f, n = fn
	if f.deg <= 1
	  fac.push [f, n]
	  n.times{ poly_exps.push -f[0]/f[1] } unless f[1].zero?
	else
	  newF = Algebra.AlgebraicExtensionField(ext_field, var_obj) {|v|
	    f.evaluate(v)
	  }

#	  n.times{ roots.push newF.var }
	  roots.push newF.var
	  (n-1).times{ poly_exps.push newF.var }
	  addelems.push newF.var
	  
	  px = Algebra.Polynomial(newF, "x")
	  fac.push [px.var - newF.var, n]
	  q = f.convert_to(px) / (px.var - newF.var)
	  polys_new = q.factorize ** n
	  polys.each do |g, m|
	    fc = g.convert_to(px).factorize
	    polys_new.concat fc ** m
	  end
	  
	  ext_field = newF
	  polys = polys_new
	  var_obj = var_obj.succ
	end
      end
      roots = roots + poly_exps
      
      mods = if ext_field <= Algebra::AlgebraicExtensionField
	       ext_field.def_polys
	     else
	       []
	     end
      
      [ext_field, mods, fac, roots, addelems]
    end

    def splitting_field(pre_facts = nil, var_obj = "a")
      poly = self
      field, def_polys, fac, roots, addelems =
	poly.decompose(pre_facts, var_obj)
      roots = roots.collect{|r| r + field.zero} # not good
      Struct.new(:poly, :field, :roots, :def_polys, :poly_exps)[
	poly, field, roots, def_polys, roots[def_polys.size..-1]
      ]
    end
  end

  #for backward compatibility
  def MinimalDecompositionField(f, *a); f.decompose(*a); end
  module_function :MinimalDecompositionField
end
