########################################################################
#                                                                      #
#   lib/finite-group.rb                                                #
#                                                                      #
########################################################################
=begin
[((<index|URL:index.html>))] 
((<Algebra::OperatorDomain>))
/
((<Algebra::Set>))
/
((<Algebra::Group>))
/
((<Algebra::QuotientGroup>))

= Algebra::OperatorDomain

This is the module for the set oprated by groups.
This is included by ((<Group>)).

== File Name:
* ((|finite-group.rb|))

== Methods:

--- right_act(other)
    Returns the products of ((|self|)) and ((|other|)), i.e.
    ((|Set|)) of (({x * y})) for
    ((|x|)) element of ((|self|)) and ((|y|)) element of ((|other|)).

--- act
    Alias of ((<right_act>)).

--- left_act(other)
    Returns the products of ((|self|)) and ((|other|)), i.e.
    ((|Set|)) of (({y * x})) for
    ((|x|)) element of ((|self|)) and ((|y|)) element of ((|other|)).

--- right_quotient(other)
    Returns the ((|Set|)) of right residue classes
    of ((|self|)) by ((|other|)). 

--- quotient
--- right_coset
--- coset
    Alias of ((<right_quotient>)).

--- left_quotient(other)
    Returns the ((|Set|)) of left residue classes
    of ((|self|)) by ((|other|)). 

--- left_coset
    Alias of ((<left_quotient>)).

--- right_representatives(other)
    Returns the representatives of the
    right residue classes ((<right_quotient>)).

--- representatives
    Alias of ((<right_representatives>)).

--- left_representatives(other)
    Returns the representatives of the
    left residue classes ((<left_quotient>)).

--- right_orbit!(other)
    Extends ((|self|)) operating the elements of ((|other|)) by right action
    ((|*|)).

--- orbit!
    Alias of ((<right_orbit!>)).

--- left_orbit!(other)
    Extends ((|self|)) operating the elements of ((|other|)) by left action
    ((|*|)).
    
= Algebra::Set

== File Name:
* ((|finite-group.rb|))

== Included Module:

* ((|OperatorDomain|))

== Methods:

--- * act
    Alias of ((<act>))

--- /
    Alias of ((<quotient>)).

--- %
    Alias of ((<representatives>)).

--- increasing_series([x])
    Returns the increasing series begining with ((|x|)).
    This is equivalent to the following code:

      def increasing_series(x = unit_group)
        a = []
        loop do
          a.push x
          if x >= (y = yield x)
            break
          end
          x = y
        end
        a
      end

--- decreasing_series([x])
    Returns the decreasing series begining with ((|x|)).
    This is equivalent to the following code:

      def decreasing_series(x = self)
        a = []
        loop do
          a.push x
          if x <= (y = yield x)
            break
          end
          x = y
        end
        a
      end

= Algebra::Group

== File Name:
* ((|finite-group.rb|))

== SuperClass:
* ((|Set|))

== Included Module:
(None)

== Class Methods:

--- ::new(u, [g0, g1, ...]])
    Returns the group which consists of ((|u|)), ((|g0|)), ((|g1|)), ... 
    and whose unity is ((|u|)).

--- ::generate_strong(u, [g0, [g1, ...]])
    Returns the group strongly generated by ((|g0|)), ((|g1|)), ... 
    and whose unity is ((|u|)).

== Methods:

--- quotient_group(u)
    Returns the residue class group of the normal subgroup ((|u|)).

--- separate
    Returns the subgroup whose elements makes the block true.

--- to_a
    Returns the array of elements. The first is the unity.

--- unity
    Returns the unity.

--- unit_group
    Returns the unit group.

--- semi_complete!
    Makes ((|self|)) be the semi-group generated by the elements.

--- semi_complete
    Returns the semi-group generated by the elements.

--- complete!
    Makes ((|self|)) be the semi-group generated by the elements.

--- complete
    Returns the group generated by the elements.

--- closed?
    Returns true when ((|self|)) is closed by product and inverse.

--- subgroups
    Returns the all subgroups.

--- centralizer(s)
    Returns the centralize of ((|s|)) in ((|self|)).

--- center
    Returns the center of((|self|)).

--- center?(x)
    Returns true if ((|x|)) is in the center of ((|self|)).

--- normalizer(s)
    Returns the normalizer of ((|s|)) in ((|self|)).

--- normal?(s)
    Returns true if ((|s|)) is a normal subgroup of ((|self|)).

--- normal_subgroups
    Returns the all normal subgroups.

--- conjugacy_class(x)
    Returns the conjugacy class of the element ((|x|)).

--- conjugacy_classes
    Returns the set of all conjucacy claases of ((|self|)).

--- simple?
    Retuns true if ((|self|)) is a simple group.

--- commutator([h])
    Returns the commutator subgroup of ((|self|)) and ((|h|)).
    If the parameter is omitted, ((|h|)) is assumed to be ((|self|)).

--- D([n])
    Returns the ((|n|))-the commutator subgroup.
    (({D(0) = self})) and (({D(n+1) = [D[n], D[n]]})).
    If the parameter ommitted, ((|n|)) is assumed to be 1.

--- commutator_series
    Returns the array (({[D(0), D(1), D(2),..., D(n)]})) .
    This sequence is terminated for ((|n|)) with (({D(n) == D(n+1)})).

--- solvable?
    Returns true if ((|self|)) is solvable.

--- K([n])
    Returns the subgroup definend such that (({K(0) = self})) and
    (({K(n+1) = [self, K[n]})).
    If the parameter is omitted, ((|n|)) is asumed to be 1.

--- descending_central_series
    Returns the descending central series:
    (({[K(0), K(1), K(2),..., K(n)]})).
    This sequence is terminated for ((|n|)) with (({K(n) == K(n+1)})).

--- Z([n])
    Returns the subgroup that defined by: (({Z(0) = unit group})),
    (({Z(n+1) = separate{|x| commutator(Set[x]) <= Z(n-1)}})) .
    If the parameter is omitted, ((|n|)) is assumed to be 1.

--- ascending_central_series
    Returns the array of  ascending central series:
    (({[Z(0), Z(1), Z(2),..., Z(n)]})).
    This sequence is terminated for ((|n|)) such that
    (({Z(n) == Z(n+1)})).

--- nilpotent?
    Returns true if ((|self|)) is nilpotent.

--- nilpotency_class
    Returns the class of nilpotency.
    If ((|self|)) is not nilpotent, returns nil.

= Algebra::QuotientGroup

== File Name:
* ((|finite-group.rb|))

== SuperClass:
* ((|Group|))

== Class Methods:
--- new(u, [g0, [g1,...]])
    Returns the residue class group by ((|u|)) of which the residues are
    ((|u|)), ((|g0|)), ((|g1|)), ... Here ((|u|)) is assumed to be
    the normal subgroup of ((|self|)).
    

== Methods:

--- inverse
    Returns the inverse element.

--- inv
    Alias of ((<inverse>)).
=end

