# $Id: Version.rb,v 1.1 2001/08/27 11:00:35 matju Exp $

class Array; include Comparable; end if not Array < Comparable

class VersionError < ScriptError
	def initialize(filename,version=nil,caller="requiring file")
		if version then
			super "file #{filename}, version #{version.inspect}, " \
				"is inappropriate according to \"#{caller}\""
		else
			super
		end
	end
end

module Kernel
	alias :require_old :require
	$require_stack = []
	$require_versions = {}
	def require(filename,&proc)
		indent = "  " * $require_stack.length
		printf "%srequire < %s\n", indent, filename if $require_verbose
		$require_stack.push [filename,proc,caller]
		if $require_versions.has_key? filename then
			if proc and not proc.call $require_versions[filename] then
				raise VersionError.new filename,version,me[2]
			end
		end
		require_old(filename)
		$require_stack.pop
		printf "%srequire > %s\n", indent, filename if $require_verbose
	end

	def version_is(*version)
		me = $require_stack[-1]
		if me and me[1] and not me[1].call *version then
			raise VersionError.new me[0],version,me[2]
		end
		if me then
			$require_versions[me[0]] = version
		end
	end
end
