=begin RD

= PDF class
class for generating PDF file.

== Super Class
* Data

== Included Module
* PDF::Constants

== Class Method
--- new([filename])
--- open([filename])
--- open([filename]) { ... }

== Method
=== general
--- close
--- set_info(key, value)
--- set_parameter(key, value)
--- get_parameter(key, value)
--- set_value(key, value)
--- get_value(key, mod)
--- begin_page(width, height)
--- end_page
--- get_buffer

=== font
--- findfont(fontname, encoding, embed)
--- setfont(font, size)
--- get_font
--- get_fontname
--- get_fontsize

=== text
--- show(text, [x, y])
--- continue_text(text)
--- set_text_pos(x, y)
--- stringwidth(text, font, size)
--- set_leading(leading)
--- set_text_rise(rise)
--- set_horiz_scaling(scale)
--- set_text_rendering(mode, clipping)
--- set_text_matrix(a, b, c, d, e, f)
--- set_char_spacing(space)
--- set_word_spacing(space)
--- show_boxed(text, x, y, width, height, mode, reserved)

=== graphic/setting
--- setdash(black, white)
--- setpolydash(dash)
--- setflat(flat)
--- setlinejoin(join)
--- setlinecap(cap)
--- setmiterlimit(limit)
--- setlinewidth(width)
--- set_fillrule(rule)
--- save
--- restore
--- initgraphics
--- translate(x, y)
--- scale(x, y)
--- rotate(phi)
--- skew(alpha, beta)
--- concat(a, b, c, d, e, f)
--- setmatrix(a, b, c, d, e, f)

=== graphic/path
--- moveto(x, y)
--- lineto(x, y)
--- curveto(x1, y1, x2, y2, x3, y3)
--- circle(x, y, r)
--- arc(x, y, r, alpha1, alpha2)
--- arcn(x, y, r, alpha1, alpha2)
--- rect(x, y, width, height)
--- closepath
--- stroke
--- closepath_stroke
--- fill
--- fill_stroke
--- closepath_fill_stroke
--- endpath
--- clip

=== graphic/color
--- setgray_fill(gray)
--- setgray_stroke(gray)
--- setgray(gray)
--- setrgbcolor_fill(red, green, blue)
--- setrgbcolor_stroke(red, green, blue)
--- setrgbcolor(red, green, blue)
--- setcolor(type, color, c1[, c2, c3, c4])
--- makespotcolor(name, len)
--- begin_pattern(width, height, xstep, ystep, type)
--- end_pattern
--- begin_template(width, height)
--- end_template

=== image
--- open_image_file(type, filename, [str_par, int_par])
--- close_image(image)
--- place_image(image, x, y, scale)
--- add_thumbnail(image)
--- open_CCITT(filename, width, height, reverse, k, black)
--- get_image_width(image)
--- get_image_height(image)

=== hyper text and link
--- add_bookmark(text, parent, open)
--- set_transition(type)
--- set_duration(duration)
--- attach_file(llx, lly, urx, ury, fname, description, author, mimetype, icon)
--- add_note(llx, lly, urx, ury, contents, title, icon, open)
--- add_pdflink(llx, lly, urx, ury, fname, page, dest)
--- add_launchlink(llx, lly, urx, ury, fname)
--- add_locallink(llx, lly, urx, ury, page, dest)
--- add_weblink(llx, lly, urx, ury, url)
--- set_border_style(style, width)
--- set_border_color(red, green, blue)
--- set_border_dash(black, white)


= PDF::Constants module
module defining constants related to PDF class.

--- MAJORVERSION
--- MINORVERSION
--- VERSIONSTRING
--- A0_WIDTH
--- A0_HEIGHT
--- A1_WIDTH
--- A1_HEIGHT
--- A2_WIDTH
--- A2_HEIGHT
--- A3_WIDTH
--- A3_HEIGHT
--- A4_WIDTH
--- A4_HEIGHT
--- A5_WIDTH
--- A5_HEIGHT
--- A6_WIDTH
--- A6_HEIGHT
--- B5_WIDTH
--- B5_HEIGHT
--- LETTER_WIDTH
--- LETTER_HEIGHT
--- LEGAL_WIDTH
--- LEGAL_HEIGHT
--- LEDGER_WIDTH
--- LEDGER_HEIGHT
--- P11X17_WIDTH
--- P11X17_HEIGHT

=end
