#!/usr/bin/ruby

require 'rice/irc'
require 'rice/drb'

URI  = 'druby://localhost:9876'
NICK = 'dirb'
USER = ENV['USER'] || ENV['USERNAME'] || ENV['LOGNAME'] || NICK
REAL = 'rice/irb user'

CHANNEL = '#ricetest'

#Thread.abort_on_exception = true

o = RICE::DRb::Server.new(URI, nil, NICK, USER, REAL, nil, CHANNEL)
c = RICE::Connection.new('localhost', 9999)
c.add_observer(o)

def o.response_for_privmsg(subject, message)
  subject.push privmsg message.params[0], message.params[1..-1].join(' ')
end

begin
  c.start
rescue RICE::Connection::Closed
  sleep 30
  retry
end

