#!/usr/bin/ruby

require 'rice/irc'
require 'nkf'

include RICE::Command
include RICE::Reply

NICK = 'irb'
USER = ENV['USER'] || ENV['USERNAME'] || ENV['LOGNAME'] || NICK
REAL = 'rice/irb user'

CHANNEL = '#ricetest'
BYEBYE  = 'byebye > ' + NICK

# Thread.abort_on_exception = true

c = RICE::Connection.new('localhost', 9999)
th = c.regist do |rq, wq|
  wq.push nick ::NICK
  wq.push user ::USER, '0', '*', ::REAL
  while x = rq.pop
    p x
    if x.kind_of?(PING)
      wq.push pong x.params[0]
    elsif x.kind_of?(RPL_WELCOME)
      wq.push join ::CHANNEL
    elsif x.kind_of?(JOIN)
      wq.push privmsg ::CHANNEL, NKF::nkf('-Ej', '줿ʬ')
    elsif x.kind_of?(PRIVMSG)
      msg = x.params[1..-1].join(' ')
      if ::BYEBYE == msg
	wq.push quit
      else
	wq.push privmsg ::CHANNEL, msg
      end
    else
      
    end
  end
end

begin
  c.start
rescue RICE::Connection::Closed
end
