#!/usr/bin/ruby

require 'rice/irc'
require 'rice/observer'
require 'nkf'

NICK = 'irb'
USER = ENV['USER'] || ENV['USERNAME'] || ENV['LOGNAME'] || NICK
REAL = 'rice/irb user'

CHANNEL = '#ricetest'
BYEBYE  = 'byebye > ' + NICK

# Thread.abort_on_exception = true

o = RICE::Observer.new
class << o
  include RICE::Command
  include RICE::Reply

  def uped(subject, message)
    subject.push nick ::NICK
    subject.push user ::USER, '0', '*', ::REAL
  end

  def message(subject, message)
    if message.kind_of?(PING)
      subject.push pong message.params[0]
    elsif message.kind_of?(RPL_WELCOME)
      subject.push join CHANNEL
    elsif message.kind_of?(JOIN)
      subject.push privmsg CHANNEL, NKF::nkf('-Ej', '줿ʬ')
    elsif message.kind_of?(PRIVMSG)
      msg = message.params[1..-1].join(' ')
      if ::BYEBYE == msg
	subject.push quit
      else
	subject.push privmsg ::CHANNEL, msg
      end
    end
  end

  def downed(subject, message)
  end
end

c = RICE::Connection.new('localhost', 9999)
c.add_observer(o)

begin
  c.start
rescue RICE::Connection::Closed
end
