#!/usr/bin/ruby

require 'rice/irc'
require 'rice/observer'
require 'nkf'

NICK = 'irb'
USER = ENV['USER'] || ENV['USERNAME'] || ENV['LOGNAME'] || NICK
REAL = 'rice/irb user'

CHANNEL = '#ricetest'
BYEBYE  = 'byebye > ' + NICK

# Thread.abort_on_exception = true

o = RICE::Observer.new
class << o
  include RICE::Command
  include RICE::Reply

  def uped(subject, message)
    subject.push nick ::NICK
    subject.push user ::USER, '0', '*', ::REAL
  end

  def response_for_ping(subject, message)
    subject.push pong message.params[0]
  end

  def response_for_rpl_welcome(subject, message)
    subject.push join CHANNEL
  end

  def response_for_join(subject, message)
    subject.push privmsg CHANNEL, NKF::nkf('-Ej', '줿ʬ(Observer)')
  end

  def response_for_privmsg(subject, message)
    msg = message.params[1..-1].join(' ')
    if BYEBYE == msg
      subject.push quit
    else
      subject.push privmsg CHANNEL, msg
    end
  end

  def message(subject, message)
  end

  def downed(subject, message)
  end
end

c = RICE::Connection.new('localhost', 9999)
c.add_observer(o)

begin
  c.start
rescue RICE::Connection::Closed
end
