#!/usr/bin/ruby

require 'rice/irc'
require 'rice/observer'

NICK = 'irb'
USER = ENV['USER'] || ENV['USERNAME'] || ENV['LOGNAME'] || NICK
REAL = 'rice/irb user'

CHANNEL = '#ricetest'

Thread.abort_on_exception = true

o = RICE::SimpleClient.new(NICK, USER, REAL, nil, CHANNEL)
c = RICE::Connection.new('localhost', 9999)
c.add_observer(o)

def o.response_for_privmsg(subject, message)
  subject.push privmsg message.params[0], message.params[1..-1].join(' ')
end

c.start {sleep 15; c.delete_observer(o); sleep}

