#
# BuiltInExecutables.rb
#
#   $Author: hiroya $
#   $Date: 2000/11/23 01:53:10 $
#   Copyright (C) 2000 Hiroya KUBO
#

module BuiltInExecutables

  def getBuiltInExecutables
    if(@builtInExecutables == nil)
      @builtInExecutables = {
	'history'=>history,
	'exit'=>exit,
	'resize'=>resize,
	'bindkey'=>bindkey
      }
    end
    return @builtInExecutables
  end

  def history
    return Proc.new{|argv|
      array = @ctx.getEditingHistory
      i = 0
      (array.size-1).times do
	print(sprintf("%7d   ",array.getOffset+1+i ),array[i],"\n")
	i += 1
      end
    }
  end

  def resize
    return Proc.new{|argv|
      cols, rows = @term.resize
      print(sprintf("cols=%d, rows=%d", cols, rows),"\n")
    }
  end

  def bindkey
    return Proc.new{|argv|
      tmp = []
      for n in @keybind.keys
	if(@keybind[n].getKey != nil)

	  tmp.push(sprintf("%s\t -> %s\n",
			   @keybind[n].getKey, @keybind[n].getAction))
	end
      end
      print(tmp.sort,"\n")
    }
  end

  def exit
    return Proc.new{|argv|
      raise ExitCommandLineEditor
    }
  end

end
