#
# KeyBind.rb
#
#   $Author: hiroya $
#   $Date: 2000/11/23 01:53:10 $
#   Copyright (C) 2000 Hiroya KUBO
#

class KeyActionPair
  def initialize(key = '', action = '')
    @key = key
    @action = action
  end

  def setKey(key)
    @key = key
  end

  def getKey
    return @key
  end

  def setAction(action)
    @action = action
  end

  def getAction
    return @action
  end
end

class KeyBindFactory
  def create
    return {
      0  => KeyActionPair.new('C-@', 'set_mark_command'),
	?\C-a  => KeyActionPair.new('C-a','beginning_of_line'),
	?\C-b    => KeyActionPair.new('C-b','backward_char'),
	?\C-c    => KeyActionPair.new('C-c','tty_sigintr'),
	?\C-d    => KeyActionPair.new('C-d','delete_char_or_list_or_eof'),
	?\C-e    => KeyActionPair.new('C-e','end_of_line'),
	?\C-f    => KeyActionPair.new('C-f','forward_char'),
	?\C-g    => KeyActionPair.new('C-g','is_undefined'),
	?\C-h    => KeyActionPair.new('C-h','backward_delete_char'),
	?\C-i    => KeyActionPair.new('C-i','complete_word'),
	?\C-j    => KeyActionPair.new('C-j','newline'),
	?\C-k    => KeyActionPair.new('C-k','kill_line'),
	?\C-l    => KeyActionPair.new('C-l','clear_screen'),
	?\C-m    => KeyActionPair.new('C-m','newline'),
	?\C-n    => KeyActionPair.new('C-n','down_history'),
      # ?\C-o    => KeyActionPair.new('C-o','tty_flush_output'),
	?\C-p    => KeyActionPair.new('C-p','up_history'),
      # ?\C-q    => KeyActionPair.new('C-q','tty_start_output'),
      # ?\C-r    => KeyActionPair.new('C-r','redisplay'),
      # ?\C-s    => KeyActionPair.new('C-s','tty_stop_output'),
      # ?\C-t    => KeyActionPair.new('C-t','transpose_chars'),
	?\C-u    => KeyActionPair.new('C-u','kill_whole_line'),
      # ?\C-v    => KeyActionPair.new('C-v','quoted_insert'),
	?\C-w    => KeyActionPair.new('C-w','kill_region'),
        ?\C-x    => KeyActionPair.new('C-x','sequence_read_in'),
	?\C-y    => KeyActionPair.new('C-y','yank'),
      # ?\C-z    => KeyActionPair.new('C-z','tty_sigstsusp'),
	27       => KeyActionPair.new(nil,'sequence_read_in'),
      #28        => KeyActionPair.new('C-','tty_sigquit'),
      #29        => KeyActionPair.new('C-','tty_dsusp'),
      #31        => KeyActionPair.new('C-','undo'),

	127 => KeyActionPair.new('delete','backward_delete_char'),
	"\ew"  => KeyActionPair.new('M-w','copy_region'),
	"\e["  => KeyActionPair.new(nil, 'sequence_read_in'),
	"\e[A" => KeyActionPair.new('up','up_history'),
	"\e[B" => KeyActionPair.new('down','down_history'),
	"\e[C" => KeyActionPair.new('right','forward_char'),
	"\e[D" => KeyActionPair.new('left','backward_char'),

    }  end

end
