class Format

   Colors = {
      'aqua'    => 0x0F,
      'black'   => 0x08,
      'blue'    => 0x0C,
      'fuchsia' => 0x0E,
      'gray'    => 0x17,
      'grey'    => 0x17,
      'green'   => 0x11,
      'lime'    => 0x0B,
      'navy'    => 0x12,
      'orange'  => 0x1D,
      'purple'  => 0x24,
      'red'     => 0x0A,
      'silver'  => 0x16,
      'white'   => 0x09,
      'yellow'  => 0x0D
   }

   attr_accessor :xf_index

   def initialize(args={},xf_index=0)
      defaults = {}

      defaults.update(:color     => 0x7FFF, :bold   => 0x0190)
      defaults.update(:fg_color  => 0x40, :pattern  => 0,  :size => 10)
      defaults.update(:bg_color  => 0x41, :rotation => 0,  :font => "Arial")
      defaults.update(:underline => 0,    :italic   => 0,  :top  => 0)
      defaults.update(:bottom    => 0,    :right    => 0,  :left => 0)

      defaults.update(:font_index     => 0, :font_family  => 0)
      defaults.update(:font_strikeout => 0, :font_script  => 0)
      defaults.update(:font_outline   => 0, :left_color   => 0)
      defaults.update(:font_charset   => 0, :right_color  => 0)
      defaults.update(:font_shadow    => 0, :top_color    => 0x40)
      defaults.update(:text_v_align   => 2, :bottom_color => 0x40)
      defaults.update(:text_h_align   => 0, :num_format   => 0)
      defaults.update(:text_justlast  => 0, :text_wrap    => 0)

      ########################################################################
      # We must manually create accessors for these so that they can handle
      # both 0/1 and true/false.
      ########################################################################
      no_acc = [:bold,:italic,:underline,:strikeout,:text_wrap,:text_justlast]
      no_acc.push(:color,:font_outline,:font_shadow)

      args.each{|key,val|
         key = key.to_s.downcase.intern
         val = 1 if val == true
         val = 0 if val == false
         defaults.fetch(key)
         defaults.update(key=>val)
      }

      defaults.each{|key,val|
         unless no_acc.member?(key)
            type.send(:attr_accessor,"#{key}")
         end
         send("#{key}=",val)
      }

      @xf_index = xf_index

      yield self if block_given?
   end

   def color=(color=0x7FFF)
      if Colors.has_key?(color)
         @color = Colors[color]
      else
         @color = 0x7FFF
      end
      @color
   end

   def color
      #Colors.invert.fetch(@color)
      @color
   end

   def italic
      return true if @italic >= 1
      return false
   end

   def italic=(val)
      val = 1 if val == true
      val = 0 if val == false
      @italic = val
   end

   def font_shadow
      return true if @font_shadow == 1
      return false
   end

   def font_shadow=(val)
      val = 1 if val == true
      val = 0 if val == false
      @font_shadow = val
   end

   def font_outline
      return true if @font_outline == 1
      return false
   end

   def font_outline=(val)
      val = 1 if val == true
      val = 0 if val == false
      @font_outline = val
   end

   def text_justlast
      return true if @text_justlast == 1
      return false
   end

   def text_justlast=(val)
      val = 1 if val == true
      val = 0 if val == false
      @text_justlast = val
   end

   def text_wrap
      return true if @text_wrap == 1
      return false
   end

   def text_wrap=(val)
      val = 1 if val == true
      val = 0 if val == false
      @text_wrap = val
   end

   def strikeout
      return true if @strikeout == 1
      return false
   end

   def strikeout=(val)
      val = 1 if val == true
      val = 0 if val == false
      @strikeout = val
   end

   def underline
      return true if @underline == 1
      return false
   end

   def underline=(val)
      val = 1 if val == true
      val = 0 if val == false
      @underline = val
   end


   def xf_biff(style=0)
      atr_num = 0
      atr_num = 1 if @num_format != 0

      atr_fnt = 0
      atr_fnt = 1 if @font_index != 0

      atr_alc = @text_wrap
      atr_bdr = [@bottom,@top,@left,@right].find{ |n| n > 0 } || 0
      atr_pat = [@fg_color,@bg_color,@pattern].find{ |n| n > 0 } || 0

      atr_prot    = 0

      @bottom_color = 0 if @bottom == 0
      @top_color    = 0 if @top    == 0
      @right_color  = 0 if @right  == 0
      @left_color   = 0 if @left   == 0

      record         = 0x00E0
      length         = 0x0010

      align  = @text_h_align
      align  |= @text_wrap     << 3
      align  |= @text_v_align  << 4
      align  |= @text_justlast << 7
      align  |= @rotation      << 8
      align  |= atr_num        << 10
      align  |= atr_fnt        << 11
      align  |= atr_alc        << 12
      align  |= atr_bdr        << 13
      align  |= atr_pat        << 14
      align  |= atr_prot       << 15

      icv   = @fg_color
      icv  |= @bg_color << 7

      fill = @pattern
      fill |= @bottom << 6
      fill |= @bottom_color << 9

      border1 = @top
      border1 |= @left      << 3
      border1 |= @right     << 6
      border1 |= @top_color << 9

      border2 = @left_color
      border2 |= @right_color << 7

      header = [record,length].pack("vv")
      fields = [@font_index,@num_format,style,align,icv,fill,border1,border2]
      data = fields.pack("vvvvvvvv")

      rv = header + data
      return rv
   end

   def font_biff
      dyheight = @size * 20
      cch      = @font.length
      record   = 0x31
      length   = 0x0F + cch
      reserved = 0x00

      grbit = 0x00
      grbit |= 0x02 if @italic > 0
      grbit |= 0x08 if @font_strikeout > 0
      grbit |= 0x10 if @font_outline > 0
      grbit |= 0x20 if @font_shadow > 0

      header = [record,length].pack("vv")
      fields = [dyheight,grbit,@color,@bold,@font_script,@underline,@font_family]
      fields.push(@font_charset,reserved,cch)

      data = fields.pack("vvvvvCCCCC")
      rv = header + data + @font

      return rv
   end

   def font_key
      key = @font.to_s + @size.to_s + @font_script.to_s + @underline.to_s
      key += @font_strikeout.to_s + @bold.to_s + @font_outline.to_s
      key += @font_family.to_s + @font_charset.to_s + @font_shadow.to_s
      key += @color.to_s + @italic.to_s
      return key
   end


   def align=(location=nil)
      return if location.nil?
      return if location.kind_of?(Fixnum)
      location.downcase!

      @text_h_align = 1 if location == 'left'
      @text_h_align = 2 if location == 'centre'
      @text_h_align = 2 if location == 'center'
      @text_h_align = 3 if location == 'right'
      @text_h_align = 4 if location == 'fill'
      @text_h_align = 5 if location == 'justify'
      @text_h_align = 6 if location == 'merge'
      @text_v_align = 0 if location == 'top'
      @text_v_align = 1 if location == 'vcentre'
      @text_v_align = 1 if location == 'vcenter'
      @text_v_align = 2 if location == 'bottom'
      @text_v_align = 3 if location == 'vjustify'
   end

   def align
      [@text_h_align,@text_v_align]
   end

   def bold=(weight=nil)
      weight = 1 if weight == true
      weight = 0 if weight == false
      weight = 0x2BC if weight.nil?
      weight = 0x2BC if weight == 1
      weight = 0x190 if weight == 0
      weight = 0x190 if weight < 0x064
      weight = 0x190 if weight > 0x3E8
      @bold = weight
      @bold
   end

   def bold
      return true if @bold >= 1
      return false
   end

   def border=(style)
      [@bottom,@top,@right,@left].each{ |attr| attr = style }
   end

   def border
      [@bottom,@top,@right,@left]
   end

   def border_color=(color)
      [@bottom_color,@top_color,@left_color,@right_color].each{ |a| a = color }
   end

   def border_color
      [@bottom_color,@top_color,@left_color,@right_color]
   end

end

=begin
= class Format
   Formats contain format information which is applied to a cell, or group of
   of cells, in an Excel object.
== Instance Methods
   Each of the write attributes listed below has a corresponding read
   attribute.  The assignment is in parentheses merely to show you the
   default value for that attribute.  Do not use parentheses in the actual
   assignment.

--- Format#align=(value = "off")
    Sets the horizontal and vertical alignment within a cell.  Vertical and
    horizontal alignments can be combined.  Valid arguments are:

    Horizontal: left, right, fill, justify, merge
    Vertical: top, vcenter, bottom, vjustify

    Text can be aligned across two or more adjacent cells using the merge
    property.

    The vjustify (vertical justify) option can be used to provide automatic
    text wrapping in a cell. The height of the cell will be adjusted to
    accommodate the wrapped text. To specify where the text wraps use the
    ((<text_wrap|Format#text_wrap=>)) method.
--- Format#bg_color=(value = "off")
    Sets the background color of a pattern.  Patterns are defined via the
    ((<pattern|Format#pattern=>)) method. If a pattern hasn't been defined
    then a solid fill pattern is used as the default.
--- Format#bold=(weight = 1)
    Sets the bold property of the font.values in the range 100..1000 are also
    valid. 400 is normal, 700 is bold and 1000 is very bold.

    You can also specify true or false, which sets the value to 1 and 0,
    respectively.
--- Format#border=(integer = 0)
    Sets the border for a given cell.  A cell border is comprised of a border
    on the bottom, top, left and right.

    Valid arguments are as follows:
    0 - No border
    1 - Thin single border
    2 - Medium single border
    3 - Dashed border
    4 - Dotted border
    5 - Thick single border
    6 - Double line border
    7 - Hair border

    Also see the ((<top|Format#top=>)), ((<bottom|Format#bottom=>)),
    ((<left|Format#left=>)), and ((<right|Format#right=>)) methods.
--- Format#border_color=(value = "black")
    Sets the color of the cell borders. Valid values are the same as for the
    ((<color|Format#color=>)) method.

    Also see the ((<bottom_color|Format#bottom_color=>)),
    ((<top_color|Format#top_color=>)), ((<left_color|Format#left_color=>)),
    and ((<right_color|Format#right_color=>)) methods.
--- Format#bottom=(integer = 0)
    Sets the bottom border of the cell.  Valid arguments are the same as for the
    ((<border|Format#border=>)) method.
--- Format#bottom_color=(value = "black")
    Sets the bottom cell border color.  Valid values are the same as for the
    ((<color|Format#color=>)) method.
--- Format#color=(value = "black")
    Sets the font color of text within a cell (not the cell itself).  Any
    integer from 8..63 is valid.  The following strings are also recognized:

    black, blue, brown, cyan, gray, green, lime, magenta, navy, orange, purple,
    red, silver, white, yellow
--- Format#fg_color=(value = "off")
    Sets the foreground color of a pattern.
--- Format#font=(name = "Arial")
    Sets the font used.  Excel can only display fonts that are installed on
    the system that it is running on. Therefore it is best to use the fonts
    that come as standard such as 'Arial', 'Times New Roman' and 'Courier New'.
--- Format#font_shadow=(value = 0)
    Macintosh only.  0/1 or false/true may be used.
--- Format#italic=(value = 0)
    Sets the italic property of the font.  

    You can also specify true or false, which sets the value to 1 and 0,
    respectively.
--- Format#left=(integer = 0)
    Sets the left border of the cell.  Valid arguments are the same as for the
    ((<border|Format#border=>)) method.
--- Format#left_color=(value = "black")
    Sets the left cell border color.  Valid values are the same as for the
    ((<color|Format#color=>)) method.
--- Format#num_format=(value = 1)
    This method is used to define the numerical format of a number in Excel.
    It controls whether a number is displayed as an integer, a floating point
    number, a date, a currency value or some other user defined format. 

    The numerical format of a cell can be specified by using a format string
    or an index to one of Excel's built-in formats, e.g.

     format1 = Format.new(:num_format => "d mmm yyyy")
     format2 = Format.new(:num_format => 0x0f)
     workbook.addformat(format1)
     workbook.addformat(format2)

     worksheet.write(0,0,36892.521,format1) -> 1 Jan 2001
     worksheet.write(0,0,36892.521,format2) -> 1-Jan-01

    Using format strings you can define very sophisticated formatting of numbers
    (assume each of these is separate and has been added to a workbook).

     format.num_format = '0.000'
     worksheet.write(0,0,3.1415926,format) -> 3.142

     format.num_format = '#,##0'
     worksheet.write(1,0,1234.56,format)   -> 1,235

     format.num_format = '#,##0.00'
     worksheet.write(2,0,1234.56,format)   -> 1,234.56

     format.num_format = '0.00'
     worksheet.write(3,0,49.99,format)     -> 49.99

     format.num_format = '0.00'
     worksheet.write(4,0,49.99,format)     -> 49.99

     format.num_format = '0.00'
     worksheet.write(5,0,49.99,format)     -> 49.99

     format.num_format = 'mm/dd/yy'
     worksheet.write(6,0,36892.521,format) -> 01/01/01

     format.num_format = 'mmm d yyyy'
     worksheet.write(7,0,36892.521,format) -> Jan 1 2001

     format.num_format = 'd mmmm yyyy'
     worksheet.write(8,0,36892.521,format) -> 1 January 2001

     format.num_format = 'dd/mm/yyyy hh:mm AM/PM'
     worksheet.write(9,0,36892.521,format) -> 01/01/2001 12:30 AM

     format.num_format = '0 "dollar and" .00 "cents"'
     worksheet.write(10,0,1.87,format)     -> 1 dollar and .87 cents

     # Conditional formatting
     format.num_format = '[Green]General;[Red]-General;General'
     worksheet.write(11,0,123,format) -> > 0 Green
     worksheet.write(12,0,-45,format) -> < 0 Red
     worksheet.write(13,0, 0, format) -> = 0 Default colour

     # Zip code
     format.num_format = '00000'
     worksheet.write(14,0,'01209',format)
--- Format#outline=(value = 0)
    Sets outline property.  Macintosh only.  Accepts 1/0 or true/false,
    respectively.
--- Format#pattern=(integer = 0)
    Sets the background pattern.  Valid arguments are 0..18.
--- Format#right=(integer = 0)
    Sets the right border of the cell.  Valid arguments are the same as for the
    ((<border|Format#border=>)) method.
--- Format#right_color=(value = "black")
    Sets the right cell border color.  Valid values are the same as for the
    ((<color|Format#color=>)) method.
--- Format#rotation=(integer = 0)
    Sets the rotation of the text in the cell. Valid arguments are:

    0 - No rotation
    1 - Top to bottom
    2 - 90 degrees counter-clockwise
    3 - 90 degrees clockwise

    Note that fractional rotation is not possible in the Excel 95 format.
--- Format#script=(integer = 0)
    Sets the subscript/superscript property of the font.

    Valid arguments:
       0 = Normal
       1 = Superscript
       2 = Subscript
--- Format#shadow=(value = 0)
    Sets the shadow property of the font.  Macintosh only.  Accepts 1/0 or
    true/false, respectively.
--- Format#size=(size = 10)
    Set the font size. Excel adjusts the height of a row to accommodate the
    largest font size in the row.
--- Format#text_justlast=(value = 0)
    Only applies to Far Eastern versions of Excel.  0/1 or false/true may be
    used here.
--- Format#text_wrap=(value = 0)
    Turn text wrap on.  Excel will adjust the height of the row to accommodate
    the wrapped text. A similar effect can be obtained without newlines using
    the ((<align='vjustify'|Format#align=>)) method.

    Accepts 1/0 or true/false as valid values.
--- Format#top=(integer = 0)
    Sets the top border of the cell.  Valid arguments are the same as for the
    ((<border|Format#border>)) method.
--- Format#top_color=(value = "black")
    Sets the top cell border color.  Valid values are the same as for the
    ((<color|Format#color=>)) method.
--- Format#underline=(value = 0)
    Sets the underline property of the font.

     Valid arguments:
     0/false - No underline
     1/true  - Single underline
     2       - Double underline
     33      - Single accounting underline
     34      - Double accounting underline
--- Format#strikeout=(value = 0)
    Sets the strikeout property 
=end
