#!/usr/local/bin/ruby

require 'runit/testsuite'
require 'runit/cui/testrunner'

module TEST_RUNNABLE
  def load_test(test)
      require test
  end
  def suite
    RUNIT::TestCase.all_suite
  end
end

class CUI_RUNTEST
  include TEST_RUNNABLE
  def initialize
    RUNIT::CUI::TestRunner.quiet_mode = true
    @runner = RUNIT::CUI::TestRunner.new
  end

  def run
    @runner.run(suite)
  end
end

if $0 == __FILE__
  if ARGV.size > 0
    runtest = CUI_RUNTEST.new
    ARGV.each do |f|
      runtest.load_test(f)
    end
    runtest.run
  else
    puts "#{File.basename($0)} testfile1 [, testfile2, ...]"
  end
end

