// Copyright (c) 1999-2000 David Muse
// See the COPYING file for more information.

#ifndef DAEMONPROCESS_H
#define DAEMONPROCESS_H

#include <sys/types.h>
#include <rudiments/signalclasses.h>

// Daemons are long running processes which often detach themselves from
// the controlling terminal and run in the background.  They are frequently
// started at boot time and run until the machine is shut down.
//
// Daemons typically perform "housecleaning" tasks or serve data to client
// programs.  See the server class.

class daemonprocess {
	public:
				daemonprocess();
			virtual	~daemonprocess();

			int	checkForPidFile(char *filename);
				// Checks for filename "filename" and reads the
				// process id out of it, if it exists.  Returns
				// the process id on success or 0 on failure.
			void	createPidFile(char *filename);
				// Create's file "filename" and puts the current
				// process id in it.  Note that when you delete
				// this file during shutdown you must use the 
				// full pathname since the detach() method 
				// below changes directories to "/".

			void	detach();
				// Detach from the controlling terminal and
				// process and run in the background.  Also
				// change directories to "/" and set the file
				// creation mask such that all files are 
				// created -rw-rw-rw and all directories 
				// drwxrwxrwx.

			// These methods allow the daemon to run as a different
			// user or group than the one that started the process.
			// They have no effect unless the process is started
			// by the root user.
			int	runAsUser(char *username);
			int	runAsGroup(char *groupname);
			int	runAsUserId(uid_t uid);
			int	runAsGroupId(gid_t gid);

		static	void	handleShutDown(void *shutdownfunction);
				// This method allows you to designate a
				// function to run when the daemon is killed.

	private:
		#include <rudiments/private/daemonprocess.h>

};

#endif
