// Copyright (c) 1999-2000 David Muse
// See the COPYING file for more information.

#ifndef SERVERPOOL_H
#define SERVERPOOL_H

#include <rudiments/serversocket.h>

// The server class manages a pool of sockets.

#include <rudiments/private/socketnode.h>

class serversocketpool {
	public:
			serversocketpool();
		virtual	~serversocketpool();

		void	addSocket(serversocket *sock);
			// Adds the specified server to the pool of 
			// sockets that the server is listening on.

		int	waitForClientConnection(int timeoutsec, 
						int timeoutusec,
						serversocket **whichsock,
						genericsocket **clientsock);
				// Waits for client connections on any of the
				// sockets in the pool for "timeoutsec" seconds
				// and "timeoutusec" milliseconds before 
				// falling through.  
				//
				// Entering -1 for either parameter causes the 
				// method to wait indefinitely.  
				//
				// Entering 0 for both parameters causes the 
				// method to fall through immediately unless a
				// client is already trying to connect.
				//
				// When a client connects, "whichsock" is set
				// to the socket in the pool that the client
				// connected to and "clientsock" is set to the 
				// socket that can be used to communicate with 
				// the client.
				//
				// Note that "clientsock" must be deleted after
				// it's been used.
				//
				// Returns 1 on success, 0 on timeout and -1
				// on error.

		int	removeSocket(serversocket *sock);
			// Removes the specified socket from the pool.

		void	removeAllSockets();
			// Removes every socket from the pool.

	protected:
		#include <rudiments/private/serversocketpool.h>

};

#endif
