// Copyright (c) 2000 David Muse
// See the COPYING file for more information.

#ifndef DATETIME_H
#define DATETIME_H
#include <time.h>

// The datetime class provides methods for converting date/time formats and
// accessing various date/time values.

class datetime {
	public:
			datetime();
				// current time
			datetime(char *datestring);
				// datestring must be "mm/dd/yyyy hh:mm:ss"
			datetime(time_t *epoch);
				// *epoch is the number of seconds since 1970,
				// output by many standard time functions
			datetime(tm *timestruct);
				// *timestruct is a (struct tm *), output by 
				// many standard time functions
			~datetime();

		// These methods return commonly needed time/date values
		int	getHour();
		int	getMinutes();
		int	getSeconds();
		int	getMonth();
		int	getDayOfMonth();
		int	getDayOfWeek();
		int	getDayOfYear();
		int	getYear();

		int	isDaylightSavingsTime();
			// returns 1 if daylight savings time is currently
			// in effect and 0 if it isn't

		char	*getTimeZone();
			// returns a 3 character string representing the
			// time zone

		long	getTimeZoneOffset();
			// returns (in seconds) the offset from GMT


		// These methods output conversions to other date/time
		// formats.
		char	*getString();
			// returns "mm/dd/yyyy hh:mm:ss"
		time_t	getEpoch();
			// returns the number of seconds since 1970
		tm	*getTm();
			// returns a pointer to the internal "struct tm"

	private:
		#include <rudiments/private/datetime.h>
};

#endif
