// Copyright (c) 1999-2000 David Muse
// See the COPYING file for more information.

#ifndef TEXT_H
#define TEXT_H

// The text class provides methods for performing commonly needed transforms
// on strings of text.

class text {
	public:
		static	void	upper(char *string); 
				// converts "string" to uppercase
		static	void	lower(char *string); 
				// converts "string" to lowercase

		static	void	rightTrim(char *string);
				// trims all spaces off of the right hand
				// side of "string"
		static	void	rightTrim(char *string, char character);
				// trims all characters off of the right hand
				// side of "string"

		static	void	leftTrim(char *string);
				// trims all spaces off of the left hand
				// side of "string"
		static	void	leftTrim(char *string, char character);
				// trims all characters off of the left hand
				// side of "string"

		static	void	bothTrim(char *string);
				// trims all spaces off of both 
				// sides of "string"
		static	void	bothTrim(char *string, char character);
				// trims all characters off of both 
				// sides of "string"

		static	void	strip(char *string, char character);
				// strips all instances of "character"
				// from "string"

		static	void	strip(char *string1, char *string2);
				// strips all instances of "string2"
				// from "string1"

		static	int	isInteger(char *val);
				// returns 1 the string "val" is an integer
				// and 0 if it is not an integer

		static	int	isNumber(char *val);
				// returns 1 the string "val" is a number
				// and 0 if it is not a number

		static	char	*httpEscape(char *input);
				// http escapes "input" and returns it in a
				// buffer allocated inside the function.
				// This buffer must be deleted by the calling
				// program.
};

#endif
