/* 
 * An example include file showing the use of ScanDoc tags
 */

/**
 * @author  James Dean Palmer
 * @package ScanDoc
 * @version 1.0.0
 */

#ifndef _FL_SCANDOC_WIDGET_H_
#define _FL_SCANDOC_WIDGET_H_

class Fl_ScanDoc_Widget;

/**
 * This is a hypothetical widget class for ScanDoc that tests various ScanDoc
 * features.
 */
class Fl_ScanDoc_Widget : Fl_Widget {
  
 public:
  
  /** 
   * The ScanDoc widget constructor.
   * @param x The x coordinate for this widget.
   * @param y The y coordinate for this widget.
   * @param w The width for this widget.
   * @param h The height for this widget.
   * @param l The label for this widget.
   */
  Fl_ScanDoc_Widget (int x, int y, int w, int h, char *l) :  Fl_Widget (x, y, w, h, l) {
  }
  
  /**
   * Get the value associated with this widget.
   * @return The value of this widget, or -1 if no value has been set.
   */
  int value ();

  /**
   * Set the value associated with this widget.
   * @param v The value that should be associated with this widget.
   */
  void value (int v);

  
  /**
   * True if values should be normalized.
   */
  static const bool normalize;

  /**
   * Total value assignments made.
   */
  static int value_assignments = 0;

   /**
    * pointer to some function in a class.
    */
   int (*function) (int i, int k, int j);
   
  /**
   * A "tip" that should be associated with this widget.
   */
  char* tip;
};

/**
 * A factory function to generate ScanDoc widgets.
 * @return The last Fl_ScanDoc_Widget generated by the factory.
 */
Fl_ScanDoc_Widget* scandoc_factory ();

extern "C" {

struct myStruct {
   
   /**
    * pointer to some function within a struct.
    */
   int (*function) (int i, int k, int j);
};
   
/**
 * This class was not defnied yet..
 * @heading Big Topic...
 * and continue..
 */
void MyFunc(int x) {
  
}

}

#endif
