//
// This file is part of the SDTS++ toolkit, written by the U.S.
// Geological Survey.  It is experimental software, written to support
// USGS research and cartographic data production.
// 
// SDTS++ is public domain software.  It may be freely copied,
// distributed, and modified.  The USGS welcomes user feedback, but makes
// no committment to any level of support for this code.  See the SDTS
// web site at http://mcmcweb.er.usgs.gov/sdts for more information,
// including points of contact.
//

#ifndef INCLUDED_SB_IDEN_H
#define INCLUDED_SB_IDEN_H

// $Id: sb_Iden.h,v 1.8 2000/12/04 21:02:33 mcoletti Exp $

#include <string>

#ifndef SB_MODULE_H
#include <sdts++/builder/sb_Module.h>
#endif


#ifndef INCLUDED_SIO8211FIELDFORMAT_H
#include <sdts++/io/sio_8211FieldFormat.h>
#endif


//class  sb_ForeignID;
struct sb_Iden_Imp;
class  sc_Record;


/**
 This class provides a convenient access to IDEN records.  It provides
 members to access or set various module field and subfield values.
 It also provides a mechanism for populating an object of this class with
 values found in a valid sc_Record of this module, and for filling a
 sc_Record with the contents of a sb_Iden object.
*/
class sb_Iden : public sb_Module
{
   public:

      sb_Iden();
      
      ~sb_Iden();

      sb_Iden(sc_Record const & recprox);

      /**
       Use these members to get subfield/field values.  Pass in an appropriate
       type to receive the value.  These members will return false if the 
       corresponding value is not set.  (It may not be set because a value 
       was not assigned to it, or because you previously tried to assign 
       an invalid value.)  Otherwise they will return true.
      */
      bool getStandardIdentification( string& str ) const;
      bool getSTID( string& str ) const { return getStandardIdentification( str ); }

      bool getStandardVersion( string& str ) const;
      bool getSTVS( string& str ) const { return getStandardVersion( str ); }

      bool getStandardDocumentationReference( string& str ) const;
      bool getDOCU( string& str ) const
      { return getStandardDocumentationReference( str ); }

      bool getProfileIdentification( string& str ) const;
      bool getPRID( string& str ) const { return getProfileIdentification( str ); }

      bool getProfileVersion( string& str ) const;
      bool getPRVS( string& str ) const { return getProfileVersion( str ); }

      bool getProfileDocumentationReference( string& str ) const;
      bool getPDOC( string& str ) const 
      { return getProfileDocumentationReference( str ); }

      bool getTitle( string& str ) const;
      bool getTITL( string& str ) const { return getTitle( str ); }

      bool getDataID( string& str ) const;
      bool getDAID( string& str ) const { return getDataID( str ); }

      bool getDataStructure( string& str ) const;
      bool getDAST( string& str ) const { return getDataStructure( str ); }

      bool getMapDate( string& str ) const;
      bool getMPDT( string& str ) const { return getMapDate( str ); }

      bool getDataSetCreationDate( string& str ) const;
      bool getDCDT( string& str ) const { return getDataSetCreationDate( str ); }

      bool getScale( long& val ) const;
      bool getSCAL( long& val ) const { return getScale( val ); }

      bool getComment( string& str ) const;
      bool getCOMT( string& str ) const { return getComment( str ); }


      //  Conformance field 

      bool getComposites( string& str ) const;
      bool getFFYN( string& str ) const { return getComposites( str ); }

      bool getVectorGeometry( string& str ) const;
      bool getVGYN( string& str ) const { return getVectorGeometry( str ); }

      bool getVectorTopology( string& str ) const;
      bool getGTYN( string& str ) const { return getVectorTopology( str ); }

      bool getRaster( string& str ) const;
      bool getRCYN( string& str ) const { return getRaster( str ); }

      bool getExternalSpatialReference( long& val ) const;
      bool getEXSP( long& val ) const { return getExternalSpatialReference( val ); }

      bool getFeaturesLevel( long& val ) const;
      bool getFTLV( long& val ) const { return getFeaturesLevel( val ); }

      bool getCodingLevel( long& val ) const;
      bool getCDLV( long& val ) const { return getCodingLevel( val ); }

      bool getNonGeoSpatialDimensions( string& str ) const;
      bool getNGDM( string& str ) const
      { return getNonGeoSpatialDimensions( str ); }
  

      // Attribute

#ifdef NOT_IMPLEMENTED
      bool getAttributeID( sb_ForeignID& fid ) const;
      bool getATID( sb_ForeignID& fid ) const { return getAttributeID( fid ); }
#endif

      /**
       fill the given record based on the builder's object field/subfield
       values -- return false if in a wedged state. (E.g., a mandatory
       field isn't set or was assigned a value outside it's proper
       domain.
      */
      bool getRecord( sc_Record& record ) const;


      /**
       Use these members to set subfield/field values.  Pass in an appropriate
       value for the particular subfield/field to be set to.  They will return
       false if you try to assign a value outside the domain of the given 
       subfield/field.  (Note that this is not too pedantic; for example, we
       do not check to see if a conditionally mandatory or optional field has
       been set.)
      */
      void setStandardIdentification( string const & );
      void setSTID( string const & str ) { setStandardIdentification( str ); }

      void setStandardVersion( string const & );
      void setSTVS( string const & str ) {  setStandardVersion( str ); }

      void setStandardDocumentationReference( string const & );
      void setDOCU( string const & str ) {  setStandardDocumentationReference( str ); }

      void setProfileIdentification( string const & );
      void setPRID( string const & str ) {  setProfileIdentification( str ); }

      void setProfileVersion( string const & );
      void setPRVS( string const & str ) {  setProfileVersion( str ); }

      void setProfileDocumentationReference( string const & );
      void setPDOC( string const & str ) {  setProfileDocumentationReference( str ); }

      void setTitle( string const & );
      void setTITL( string const & str ) {  setTitle( str ); }

      void setDataID( string const & );
      void setDAID( string const & str ) {  setDataID( str ); }

      void setDataStructure( string const & );
      void setDAST( string const & str ) {  setDataStructure( str ); }

      void setMapDate( string const & );
      void setMPDT( string const & str ) {  setMapDate( str ); }

      void setDataSetCreationDate( string const & );
      void setDCDT( string const & str ) {  setDataSetCreationDate( str ); }

      void setScale( long );
      void setSCAL( long val ) {  setScale( val ); }

      void setComment( string const & );
      void setCOMT( string const & str ) {  setComment( str ); }


      // Conformance Field

      void setComposites( string const & );
      void setFFYN( string const & str ) {  setComposites( str ); }

      void setVectorGeometry( string const & );
      void setVGYN( string const & str ) {  setVectorGeometry( str ); }

      void setVectorTopology( string const & );
      void setGTYN( string const & str ) {  setVectorTopology( str ); }

      void setRaster( string const & );
      void setRCYN( string const & str ) {  setRaster( str ); }

      void setExternalSpatialReference( long );
      void setEXSP( long val ) {  setExternalSpatialReference( val ); }

      void setFeaturesLevel( long );
      void setFTLV( long val ) {  setFeaturesLevel( val ); }

      void setCodingLevel( long );
      void setCDLV( long val ) {  setCodingLevel( val ); }

      void setNonGeoSpatialDimensions( string const & );
      void setNGDM( string const & str ) {  setNonGeoSpatialDimensions( str ); }

      
#ifdef NOT_IMPLEMENTED
      void setAttributeID( sb_ForeignID const & );
      void setATID( sb_ForeignID const & fid ) {  setAttributeID( fid ); }
#endif


      /**
       set the object with values found in the record; if not a valid
       IDEN record, this will return false
      */
      bool setRecord( sc_Record const& record );


   private:

      /// returns reference to schema
      virtual sio_8211Schema& schema_();

      ///
      virtual void buildSpecificSchema_();


      /// NOT NEEDED
      sb_Iden( sb_Iden const & );

      /// hidden opaque data type containing internals
      sb_Iden_Imp*  imp_;

}; // sb_Iden



#endif
