#!/bin/sh
# the next line restarts using wish \
exec wishstep8.0 "$0" "$@"

package require Img

set dtLib "/usr/X11R6/JDE/SeizeDesktop"
set dtDef "~/GNUstep/Defaults"

set button -1

set fgColor #000000
set bgColor #c0c0c0
set rootSolid #505075
set rootBG {}
set lang ja
set stopped 1
set seconds 0
set setTime 10
set preVTime 5
set JackMode random
set JackLock 0

source $dtLib/menu/menu.$lang
source $dtLib/modules/PrefDesktop.m
source $dtLib/modules/TabNote.m

proc desktop_tick {} {
	global setTime seconds stopped

	if $stopped return
	after 1000 desktop_tick
	incr seconds

	if {$setTime == $seconds} {
		desktop_JackSpace_exec
	}
}

proc desktop_JackSpace_exec {} {
	global JackMode JackLock

	if {$JackLock=="0"} {
		exec xlock -nolock -mode $JackMode
	} else {
		exec xlock -mode $JackMode
	}
}

proc desktop_exit {} {
	exit
}

proc desktop_rePref {} {
	global dtLib dtDef
	global rootSolid rootBG fgColor bgColor lang

	source $dtDef/SeizeDesktop
	source $dtLib/menu/menu.$lang

	.c configure -bg $rootSolid
	if {$rootBG!={}} {
		desktop_wallPaper .c $rootBG
	}

	.c itemconfigure Jack -fill $rootSolid -width 0.0 \
		-outline $rootSolid -stipple @$dtLib/modules/filler
}

proc desktop_preference {} {
	global button

	desktop_Preference

	if {$button==0} {desktop_rePref}

	set button -1
	return
}

proc desktop_drop {c dName trig} {

	if {$trig=="2"} {

		switch [file extension $dName] {
			".tif" {desktop_wallPaper .c $dName}
			".jpg" {desktop_wallPaper .c $dName}
			".JPG" {desktop_wallPaper .c $dName}
			".jpeg" {desktop_wallPaper .c $dName}
			".gif" {desktop_wallPaper .c $dName}
			".xbm" {desktop_wallPaper .c $dName}
			".xpm" {desktop_wallPaper .c $dName}
			".bmp" {desktop_wallPaper .c $dName}
			".png" {desktop_wallPaper .c $dName}
		}
	}
}

proc desktop_bgErace {} {
	global rootBG

	.c delete BG
	set rootBG {}
}

proc desktop_wallPaper {c fName} {
	global cX cY rootBG

	if {![file exists $fName]} {
		return
	}

	if {[winfo exists bg]} {destroy bg}
	image create photo bg -file $fName
	set rootBG $fName

	set bgW [image width bg];set bgH [image height bg]

	for {set y 0} {$y<[expr $cY/$bgH+1]} {incr y} {
		for {set x 0} {$x<[expr $cX/$bgW+1]} {incr x} {
			$c create image [expr $x*$bgW] [expr $y*$bgH] \
				-image bg -anchor nw -tag BG
		}
	}

	pref_save tl

	$c raise Jack
}

proc desktop_updateLower {} {
	lower .
	after 1000 desktop_updateLower
}

if {![file exists $dtDef/SeizeDesktop]} {
	file copy -force -- $dtLib/default/SeizeDesktop $dtDef/SeizeDesktop
}

source $dtDef/SeizeDesktop

set cX [winfo screenwidth .]
set cY [winfo screenheight .]
set cX2 [expr $cX-100]
set cY2 [expr $cY-100]

wm group . .
wm overrideredirect . true
wm geometry . [format "%dx%d" $cX $cY]

pack [canvas .c -width $cX -height $cY -bg $rootSolid]

.c create polygon 0 0 0 100 100 100 100 0 -tag Jack
.c create polygon $cX2 0 $cX2 100 $cX 100 $cX 0 -tag Jack
.c create polygon 0 $cY2 0 $cY 100 $cY 100 $cY2 -tag Jack
.c create polygon $cX2 $cY2 $cX2 $cY $cX $cY $cX $cY2 -tag Jack

.c itemconfigure Jack -fill $rootSolid\
	-stipple @$dtLib/modules/filler

if {$rootBG!={}} {
	desktop_wallPaper .c $rootBG
}

bind . <Any-ButtonPress-3> "tk_popup .menu %X %Y"
bind . <Drop> "desktop_drop .c %D %b"
.c bind Jack <Any-Enter> "set stopped 0;desktop_tick"
.c bind Jack <Any-Leave> "set stopped 1;set seconds 0"

desktop_updateLower

