#ifdef __cplusplus
extern "C" {
#endif

#ifdef __cplusplus
}
#endif
#include "install.h"
#ifdef __cplusplus
extern "C" {
#endif




void* se_malloc(size_t size) {
  void *result = malloc(size);
  if (result == NULL) {
#ifdef SE_EXCEPTIONS
    internal_exception_handler(No_more_memory);
#elif !defined(SE_BOOST)
    error0("No more memory.", NULL);
#else
  fprintf(SE_ERR,"No more memory.\n");
  se_print_run_time_stack();
  exit(EXIT_FAILURE);
#endif
  }
  return result;
}


void* se_calloc(size_t nmemb, size_t size) {
  void *result = calloc(nmemb,size);
  if (result == NULL) {
#ifdef SE_EXCEPTIONS
    internal_exception_handler(No_more_memory);
#elif !defined(SE_BOOST)
    error0("No more memory.", NULL);
#else
  fprintf(SE_ERR,"No more memory.\n");
  se_print_run_time_stack();
  exit(EXIT_FAILURE);
#endif
  }
  return result;
}

int se_cmpT35(T35 o1,T35 o2){
return memcmp(&o1,&o2,sizeof(o1));}
T43 M43=0;
T45 M45=0;
T26 M26={0,0,0,NULL,0,0,0,0};
T50 M50={NULL,NULL};
T12 M12={0,0,0,0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,{NULL,NULL},NULL};
T32 M32=0;
T47 M47={NULL,0,0};
T31 M31={0};
T36 M36={NULL,0,0,0,NULL,NULL,0,0,0,0};
T34 M34={NULL,NULL,NULL,0,{NULL,NULL},NULL};
T7 M7={NULL,0,0};
T35 M35={NULL,NULL};
T55 M55=NULL;
T44 M44={NULL,0,{NULL,NULL},NULL};
T41 M41={NULL,0,0,0};
T48 M48={NULL,NULL,0,0,NULL};
T29 M29={0,NULL,0};
T33 M33=NULL;




void se_print_run_time_stack (void) {
  fprintf(SE_ERR,"Eiffel program crash at run time.\n");
  fprintf(SE_ERR,"No trace when using option \"-boost\"\n");
}

void se_signal_handler(int sig) {
  printf("Received signal %d (man signal).\n",sig);
  se_print_run_time_stack();
  exit(EXIT_FAILURE);
}



#ifdef WIN32
#define SIMULATED_MODE

typedef struct _SIMULATED_DIR {
  HANDLE handle;
  WIN32_FIND_DATA data;
  int entry_used;
} SIMULATED_DIR;

static SIMULATED_DIR* simulated_opendir(char* path) {
  int len = strlen((char*)path);
  char* pattern = se_malloc(len + 5);
  SIMULATED_DIR* result = se_malloc(sizeof(SIMULATED_DIR));

  pattern = strcpy(pattern,(char*)path);
  if (pattern[len - 1] != '\\') pattern[len++] = '\\';
  pattern[len++] = '*';
  pattern[len++] = '.';
  pattern[len++] = '*';
  pattern[len++] = 0;
  result->handle = FindFirstFile(pattern,&(result->data));
  if (result->handle == INVALID_HANDLE_VALUE) {
    free(pattern);
    free(result);
    return NULL;
  }
  result->entry_used = 0;
  return result;
}

static void* simulated_readdir(SIMULATED_DIR* dirstream) {
  if (dirstream->entry_used) {
    if (FindNextFile(dirstream->handle,&(dirstream->data))) {
      dirstream->entry_used = 1;
      return dirstream;
    }
    else {
      return NULL;
    }
  }
  else {
    dirstream->entry_used = 1;
    return dirstream;
  }
}

#define simulated_get_entry_name(x) ((x)->data.cFileName)

static int simulated_closedir(SIMULATED_DIR* dirstream) {
  FindClose(dirstream->handle);
  free(dirstream);
  return 0;
}



char * getcwd(char* buffer, int maxlen);
int chdir(const char* buffer);
int mkdir(const char* directory_path);
int rmdir(const char* directory_path);


#define simulated_getcwd(x, y) getcwd(x, y)
#define simulated_chdir(x) chdir(x)
#define simulated_rmdir(x) rmdir(x)

int simulated_mkdir(const char* directory_path, int perm) {

  mkdir(directory_path);
  return 0;
}

#endif  

#ifdef AMIGA
#define SIMULATED_MODE

#include <exec/types.h>
#include <dos/dos.h>
#include <dos/dostags.h>

#include <proto/exec.h>
#include <proto/dos.h>

typedef struct _SIMULATED_DIR {
  struct FileInfoBlock *info;
  BPTR lock;
} SIMULATED_DIR;



static void free_simulated_dir(SIMULATED_DIR * dir) {
  if (dir != NULL) {
    if (dir->lock != NULL) {
      UnLock(dir->lock);
    }
    if (dir->info != NULL) {
      FreeDosObject(DOS_FIB, dir->info);
    }
    free(dir);
  }
}

static SIMULATED_DIR * simulated_opendir(char *path) {
  BOOL ok = FALSE;
  SIMULATED_DIR *result = se_malloc(sizeof(SIMULATED_DIR));

  if (result != NULL) {
    result->lock = NULL;
    result->info = (struct FileInfoBlock *) AllocDosObject(DOS_FIB, NULL);
    if (result->info != NULL) {
      result->lock = Lock(path, ACCESS_READ);
      if (result->lock != NULL) {
 ok = (Examine(result->lock, result->info) != DOSFALSE);
 if (ok) {
   
   ok = (result->info->fib_DirEntryType >= 0)
     && (result->info->fib_DirEntryType != ST_SOFTLINK);
 }
      }
    }
  }
  if (!ok) {
    free_simulated_dir(result);
    result = NULL;
  }
  return result;
}

static void * simulated_readdir(SIMULATED_DIR * dirstream) {
  BOOL ok;
  SIMULATED_DIR *result = NULL;

  ok = (ExNext(dirstream->lock, dirstream->info) != DOSFALSE);

  if (ok) {
    result = dirstream;
  }
  return (void *) result;
}

#define simulated_get_entry_name(entry) ((entry)->info->fib_FileName)

static int simulated_closedir(SIMULATED_DIR * dirstream) {
  free_simulated_dir(dirstream);
  return 0;
}


static EIF_POINTER simulated_getcwd(char *buffer, size_t maximum_length) {
     EIF_POINTER result = NULL;
     BPTR lock = Lock("", ACCESS_READ);
     if (lock != NULL) {
       if (NameFromLock(lock, buffer, maximum_length) != DOSFALSE) {
         result = (EIF_POINTER) buffer;
       }
       UnLock(lock);
     }
     return result;
   }

static int simulated_chdir(char *name) {
  int result = -1;
  BPTR lock = Lock(name, ACCESS_READ);
  if (lock != NULL) {
    
    BPTR old_lock = CurrentDir(lock);

    
    
    if (SetCurrentDirName(name)) {
      
      UnLock(old_lock);
      result = 0;
    }
    else {
      
      CurrentDir(old_lock);
    }
  }
  return result;
}

static void strip_trailing_slash(char *path, size_t *length,
     BOOL * stripped) {
  
  *length = strlen(path);
  if ((*length > 0) && (path[*length - 1] == '/')) {
    *stripped = TRUE;
    path[*length - 1] = '\0';
  } else {
    *stripped = FALSE;
  }
}

static void restore_trailing_slash(char *path, size_t *length,
       BOOL * stripped) {
  if (*stripped) {
    path[*length - 1] = '/';
  }
}

static int simulated_mkdir(char *directory_path, int permission) {
  BPTR lock;
  int result = -1;
  size_t path_length;
  BOOL slash_stripped;

  strip_trailing_slash(directory_path, &path_length, &slash_stripped);
  lock = CreateDir(directory_path);
  if (lock != NULL) {
    UnLock(lock);
    result = 0;
  }
  restore_trailing_slash(directory_path, &path_length, &slash_stripped);
  return result;
}

static int simulated_rmdir(char *directory_path) {
  int result = -1;
  size_t path_length;
  BOOL slash_stripped;

  strip_trailing_slash(directory_path, &path_length, &slash_stripped);
  if (DeleteFile(directory_path)) {
    result = 0;
  }
  restore_trailing_slash(directory_path, &path_length, &slash_stripped);
  return result;
}
#endif 



EIF_POINTER basic_directory_open(EIF_POINTER path) {
  
#ifndef SIMULATED_MODE
  return (opendir(((char*) path)));
#else
  return (simulated_opendir(((char*) path)));
#endif
}

EIF_POINTER basic_directory_read_entry(EIF_POINTER dirstream) {
  
#ifndef SIMULATED_MODE
  return readdir((DIR*)dirstream);
#else
  return simulated_readdir((SIMULATED_DIR*)dirstream);
#endif
}

EIF_POINTER basic_directory_get_entry_name(EIF_POINTER entry) {
  
#ifndef SIMULATED_MODE
  return (((struct dirent*)entry)->d_name);
#else
  return simulated_get_entry_name((SIMULATED_DIR*)entry);
#endif
}

EIF_BOOLEAN basic_directory_close(EIF_POINTER dirstream) {
  
  int status;
#ifndef SIMULATED_MODE
  status = (closedir((DIR*)dirstream) == 0);
#else
  status = (simulated_closedir((SIMULATED_DIR*)dirstream) == 0);
#endif
  return ((EIF_BOOLEAN)(status ? 1 : 0));
}

EIF_POINTER basic_directory_cwd(void) {
  
  static char* buf = NULL;
#ifdef WIN32
  
  static int size = 0;
#else
  static size_t size = 0;
#endif
  int status;
  if (buf == NULL) {
    size = 256;
    buf = (char*)se_malloc(size);
  }


#ifndef SIMULATED_MODE
  status = (getcwd(buf,size) != NULL);
#else
  status = (simulated_getcwd(buf,size) != NULL);
#endif


  if (status) {
    return buf;
  }
  else {
    free(buf);
    size = size * 2;
    buf = (char*)se_malloc(size);
    return basic_directory_cwd();
  }
}

EIF_BOOLEAN basic_directory_chdir(EIF_POINTER destination) {
  
  int status;
#ifndef SIMULATED_MODE
  status = (chdir((char*)destination));
#else
  status = simulated_chdir((char*)destination);
#endif
  return ((EIF_BOOLEAN)(status == 0 ? 1 : 0));
}

EIF_BOOLEAN basic_directory_mkdir(EIF_POINTER directory_path){
  
  int status;
#ifndef SIMULATED_MODE
  status = (mkdir((char*)directory_path,0777));
#else
  status = simulated_mkdir((char*)directory_path,0777);
#endif
  return ((EIF_BOOLEAN)(status == 0 ? 1 : 0));
}

EIF_BOOLEAN basic_directory_rmdir(EIF_POINTER directory_path){
  
  int status;
#ifndef SIMULATED_MODE
  status = rmdir((char*)directory_path);
#else
  status = simulated_rmdir((char*)directory_path);
#endif
  return ((EIF_BOOLEAN)(status == 0 ? 1 : 0));
}




#if defined __USE_POSIX || defined __unix__ || defined _POSIX_C_SOURCE

#else
int basic_io_read_stdin(char *buffer, int size) {
  int c;
  c = getc(stdin);
  if (c==EOF)
    return 0;
  *buffer = (char)c;
  return 1;
}
#endif



T6 r8is_null(T8 C){
T6 R=0;
R=((T6)(!((NULL!=C))));
return R;
}


T6 r6_px_not(T6 C){
T6 R=0;
R=((T6)((C)==(0)));
return R;
}


T6 r3is_separator(T3 C){
T6 R=0;

{int z1=(C);
switch(z1){
case 0:
case 9:
case 10:
case 12:
case 13:
case 32:
R=((T6)(1));
break;
}
}
return R;
}


T6 r3is_decimal_digit(T3 C){
T6 R=0;

if((((unsigned)((C)))>=((unsigned)(((T3)'0'))))){
R=((T6)((((unsigned)((C)))<=((unsigned)(((T3)'9'))))));
}

return R;
}


T6 r3_ix_6061(T3 C,T3 a1){
T6 R=0;
R=((T6)((T3code(C))<=(T3code(a1))));
return R;
}


T6 r3same_as(T3 C,T3 a1){
T6 R=0;

if(((C))==(a1)){
R=((T6)(1));
}
else{

{int z1=T3code(C);
switch(z1){
case 65:
case 66:
case 67:
case 68:
case 69:
case 70:
case 71:
case 72:
case 73:
case 74:
case 75:
case 76:
case 77:
case 78:
case 79:
case 80:
case 81:
case 82:
case 83:
case 84:
case 85:
case 86:
case 87:
case 88:
case 89:
case 90:
R=((T6)((T3code(C))==((T3code(a1))-((T2)(INT8_C(32))))));
break;
case 97:
case 98:
case 99:
case 100:
case 101:
case 102:
case 103:
case 104:
case 105:
case 106:
case 107:
case 108:
case 109:
case 110:
case 111:
case 112:
case 113:
case 114:
case 115:
case 116:
case 117:
case 118:
case 119:
case 120:
case 121:
case 122:
R=((T6)((T3code(C))==((T3code(a1))+((T2)(INT8_C(32))))));
break;
}
}
}

return R;
}


T6 r3_ix_6261(T3 C,T3 a1){
T6 R=0;
R=((T6)((T3code(C))>=(T3code(a1))));
return R;
}


T3 r3to_upper(T3 C){
T3 R=0;

if((T3code(C))<((T2)(INT8_C(97)))){
R=(C);
}
 else if((T3code(C))>((T2)(INT8_C(122)))){
R=(C);
}
else{
R=((T3)((T3code(C))-((T2)(INT8_C(32)))));
}

return R;
}


T3 r3to_lower(T3 C){
T3 R=0;

if((T3code(C))<((T2)(INT8_C(65)))){
R=(C);
}
 else if((T3code(C))>((T2)(INT8_C(90)))){
R=(C);
}
else{
R=((T3)((T3code(C))+((T2)(INT8_C(32)))));
}

return R;
}


T2 r2max(T2 C,T2 a1){
T2 R=0;

if((C)>=(a1)){
R=C;
}
else{
R=a1;
}

return R;
}


T6 r2in_range(T2 C,T2 a1,T2 a2){
T6 R=0;
R=((T6)((T6)(((C)>=(a1))&&((T6)((C)<=(a2))))));
return R;
}


T2 r2min(T2 C,T2 a1){
T2 R=0;

if((C)<=(a1)){
R=C;
}
else{
R=a1;
}

return R;
}


void r2append_in(T2 C,T0* a1){
T11 _val=0;
T2 _i=0;
T2 _idx=0;

if((C)==(INT8_C(0))){
r7extend(((T7*)a1),((T3)'0'));
}
else{

if((C)>((T2)(INT8_C(0)))){
_i=(((((T7*)a1))->_count))+((T2)(INT8_C(1)));
_val=(T11)(C);
while (!((_val)==(INT8_C(0))))
{
r7extend(((T7*)a1),r11digit((_val)%((T11)(INT8_C(10)))));
_val=(_val)/((T11)(INT8_C(10)));
}
}
else{
r7extend(((T7*)a1),((T3)'\55'));
_i=(((((T7*)a1))->_count))+((T2)(INT8_C(1)));
_val=(T11)(C);
while (!((_val)==(INT8_C(0))))
{
r7extend(((T7*)a1),r11digit(-((_val)%((T11)(INT8_C(10))))));
_val=(_val)/((T11)(INT8_C(10)));
}
}

_idx=((((T7*)a1))->_count);
while (!((_i)>=(_idx)))
{
r7swap(((T7*)a1),_i,_idx);
_idx=(_idx)-((T2)(INT8_C(1)));
_i=(_i)+((T2)(INT8_C(1)));
}
}

}


T3 r11digit(T11 C){
T3 R=0;
R=((T3)((C)+((T11)(T3code(((T3)'0'))))));
return R;
}


void r11append_in(T11 C,T0* a1){
T11 _val=0;
T2 _i=0;
T2 _idx=0;

if((C)==(INT8_C(0))){
r7extend(((T7*)a1),((T3)'0'));
}
else{

if((C)>((T11)(INT8_C(0)))){
_i=(((((T7*)a1))->_count))+((T2)(INT8_C(1)));
_val=C;
while (!((_val)==(INT8_C(0))))
{
r7extend(((T7*)a1),r11digit((_val)%((T11)(INT8_C(10)))));
_val=(_val)/((T11)(INT8_C(10)));
}
}
else{
r7extend(((T7*)a1),((T3)'\55'));
_i=(((((T7*)a1))->_count))+((T2)(INT8_C(1)));
_val=C;
while (!((_val)==(INT8_C(0))))
{
r7extend(((T7*)a1),r11digit(-((_val)%((T11)(INT8_C(10))))));
_val=(_val)/((T11)(INT8_C(10)));
}
}

_idx=((((T7*)a1))->_count);
while (!((_i)>=(_idx)))
{
r7swap(((T7*)a1),_i,_idx);
_idx=(_idx)-((T2)(INT8_C(1)));
_i=(_i)+((T2)(INT8_C(1)));
}
}

}


T6 r42safe_equal(T0* a1,T0* a2){
T6 R=0;

if((a1)==((void*)(a2))){
R=((T6)(1));
}
 else if((T6)(((a1)==((void*)(NULL)))||((T6)((a2)==((void*)(NULL)))))){
}
 else if(((T0*)(t[7]))==((void*)((T0*)(t[7])))){
R=((T6)(r7is_equal(((T7*)a1),a2)));
}

return R;
}


T42 r42realloc(T42 C,T2 a1,T2 a2){
T42 R=NULL;
R=((T42)(se_calloc(a2,sizeof(T0*))));
r42copy_from(R,C,(a1)-((T2)(INT8_C(1))));
return R;
}


T2 r42index_of(T42 C,T0* a1,T2 a2){
T2 R=0;
while (!((T6)(((R)>(a2))||((T6)(r42safe_equal(a1,(C)[R]))))))
{
R=(R)+((T2)(INT8_C(1)));
}
return R;
}


void r42clear(T42 C,T2 a1,T2 a2){
T0* _v=NULL;
T2 _i=0;
_i=a1;
while (!((_i)>(a2)))
{
(C)[_i]=(_v);
_i=(_i)+((T2)(INT8_C(1)));
}
}


void r42copy_from(T42 C,T42 a1,T2 a2){
T2 _i=0;
_i=a2;
while (!((_i)<((T2)(INT8_C(0)))))
{
(C)[_i]=((a1)[_i]);
_i=(_i)-((T2)(INT8_C(1)));
}
}


void r9copy_slice(T9 C,T2 a1,T9 a2,T2 a3,T2 a4){
T2 _i1=0;
T2 _i2=0;
_i1=a1;
_i2=a3;
while (!((_i2)>(a4)))
{
(C)[_i1]=((a2)[_i2]);
_i2=(_i2)+((T2)(INT8_C(1)));
_i1=(_i1)+((T2)(INT8_C(1)));
}
}


T9 r9realloc(T9 C,T2 a1,T2 a2){
T9 R=NULL;
R=((T9)(se_calloc(a2,sizeof(T3))));
r9copy_from(R,C,(a1)-((T2)(INT8_C(1))));
return R;
}


T6 r9fast_memcmp(T9 C,T9 a1,T2 a2){
T6 R=0;
T2 _i=0;
_i=(a2)-((T2)(INT8_C(1)));
while (!((T6)(((_i)<((T2)(INT8_C(0))))||((T6)(((C)[_i])!=((a1)[_i]))))))
{
_i=(_i)-((T2)(INT8_C(1)));
}
R=((T6)((_i)<((T2)(INT8_C(0)))));
return R;
}


T6 r9fast_has(T9 C,T3 a1,T2 a2){
T6 R=0;
T2 _i=0;
_i=a2;
while (!((T6)(((_i)<((T2)(INT8_C(0))))||((T6)((a1)==((C)[_i]))))))
{
_i=(_i)-((T2)(INT8_C(1)));
}
R=((T6)((_i)>=((T2)(INT8_C(0)))));
return R;
}


void r9copy_at(T9 C,T2 a1,T9 a2,T2 a3){
T2 _at_idx=0;
T2 _src_idx=0;
_src_idx=(a3)-((T2)(INT8_C(1)));
_at_idx=(a1)+(_src_idx);
while (!((_src_idx)<((T2)(INT8_C(0)))))
{
(C)[_at_idx]=((a2)[_src_idx]);
_src_idx=(_src_idx)-((T2)(INT8_C(1)));
_at_idx=(_at_idx)-((T2)(INT8_C(1)));
}
}


void r9clear(T9 C,T2 a1,T2 a2){
T3 _v=0;
T2 _i=0;
_i=a1;
while (!((_i)>(a2)))
{
(C)[_i]=(_v);
_i=(_i)+((T2)(INT8_C(1)));
}
}


void r9copy_from(T9 C,T9 a1,T2 a2){
T2 _i=0;
_i=a2;
while (!((_i)<((T2)(INT8_C(0)))))
{
(C)[_i]=((a1)[_i]);
_i=(_i)-((T2)(INT8_C(1)));
}
}


T2 r7first_index_of(T7* C,T3 a1){
T2 R=0;
R=r7index_of(C,a1,(T2)(INT8_C(1)));
return R;
}


void r7copy(T7* C,T0* a1){
T2 _c=0;
_c=((((T7*)a1))->_count);

if((_c)>((T2)(INT8_C(0)))){

if((((C)->_capacity))<(_c)){
(C->_storage)=((T9)(se_calloc(_c,sizeof(T3))));
(C->_capacity)=_c;
}

r9copy_from(((C)->_storage),((((T7*)a1))->_storage),(_c)-((T2)(INT8_C(1))));
}

(C->_count)=_c;
}


T0* r7substring(T7* C,T2 a1,T2 a2){
T0* R=NULL;
T2 _c=0;
_c=((a2)-(a1))+((T2)(INT8_C(1)));
{T7*n=((T7*)se_malloc(sizeof(*n)));
*n=M7;
r7make(n,_c);
R=((T0*)n);
}
((((T7*)(((T7*)R))))->_count)=(_c);

r9copy_slice(((((T7*)R))->_storage),(T2)(INT8_C(0)),((C)->_storage),(a1)-((T2)(INT8_C(1))),(a2)-((T2)(INT8_C(1))));
return R;
}


void r7remove_first(T7* C,T2 a1){

if((a1)>(((C)->_count))){
(C->_count)=(T2)(INT8_C(0));
}
else{

if((a1)>((T2)(INT8_C(0)))){
r7remove_between(C,(T2)(INT8_C(1)),a1);
}

}

}


T3 r7last(T7* C){
T3 R=0;
R=(((C)->_storage))[(((C)->_count))-((T2)(INT8_C(1)))];
return R;
}


void r7remove_between(T7* C,T2 a1,T2 a2){
T2 _i=0;
T2 _len=0;
_len=((a2)-(a1))+((T2)(INT8_C(1)));

if((_len)>((T2)(INT8_C(0)))){
_i=(a2)+((T2)(INT8_C(1)));
while (!((_i)>(((C)->_count))))
{
(((C)->_storage))[((_i)-(_len))-(INT8_C(1))]=((((C)->_storage))[(_i)-(INT8_C(1))]);

_i=(_i)+((T2)(INT8_C(1)));
}
(C->_count)=(((C)->_count))-(_len);
}

}


T6 r7is_equal(T7* C,T0* a1){
T6 R=0;

if((((C)->_count))==(((((T7*)a1))->_count))){
R=((T6)(r9fast_memcmp(((C)->_storage),((((T7*)a1))->_storage),((C)->_count))));
}

return R;
}
T0*oBC7string_buffer=NULL;
T0*oBC7split_buffer=NULL;


T0* r7split(T7* C){
T0* R=NULL;

if((((C)->_count))>((T2)(INT8_C(0)))){
r41clear((T41*)(oBC7split_buffer));
r7split_in(C,oBC7split_buffer);

if(!(r41is_empty((T41*)(oBC7split_buffer)))){
R=r41twin((T41*)(oBC7split_buffer));
}

}

return R;
}


T6 r7valid_index(T7* C,T2 a1){
T6 R=0;
R=((T6)((T6)((((T2)(INT8_C(1)))<=(a1))&&((T6)((a1)<=(((C)->_count)))))));
return R;
}


void r7append(T7* C,T0* a1){
T2 _s_count=0;
T2 _needed_capacity=0;
T2 _new_capacity=0;
_s_count=((((T7*)a1))->_count);
_needed_capacity=(((C)->_count))+(_s_count);

if((_needed_capacity)>(((C)->_capacity))){

if((((C)->_capacity))==(INT8_C(0))){
(C->_storage)=((T9)(se_calloc(_needed_capacity,sizeof(T3))));
(C->_capacity)=_needed_capacity;
}
else{
_new_capacity=((T2)(INT8_C(2)))*(((C)->_capacity));

if((_needed_capacity)>(_new_capacity)){
(C->_storage)=r9realloc(((C)->_storage),((C)->_capacity),_needed_capacity);
(C->_capacity)=_needed_capacity;
}
else{
(C->_storage)=r9realloc(((C)->_storage),((C)->_capacity),_new_capacity);
(C->_capacity)=_new_capacity;
}

}

}

r9copy_at(((C)->_storage),((C)->_count),((((T7*)a1))->_storage),_s_count);
(C->_count)=_needed_capacity;
}


T6 r7has_substring(T7* C,T0* a1){
T6 R=0;
R=((T6)((r7substring_index(C,a1,(T2)(INT8_C(1))))!=(INT8_C(0))));
return R;
}


T2 r7index_of(T7* C,T3 a1,T2 a2){
T2 R=0;
R=a2;
while (!((T6)(((R)>(((C)->_count)))||((T6)((a1)==((((C)->_storage))[(R)-(INT8_C(1))]))))))
{
R=(R)+((T2)(INT8_C(1)));
}

if((R)>(((C)->_count))){
R=(T2)(INT8_C(0));
}

return R;
}


T6 r7has_suffix(T7* C,T0* a1){
T6 R=0;
T2 _i1=0;
T2 _i2=0;

if((((((T7*)a1))->_count))<=(((C)->_count))){
_i1=((((C)->_count))-(((((T7*)a1))->_count)))+((T2)(INT8_C(1)));
_i2=(T2)(INT8_C(1));
while (!((T6)(((T6)(((_i1)>(((C)->_count)))||((T6)((_i2)>(((((T7*)a1))->_count))))))||((T6)(((((C)->_storage))[(_i1)-(INT8_C(1))])!=((((((T7*)a1))->_storage))[(_i2)-(INT8_C(1))]))))))
{
_i1=(_i1)+((T2)(INT8_C(1)));
_i2=(_i2)+((T2)(INT8_C(1)));
}
R=((T6)((_i1)>(((C)->_count))));
}

return R;
}


void r7make(T7* C,T2 a1){

if((a1)>((T2)(INT8_C(0)))){

if((((C)->_capacity))<(a1)){
(C->_storage)=((T9)(se_calloc(a1,sizeof(T3))));
(C->_capacity)=a1;
}

}

(C->_count)=(T2)(INT8_C(0));
}


T6 r7has_prefix(T7* C,T0* a1){
T6 R=0;
T2 _i=0;

if((((((T7*)a1))->_count))<=(((C)->_count))){
_i=((((T7*)a1))->_count);
while (!((T6)(((_i)==(INT8_C(0)))||((T6)(((((C)->_storage))[(_i)-(INT8_C(1))])!=((((((T7*)a1))->_storage))[(_i)-(INT8_C(1))]))))))
{
_i=(_i)-((T2)(INT8_C(1)));
}
R=((T6)((_i)==(INT8_C(0))));
}

return R;
}


void r7append_string(T7* C,T0* a1){
T2 _s_count=0;
T2 _needed_capacity=0;
T2 _new_capacity=0;
_s_count=((((T7*)a1))->_count);
_needed_capacity=(((C)->_count))+(_s_count);

if((_needed_capacity)>(((C)->_capacity))){

if((((C)->_capacity))==(INT8_C(0))){
(C->_storage)=((T9)(se_calloc(_needed_capacity,sizeof(T3))));
(C->_capacity)=_needed_capacity;
}
else{
_new_capacity=((T2)(INT8_C(2)))*(((C)->_capacity));

if((_needed_capacity)>(_new_capacity)){
(C->_storage)=r9realloc(((C)->_storage),((C)->_capacity),_needed_capacity);
(C->_capacity)=_needed_capacity;
}
else{
(C->_storage)=r9realloc(((C)->_storage),((C)->_capacity),_new_capacity);
(C->_capacity)=_new_capacity;
}

}

}

r9copy_at(((C)->_storage),((C)->_count),((((T7*)a1))->_storage),_s_count);
(C->_count)=_needed_capacity;
}


void r7extend(T7* C,T3 a1){
T2 _new_capacity=0;

if((((C)->_capacity))>(((C)->_count))){
}
 else if((((C)->_capacity))==(INT8_C(0))){
_new_capacity=(T2)(INT8_C(32));
(C->_storage)=((T9)(se_calloc(_new_capacity,sizeof(T3))));
(C->_capacity)=_new_capacity;
}
else{
_new_capacity=((T2)(INT8_C(2)))*(((C)->_capacity));
(C->_storage)=r9realloc(((C)->_storage),((C)->_capacity),_new_capacity);
(C->_capacity)=_new_capacity;
}

(((C)->_storage))[((C)->_count)]=(a1);
(C->_count)=(((C)->_count))+((T2)(INT8_C(1)));
}


void r7remove_last(T7* C,T2 a1){

if((a1)>(((C)->_count))){
(C->_count)=(T2)(INT8_C(0));
}
else{
(C->_count)=(((C)->_count))-(a1);
}

}


T6 r7has(T7* C,T3 a1){
T6 R=0;
R=((T6)(r9fast_has(((C)->_storage),a1,(((C)->_count))-((T2)(INT8_C(1))))));
return R;
}


void r7append_character(T7* C,T3 a1){
T2 _new_capacity=0;

if((((C)->_capacity))>(((C)->_count))){
}
 else if((((C)->_capacity))==(INT8_C(0))){
_new_capacity=(T2)(INT8_C(32));
(C->_storage)=((T9)(se_calloc(_new_capacity,sizeof(T3))));
(C->_capacity)=_new_capacity;
}
else{
_new_capacity=((T2)(INT8_C(2)))*(((C)->_capacity));
(C->_storage)=r9realloc(((C)->_storage),((C)->_capacity),_new_capacity);
(C->_capacity)=_new_capacity;
}

(((C)->_storage))[((C)->_count)]=(a1);
(C->_count)=(((C)->_count))+((T2)(INT8_C(1)));
}


void r7extend_unless(T7* C,T3 a1){

if((T6)(((((C)->_count))==(INT8_C(0)))||((T6)(((((C)->_storage))[(((C)->_count))-(INT8_C(1))])!=(a1))))){
r7append_character(C,a1);
}

}


T6 r7same_as(T7* C,T0* a1){
T6 R=0;
T9 _s1=NULL;
T9 _s2=NULL;
T2 _i=0;
_i=((C)->_count);

if((_i)==(((((T7*)a1))->_count))){

if(r9fast_memcmp(((C)->_storage),((((T7*)a1))->_storage),_i)){
R=((T6)(1));
}
else{
_i=(_i)-((T2)(INT8_C(1)));
_s1=((C)->_storage);
_s2=((((T7*)a1))->_storage);
R=((T6)(1));
while (!((_i)<((T2)(INT8_C(0)))))
{

if(r3same_as((_s1)[_i],(_s2)[_i])){
_i=(_i)-((T2)(INT8_C(1)));
}
else{
_i=(T2)(INT8_C(-1));
R=((T6)(0));
}

}
}

}

return R;
}


void r7add_last(T7* C,T3 a1){
T2 _new_capacity=0;

if((((C)->_capacity))>(((C)->_count))){
}
 else if((((C)->_capacity))==(INT8_C(0))){
_new_capacity=(T2)(INT8_C(32));
(C->_storage)=((T9)(se_calloc(_new_capacity,sizeof(T3))));
(C->_capacity)=_new_capacity;
}
else{
_new_capacity=((T2)(INT8_C(2)))*(((C)->_capacity));
(C->_storage)=r9realloc(((C)->_storage),((C)->_capacity),_new_capacity);
(C->_capacity)=_new_capacity;
}

(((C)->_storage))[((C)->_count)]=(a1);
(C->_count)=(((C)->_count))+((T2)(INT8_C(1)));
}


void r7shrink(T7* C,T2 a1,T2 a2){

if((a2)<(a1)){
(C->_count)=(T2)(INT8_C(0));
}
 else if((a1)==(INT8_C(1))){
(C->_count)=a2;
}
else{
r9copy_slice(((C)->_storage),(T2)(INT8_C(0)),((C)->_storage),(a1)-((T2)(INT8_C(1))),(a2)-((T2)(INT8_C(1))));
(C->_count)=((a2)-(a1))+((T2)(INT8_C(1)));
}

}


void r7resize(T7* C,T2 a1){
T9 _s=NULL;

if((a1)<=(((C)->_count))){
}
 else if((((C)->_capacity))<(a1)){

if((((C)->_capacity))==(INT8_C(0))){
(C->_storage)=((T9)(se_calloc(a1,sizeof(T3))));
}
else{
(C->_storage)=r9realloc(((C)->_storage),((C)->_capacity),a1);
}

(C->_capacity)=a1;
}
else{
r9clear(((C)->_storage),((C)->_count),(a1)-((T2)(INT8_C(1))));
}

(C->_count)=a1;
}


void r7to_upper(T7* C){
T2 _i=0;
_i=((C)->_count);
while (!((_i)==(INT8_C(0))))
{
(((C)->_storage))[(_i)-(INT8_C(1))]=(r3to_upper((((C)->_storage))[(_i)-(INT8_C(1))]));

_i=(_i)-((T2)(INT8_C(1)));
}
}


T2 r7substring_index(T7* C,T0* a1,T2 a2){
T2 R=0;
T2 _i=0;
T2 _s=0;
_s=a2;
while (!((T6)(((R)!=(INT8_C(0)))||((T6)((((_s)+(((((T7*)a1))->_count)))-((T2)(INT8_C(1))))>(((C)->_count)))))))
{
_i=(T2)(INT8_C(1));
while (!((T6)(((_i)>(((((T7*)a1))->_count)))||((T6)(((((C)->_storage))[(((_s)+(_i))-((T2)(INT8_C(1))))-(INT8_C(1))])!=((((((T7*)a1))->_storage))[(_i)-(INT8_C(1))]))))))
{
_i=(_i)+((T2)(INT8_C(1)));
}

if((_i)>(((((T7*)a1))->_count))){
R=_s;
}
else{
_s=(_s)+((T2)(INT8_C(1)));
}

}
return R;
}


void r7from_external_copy(T7* C,T8 a1){
T9 _s=NULL;
T2 _i=0;
_s=a1;
(C->_count)=(T2)(INT8_C(0));
while (!(((_s)[_i])==(((T3)'\0'))))
{
r7append_character(C,(_s)[_i]);
_i=(_i)+((T2)(INT8_C(1)));
}
}


T8 r7to_external(T7* C){
T8 R=NULL;

if((((C)->_capacity))>(((C)->_count))){
(C->_count)=(((C)->_count))+((T2)(INT8_C(1)));

if(((((C)->_storage))[(((C)->_count))-(INT8_C(1))])!=(((T3)'\0'))){
(((C)->_storage))[(((C)->_count))-(INT8_C(1))]=(((T3)'\0'));

}

}
else{
r7append_character(C,((T3)'\0'));
}

(C->_count)=(((C)->_count))-((T2)(INT8_C(1)));
R=((void*)(((C)->_storage)));
return R;
}


void r7to_lower(T7* C){
T2 _i=0;
_i=((C)->_count);
while (!((_i)==(INT8_C(0))))
{
(((C)->_storage))[(_i)-(INT8_C(1))]=(r3to_lower((((C)->_storage))[(_i)-(INT8_C(1))]));

_i=(_i)-((T2)(INT8_C(1)));
}
}


T0* r7twin(T7* C){
T0* R=NULL;
R=se_malloc(sizeof(*C));
*((T7*)R)=M7;
r7copy(((T7*)R),((T0*)C));
return R;
}


T0* r7_ix_43(T7* C,T0* a1){
T0* R=NULL;
{T7*n=((T7*)se_malloc(sizeof(*n)));
*n=M7;
r7make(n,(((C)->_count))+(((((T7*)a1))->_count)));
R=((T0*)n);
}
r7append(((T7*)R),(T0*)C);
r7append(((T7*)R),a1);
return R;
}


void r7split_in(T7* C,T0* a1){
T2 _state=0;
T2 _i=0;
T3 _c=0;

if((((C)->_count))>((T2)(INT8_C(0)))){
_i=(T2)(INT8_C(1));
while (!((_i)>(((C)->_count))))
{
_c=(((C)->_storage))[(_i)-(INT8_C(1))];

if((_state)==(INT8_C(0))){

if(!(r3is_separator(_c))){
((((T7*)((T7*)(oBC7string_buffer))))->_count)=((T2)(INT8_C(0)));

r7append_character((T7*)(oBC7string_buffer),_c);
_state=(T2)(INT8_C(1));
}

}
else{

if(!(r3is_separator(_c))){
r7append_character((T7*)(oBC7string_buffer),_c);
}
else{
r41add_last(((T41*)a1),r7twin((T7*)(oBC7string_buffer)));
_state=(T2)(INT8_C(0));
}

}

_i=(_i)+((T2)(INT8_C(1)));
}

if((_state)==(INT8_C(1))){
r41add_last(((T41*)a1),r7twin((T7*)(oBC7string_buffer)));
}

}

}


void r7swap(T7* C,T2 a1,T2 a2){
T3 _tmp=0;
_tmp=(((C)->_storage))[(a1)-(INT8_C(1))];
(((C)->_storage))[(a1)-(INT8_C(1))]=((((C)->_storage))[(a2)-(INT8_C(1))]);

(((C)->_storage))[(a2)-(INT8_C(1))]=(_tmp);

}


T6 r47valid_index(T47* C,T2 a1){
T6 R=0;
R=((T6)((T6)(((INT8_C(0))<=(a1))&&((T6)((a1)<=(((C)->_upper)))))));
return R;
}


void r47make(T47* C,T2 a1){

if((a1)>(((C)->_capacity))){
(C->_storage)=((T42)(se_calloc(a1,sizeof(T0*))));
(C->_capacity)=a1;
}
 else if((T6)(((((C)->_capacity))>((T2)(INT8_C(0))))&&((T6)((((C)->_upper))>=((T2)(INT8_C(0))))))){
r42clear(((C)->_storage),(T2)(INT8_C(0)),((C)->_upper));
}

(C->_upper)=(a1)-((T2)(INT8_C(1)));
}


void r47add_last(T47* C,T0* a1){
T2 _new_capacity=0;

if(((((C)->_upper))+((T2)(INT8_C(1))))<=((((C)->_capacity))-((T2)(INT8_C(1))))){
(C->_upper)=(((C)->_upper))+((T2)(INT8_C(1)));
}
 else if((((C)->_capacity))==(INT8_C(0))){
(C->_storage)=((T42)(se_calloc((T2)(INT8_C(2)),sizeof(T0*))));
(C->_capacity)=(T2)(INT8_C(2));
(C->_upper)=(T2)(INT8_C(0));
}
else{
_new_capacity=((T2)(INT8_C(2)))*(((C)->_capacity));
(C->_storage)=r42realloc(((C)->_storage),((C)->_capacity),_new_capacity);
(C->_capacity)=_new_capacity;
(C->_upper)=(((C)->_upper))+((T2)(INT8_C(1)));
}

(((C)->_storage))[((C)->_upper)]=(a1);
}


void r47with_capacity(T47* C,T2 a1){

if((((C)->_capacity))<(a1)){
(C->_storage)=((T42)(se_calloc(a1,sizeof(T0*))));
(C->_capacity)=a1;
}
 else if((((C)->_capacity))>(a1)){
r42clear(((C)->_storage),(T2)(INT8_C(0)),((C)->_upper));
}

(C->_upper)=(T2)(INT8_C(-1));
}


void r41copy(T41* C,T0* a1){
T2 _needed_capacity=0;
(C->_lower)=((((T41*)a1))->_lower);
(C->_upper)=((((T41*)a1))->_upper);
_needed_capacity=((((C)->_upper))-(((C)->_lower)))+((T2)(INT8_C(1)));

if((((C)->_capacity))<(_needed_capacity)){
(C->_storage)=((T42)(se_calloc(_needed_capacity,sizeof(T0*))));
(C->_capacity)=_needed_capacity;
}


if((_needed_capacity)>((T2)(INT8_C(0)))){
r42copy_from(((C)->_storage),((((T41*)a1))->_storage),(_needed_capacity)-((T2)(INT8_C(1))));
}

}


T2 r41count(T41* C){
T2 R=0;
R=((((C)->_upper))-(((C)->_lower)))+((T2)(INT8_C(1)));
return R;
}


T0* r41item(T41* C,T2 a1){
T0* R=NULL;
R=(((C)->_storage))[(a1)-(((C)->_lower))];
return R;
}


T6 r41valid_index(T41* C,T2 a1){
T6 R=0;
R=((T6)((T6)(((((C)->_lower))<=(a1))&&((T6)((a1)<=(((C)->_upper)))))));
return R;
}


T2 r41index_of(T41* C,T0* a1){
T2 R=0;
R=(((C)->_lower))+(r42index_of(((C)->_storage),a1,(((C)->_upper))-(((C)->_lower))));
return R;
}


T6 r41is_empty(T41* C){
T6 R=0;
R=((T6)((((C)->_upper))<(((C)->_lower))));
return R;
}


void r41add_last(T41* C,T0* a1){
T2 _new_capacity=0;

if((((C)->_capacity))<((r41count(C))+((T2)(INT8_C(1))))){

if((((C)->_capacity))==(INT8_C(0))){
_new_capacity=(T2)(INT8_C(16));
(C->_storage)=((T42)(se_calloc(_new_capacity,sizeof(T0*))));
(C->_capacity)=_new_capacity;
}
else{
_new_capacity=((T2)(INT8_C(2)))*(((C)->_capacity));
(C->_storage)=r42realloc(((C)->_storage),((C)->_capacity),_new_capacity);
(C->_capacity)=_new_capacity;
}

}

(C->_upper)=(((C)->_upper))+((T2)(INT8_C(1)));
{T41* C1=C;
T0* b1=a1;
T2 b2=((C)->_upper);
(((C1)->_storage))[(b2)-(((C1)->_lower))]=(b1);
}
}


void r41clear(T41* C){
(C->_upper)=(((C)->_lower))-((T2)(INT8_C(1)));
}


T0* r41twin(T41* C){
T0* R=NULL;
R=se_malloc(sizeof(*C));
*((T41*)R)=M41;
r41copy(((T41*)R),((T0*)C));
return R;
}


void r41with_capacity(T41* C,T2 a1,T2 a2){

if((((C)->_capacity))<(a1)){
(C->_storage)=((T42)(se_calloc(a1,sizeof(T0*))));
(C->_capacity)=a1;
}

(C->_lower)=a2;
(C->_upper)=(a2)-((T2)(INT8_C(1)));
}


void r26read_character(T26* C){

if(((((T29*)(oBC19std_output))->_buffer_position))>((T2)(INT8_C(0)))){
r29flush((T29*)(oBC19std_output));
}

(C->_push_back_flag)=((T6)(0));

if((((C)->_buffer_position))>=(((C)->_buffer_size))){
r26fill_buffer(C);
}

(C->_last_character)=(((C)->_buffer))[((C)->_buffer_position)];
(C->_buffer_position)=(((C)->_buffer_position))+((T2)(INT8_C(1)));
(C->_end_of_input)=((T6)(((C)->_end_reached)));
}


void r26fill_buffer(T26* C){
T3 _last=0;

if((((C)->_buffer_size))>((T2)(INT8_C(0)))){
_last=(((C)->_buffer))[(((C)->_buffer_size))-((T2)(INT8_C(1)))];
}

(C->_buffer_size)=basic_io_read_stdin(((C)->_buffer),(T2)(INT16_C(4096)));
(C->_buffer_position)=(T2)(INT8_C(0));

if((((C)->_buffer_size))<=((T2)(INT8_C(0)))){
(C->_end_reached)=((T6)(1));
(((C)->_buffer))[(T2)(INT8_C(0))]=(_last);
(C->_buffer_size)=(T2)(INT8_C(1));
(C->_buffer_position)=(T2)(INT8_C(1));
}

}


void r26make(T26* C){
(C->_buffer)=((T9)(se_calloc((T2)(INT16_C(4096)),sizeof(T3))));
(C->_capacity)=(T2)(INT16_C(4096));
}


void r26skip_separators(T26* C){
r26read_character(C);
while (!((T6)((((C)->_end_of_input))||((T6)(!(r3is_separator(((C)->_last_character))))))))
{
r26read_character(C);
}

if(!(((C)->_end_of_input))){
r26unread_character(C);
}

}


void r26read_line_in(T26* C,T0* a1){
T2 _i=0;
T6 _stop=0;
T2 _old_count=0;
T2 _new_count=0;
T2 _initial_count=0;

if(((((T29*)(oBC19std_output))->_buffer_position))>((T2)(INT8_C(0)))){
r29flush((T29*)(oBC19std_output));
}

_initial_count=((((T7*)a1))->_count);
while (!(_stop))
{
_i=((C)->_buffer_position);
while (!((T6)(((_i)>=(((C)->_buffer_size)))||((T6)(((((C)->_buffer))[_i])==(((T3)'\n')))))))
{
_i=(_i)+((T2)(INT8_C(1)));
}

if((_i)>(((C)->_buffer_position))){
_old_count=((((T7*)a1))->_count);
_new_count=((_old_count)+(_i))-(((C)->_buffer_position));

if((((((T7*)a1))->_capacity))<(_new_count)){
r7resize(((T7*)a1),r2max((_old_count)*((T2)(INT8_C(2))),_new_count));
}

r9copy_slice(((((T7*)a1))->_storage),_old_count,((C)->_buffer),((C)->_buffer_position),(_i)-((T2)(INT8_C(1))));
((((T7*)(((T7*)a1))))->_count)=(_new_count);

}


if((T6)(((_i)<(((C)->_buffer_size)))&&((T6)(((((C)->_buffer))[_i])==(((T3)'\n')))))){
_stop=((T6)(1));
(C->_buffer_position)=(_i)+((T2)(INT8_C(1)));

if((T6)(((((((T7*)a1))->_count))>(_initial_count))&&((T6)((r7last(((T7*)a1)))==(((T3)'\15')))))){
r7remove_last(((T7*)a1),(T2)(INT8_C(1)));
}

}
else{

if(!(((C)->_end_reached))){
r26fill_buffer(C);
}

_stop=((T6)(((C)->_end_reached)));
}

}
(C->_push_back_flag)=((T6)(0));
(C->_end_of_input)=((T6)(((C)->_end_reached)));
}


void r26read_word(T26* C){
r26skip_separators(C);

if(!(((C)->_end_of_input))){
r26read_character(C);
}

((((T7*)((T7*)(oBC27last_string))))->_count)=((T2)(INT8_C(0)));

while (!((T6)((((C)->_end_of_input))||((T6)(r3is_separator(((C)->_last_character)))))))
{
r7extend((T7*)(oBC27last_string),((C)->_last_character));
r26read_character(C);
}
}


void r26read_line(T26* C){
((((T7*)((T7*)(oBC27last_string))))->_count)=((T2)(INT8_C(0)));

r26read_line_in(C,oBC27last_string);
}
T0*oBC19std_output=NULL;
T0*oBC27last_string=NULL;


void r26unread_character(T26* C){
(C->_push_back_flag)=((T6)(1));
(C->_end_of_input)=((T6)(0));
(C->_buffer_position)=(((C)->_buffer_position))-((T2)(INT8_C(1)));
}


void r31file_removing(T31* C,T0* a1){

if(r31file_exists(a1)){
r31put_string(C,((T0*)ms31_210310269));
r31put_string(C,a1);
r31put_string(C,((T0*)ms15_1090));
{T0* b1=a1;
r45delete(b1);
}
}

}


T6 r31file_exists(T0* a1){
T6 R=0;
R=((T6)(r45is_readable(a1)));
return R;
}


void r31file_renaming(T31* C,T0* a1,T0* a2){
r31put_string(C,((T0*)ms31_210141519));
r31put_string(C,a1);
r31put_string(C,((T0*)ms31_141444));
r31put_string(C,a2);
r31put_string(C,((T0*)ms15_1090));
{T0* b1=a1;
T0* b2=a2;
r45rename_to(b1,b2);
}
}
T0*oBC14system_tools=NULL;
int fBC14system_tools=0;


T0* r31system_tools(void){
if(fBC14system_tools==0){fBC14system_tools=1;{
{T34*n=((T34*)se_malloc(sizeof(*n)));
*n=M34;
oBC14system_tools=((T0*)n);
r34make(n);
}
}}
return oBC14system_tools;
}


void r31tfw_connect(T31* C,T0* a1,T0* a2){
r48connect_to(((T48*)a1),a2);

if((((((T48*)a1))->_path))!=(NULL)){
r31put_string(C,((T0*)ms31_44975894));
r31put_string(C,a2);
r31put_string(C,((T0*)ms31_3556890));
}
else{
r31w_put_string(((T0*)ms31_1711985232));
r31w_put_string(a2);
r31w_put_string(((T0*)ms15_1090));
exit(INT8_C(1));
}

}


void r31w_put_character(T3 a1){
{T3 b1=a1;
basic_io_putc(b1,basic_io_stderr);
}
basic_io_flush(basic_io_stderr);

}


void r31tfr_connect(T31* C,T0* a1,T0* a2){
r31put_string(C,((T0*)ms31_27561173));
r31put_string(C,a2);
r31put_string(C,((T0*)ms15_1090));
r36connect_to(((T36*)a1),a2);
}


T0* r31getenv(T0* a1,T0* a2){
T0* R=NULL;
int _s=0;

if((T6)((r7same_as((T7*)(((T0*)ms31_1071750288)),a1))||((T6)(r7same_as((T7*)(((T0*)ms31_1662662954)),a1))))){
r31w_put_string(((T0*)ms31_203714719));
r31w_put_string(a1);
r31w_put_string(((T0*)ms31_1974940930));

if((a2)!=((void*)(NULL))){
r31w_put_string(((T0*)ms31_113009969));
r31w_put_string(a2);
r31w_put_character(((T3)'\42'));
}
else{
r31w_put_character(((T3)'\56'));
}

r31w_put_character(((T3)'\n'));
}

R=r32get_environment_variable(a1);

if((T6)(((R)==((void*)(NULL)))&&((T6)((T6)((r7same_as((T7*)(((T0*)ms31_1635864124)),a1))||((T6)(r7same_as((T7*)(((T0*)ms31_1662662954)),a1)))))))){
R=r31getenv(((T0*)ms15_1072344038),a2);

if((T6)(((R)!=((void*)(NULL)))&&((T6)((((((T7*)R))->_count))>((T2)(INT8_C(9))))))){
r7remove_last(((T7*)R),(T2)(INT8_C(9)));

if((((((T7*)R))->_count))>((T2)(INT8_C(3)))){
r34parent_directory((T34*)(r31system_tools()),R);
}

}

}


if((T6)(((R)==((void*)(NULL)))&&((T6)(r7same_as((T7*)(((T0*)ms15_1072344038)),a1))))){
r31w_put_string(((T0*)se_ms(47,"Environment variable \"SmartEiffel\" is not set.\n")));
R=r32get_environment_variable(((T0*)ms31_1071750288));

if((R)!=((void*)(NULL))){
r31w_put_string(((T0*)se_ms(53,"Trying with the old obsolete \"SmallEiffel\" variable.\n")));
}

}


if((R)==((void*)(NULL))){
r31w_put_string(((T0*)ms31_354654986));
r31w_put_string(a1);
r31w_put_character(((T3)'\175'));

if((a2)!=((void*)(NULL))){
r31w_put_string(((T0*)ms31_1430004157));
r31w_put_string(a2);
r31w_put_character(((T3)'\42'));
}

r31w_put_string(((T0*)ms31_1293738877));
}

return R;
}


T0* r31read_word_in(T31* C,T0* a1){
T0* R=NULL;
r31put_string(C,((T0*)ms31_136264778));
r31put_string(C,((((T36*)a1))->_path));
r31put_string(C,((T0*)ms15_1090));

if(((((T36*)a1))->_end_of_input)){
r31w_put_string(((T0*)ms31_1520107011));
r31w_put_string(((((T36*)a1))->_path));
r31w_put_string(((T0*)ms15_1090));
exit(INT8_C(1));
}
else{
r36read_word(((T36*)a1));
R=r7twin((T7*)(oBC27last_string));
}

return R;
}


void r31tfr_connect_or_exit(T31* C,T0* a1,T0* a2){
r31tfr_connect(C,a1,a2);

if(!((((((T36*)a1))->_path))!=(NULL))){
r31w_put_string(((T0*)ms15_300594));
r31w_put_string(a2);
r31w_put_string(((T0*)se_ms(13,"\" not found.\n")));
exit(INT8_C(1));
}

}
T45 oBC19file_tools=0;


void r31w_put_string(T0* a1){
r33put_string(a1);
basic_io_flush(basic_io_stderr);

}


void r31system_call(T31* C,T0* a1){
T2 _i=0;
T0* _cmd2=NULL;
int _s=0;

if((r7last(((T7*)a1)))==(((T3)'\n'))){
r7remove_last(((T7*)a1),(T2)(INT8_C(1)));
r31system_call(C,a1);
}
 else if(r7has(((T7*)a1),((T3)'\n'))){
_i=r7first_index_of(((T7*)a1),((T3)'\n'));
_cmd2=r7substring(((T7*)a1),(_i)+((T2)(INT8_C(1))),((((T7*)a1))->_count));
r7remove_last(((T7*)a1),((((((T7*)a1))->_count))-(_i))+((T2)(INT8_C(1))));
r31system_call(C,a1);
r31system_call(C,_cmd2);
}
else{
r31put_string(C,((T0*)ms31_1800535743));
r31put_string(C,a1);
r31put_string(C,((T0*)ms15_1090));
r32execute_command_line(a1);
}

}


void r31put_string(T31* C,T0* a1){

if(((C)->_verbose)){
r29put_string((T29*)(oBC19std_output),a1);
r29flush((T29*)(oBC19std_output));
}

}
T0*oBC19std_error=NULL;


void r36disconnect(T36* C){
basic_io_fclose(((C)->_input_stream));
(C->_path)=NULL;
}


void r36read_character(T36* C){
(C->_push_back_flag)=((T6)(0));

if((((C)->_buffer_position))>=(((C)->_buffer_size))){
r36fill_buffer(C);
}

(C->_last_character)=(((C)->_buffer))[((C)->_buffer_position)];
(C->_buffer_position)=(((C)->_buffer_position))+((T2)(INT8_C(1)));
(C->_end_of_input)=((T6)(((C)->_end_reached)));
}


void r36fill_buffer(T36* C){
T3 _last=0;

if((((C)->_buffer_size))>((T2)(INT8_C(0)))){
_last=(((C)->_buffer))[(((C)->_buffer_size))-((T2)(INT8_C(1)))];
}

(C->_buffer_size)=basic_io_fread(((C)->_buffer),((C)->_capacity),((C)->_input_stream));
(C->_buffer_position)=(T2)(INT8_C(0));

if((((C)->_buffer_size))<=((T2)(INT8_C(0)))){
(C->_end_reached)=((T6)(1));
(((C)->_buffer))[(T2)(INT8_C(0))]=(_last);
(C->_buffer_size)=(T2)(INT8_C(1));
(C->_buffer_position)=(T2)(INT8_C(1));
}

}


void r36skip_separators(T36* C){
r36read_character(C);
while (!((T6)((((C)->_end_of_input))||((T6)(!(r3is_separator(((C)->_last_character))))))))
{
r36read_character(C);
}

if(!(((C)->_end_of_input))){
r36unread_character(C);
}

}


void r36read_line_in(T36* C,T0* a1){
T2 _i=0;
T6 _stop=0;
T2 _old_count=0;
T2 _new_count=0;
T2 _initial_count=0;
_initial_count=((((T7*)a1))->_count);
while (!(_stop))
{
_i=((C)->_buffer_position);
while (!((T6)(((_i)>=(((C)->_buffer_size)))||((T6)(((((C)->_buffer))[_i])==(((T3)'\n')))))))
{
_i=(_i)+((T2)(INT8_C(1)));
}

if((_i)>(((C)->_buffer_position))){
_old_count=((((T7*)a1))->_count);
_new_count=((_old_count)+(_i))-(((C)->_buffer_position));

if((((((T7*)a1))->_capacity))<(_new_count)){
r7resize(((T7*)a1),r2max((_old_count)*((T2)(INT8_C(2))),_new_count));
}

r9copy_slice(((((T7*)a1))->_storage),_old_count,((C)->_buffer),((C)->_buffer_position),(_i)-((T2)(INT8_C(1))));
((((T7*)(((T7*)a1))))->_count)=(_new_count);

}


if((T6)(((_i)<(((C)->_buffer_size)))&&((T6)(((((C)->_buffer))[_i])==(((T3)'\n')))))){
_stop=((T6)(1));
(C->_buffer_position)=(_i)+((T2)(INT8_C(1)));

if((T6)(((((((T7*)a1))->_count))>(_initial_count))&&((T6)((r7last(((T7*)a1)))==(((T3)'\15')))))){
r7remove_last(((T7*)a1),(T2)(INT8_C(1)));
}

}
else{

if(!(((C)->_end_reached))){
r36fill_buffer(C);
}

_stop=((T6)(((C)->_end_reached)));
}

}
(C->_push_back_flag)=((T6)(0));
(C->_end_of_input)=((T6)(((C)->_end_reached)));
}


void r36connect_to(T36* C,T0* a1){
T8 _p=NULL;
_p=r7to_external(((T7*)a1));
(C->_input_stream)=basic_io_text_file_read_open(_p);

if((NULL!=((C)->_input_stream))){
(C->_push_back_flag)=((T6)(0));
(C->_end_of_input)=((T6)(0));
(C->_path)=a1;

if((((C)->_capacity))==(INT8_C(0))){
(C->_buffer)=((T9)(se_calloc((T2)(INT16_C(4096)),sizeof(T3))));
(C->_capacity)=(T2)(INT16_C(4096));
}

(C->_end_reached)=((T6)(0));
(C->_buffer_position)=(T2)(INT8_C(0));
(C->_buffer_size)=(T2)(INT8_C(0));
}

}


void r36read_word(T36* C){
r36skip_separators(C);

if(!(((C)->_end_of_input))){
r36read_character(C);
}

((((T7*)((T7*)(oBC27last_string))))->_count)=((T2)(INT8_C(0)));

while (!((T6)((((C)->_end_of_input))||((T6)(r3is_separator(((C)->_last_character)))))))
{
r7extend((T7*)(oBC27last_string),((C)->_last_character));
r36read_character(C);
}
}


void r36read_line(T36* C){
((((T7*)((T7*)(oBC27last_string))))->_count)=((T2)(INT8_C(0)));

r36read_line_in(C,oBC27last_string);
}


void r36unread_character(T36* C){
(C->_push_back_flag)=((T6)(1));
(C->_end_of_input)=((T6)(0));
(C->_buffer_position)=(((C)->_buffer_position))-((T2)(INT8_C(1)));
}


void r34append_token(T0* a1,T0* a2){

if(!((((((T7*)a2))->_count))==(INT8_C(0)))){

if(((((((T7*)a2))->_storage))[INT8_C(0)])!=(((T3)'\40'))){

if(!((((((T7*)a1))->_count))==(INT8_C(0)))){
r7extend_unless(((T7*)a1),((T3)'\40'));
}

}

r7append(((T7*)a1),a2);
}

}


void r34set_c_compiler(T34* C,T0* a1){
T2 _i=0;
T2 _j=0;
T0* _lib_name=NULL;

if((a1)!=((void*)(NULL))){
_i=r41index_of((T41*)(oBC34compiler_list),a1);

if((_i)>((((T41*)(oBC34compiler_list))->_upper))){
r31w_put_string(((T0*)ms34_17494489));
r31w_put_string(a1);
r31w_put_string(((T0*)ms34_561720547));
r34show_compiler_list_then_exit(C);
}

(C->_c_compiler)=r41item((T41*)(oBC34compiler_list),_i);
}
else{
r7copy((T7*)(oBC14tmp_path),((C)->_sys_directory));
r7append((T7*)(oBC14tmp_path),((T0*)ms34_1236979201));
r31tfr_connect_or_exit((T31*)(oBC14echo),oBC14tmp_file_read,oBC14tmp_path);
(C->_c_compiler)=r31read_word_in((T31*)(oBC14echo),oBC14tmp_file_read);
_i=r41index_of((T41*)(oBC34compiler_list),((C)->_c_compiler));

if((_i)>((((T41*)(oBC34compiler_list))->_upper))){
r31w_put_string(((T0*)ms34_876917780));
r31w_put_string((((T36*)(oBC14tmp_file_read))->_path));
r31w_put_string(((T0*)ms15_1090));
r34show_compiler_list_then_exit(C);
}

(C->_c_compiler)=r41item((T41*)(oBC34compiler_list),_i);

if(!((((T36*)(oBC14tmp_file_read))->_end_of_input))){
r36read_line_in((T36*)(oBC14tmp_file_read),((T0*)ms34_0aaaaaaa));
}

r36disconnect((T36*)(oBC14tmp_file_read));
while (!((T6)((((((T7*)(((T0*)ms34_0aaaaaaa)))->_count))==(INT8_C(0)))||((T6)(!(r3is_separator(((((T7*)(((T0*)ms34_0aaaaaaa)))->_storage))[INT8_C(0)])))))))
{
r7remove_first((T7*)(((T0*)ms34_0aaaaaaa)),(T2)(INT8_C(1)));
}

if((T6)(((T6)(((((C)->_c_compiler))==((void*)(((T0*)ms34_51699930))))||((T6)((((C)->_c_compiler))==((void*)(((T0*)ms34_603)))))))||((T6)((((C)->_c_compiler))==((void*)(((T0*)ms34_76405))))))){
_i=r7substring_index((T7*)(((T0*)ms34_0aaaaaaa)),((T0*)ms34_9073),(T2)(INT8_C(1)));
while (!((_i)==(INT8_C(0))))
{

if((T6)((((_i)+((T2)(INT8_C(4))))>((((T7*)(((T0*)ms34_0aaaaaaa)))->_count)))||((T6)(r3is_separator(((((T7*)(((T0*)ms34_0aaaaaaa)))->_storage))[((_i)+((T2)(INT8_C(4))))-(INT8_C(1))]))))){
_j=_i;
while (!((T6)(((_j)==(INT8_C(1)))||((T6)(r3is_separator(((((T7*)(((T0*)ms34_0aaaaaaa)))->_storage))[((_j)-((T2)(INT8_C(1))))-(INT8_C(1))]))))))
{
_j=(_j)-((T2)(INT8_C(1)));
}
_lib_name=r7twin((T7*)(((T0*)ms34_0aaaaaaa)));
r7shrink(((T7*)_lib_name),_j,(_i)+((T2)(INT8_C(3))));
r34add_external_lib(C,_lib_name);
r7remove_between((T7*)(((T0*)ms34_0aaaaaaa)),_j,(_i)+((T2)(INT8_C(3))));
_i=_j;
}
else{
_i=(_i)+((T2)(INT8_C(4)));
}

_i=r7substring_index((T7*)(((T0*)ms34_0aaaaaaa)),((T0*)ms34_9073a),_i);
}
}
else{
_i=r7substring_index((T7*)(((T0*)ms34_0aaaaaaa)),((T0*)ms34_333a),(T2)(INT8_C(1)));
while (!((_i)==(INT8_C(0))))
{

if((T6)(((_i)==(INT8_C(1)))||((T6)(r3is_separator(((((T7*)(((T0*)ms34_0aaaaaaa)))->_storage))[((_i)-((T2)(INT8_C(1))))-(INT8_C(1))]))))){
_j=_i;
while (!((T6)(((_j)==((((T7*)(((T0*)ms34_0aaaaaaa)))->_count)))||((T6)(r3is_separator(((((T7*)(((T0*)ms34_0aaaaaaa)))->_storage))[((_j)+((T2)(INT8_C(1))))-(INT8_C(1))]))))))
{
_j=(_j)+((T2)(INT8_C(1)));
}
_lib_name=r7twin((T7*)(((T0*)ms34_0aaaaaaa)));
r7shrink(((T7*)_lib_name),_i,_j);
r34add_external_lib(C,_lib_name);
r7remove_between((T7*)(((T0*)ms34_0aaaaaaa)),_i,_j);
}
else{
_i=(_i)+((T2)(INT8_C(2)));
}

_i=r7substring_index((T7*)(((T0*)ms34_0aaaaaaa)),((T0*)ms34_9073aa),_i);
}
}

}

}
T0*oBC34system_list=NULL;
T0*oBC14tmp_file_read=NULL;
T6 oBC34Scoptions_exists=0;
int fBC34Scoptions_exists=0;


T6 r34Scoptions_exists(void){
if(fBC34Scoptions_exists==0){fBC34Scoptions_exists=1;{
oBC34Scoptions_exists=((T6)(r45is_readable(((T0*)ms34_39204698))));
}}
return oBC34Scoptions_exists;
}


void r34no_split_mode_command(T34* C,T0* a1,T0* a2){
((((T7*)(((T7*)a1))))->_count)=((T2)(INT8_C(0)));


if((((C)->_c_compiler))==((void*)(((T0*)ms34_3169)))){

if(((((T7*)(((T0*)ms34_0aa)))->_count))==(INT8_C(0))){
r7append(((T7*)a1),((T0*)ms34_3169));
}
else{
r7append(((T7*)a1),((T0*)ms34_2833));
}

r34append_token(a1,((T0*)ms34_0aaaaaaa));
r34append_token(a1,((T0*)ms34_0aaaaaa));
r34append_token(a1,((T0*)ms34_0aaaaa));
r34append_token(a1,((T0*)ms34_0aaaa));
r34add_executable_name(C,a1);
r34append_token(a1,a2);
r34append_token(a1,((T0*)ms34_0aaa));
r34append_token(a1,((T0*)ms34_0aa));
r34append_token(a1,((T0*)ms34_0a));
r34append_token(a1,((T0*)ms34_0));
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_51699930)))){
r7append(((T7*)a1),((T0*)ms34_3294));
r34append_token(a1,((T0*)ms34_0aaaaaaa));
r34append_token(a1,((T0*)ms34_0aaaaaa));
r34append_token(a1,a2);
r7extend(((T7*)a1),((T3)'\n'));
r34external_c_files_for_lcc_win32(C,a1);
r7append(((T7*)a1),((T0*)ms34_415107));

if(!(((C)->_no_strip))){
r34append_token(a1,((T0*)ms34_340));
}

r34append_token(a1,((T0*)ms34_0aaaaa));
r34add_executable_name(C,a1);
{T7* C1=((T7*)a2);
T0* b1=((T0*)ms14_329);
r7remove_last(C1,((((T7*)b1))->_count));
}
r7append(((T7*)a2),r34object_suffix(C));
r34append_token(a1,a2);
r34append_token(a1,((T0*)ms34_0a));
r34append_token(a1,((T0*)ms34_0));
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_594)))){
r7append(((T7*)a1),((T0*)ms34_594));
r34append_token(a1,((T0*)ms34_0aaaaaaa));
r34append_token(a1,((T0*)ms34_0aaaaaa));
r34append_token(a1,((T0*)ms34_0aaaaa));
r34append_token(a1,((T0*)ms34_0aaaa));
r34add_executable_name(C,a1);
r34append_token(a1,a2);
r34append_token(a1,((T0*)ms34_0aaa));
r34append_token(a1,((T0*)ms34_0aa));
r34append_token(a1,((T0*)ms34_0a));
r34append_token(a1,((T0*)ms34_0));
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_448859)))){
r7append(((T7*)a1),((T0*)ms34_448859));
r34append_token(a1,((T0*)ms34_0aaaaaaa));
r34append_token(a1,((T0*)ms34_0aaaaaa));
r34append_token(a1,((T0*)ms34_0aaaaa));
r34append_token(a1,((T0*)ms34_0aaaa));
r34add_executable_name(C,a1);
r34append_token(a1,a2);
r34append_token(a1,((T0*)ms34_0aaa));
r34append_token(a1,((T0*)ms34_0aa));
r34append_token(a1,((T0*)ms34_0a));
r34append_token(a1,((T0*)ms34_0));
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_76405)))){
r7append(((T7*)a1),((T0*)ms34_76405));
r34append_token(a1,((T0*)ms34_0aaaaaaa));
r34append_token(a1,((T0*)ms34_0aaaaaa));
r34append_token(a1,((T0*)ms34_0aaaaa));
r34append_token(a1,((T0*)ms34_0aaaa));
r34add_executable_name(C,a1);
r34append_token(a1,a2);
r34append_token(a1,((T0*)ms34_0aaa));
r34append_token(a1,((T0*)ms34_0aa));
r34append_token(a1,((T0*)ms34_0a));
r34append_token(a1,((T0*)ms34_0));
r34add_lib_math(C);
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_603)))){
r7append(((T7*)a1),((T0*)ms34_603));
r34append_token(a1,((T0*)ms34_0aaaaaaa));
r34append_token(a1,((T0*)ms34_0aaaaaa));
r34add_executable_name(C,a1);
r34append_token(a1,a2);
r34append_token(a1,((T0*)ms34_0aaa));
r34append_token(a1,((T0*)ms34_0aa));
r34append_token(a1,((T0*)ms34_0a));
r34append_token(a1,((T0*)ms34_146157a));
r34append_token(a1,((T0*)ms34_0aaaaa));
r34append_token(a1,((T0*)ms34_0aaaa));
r34append_token(a1,((T0*)ms34_0));
r34add_lib_math(C);
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_674)))){
r7append(((T7*)a1),((T0*)ms34_674));
r34append_token(a1,r34sas_c_compiler_options((T6)(0)));
r34append_token(a1,((T0*)ms34_0aaaaaaa));
r34append_token(a1,((T0*)ms34_0aaaaaa));
r34append_token(a1,((T0*)ms34_0aaaaa));
r34append_token(a1,((T0*)ms34_0aaaa));
r34append_token(a1,a2);
r34append_token(a1,((T0*)ms34_0aaa));
r34append_token(a1,((T0*)ms34_0aa));
r34append_token(a1,((T0*)ms34_0a));
r34append_token(a1,((T0*)ms34_0));
r34add_lib_math(C);
r34add_executable_name(C,a1);
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_15721)))){
r7append(((T7*)a1),((T0*)ms34_3094));
r34append_token(a1,((T0*)ms34_0aaaaaaa));
r34append_token(a1,((T0*)ms34_0aaaaaa));
r34append_token(a1,((T0*)ms34_0aaaaa));
r34append_token(a1,((T0*)ms34_0aaaa));
r34add_executable_name(C,a1);
r34append_token(a1,a2);
r34append_token(a1,((T0*)ms34_0aaa));
r34append_token(a1,((T0*)ms34_0aa));
r34append_token(a1,((T0*)ms34_0a));
r34append_token(a1,((T0*)ms34_0));
r34add_lib_math(C);

if(((C)->_no_strip)){
r34append_token(a1,((T0*)ms34_340a));
}

}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_17794)))){
r7append(((T7*)a1),((T0*)ms34_689));
r34append_token(a1,((T0*)ms34_0aaaaaaa));
r34append_token(a1,((T0*)ms34_0aaaaaa));
r34append_token(a1,((T0*)ms34_0aaaaa));
r34append_token(a1,((T0*)ms34_0aaaa));
r34add_executable_name(C,a1);
r34add_lib_math(C);
r34append_token(a1,a2);
r34append_token(a1,((T0*)ms34_0aaa));
r34append_token(a1,((T0*)ms34_0aa));
r34append_token(a1,((T0*)ms34_0a));
r34append_token(a1,((T0*)ms34_0));
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_3069)))){
r7append(((T7*)a1),((T0*)ms34_3069));
r34append_token(a1,((T0*)ms34_0aaaaaaa));
r34append_token(a1,((T0*)ms34_0aaaaaa));
r34append_token(a1,((T0*)ms34_0aaaaa));
r34append_token(a1,((T0*)ms34_0aaaa));
r34add_executable_name(C,a1);
r34append_token(a1,a2);
r34append_token(a1,((T0*)ms34_0aaa));
r34append_token(a1,((T0*)ms34_0aa));
r34append_token(a1,((T0*)ms34_0a));
r34append_token(a1,((T0*)ms34_0));
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_18144)))){
r7append(((T7*)a1),((T0*)ms34_18144));
r34append_token(a1,((T0*)ms34_0aaaaaaa));
r34append_token(a1,((T0*)ms34_0aaaaaa));
r34append_token(a1,((T0*)ms34_0aaaaa));
r34append_token(a1,((T0*)ms34_0aaaa));
r34add_executable_name(C,a1);
r34append_token(a1,a2);
r34append_token(a1,((T0*)ms34_0aaa));
r34append_token(a1,((T0*)ms34_0aa));
r34append_token(a1,((T0*)ms34_0a));
r34append_token(a1,((T0*)ms34_0));
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_207986277)))){
r7append(((T7*)a1),((T0*)ms34_683870135a));
r7append(((T7*)a1),a2);
r7remove_last(((T7*)a1),(T2)(INT8_C(2)));
r7append(((T7*)a1),((T0*)ms34_72020566));
r34add_executable_name(C,a1);
r7extend(((T7*)a1),((T3)'\40'));
r7append(((T7*)a1),a2);
r7remove_last(((T7*)a1),(T2)(INT8_C(2)));
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_3494)))){
r7append(((T7*)a1),((T0*)ms34_3494));
r34append_token(a1,((T0*)ms34_0aaaaaaa));
r34append_token(a1,((T0*)ms34_0aaaaaa));
r34append_token(a1,((T0*)ms34_0aaaaa));
r34append_token(a1,((T0*)ms34_0aaaa));
r34add_executable_name(C,a1);
r34append_token(a1,((T0*)ms34_0));
r34append_token(a1,a2);
r34append_token(a1,((T0*)ms34_0aaa));
r34append_token(a1,((T0*)ms34_0a));
}

}


void r34add_executable_name(T34* C,T0* a1){
T0* _executable_name=NULL;
_executable_name=(((T50*)(oBC14ace))->_executable_name);

if((_executable_name)==((void*)(NULL))){
_executable_name=r7twin((T7*)((((T50*)(oBC14ace))->_root_class_name)));
r7to_lower(((T7*)_executable_name));

if((((C)->_c_compiler))==((void*)(((T0*)ms34_51699930)))){
r34append_token(a1,((T0*)ms34_336));
r34append_token(a1,_executable_name);
r34add_x_suffix(C,a1);
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_76405)))){
r34append_token(a1,((T0*)ms34_326));
r7append(((T7*)a1),_executable_name);
r34add_x_suffix(C,a1);
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_448859)))){
r34append_token(a1,((T0*)ms34_336));
r7append(((T7*)a1),_executable_name);
r34add_x_suffix(C,a1);
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_674)))){
_executable_name=r7twin((T7*)((((T50*)(oBC14ace))->_root_class_name)));
r7to_lower(((T7*)_executable_name));
r7append(((T7*)a1),((T0*)ms34_6687));
r7append(((T7*)a1),_executable_name);
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_15721)))){
r34append_token(a1,((T0*)ms34_336));
r7append(((T7*)a1),_executable_name);
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_17794)))){
r34append_token(a1,((T0*)ms34_336));
r7append(((T7*)a1),_executable_name);
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_18144)))){
r34append_token(a1,((T0*)ms34_336));
r7append(((T7*)a1),_executable_name);
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_207986277)))){
r7append(((T7*)a1),_executable_name);
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_3494)))){

if((((C)->_system_name))==((void*)(((T0*)ms34_13028)))){
r34append_token(a1,((T0*)ms34_336));
r34append_token(a1,((T0*)ms34_69851));
}
else{
r34append_token(a1,((T0*)ms34_336));
r34append_token(a1,_executable_name);
r34add_x_suffix(C,a1);
}

}

}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_3169)))){
r34append_token(a1,((T0*)ms34_336));
r34append_token(a1,_executable_name);
r34add_x_suffix(C,a1);
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_51699930)))){
r34append_token(a1,((T0*)ms34_336));
r34append_token(a1,_executable_name);
r34add_x_suffix(C,a1);
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_594)))){
r34append_token(a1,((T0*)ms34_336));
r34append_token(a1,_executable_name);
r34add_x_suffix(C,a1);
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_448859)))){
r34append_token(a1,((T0*)ms34_336));
r34append_token(a1,_executable_name);
r34add_x_suffix(C,a1);
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_76405)))){
r34append_token(a1,((T0*)ms34_326));
r7append(((T7*)a1),_executable_name);
r34add_x_suffix(C,a1);
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_603)))){
r34append_token(a1,((T0*)ms34_336));
r7append(((T7*)a1),_executable_name);
r34add_x_suffix(C,a1);
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_674)))){
r7append(((T7*)a1),((T0*)ms34_6687));
r34append_token(a1,_executable_name);
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_15721)))){
r34append_token(a1,((T0*)ms34_336));
r34append_token(a1,_executable_name);
r34add_x_suffix(C,a1);
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_17794)))){
r34append_token(a1,((T0*)ms34_336));
r34append_token(a1,_executable_name);
r34add_x_suffix(C,a1);
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_3069)))){
r34append_token(a1,((T0*)ms34_336));
r34append_token(a1,_executable_name);
r34add_x_suffix(C,a1);
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_18144)))){
r34append_token(a1,((T0*)ms34_336));
r34append_token(a1,_executable_name);
r34add_x_suffix(C,a1);
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_207986277)))){
r7append(((T7*)a1),_executable_name);
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_3494)))){
r34append_token(a1,((T0*)ms34_336));
r34append_token(a1,_executable_name);
r34add_x_suffix(C,a1);
}

}


void r34add_x_suffix(T34* C,T0* a1){
T0* _suffix=NULL;
_suffix=r34x_suffix(C);

if(!(r7has_suffix(((T7*)a1),_suffix))){
r7append(((T7*)a1),_suffix);
}

}


void r34external_c_files_for_lcc_win32(T34* C,T0* a1){
T0* _c_files=NULL;
T0* _c_file=NULL;
T2 _i=0;

if(!(((((T7*)(((T0*)ms34_0aaa)))->_count))==(INT8_C(0)))){
_c_files=r7split((T7*)(((T0*)ms34_0aaa)));
((((T7*)((T7*)(((T0*)ms34_0aaa)))))->_count)=((T2)(INT8_C(0)));


if((_c_files)!=((void*)(NULL))){
_i=((((T41*)_c_files))->_lower);
while (!((_i)>(((((T41*)_c_files))->_upper))))
{
_c_file=r41item(((T41*)_c_files),_i);
r7append(((T7*)a1),((T0*)ms34_3294));
r34append_token(a1,((T0*)ms34_0aaaaaaa));
r34append_token(a1,_c_file);
r7extend(((T7*)a1),((T3)'\n'));
{T7* C1=((T7*)_c_file);
T0* b1=((T0*)ms14_329);
r7remove_last(C1,((((T7*)b1))->_count));
}
r7append(((T7*)_c_file),r34object_suffix(C));
r34append_token(((T0*)ms34_0a),_c_file);
_i=(_i)+((T2)(INT8_C(1)));
}
}

}

}
T0*oBC14tmp_path=NULL;
T0*oBC34token_buffer=NULL;


void r34split_mode_c_compiler_command(T34* C,T0* a1,T0* a2){
((((T7*)(((T7*)a1))))->_count)=((T2)(INT8_C(0)));


if((((C)->_c_compiler))==((void*)(((T0*)ms34_3169)))){

if(r34is_c_plus_plus_file_path(a2)){
r7append(((T7*)a1),((T0*)ms34_2833));
}
else{
r7append(((T7*)a1),((T0*)ms34_3169));
}

r34append_token(a1,((T0*)ms34_0aaaaaaa));
r34append_token(a1,((T0*)ms34_0aaaaaa));
r34append_token(a1,((T0*)ms34_324));
r34append_token(a1,a2);
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_51699930)))){
r7append(((T7*)a1),((T0*)ms34_3294));
r34append_token(a1,((T0*)ms34_0aaaaaaa));
r34append_token(a1,((T0*)ms34_0aaaaaa));
r34append_token(a1,a2);
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_594)))){
r7append(((T7*)a1),((T0*)ms34_594));
r34append_token(a1,((T0*)ms34_0aaaaaaa));
r34append_token(a1,((T0*)ms34_0aaaaaa));
r34append_token(a1,((T0*)ms34_324));
r34append_token(a1,a2);
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_448859)))){
r7append(((T7*)a1),((T0*)ms34_447734));
r34append_token(a1,((T0*)ms34_0aaaaaaa));
r34append_token(a1,((T0*)ms34_0aaaaaa));
r34append_token(a1,a2);
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_76405)))){
r7append(((T7*)a1),((T0*)ms34_76405));
r34append_token(a1,((T0*)ms34_0aaaaaaa));
r34append_token(a1,((T0*)ms34_0aaaaaa));
r34append_token(a1,((T0*)ms34_324));
r34append_token(a1,a2);
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_603)))){
r7append(((T7*)a1),((T0*)ms34_603));
r34append_token(a1,((T0*)ms34_0aaaaaaa));
r34append_token(a1,((T0*)ms34_0aaaaaa));
r34append_token(a1,((T0*)ms34_324));
r34append_token(a1,a2);
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_674)))){
r7append(((T7*)a1),((T0*)ms34_674));
r34append_token(a1,r34sas_c_compiler_options((T6)(1)));
r34append_token(a1,((T0*)ms34_0aaaaaaa));
r34append_token(a1,((T0*)ms34_0aaaaaa));
r34append_token(a1,a2);
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_15721)))){
r7append(((T7*)a1),((T0*)ms34_3094));
r34append_token(a1,((T0*)ms34_0aaaaaaa));
r34append_token(a1,((T0*)ms34_0aaaaaa));
r34append_token(a1,((T0*)ms34_324));
r34append_token(a1,a2);
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_17794)))){
r7append(((T7*)a1),((T0*)ms34_689));
r34append_token(a1,((T0*)ms34_0aaaaaaa));
r34append_token(a1,((T0*)ms34_0aaaaaa));
r34append_token(a1,((T0*)ms34_324));
r34append_token(a1,a2);
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_3069)))){
r7append(((T7*)a1),((T0*)ms34_3069));
r34append_token(a1,((T0*)ms34_0aaaaaaa));
r34append_token(a1,((T0*)ms34_0aaaaaa));
r34append_token(a1,((T0*)ms34_324));
r34append_token(a1,a2);
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_18144)))){
r7append(((T7*)a1),((T0*)ms34_18144));
r34append_token(a1,((T0*)ms34_0aaaaaaa));
r34append_token(a1,((T0*)ms34_0aaaaaa));
r34append_token(a1,((T0*)ms34_324));
r34append_token(a1,a2);
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_207986277)))){
r7append(((T7*)a1),((T0*)ms34_683870135));
r7append(((T7*)a1),a2);
r7remove_last(((T7*)a1),(T2)(INT8_C(2)));
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_3494)))){
r7append(((T7*)a1),((T0*)ms34_3494));
r34append_token(a1,((T0*)ms34_0aaaaaaa));
r34append_token(a1,((T0*)ms34_0aaaaaa));
r34append_token(a1,((T0*)ms34_324));
r34append_token(a1,((T0*)ms34_336));
r34append_token(a1,a2);
r7remove_last(((T7*)a1),(T2)(INT8_C(2)));
r7append(((T7*)a1),r34object_suffix(C));
r34append_token(a1,a2);
}

}


void r34add_objects_(T34* C,T0* a1,T0* a2,T2 a3,T2 a4){
T2 _c=0;
T2 _i1=0;
T2 _i2=0;
T2 _new_min=0;

if((a3)>(a4)){
}
 else if((a3)<((T2)(INT8_C(9)))){
r34append_token(a1,a2);
r7append(((T7*)a1),((T0*)ms34_2565));
_i1=r2min((T2)(INT8_C(9)),a4);
r2append_in(_i1,a1);
r7extend(((T7*)a1),((T3)'\135'));
r7append(((T7*)a1),r34object_suffix(C));
r34add_objects_(C,a1,a2,(_i1)+((T2)(INT8_C(1))),a4);
}
 else if((a3)==(a4)){
r34append_token(a1,a2);
r2append_in(a3,a1);
r7append(((T7*)a1),r34object_suffix(C));
}
else{
_c=((a4)-(a3))+((T2)(INT8_C(1)));

if((_c)<=((T2)(INT8_C(10)))){
_i1=(a3)/((T2)(INT8_C(10)));
_i2=(a4)%((T2)(INT8_C(10)));
r34append_token(a1,a2);
r2append_in(_i1,a1);
r7extend(((T7*)a1),((T3)'\133'));
r7extend(((T7*)a1),((T3)'0'));
r7extend(((T7*)a1),((T3)'\55'));
r2append_in(_i2,a1);
r7extend(((T7*)a1),((T3)'\135'));
r7append(((T7*)a1),r34object_suffix(C));
}
 else if((_c)<((T2)(INT8_C(20)))){
r34add_objects_(C,a1,a2,a3,(a3)+((T2)(INT8_C(9))));
r34add_objects_(C,a1,a2,(a3)+((T2)(INT8_C(10))),a4);
}
else{
_i1=(a3)/((T2)(INT8_C(10)));
_i2=((a4)-((T2)(INT8_C(9))))/((T2)(INT8_C(10)));
r34append_token(a1,a2);
r7extend(((T7*)a1),((T3)'\133'));
r2append_in(_i1,a1);
r7extend(((T7*)a1),((T3)'\55'));
r2append_in(_i2,a1);
r7append(((T7*)a1),((T0*)ms34_355003));
r7append(((T7*)a1),r34object_suffix(C));
_new_min=((_i2)*((T2)(INT8_C(10))))+((T2)(INT8_C(10)));
r34add_objects_(C,a1,a2,_new_min,a4);
}

}

}


void r34default_c_compiler_options(T34* C,T6 a1){

if((((T0*)ms34_3169))==((void*)(((C)->_c_compiler)))){

if(a1){
r34append_token(((T0*)ms34_0aaaaaaa),((T0*)ms34_1570));
}

}
 else if((((T0*)ms34_2833))==((void*)(((C)->_c_compiler)))){

if(a1){
r34append_token(((T0*)ms34_0aaaaaaa),((T0*)ms34_1570));
}

}
 else if((((T0*)ms34_51699930))==((void*)(((C)->_c_compiler)))){

if(!(r7has((T7*)(((T0*)ms34_0aaaaaaa)),((T3)'O')))){
r34append_token(((T0*)ms34_0aaaaaaa),((T0*)ms34_304));
}

}
 else if((((T0*)ms34_594))==((void*)(((C)->_c_compiler)))){
}
 else if((((T0*)ms34_448859))==((void*)(((C)->_c_compiler)))){
}
 else if((((T0*)ms34_76405))==((void*)(((C)->_c_compiler)))){

if(((((T7*)(((T0*)ms34_0aaaaaaa)))->_count))==(INT8_C(0))){
r7copy((T7*)(((T0*)ms34_0aaaaaaa)),((T0*)ms34_836475934));
}

}
 else if((((T0*)ms34_603))==((void*)(((C)->_c_compiler)))){

if(((((T7*)(((T0*)ms34_0aaaaaaa)))->_count))==(INT8_C(0))){
r7copy((T7*)(((T0*)ms34_0aaaaaaa)),((T0*)ms34_616914401));
}

}
 else if((((T0*)ms34_674))==((void*)(((C)->_c_compiler)))){

if(a1){

if(!(r34Scoptions_exists())){
r34append_token(((T0*)ms34_0aaaaaaa),((T0*)ms34_426884100));
}

}
else{
((((T7*)((T7*)(((T0*)ms34_0aaaaaaa)))))->_count)=((T2)(INT8_C(0)));

r7copy((T7*)(((T0*)ms34_0aaaaa)),((T0*)ms34_12782));

if(!(r34Scoptions_exists())){
r34append_token(((T0*)ms34_0aaaaa),((T0*)ms34_698995372));
}

}

}
 else if((((T0*)ms34_15721))==((void*)(((C)->_c_compiler)))){

if(((((T7*)(((T0*)ms34_0aaaaaaa)))->_count))==(INT8_C(0))){
r7copy((T7*)(((T0*)ms34_0aaaaaaa)),((T0*)ms34_1091987));
}

}
 else if((((T0*)ms34_17794))==((void*)(((C)->_c_compiler)))){

if(((((T7*)(((T0*)ms34_0aaaaaaa)))->_count))==(INT8_C(0))){

if((((T0*)ms34_57487))==((void*)(((C)->_system_name)))){
r7copy((T7*)(((T0*)ms34_0aaaaaaa)),((T0*)ms34_968120));
}

}

}
 else if((((T0*)ms34_3069))==((void*)(((C)->_c_compiler)))){

if(((((T7*)(((T0*)ms34_0aaaaaaa)))->_count))==(INT8_C(0))){
r7copy((T7*)(((T0*)ms34_0aaaaaaa)),((T0*)ms34_1570));
}

}
 else if((((T0*)ms34_18144))==((void*)(((C)->_c_compiler)))){
}
 else if((((T0*)ms34_207986277))==((void*)(((C)->_c_compiler)))){
}
 else if((((T0*)ms34_3494))==((void*)(((C)->_c_compiler)))){
}
else{
}

}
T0*oBC34object_suffix=NULL;
int fBC34object_suffix=0;


T0* r34object_suffix(T34* C){
if(fBC34object_suffix==0){fBC34object_suffix=1;{

if((((C)->_c_compiler))==((void*)(((T0*)ms34_3169)))){
oBC34object_suffix=((T0*)ms34_341);
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_51699930)))){
oBC34object_suffix=((T0*)ms34_9121);
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_594)))){
oBC34object_suffix=((T0*)ms34_341);
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_448859)))){
oBC34object_suffix=((T0*)ms34_9121);
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_76405)))){
oBC34object_suffix=((T0*)ms34_9121);
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_603)))){
oBC34object_suffix=((T0*)ms34_9121);
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_674)))){
oBC34object_suffix=((T0*)ms34_341);
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_15721)))){
oBC34object_suffix=((T0*)ms34_341);
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_17794)))){
oBC34object_suffix=((T0*)ms34_341);
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_3069)))){
oBC34object_suffix=((T0*)ms34_341);
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_18144)))){
oBC34object_suffix=((T0*)ms34_341);
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_207986277)))){
oBC34object_suffix=((T0*)ms34_9121);
r7to_upper(((T7*)oBC34object_suffix));
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_3494)))){
oBC34object_suffix=((T0*)ms34_341);
}

}}
return oBC34object_suffix;
}


void r34subdirectory(T34* C,T0* a1,T0* a2){
r34set_basic_directory_notation(C);
r35compute_subdirectory_with(a1,a2);
r7copy(((T7*)a1),oBC35last_entry);
}


void r34make(T34* C){
T0* _system_se_path=NULL;
T2 _i=0;
_system_se_path=r31getenv(((T0*)ms15_1072344038),NULL);

if((_system_se_path)==((void*)(NULL))){
_system_se_path=r7twin((T7*)(((T0*)ms15_1072344038)));
r7to_upper(((T7*)_system_se_path));
_system_se_path=r31getenv(_system_se_path,NULL);

if((_system_se_path)==((void*)(NULL))){
r31put_string((T31*)(oBC14echo),((T0*)ms34_1327525317));
_system_se_path=((T0*)se_ms(34,"/usr/lib/SmartEiffel/sys/system.se"));
r31put_string((T31*)(oBC14echo),_system_se_path);
r31put_string((T31*)(oBC14echo),((T0*)ms15_216));
}

}
else{
r31put_string((T31*)(oBC14echo),((T0*)ms34_1038797513));
r31put_string((T31*)(oBC14echo),_system_se_path);
r31put_string((T31*)(oBC14echo),((T0*)ms15_1090));
}


if(r7has_suffix(((T7*)_system_se_path),((T0*)ms15_56612951))){
r31tfr_connect((T31*)(oBC14echo),oBC14tmp_file_read,_system_se_path);
}
else{
r31put_string((T31*)(oBC14echo),((T0*)se_ms(269,"You should update the value of the \"SmartEiffel\" system environment variable.\nSince release -0.79, the \"SmartEiffel\" system environment variable must be the absolute path of the \"system.se\" file.\nFor example \"/usr/lib/SmartEiffel/sys/system.se\" under Unix like system.\n")));

if(r7has(((T7*)_system_se_path),((T3)'\57'))){
r31put_string((T31*)(oBC14echo),((T0*)ms34_467476687));
r7copy((T7*)(oBC14tmp_path),_system_se_path);
r7extend_unless((T7*)(oBC14tmp_path),((T3)'\57'));
r7append((T7*)(oBC14tmp_path),((T0*)ms15_3595));
r7extend((T7*)(oBC14tmp_path),((T3)'\57'));
r7append((T7*)(oBC14tmp_path),((T0*)ms15_56612951));
r31tfr_connect((T31*)(oBC14echo),oBC14tmp_file_read,oBC14tmp_path);
}


if(!(((((T36*)(oBC14tmp_file_read))->_path))!=(NULL))){

if(r7has(((T7*)_system_se_path),((T3)'\134'))){
r31put_string((T31*)(oBC14echo),((T0*)ms34_581585530));
r7copy((T7*)(oBC14tmp_path),_system_se_path);
r7extend_unless((T7*)(oBC14tmp_path),((T3)'\134'));
r7append((T7*)(oBC14tmp_path),((T0*)ms15_3595));
r7extend((T7*)(oBC14tmp_path),((T3)'\134'));
r7append((T7*)(oBC14tmp_path),((T0*)ms15_56612951));
r31tfr_connect((T31*)(oBC14echo),oBC14tmp_file_read,oBC14tmp_path);
}

}


if(!(((((T36*)(oBC14tmp_file_read))->_path))!=(NULL))){

if(r7has(((T7*)_system_se_path),((T3)'\72'))){
r31put_string((T31*)(oBC14echo),((T0*)ms34_1631212670));
r7copy((T7*)(oBC14tmp_path),_system_se_path);
r7extend_unless((T7*)(oBC14tmp_path),((T3)'\72'));
r7append((T7*)(oBC14tmp_path),((T0*)ms15_3595));
r7extend((T7*)(oBC14tmp_path),((T3)'\72'));
r7append((T7*)(oBC14tmp_path),((T0*)ms15_56612951));
r31tfr_connect((T31*)(oBC14echo),oBC14tmp_file_read,oBC14tmp_path);
}

}


if(!(((((T36*)(oBC14tmp_file_read))->_path))!=(NULL))){

if(r7has(((T7*)_system_se_path),((T3)'\135'))){
r31put_string((T31*)(oBC14echo),((T0*)ms34_128214728));
r7copy((T7*)(oBC14tmp_path),_system_se_path);
r7extend_unless((T7*)(oBC14tmp_path),((T3)'\135'));
r7remove_last((T7*)(oBC14tmp_path),(T2)(INT8_C(1)));
r7extend((T7*)(oBC14tmp_path),((T3)'\56'));
r7append((T7*)(oBC14tmp_path),((T0*)ms15_3595));
r7extend((T7*)(oBC14tmp_path),((T3)'\135'));
r7append((T7*)(oBC14tmp_path),((T0*)ms15_56612951));
r31tfr_connect((T31*)(oBC14echo),oBC14tmp_file_read,oBC14tmp_path);
}

}


if(!(((((T36*)(oBC14tmp_file_read))->_path))!=(NULL))){
r31put_string((T31*)(oBC14echo),((T0*)ms34_1106932385));
r7copy((T7*)(oBC14tmp_path),_system_se_path);
r7append((T7*)(oBC14tmp_path),((T0*)ms15_56612951));
r31tfr_connect((T31*)(oBC14echo),oBC14tmp_file_read,oBC14tmp_path);
}

}


if(!(((((T36*)(oBC14tmp_file_read))->_path))!=(NULL))){
r31w_put_string(((T0*)se_ms(244,"Unable to find file \"system.se\".\nPlease, set the environment variable \"SmartEiffel\" with the appropriate absolute path to this file.\nExample for Unix: \"/usr/lib/SmartEiffel/sys/system.se\"\nExample for DOS/Windows: \"C:\\SmartEiffel\\sys\\system.se\"\n")));
exit(INT8_C(1));
}

r36read_line((T36*)(oBC14tmp_file_read));
(C->_system_name)=oBC27last_string;
_i=r41index_of((T41*)(oBC34system_list),((C)->_system_name));

if((_i)>((((T41*)(oBC34system_list))->_upper))){
r31w_put_string(((T0*)ms34_179868158));
r31w_put_string((((T36*)(oBC14tmp_file_read))->_path));
r31w_put_string(((T0*)ms34_373286592));
_i=(T2)(INT8_C(1));
while (!((_i)>((((T41*)(oBC34system_list))->_upper))))
{
r31w_put_string(r41item((T41*)(oBC34system_list),_i));
r31w_put_character(((T3)'\n'));
_i=(_i)+((T2)(INT8_C(1)));
}
exit(INT8_C(1));
}
else{
(C->_system_name)=r41item((T41*)(oBC34system_list),_i);
r31put_string((T31*)(oBC14echo),((T0*)ms34_1102814319));
r31put_string((T31*)(oBC14echo),((C)->_system_name));
r31put_string((T31*)(oBC14echo),((T0*)ms15_1090));
}

(C->_sys_directory)=r7twin((T7*)((((T36*)(oBC14tmp_file_read))->_path)));
{T7* C1=(T7*)(((C)->_sys_directory));
T0* b1=((T0*)ms15_56612951);
r7remove_last(C1,((((T7*)b1))->_count));
}
r36disconnect((T36*)(oBC14tmp_file_read));
(C->_bin_directory)=r7twin((T7*)(((C)->_sys_directory)));
r34parent_directory(C,((C)->_bin_directory));
r34subdirectory(C,((C)->_bin_directory),((T0*)ms15_3085));
}


void r34parent_directory(T34* C,T0* a1){
r34set_basic_directory_notation(C);
r35compute_parent_directory_of(a1);
r7copy(((T7*)a1),oBC35last_entry);
}


void r34show_compiler_list_then_exit(T34* C){
T2 _i=0;
r31w_put_string(((T0*)ms34_270309168));
_i=(T2)(INT8_C(1));
while (!((_i)>((((T41*)(oBC34compiler_list))->_upper))))
{
r31w_put_string(r41item((T41*)(oBC34compiler_list),_i));
r31w_put_character(((T3)'\n'));
_i=(_i)+((T2)(INT8_C(1)));
}
exit(INT8_C(1));
}
T0*oBC14echo=NULL;


void r34add_external_lib(T34* C,T0* a1){
((((T7*)((T7*)(oBC34token_buffer))))->_count)=((T2)(INT8_C(0)));


if((T6)(((T6)(((((C)->_c_compiler))==((void*)(((T0*)ms34_51699930))))||((T6)((((C)->_c_compiler))==((void*)(((T0*)ms34_603)))))))||((T6)((((C)->_c_compiler))==((void*)(((T0*)ms34_76405))))))){
}
else{

if(((((((T7*)a1))->_storage))[((T2)(INT8_C(1)))-(INT8_C(1))])!=(((T3)'\55'))){

if((T6)((!(r7has(((T7*)a1),((T3)'\57'))))&&((T6)(!(r7has(((T7*)a1),((T3)'\134'))))))){
r7copy((T7*)(oBC34token_buffer),((T0*)ms34_333));
}

}

}

r7append_string((T7*)(oBC34token_buffer),a1);
r7extend_unless((T7*)(oBC34token_buffer),((T3)'\40'));
r34do_add_external_lib(oBC34token_buffer);
}


void r34command_path_in(T34* C,T0* a1,T0* a2){

if((((C)->_system_name))==((void*)(((T0*)ms34_1663868)))){
r7append(((T7*)a1),((T0*)ms34_16702));
}

r7append(((T7*)a1),((C)->_bin_directory));
r7append(((T7*)a1),a2);
r7append(((T7*)a1),r34x_suffix(C));
}


T6 r34is_c_plus_plus_file_path(T0* a1){
T6 R=0;

if(r7has_suffix(((T7*)a1),((T0*)ms14_8897))){
R=((T6)(1));
}
 else if(r7has_suffix(((T7*)a1),((T0*)ms34_1744))){
R=((T6)(1));
}
 else if(r7has_suffix(((T7*)a1),((T0*)ms34_297))){
R=((T6)(1));
}

return R;
}
T0*oBC14ace=NULL;
T0*oBC34x_suffix=NULL;
int fBC34x_suffix=0;


T0* r34x_suffix(T34* C){
if(fBC34x_suffix==0){fBC34x_suffix=1;{

if((((T0*)ms34_2178))==((void*)(((C)->_system_name)))){
oBC34x_suffix=((T0*)ms34_8976);
r7to_upper(((T7*)oBC34x_suffix));
}
 else if((((T0*)ms34_1663868))==((void*)(((C)->_system_name)))){
oBC34x_suffix=((T0*)ms34_8976);
r7to_upper(((T7*)oBC34x_suffix));
}
 else if((((T0*)ms34_2440))==((void*)(((C)->_system_name)))){
oBC34x_suffix=((T0*)ms34_8976);
}
 else if((((T0*)ms34_1772235))==((void*)(((C)->_system_name)))){
oBC34x_suffix=((T0*)ms34_8976);
}
 else if((((T0*)ms34_301485))==((void*)(((C)->_system_name)))){
oBC34x_suffix=((T0*)ms34_8976);
}
 else if((((T0*)ms34_59731))==((void*)(((C)->_system_name)))){
oBC34x_suffix=((T0*)ms34_1438);
}
else{
{T7*n=((T7*)se_malloc(sizeof(*n)));
*n=M7;
oBC34x_suffix=((T0*)n);
r7make(n,(T2)(INT8_C(4)));
}
}

}}
return oBC34x_suffix;
}
T0*oBC34compiler_list=NULL;
int fBC34add_lib_math=0;


void r34add_lib_math(T34* C){
if(fBC34add_lib_math==0){fBC34add_lib_math=1;{

if((((T0*)ms34_11253))==((void*)(((C)->_system_name)))){
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_3169)))){
r34add_external_lib(C,((T0*)ms34_109));
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_603)))){
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_674)))){
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_15721)))){
r34add_external_lib(C,((T0*)ms34_109));
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_17794)))){

if((((T0*)ms34_57487))==((void*)(((C)->_system_name)))){
r34add_external_lib(C,((T0*)ms34_84381));
}
else{
r34add_external_lib(C,((T0*)ms34_109));
}

}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_3069)))){
r34add_external_lib(C,((T0*)ms34_15828));
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_18144)))){
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_207986277)))){
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_3494)))){
r34add_external_lib(C,((T0*)ms34_109));
}

}}}


void r34add_objects(T34* C,T0* a1,T0* a2,T2 a3){
T2 _i=0;
T6 _short_command=0;

if(r2in_range(a3,(T2)(INT8_C(3)),(T2)(INT8_C(99)))){

if((((T0*)ms34_13028))==((void*)(((C)->_system_name)))){
_short_command=((T6)(1));
}
 else if((((T0*)ms34_301485))==((void*)(((C)->_system_name)))){
_short_command=((T6)(1));
}

}


if(_short_command){
r34add_objects_(C,a1,a2,(T2)(INT8_C(1)),a3);
}
else{
_i=(T2)(INT8_C(1));
while (!((_i)>(a3)))
{
r34append_token(a1,a2);
r2append_in(_i,a1);
r7append(((T7*)a1),r34object_suffix(C));
_i=(_i)+((T2)(INT8_C(1)));
}
}

}


void r34do_add_external_lib(T0* a1){

if(!(r7has_substring((T7*)(((T0*)ms34_0)),a1))){
r34append_token(((T0*)ms34_0),a1);
}

}
int fBC34set_basic_directory_notation=0;


void r34set_basic_directory_notation(T34* C){
if(fBC34set_basic_directory_notation==0){fBC34set_basic_directory_notation=1;{
T0* _s=NULL;
T3 _letter_code=0;
_s=((C)->_system_name);

if((_s)==((void*)(NULL))){
}
 else if((_s)==((void*)(((T0*)ms34_13028)))){
_letter_code=((T3)'U');
}
 else if((T6)(((T6)(((_s)==((void*)(((T0*)ms34_1772235))))||((T6)((_s)==((void*)(((T0*)ms34_2178)))))))||((T6)((_s)==((void*)(((T0*)ms34_2440))))))){
_letter_code=((T3)'W');
}
 else if((_s)==((void*)(((T0*)ms34_11253)))){
_letter_code=((T3)'U');
}
 else if((_s)==((void*)(((T0*)ms34_39617954)))){
_letter_code=((T3)'M');
}
 else if((_s)==((void*)(((T0*)ms34_57487)))){
_letter_code=((T3)'A');
}
 else if((_s)==((void*)(((T0*)ms34_1663868)))){
_letter_code=((T3)'V');
}
 else if((_s)==((void*)(((T0*)ms34_301485)))){
_letter_code=((T3)'C');
}
 else if((_s)==((void*)(((T0*)ms34_59731)))){
_letter_code=((T3)'U');
}
else{
}


if((_s)!=((void*)(NULL))){
((((T7*)(((T0*)ms35_63)))->_storage))[((T2)(INT8_C(1)))-(INT8_C(1))]=(_letter_code);

}

}}}


T0* r34sas_c_compiler_options(T6 a1){
T0* R=NULL;

if(r34Scoptions_exists()){
R=((T0*)ms34_0aaaaaaaa);
}
else{
{T7*n=((T7*)se_malloc(sizeof(*n)));
*n=M7;
r7make(n,(T2)(INT8_C(0)));
R=((T0*)n);
}
r7append(((T7*)R),((T0*)ms34_1721407046));

if(a1){
r7append(((T7*)R),((T0*)ms34_19761224));
}
else{
r7append(((T7*)R),((T0*)ms34_98806116));
}

r7append(((T7*)R),((T0*)ms34_1494914262));
r7append(((T7*)R),((T0*)ms34_721564652));
}

return R;
}


void r34split_mode_linker_command(T34* C,T0* a1,T0* a2,T2 a3){
T0* _script=NULL;
T0* _lst=NULL;
T2 _i=0;
T0* _name=NULL;
((((T7*)(((T7*)a1))))->_count)=((T2)(INT8_C(0)));


if((((C)->_c_compiler))==((void*)(((T0*)ms34_3169)))){

if(((((T7*)(((T0*)ms34_0aa)))->_count))==(INT8_C(0))){
r7append(((T7*)a1),((T0*)ms34_3169));
}
else{
r7append(((T7*)a1),((T0*)ms34_2833));
}

r34append_token(a1,((T0*)ms34_0aaaaaaa));
r34append_token(a1,((T0*)ms34_0aaaaaa));
r34append_token(a1,((T0*)ms34_0aaaaa));
r34append_token(a1,((T0*)ms34_0aaaa));
r34add_executable_name(C,a1);
r34add_objects(C,a1,a2,a3);
r34append_token(a1,((T0*)ms34_0aaa));
r34append_token(a1,((T0*)ms34_0aa));
r34append_token(a1,((T0*)ms34_0a));
r34append_token(a1,((T0*)ms34_0));
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_51699930)))){
r34external_c_files_for_lcc_win32(C,a1);
r7append(((T7*)a1),((T0*)ms34_415107));

if(!(((C)->_no_strip))){
r34append_token(a1,((T0*)ms34_340));
}

r34append_token(a1,((T0*)ms34_0aaaaa));
r34add_executable_name(C,a1);

if((a3)<((T2)(INT8_C(4)))){
r34add_objects(C,a1,a2,a3);
}
else{
_name=a2;
r7append(((T7*)_name),((T0*)ms34_9107));
r34append_token(a1,r7_ix_43(se_ms(1,"@"),_name));
{T48*n=((T48*)se_malloc(sizeof(*n)));
*n=M48;
r48make(n);
_lst=((T0*)n);
}
r31tfw_connect((T31*)(oBC14echo),_lst,_name);
r7remove_last(((T7*)_name),(T2)(INT8_C(4)));
_i=(T2)(INT8_C(1));
while (!((_i)>(a3)))
{
r48put_string(((T48*)_lst),_name);
r48put_integer(((T48*)_lst),(T11)(_i));
r48put_string(((T48*)_lst),((T0*)ms34_9121));
r48put_character(((T48*)_lst),((T3)'\n'));

_i=(_i)+((T2)(INT8_C(1)));
}
r48disconnect(((T48*)_lst));
}

r34append_token(a1,((T0*)ms34_0a));
r34append_token(a1,((T0*)ms34_0));
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_594)))){
r7append(((T7*)a1),((T0*)ms34_594));
r34append_token(a1,((T0*)ms34_0aaaaaaa));
r34append_token(a1,((T0*)ms34_0aaaaaa));
r34append_token(a1,((T0*)ms34_0aaaaa));
r34append_token(a1,((T0*)ms34_0aaaa));
r34add_executable_name(C,a1);
r34add_objects(C,a1,a2,a3);
r34append_token(a1,((T0*)ms34_0aaa));
r34append_token(a1,((T0*)ms34_0aa));
r34append_token(a1,((T0*)ms34_0a));
r34append_token(a1,((T0*)ms34_0));
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_448859)))){
r7append(((T7*)a1),((T0*)ms34_91157));
r34append_token(a1,((T0*)ms34_0aaaaaaa));
r34append_token(a1,((T0*)ms34_0aaaaaa));
r34append_token(a1,((T0*)ms34_0aaaaa));
r34append_token(a1,((T0*)ms34_0aaaa));
r34add_executable_name(C,a1);
r34add_objects(C,a1,a2,a3);
r34append_token(a1,((T0*)ms34_0aaa));
r34append_token(a1,((T0*)ms34_0aa));
r34append_token(a1,((T0*)ms34_0a));
r34append_token(a1,((T0*)ms34_0));
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_76405)))){
r7append(((T7*)a1),((T0*)ms34_76405));
r34append_token(a1,((T0*)ms34_0aaaaaaa));
r34append_token(a1,((T0*)ms34_0aaaaaa));
r34append_token(a1,((T0*)ms34_0aaaaa));
r34append_token(a1,((T0*)ms34_0aaaa));
r34add_executable_name(C,a1);
r34add_objects(C,a1,a2,a3);
r34append_token(a1,((T0*)ms34_0aaa));
r34append_token(a1,((T0*)ms34_0aa));
r34append_token(a1,((T0*)ms34_0a));
r34append_token(a1,((T0*)ms34_0));
r34add_lib_math(C);
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_603)))){
r7append(((T7*)a1),((T0*)ms34_603));
r34append_token(a1,((T0*)ms34_0aaaaaaa));
r34append_token(a1,((T0*)ms34_0aaaaaa));
r34add_executable_name(C,a1);
r34add_objects(C,a1,a2,a3);
r34append_token(a1,((T0*)ms34_0aaa));
r34append_token(a1,((T0*)ms34_0aa));
r34append_token(a1,((T0*)ms34_0a));
r34append_token(a1,((T0*)ms34_146157));
r34append_token(a1,((T0*)ms34_0aaaaa));
r34append_token(a1,((T0*)ms34_0aaaa));
r34append_token(a1,((T0*)ms34_0));
r34add_lib_math(C);
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_674)))){
r7append(((T7*)a1),((T0*)ms34_674));
r34append_token(a1,r34sas_c_compiler_options((T6)(1)));
r34append_token(a1,((T0*)ms34_0aaaaaaa));
r34append_token(a1,((T0*)ms34_0aaaaaa));
r34append_token(a1,((T0*)ms34_0aaaaa));
r34append_token(a1,a2);
r7append(((T7*)a1),((T0*)ms34_2075119688));
r34append_token(a1,((T0*)ms34_0aaa));
r34append_token(a1,((T0*)ms34_0aa));
r34append_token(a1,((T0*)ms34_0a));
r34append_token(a1,((T0*)ms34_0));
r34add_executable_name(C,a1);

if(!(((C)->_no_strip))){
r7append(((T7*)a1),((T0*)ms34_530877013));
}

}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_15721)))){
r7append(((T7*)a1),((T0*)ms34_3094));
r34append_token(a1,((T0*)ms34_0aaaaaaa));
r34append_token(a1,((T0*)ms34_0aaaaaa));
r34append_token(a1,((T0*)ms34_0aaaaa));
r34append_token(a1,((T0*)ms34_0aaaa));
r34add_executable_name(C,a1);
r34add_objects(C,a1,a2,a3);
r34append_token(a1,((T0*)ms34_0aaa));
r34append_token(a1,((T0*)ms34_0aa));
r34append_token(a1,((T0*)ms34_0a));
r34append_token(a1,((T0*)ms34_0));

if(((C)->_no_strip)){
r34append_token(a1,((T0*)ms34_218174));
}

r34add_lib_math(C);
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_17794)))){
r7append(((T7*)a1),((T0*)ms34_689));
r34append_token(a1,((T0*)ms34_0aaaaaaa));
r34append_token(a1,((T0*)ms34_0aaaaaa));
r34append_token(a1,((T0*)ms34_0aaaaa));
r34append_token(a1,((T0*)ms34_0aaaa));
r34add_executable_name(C,a1);
r34add_lib_math(C);
r34add_objects(C,a1,a2,a3);
r34append_token(a1,((T0*)ms34_0aaa));
r34append_token(a1,((T0*)ms34_0aa));
r34append_token(a1,((T0*)ms34_0a));
r34append_token(a1,((T0*)ms34_0));
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_3069)))){
r7append(((T7*)a1),((T0*)ms34_3069));
r34append_token(a1,((T0*)ms34_0aaaaaaa));
r34append_token(a1,((T0*)ms34_0aaaaaa));
r34append_token(a1,((T0*)ms34_0aaaaa));
r34append_token(a1,((T0*)ms34_0aaaa));
r34add_executable_name(C,a1);
r34add_objects(C,a1,a2,a3);
r34append_token(a1,((T0*)ms34_0aaa));
r34append_token(a1,((T0*)ms34_0aa));
r34append_token(a1,((T0*)ms34_0a));
r34append_token(a1,((T0*)ms34_0));
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_18144)))){
r7append(((T7*)a1),((T0*)ms34_18144));
r34append_token(a1,((T0*)ms34_0aaaaaaa));
r34append_token(a1,((T0*)ms34_0aaaaaa));
r34append_token(a1,((T0*)ms34_0aaaaa));
r34append_token(a1,((T0*)ms34_0aaaa));
r34add_executable_name(C,a1);
r34add_objects(C,a1,a2,a3);
r34append_token(a1,((T0*)ms34_0aaa));
r34append_token(a1,((T0*)ms34_0aa));
r34append_token(a1,((T0*)ms34_0a));
r34append_token(a1,((T0*)ms34_0));
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_207986277)))){
{T48*n=((T48*)se_malloc(sizeof(*n)));
*n=M48;
r48make(n);
_script=((T0*)n);
}
r31tfw_connect((T31*)(oBC14echo),_script,((T0*)ms34_262628264));
r48put_string(((T48*)_script),((T0*)ms34_466551816));
((((T7*)(((T7*)a1))))->_count)=((T2)(INT8_C(0)));

r34add_executable_name(C,a1);
r48put_string(((T48*)_script),a1);
r48put_character(((T48*)_script),((T3)'\40'));
_i=(T2)(INT8_C(1));
while (!((_i)>=(a3)))
{
r48put_string(((T48*)_script),a2);
r48put_integer(((T48*)_script),(T11)(_i));
r48put_string(((T48*)_script),((T0*)ms34_1335));
_i=(_i)+((T2)(INT8_C(1)));
}
r48put_string(((T48*)_script),a2);
r48put_integer(((T48*)_script),(T11)(_i));
r48put_character(((T48*)_script),((T3)'\n'));
r48disconnect(((T48*)_script));
((((T7*)(((T7*)a1))))->_count)=((T2)(INT8_C(0)));

r7append(((T7*)a1),((T0*)ms34_1361085152));
}
 else if((((C)->_c_compiler))==((void*)(((T0*)ms34_3494)))){
r7append(((T7*)a1),((T0*)ms34_3494));
r34append_token(a1,((T0*)ms34_0aaaaaaa));
r34append_token(a1,((T0*)ms34_0aaaaaa));
r34append_token(a1,((T0*)ms34_0aaaaa));
r34append_token(a1,((T0*)ms34_0aaaa));
r34add_executable_name(C,a1);
r34append_token(a1,((T0*)ms34_0));
r34add_objects(C,a1,a2,a3);
r34append_token(a1,((T0*)ms34_0aaa));
r34append_token(a1,((T0*)ms34_0a));
}

}


void r34remove_other_extra_files(T34* C,T0* a1){
T0* _n=NULL;

if((T6)(((((C)->_c_compiler))==((void*)(((T0*)ms34_51699930))))||((T6)((((C)->_c_compiler))==((void*)(((T0*)ms34_674))))))){
_n=r7_ix_43(((T7*)a1),((T0*)ms34_9107));
r31file_removing((T31*)(oBC14echo),_n);
}

}


T2 r44upper(T44* C){
T2 R=0;
R=((((T47*)(((C)->_name_list)))->_upper))+((T2)(INT8_C(1)));
return R;
}


void r44make(T44* C){

if((((C)->_name_list))==((void*)(NULL))){
{T47*n=((T47*)se_malloc(sizeof(*n)));
*n=M47;
r47with_capacity(n,(T2)(INT8_C(32)));
(C->_name_list)=((T0*)n);
}
}
else{
((((T47*)((T47*)(((C)->_name_list)))))->_upper)=((T2)(INT8_C(-1)));

}

}


void r44scan_current_working_directory(T44* C){
T0* _entry=NULL;
r44make(C);
r35connect_to_current_working_directory(&(((C)->_basic_directory)));

if((NULL!=((((C)->_basic_directory))._directory_stream))){
(C->_path)=r7twin((T7*)(oBC35last_entry));
r35read_entry(&(((C)->_basic_directory)));
while (!(r8is_null(((T8)(((((C)->_basic_directory))._current_entry))))))
{
_entry=r7twin((T7*)(oBC35last_entry));
r47add_last((T47*)(((C)->_name_list)),_entry);
r35read_entry(&(((C)->_basic_directory)));
}
r35disconnect(&(((C)->_basic_directory)));
(C->_last_scan_status)=((T6)(1));
}
else{
(C->_last_scan_status)=((T6)(0));
}

}


void r48disconnect(T48* C){

if((((C)->_buffer_position))>((T2)(INT8_C(0)))){
r48write_buffer(C);
}

basic_io_fclose(((C)->_output_stream));
(C->_path)=NULL;
}
T0*oBC30tmp_string=NULL;


void r48make(T48* C){
(C->_buffer)=((T9)(se_calloc((T2)(INT16_C(4096)),sizeof(T3))));
(C->_capacity)=(T2)(INT16_C(4096));
}


void r48connect_to(T48* C,T0* a1){
T8 _p=NULL;
_p=r7to_external(((T7*)a1));
(C->_output_stream)=basic_io_text_file_write_open(_p);

if((NULL!=((C)->_output_stream))){
(C->_path)=a1;

if((((C)->_capacity))==(INT8_C(0))){
(C->_buffer)=((T9)(se_calloc((T2)(INT16_C(4096)),sizeof(T3))));
(C->_capacity)=(T2)(INT16_C(4096));
}

}

}


void r48put_integer(T48* C,T11 a1){
((((T7*)((T7*)(oBC30tmp_string))))->_count)=((T2)(INT8_C(0)));

r11append_in(a1,oBC30tmp_string);
r48put_string(C,oBC30tmp_string);
}


void r48write_buffer(T48* C){

if((((C)->_buffer_position))>((T2)(INT8_C(0)))){
basic_io_fwrite(((C)->_buffer),((C)->_buffer_position),((C)->_output_stream));
(C->_buffer_position)=(T2)(INT8_C(0));
}

}


void r48put_character(T48* C,T3 a1){

if((((C)->_buffer_position))>=((T2)(INT16_C(4096)))){
r48write_buffer(C);
}

(((C)->_buffer))[((C)->_buffer_position)]=(a1);
(C->_buffer_position)=(((C)->_buffer_position))+((T2)(INT8_C(1)));
}


void r48put_string(T48* C,T0* a1){
T2 _i=0;
T2 _count=0;
_i=(T2)(INT8_C(1));
_count=((((T7*)a1))->_count);
while (!((_i)>(_count)))
{
r48put_character(C,(((((T7*)a1))->_storage))[(_i)-(INT8_C(1))]);
_i=(_i)+((T2)(INT8_C(1)));
}
}


void r29make(T29* C){
(C->_buffer)=((T9)(se_calloc((T2)(INT16_C(4096)),sizeof(T3))));
(C->_capacity)=(T2)(INT16_C(4096));
}


void r29flush(T29* C){

if((((C)->_buffer_position))>((T2)(INT8_C(0)))){
r29write_buffer(C);
}

basic_io_flush(basic_io_stdout);
}


void r29write_buffer(T29* C){

if((((C)->_buffer_position))>((T2)(INT8_C(0)))){
basic_io_fwrite(((C)->_buffer),((C)->_buffer_position),basic_io_stdout);
(C->_buffer_position)=(T2)(INT8_C(0));
}

}


void r29put_character(T29* C,T3 a1){

if((((C)->_buffer_position))>=((T2)(INT16_C(4096)))){
r29write_buffer(C);
}

(((C)->_buffer))[((C)->_buffer_position)]=(a1);
(C->_buffer_position)=(((C)->_buffer_position))+((T2)(INT8_C(1)));

if((a1)==(((T3)'\n'))){
r29write_buffer(C);
}

}


void r29put_string(T29* C,T0* a1){
T2 _i=0;
T2 _count=0;
_i=(T2)(INT8_C(1));
_count=((((T7*)a1))->_count);
while (!((_i)>(_count)))
{
r29put_character(C,(((((T7*)a1))->_storage))[(_i)-(INT8_C(1))]);
_i=(_i)+((T2)(INT8_C(1)));
}
}


void r33put_string(T0* a1){
T2 _i=0;
T2 _count=0;
_i=(T2)(INT8_C(1));
_count=((((T7*)a1))->_count);
while (!((_i)>(_count)))
{
{T3 b1=(((((T7*)a1))->_storage))[(_i)-(INT8_C(1))];
basic_io_putc(b1,basic_io_stderr);
}
_i=(_i)+((T2)(INT8_C(1)));
}
}


T6 r45file_exists(T0* a1){
T6 R=0;
R=((T6)(r45is_readable(a1)));
return R;
}


void r45rename_to(T0* a1,T0* a2){
T8 _p1=NULL;
T8 _p2=NULL;

if(r45file_exists(a2)){
r45delete(a2);
}

_p1=r7to_external(((T7*)a1));
_p2=r7to_external(((T7*)a2));
basic_io_rename(_p1,_p2);
}
T0*oBC45tfr1=NULL;


void r45delete(T0* a1){
T8 _p=NULL;
_p=r7to_external(((T7*)a1));
basic_io_remove(_p);
}


T6 r45is_readable(T0* a1){
T6 R=0;
r36connect_to((T36*)(oBC45tfr1),a1);
R=((T6)(((((T36*)(oBC45tfr1))->_path))!=(NULL)));

if(R){
r36disconnect((T36*)(oBC45tfr1));
}

return R;
}


void r12prepare_bin_c_directory(T12* C){
T2 _i=0;
T0* _args=NULL;
T0* _item=NULL;
_i=(T2)(INT8_C(1));
while (!((_i)>(r41count((T41*)(oBC12no_split_command_list)))))
{
_item=r41item((T41*)(oBC12no_split_command_list),_i);

if(r7same_as(se_ms(9,"lcc-win32"),((C)->_c_compiler_name))){
_args=((T0*)se_ms(16,"-boost -no_split"));
}
else{
_args=((T0*)se_ms(23,"-boost -no_split -no_gc"));
}

r12call_compile_to_c(_args,_item);
_i=(_i)+((T2)(INT8_C(1)));
}
_i=(T2)(INT8_C(1));
while (!((_i)>(r41count((T41*)(oBC12splitted_command_list)))))
{
_item=r41item((T41*)(oBC12splitted_command_list),_i);

if(r7same_as(se_ms(9,"lcc-win32"),((C)->_c_compiler_name))){
_args=((T0*)se_ms(6,"-boost"));
}
else{
_args=((T0*)se_ms(13,"-boost -no_gc"));
}

r12call_compile_to_c(_args,_item);
_i=(_i)+((T2)(INT8_C(1)));
}
}


T6 r12is_version_flag(T12* C,T0* a1){
T6 R=0;

if((T6)((r12flag_match(((T0*)ms15_2248290),a1))||((T6)(r12flag_match(((T0*)ms13_118),a1))))){

if(!(((C)->_version_flag))){
r29put_string((T29*)(oBC19std_output),((T0*)ms13_1042405932));
r29put_string((T29*)(oBC19std_output),((T0*)ms12_2073823));
r29put_string((T29*)(oBC19std_output),((T0*)ms13_142550));
r29put_string((T29*)(oBC19std_output),((T0*)ms55_983674906));
}


{int z1=(((T47*)(r12command_arguments()))->_upper);
switch(z1){
case 1:
exit(INT8_C(0));
break;
case 2:

if(((C)->_help_flag)){
exit(INT8_C(0));
}

break;
}
}
(C->_version_flag)=((T6)(1));
R=((T6)(1));
}

return R;
}


void r12echo_variable(T0* a1,T0* a2){
r31put_string((T31*)(oBC14echo),a1);
r31put_string((T31*)(oBC14echo),((T0*)se_ms(4," = \"")));
r31put_string((T31*)(oBC14echo),a2);
r31put_string((T31*)(oBC14echo),((T0*)se_ms(3,"\".\n")));
}


void r12gathered_information_summary(T12* C){
r29put_string((T29*)(oBC19std_output),((T0*)se_ms(64,"-----\nSummary of gathered information :\n   installation_path = \"")));
r29put_string((T29*)(oBC19std_output),((C)->_installation_path));
r29put_string((T29*)(oBC19std_output),((T0*)se_ms(20,"\"\n   system_name = \"")));
r29put_string((T29*)(oBC19std_output),((C)->_system_name));
r29put_string((T29*)(oBC19std_output),((T0*)se_ms(24,"\"\n   c_compiler_name = \"")));
r29put_string((T29*)(oBC19std_output),((C)->_c_compiler_name));
r29put_string((T29*)(oBC19std_output),((T0*)se_ms(2,"\"\n")));

if(!(((((T7*)(((T0*)ms12_0)))->_count))==(INT8_C(0)))){
r29put_string((T29*)(oBC19std_output),((T0*)se_ms(32,"   c_compiler_linker_options = \"")));
r29put_string((T29*)(oBC19std_output),((T0*)ms12_0));
r29put_string((T29*)(oBC19std_output),((T0*)se_ms(2,"\"\n")));
}

r29put_string((T29*)(oBC19std_output),((T0*)se_ms(24,"   garbage_collector = \"")));
r29put_string((T29*)(oBC19std_output),((C)->_garbage_collector));
r29put_string((T29*)(oBC19std_output),((T0*)se_ms(2,"\"\n")));

if(((C)->_interactive)){

if(!(r12yes_or_no(((T0*)se_ms(21,"Continue installation")),(T6)(1)))){
r29put_string((T29*)(oBC19std_output),((T0*)se_ms(34,"SmartEiffel installation aborted.\n")));
r12install_exit(C,INT8_C(0));
}

}

r29put_string((T29*)(oBC19std_output),((T0*)se_ms(40,"---\nSmartEiffel\'s bootstrap started ...\n")));
}


T6 r12yes_or_no(T0* a1,T6 a2){
T6 R=0;
T0* _answer=NULL;
r29put_string((T29*)(oBC19std_output),a1);
r29put_string((T29*)(oBC19std_output),((T0*)se_ms(10," (yes/no)?")));

if(a2){
r29put_string((T29*)(oBC19std_output),((T0*)se_ms(5,"[yes]")));
}
else{
r29put_string((T29*)(oBC19std_output),((T0*)se_ms(4,"[no]")));
}

r29flush((T29*)(oBC19std_output));
r26read_line((T26*)(oBC19std_input));
_answer=oBC27last_string;
r7to_lower(((T7*)_answer));

if((((((T7*)_answer))->_count))==(INT8_C(0))){
R=((T6)(a2));
}
 else if((T6)(((T6)(((T6)((r7is_equal(se_ms(1,"y"),_answer))||((T6)(r7is_equal(se_ms(3,"yes"),_answer)))))||((T6)(r7is_equal(se_ms(1,"o"),_answer)))))||((T6)(r7is_equal(se_ms(3,"oui"),_answer))))){
R=((T6)(1));
}
 else if((T6)(((T6)((r7is_equal(se_ms(1,"n"),_answer))||((T6)(r7is_equal(se_ms(2,"no"),_answer)))))||((T6)(r7is_equal(se_ms(3,"non"),_answer))))){
}
else{
r29put_string((T29*)(oBC19std_output),((T0*)se_ms(31,"yes or no ?\nThis is not clear.\n")));
R=((T6)(r12yes_or_no(a1,(T6)(a2))));
}

return R;
}


T6 r12file_exists(T0* a1){
T6 R=0;
R=((T6)(r45is_readable(a1)));
return R;
}


void r12set_bin_c_directory_path(T12* C){
(C->_bin_c_directory_path)=r7twin((T7*)(((C)->_installation_path)));
r35compute_subdirectory_with(((C)->_bin_c_directory_path),((T0*)se_ms(5,"bin_c")));
(C->_bin_c_directory_path)=r7twin((T7*)(oBC35last_entry));
}
T0*oBC14smart_eiffel=NULL;
T0*oBC12system_tools=NULL;


void r12call_compile_to_c(T0* a1,T0* a2){
((((T7*)((T7*)(oBC12command))))->_count)=((T2)(INT8_C(0)));

r34command_path_in((T34*)(oBC12system_tools),oBC12command,((T0*)se_ms(12,"compile_to_c")));
r7extend((T7*)(oBC12command),((T3)'\40'));
r7append((T7*)(oBC12command),a1);
r7append((T7*)(oBC12command),((T0*)se_ms(4," -o ")));
r7append((T7*)(oBC12command),a2);
r7extend((T7*)(oBC12command),((T3)'\40'));
r7append((T7*)(oBC12command),a2);
r29put_string((T29*)(oBC19std_output),oBC12command);
r29put_string((T29*)(oBC19std_output),((T0*)se_ms(1,"\n")));
r31system_call((T31*)(oBC14echo),oBC12command);
}
T0*oBC19command_arguments=NULL;
int fBC19command_arguments=0;


T0* r12command_arguments(void){
if(fBC19command_arguments==0){fBC19command_arguments=1;{
T2 _i=0;
T0* _arg=NULL;
_i=se_argc;
{T47*n=((T47*)se_malloc(sizeof(*n)));
*n=M47;
oBC19command_arguments=((T0*)n);
r47make(n,_i);
}
while (!((_i)==(INT8_C(0))))
{
_i=(_i)-((T2)(INT8_C(1)));
_arg=((T0*)se_string(se_argv[_i]));
(((((T47*)oBC19command_arguments))->_storage))[_i]=(_arg);

}
}}
return oBC19command_arguments;
}


void r12interactive_c_compiler_linker_options(T12* C){
r29put_string((T29*)(oBC19std_output),((T0*)se_ms(90,"-----\nIt is possible to add some default option(s) to be passed\nto the C compiler/linker.\n")));

if(r7same_as(se_ms(3,"gcc"),((C)->_c_compiler_name))){
r29put_string((T29*)(oBC19std_output),((T0*)se_ms(152,"With gcc the -pipe option is recommended (unfortunately\nthis is not supported for all platforms).\nThe -pipe option is supported on all Linux platforms.\n")));
}

r29put_string((T29*)(oBC19std_output),((T0*)se_ms(64,"Enter now one single line for extra option(s) or an empty line:\n")));
r26read_line((T26*)(oBC19std_input));
r7copy((T7*)(((T0*)ms12_0)),oBC27last_string);
}


void r12set_installation_path(T12* C){
T0* _string=NULL;
r31put_string((T31*)(oBC14echo),((T0*)se_ms(48,"Checking that the SmartEiffel directory exists:\n")));
_string=r7twin((T7*)(((C)->_system_se_path)));
r35compute_parent_directory_of(_string);

if(((((T7*)(oBC35last_entry))->_count))==(INT8_C(0))){
((((T31*)((T31*)(oBC14echo))))->_verbose)=(1);

r31put_string((T31*)(oBC14echo),((T0*)se_ms(219,"*** Fatal problem during installation of SmartEiffel.\n    Read carefully the following information before starting\n    again the `install\' -debug command.\n***************************************************************\n")));

r31put_string((T31*)(oBC14echo),((T0*)se_ms(40,"Unable to compute parent directory \nof \"")));
r31put_string((T31*)(oBC14echo),((C)->_system_se_path));
r31put_string((T31*)(oBC14echo),((T0*)se_ms(3,"\".\n")));
r12fatal_problem_description_end(C);
}

_string=r7twin((T7*)(oBC35last_entry));
r35compute_parent_directory_of(_string);

if(((((T7*)(oBC35last_entry))->_count))==(INT8_C(0))){
((((T31*)((T31*)(oBC14echo))))->_verbose)=(1);

r31put_string((T31*)(oBC14echo),((T0*)se_ms(219,"*** Fatal problem during installation of SmartEiffel.\n    Read carefully the following information before starting\n    again the `install\' -debug command.\n***************************************************************\n")));

r31put_string((T31*)(oBC14echo),((T0*)se_ms(40,"Unable to compute parent directory \nof \"")));
r31put_string((T31*)(oBC14echo),_string);
r31put_string((T31*)(oBC14echo),((T0*)se_ms(3,"\".\n")));
r12fatal_problem_description_end(C);
}

(C->_installation_path)=r7twin((T7*)(oBC35last_entry));
r31put_string((T31*)(oBC14echo),((T0*)se_ms(31,"SmartEiffel directory path is \"")));
r31put_string((T31*)(oBC14echo),((C)->_installation_path));
r31put_string((T31*)(oBC14echo),((T0*)se_ms(3,"\".\n")));
}
T0*oBC12tfr=NULL;


void r12c_compile_no_split_command_list(T12* C){
T0* _item=NULL;
T2 _i=0;
_i=(T2)(INT8_C(1));
while (!((_i)>(r41count((T41*)(oBC12no_split_command_list)))))
{
_item=r41item((T41*)(oBC12no_split_command_list),_i);
r12no_split_mode_c_compile(C,_item);
_i=(_i)+((T2)(INT8_C(1)));
}
}
T0*oBC19std_input=NULL;
T0*oBC12tfw=NULL;


T6 r12flag_match(T0* a1,T0* a2){
T6 R=0;
T2 _i_flag=0;
T2 _i_arg=0;
_i_arg=((((T7*)a2))->_count);

if((_i_arg)>=((T2)(INT8_C(2)))){
_i_flag=((((T7*)a1))->_count);

{int z1=(((((T7*)a2))->_storage))[INT8_C(0)];
switch(z1){
case 45:

if(((((((T7*)a2))->_storage))[((T2)(INT8_C(2)))-(INT8_C(1))])==(((T3)'\55'))){
R=((T6)(((_i_flag)+((T2)(INT8_C(2))))==(_i_arg)));
}
else{
R=((T6)(((_i_flag)+((T2)(INT8_C(1))))==(_i_arg)));
}

break;
case 47:
R=((T6)(((_i_flag)+((T2)(INT8_C(1))))==(_i_arg)));
break;
}
}
while (!((T6)((!(R))||((T6)((_i_flag)==(INT8_C(0)))))))
{

if(r3same_as((((((T7*)a1))->_storage))[(_i_flag)-(INT8_C(1))],(((((T7*)a2))->_storage))[(_i_arg)-(INT8_C(1))])){
_i_arg=(_i_arg)-((T2)(INT8_C(1)));
_i_flag=(_i_flag)-((T2)(INT8_C(1)));
}
else{
R=((T6)(0));
}

}
}

return R;
}


void r12set_garbage_collector_file_path(T12* C){
T0* _path=NULL;
r31put_string((T31*)(oBC14echo),((T0*)se_ms(24,"Computing GC file path:\n")));
_path=r7twin((T7*)(((C)->_installation_path)));
r35compute_subdirectory_with(_path,((T0*)se_ms(3,"sys")));

if(((((T7*)(oBC35last_entry))->_count))==(INT8_C(0))){
((((T31*)((T31*)(oBC14echo))))->_verbose)=(1);

r31put_string((T31*)(oBC14echo),((T0*)se_ms(219,"*** Fatal problem during installation of SmartEiffel.\n    Read carefully the following information before starting\n    again the `install\' -debug command.\n***************************************************************\n")));

r31put_string((T31*)(oBC14echo),((T0*)se_ms(39,"Unable to compute directory path with \"")));
r31put_string((T31*)(oBC14echo),_path);
r31put_string((T31*)(oBC14echo),((T0*)se_ms(13,"\" and \"sys\".\n")));
r12fatal_problem_description_end(C);
}

_path=r7twin((T7*)(oBC35last_entry));
r35compute_file_path_with(_path,((T0*)se_ms(2,"gc")));
_path=r7twin((T7*)(oBC35last_entry));
(C->_garbage_collector_file_path)=_path;
r31put_string((T31*)(oBC14echo),((T0*)se_ms(17,"GC file path is \"")));
r31put_string((T31*)(oBC14echo),((C)->_garbage_collector_file_path));
r31put_string((T31*)(oBC14echo),((T0*)se_ms(13,"\" and \"sys\".\n")));
}


void r12open_vms_entry_patch(T12* C,T0* a1){
T6 _stop=0;
T0* _s=NULL;

if(r7same_as(se_ms(7,"OpenVMS"),((C)->_system_name))){
r7to_lower(((T7*)a1));
_s=r7twin(((T7*)a1));
while (!(_stop))
{

if((((((T7*)_s))->_count))==(INT8_C(0))){
_stop=((T6)(1));
}
 else if((r7last(((T7*)_s)))==(((T3)'\73'))){
r7remove_last(((T7*)_s),(T2)(INT8_C(1)));
r7copy(((T7*)a1),_s);
_stop=((T6)(1));
}
 else if(r3is_decimal_digit(r7last(((T7*)_s)))){
r7remove_last(((T7*)_s),(T2)(INT8_C(1)));
}
else{
_stop=((T6)(1));
}

}
r12echo_variable(((T0*)se_ms(7,"OpenVMS")),a1);
}

}
T0*oBC12splitted_command_list=NULL;


void r12set_bin_directory_path(T12* C){
(C->_bin_directory_path)=r7twin((T7*)(((C)->_installation_path)));
r35compute_subdirectory_with(((C)->_bin_directory_path),((T0*)se_ms(3,"bin")));
(C->_bin_directory_path)=r7twin((T7*)(oBC35last_entry));
r35connect_to(&(((C)->_basic_directory)),((C)->_bin_directory_path));

if((NULL!=((((C)->_basic_directory))._directory_stream))){
r35disconnect(&(((C)->_basic_directory)));
}
 else if(r35create_new_directory(((C)->_bin_directory_path))){
r31put_string((T31*)(oBC14echo),((T0*)se_ms(11,"Directory \"")));
r31put_string((T31*)(oBC14echo),((C)->_bin_directory_path));
r31put_string((T31*)(oBC14echo),((T0*)se_ms(11,"\" created.\n")));
}
else{
r31put_string((T31*)(oBC14echo),((T0*)se_ms(11,"Directory \"")));
r31put_string((T31*)(oBC14echo),((C)->_bin_directory_path));
r31put_string((T31*)(oBC14echo),((T0*)se_ms(13,"\" not found.\n")));
}

}


void r12make(T12* C){
T2 _i=0;
T0* _arg=NULL;
T6 _b=0;
_i=(T2)(INT8_C(1));
while (!((_i)>((((T47*)(r12command_arguments()))->_upper))))
{
_arg=r12argument(_i);

if(r12is_version_flag(C,_arg)){
}
 else if(r12flag_match(((T0*)se_ms(5,"debug")),_arg)){
((((T31*)((T31*)(oBC14echo))))->_verbose)=(1);

}
 else if(r12flag_match(((T0*)se_ms(11,"interactive")),_arg)){
(C->_interactive)=((T6)(1));
}
 else if(r12flag_match(((T0*)se_ms(18,"skip_c_compilation")),_arg)){
(C->_skip_c_compilation)=((T6)(1));
}
 else if(r12flag_match(((T0*)se_ms(2,"cc")),_arg)){

if((_i)<((((T47*)(r12command_arguments()))->_upper))){
_i=(_i)+((T2)(INT8_C(1)));
(C->_c_compiler_name)=r12argument(_i);
}
else{
r29put_string((T29*)(oBC19std_output),((T0*)se_ms(44,"compiler name must be specified after \"-cc\"\n")));
r12echo_usage_exit(C);
}

}
else{
r12echo_usage_exit(C);
}

_i=(_i)+((T2)(INT8_C(1)));
}
r29put_string((T29*)(oBC19std_output),((T0*)se_ms(32,"Install of SmartEiffel started.\n")));

if(((C)->_interactive)){
(C->_interactive)=((T6)(r12yes_or_no(((T0*)se_ms(223,"Do you want to continue the installation of SmartEiffel with\nthe -interactive mode activated?\nActually, there are just a few questions to answer and then\nall the process is automatic.\nContinue the with the -interactive mode")),(T6)(1))));
}


if((T6)((((C)->_interactive))&&((T6)(!((((T31*)(oBC14echo))->_verbose)))))){
_b=((T6)(r12yes_or_no(((T0*)se_ms(279,"Do you want to see all what\'s done during the installation (i.e. to switch\non the -debug mode)?\nActually, the -debug mode is really verbose and is really useful only in\ncase of problem. Also note that you can always rerun this install procedure.\nAdd the -debug verbose option now")),(T6)(0))));

if(_b){
((((T31*)((T31*)(oBC14echo))))->_verbose)=(1);

}

}


if(!(((C)->_interactive))){
r29put_string((T29*)(oBC19std_output),((T0*)se_ms(38,"Automatic installation in progress...\n")));
}

r31put_string((T31*)(oBC14echo),((T0*)se_ms(20,"Version of command \"")));
r31put_string((T31*)(oBC14echo),((T0*)ms12_2073823));
r31put_string((T31*)(oBC14echo),((T0*)se_ms(6,"\" is:\n")));
r31put_string((T31*)(oBC14echo),((T0*)ms55_983674906));
r35connect_to_current_working_directory(&(((C)->_basic_directory)));
(C->_cwd)=r7twin((T7*)(oBC35last_entry));
r12echo_variable(((T0*)se_ms(23,"CurrentWorkingDirectory")),((C)->_cwd));

if((NULL!=((((C)->_basic_directory))._directory_stream))){
r35disconnect(&(((C)->_basic_directory)));
}

r12set_system_se_path(C);
r12set_installation_path(C);
r12set_system_name(C);
r12write_default_loadpath_se_file(C);
r12set_compiler_se_path(C);
r12set_garbage_collector_file_path(C);
r12garbage_collector_selection(C);
r12set_c_compiler_name(C);
r12set_bin_directory_path(C);
r12set_bin_c_directory_path(C);
r35change_current_working_directory(&(((C)->_basic_directory)),((C)->_bin_c_directory_path));

if(((((T7*)(oBC35last_entry))->_count))==(INT8_C(0))){
((((T31*)((T31*)(oBC14echo))))->_verbose)=(1);

r31put_string((T31*)(oBC14echo),((T0*)se_ms(219,"*** Fatal problem during installation of SmartEiffel.\n    Read carefully the following information before starting\n    again the `install\' -debug command.\n***************************************************************\n")));

r31put_string((T31*)(oBC14echo),((T0*)se_ms(48,"Unable to change current working directory \nto \"")));
r31put_string((T31*)(oBC14echo),((C)->_bin_c_directory_path));
r31put_string((T31*)(oBC14echo),((T0*)se_ms(3,"\".\n")));
r12fatal_problem_description_end(C);
}

r12gathered_information_summary(C);

if(((C)->_skip_c_compilation)){
}
else{
r29put_string((T29*)(oBC19std_output),((T0*)se_ms(16,"C Compiling in \"")));
r29put_string((T29*)(oBC19std_output),oBC35last_entry);
r29put_string((T29*)(oBC19std_output),((T0*)se_ms(3,"\".\n")));
r12split_mode_c_compile(C,((T0*)se_ms(12,"compile_to_c")));
r12prepare_bin_c_directory(C);
r12c_compile_no_split_command_list(C);
r12c_compile_splitted_command_list(C);
r12clean_bin_c_directory_path(C);
}

r12restore_current_working_directory(C);
r29put_string((T29*)(oBC19std_output),((T0*)se_ms(31,"SmartEiffel installation done.\n")));
r12check_system_path_variable_warning(C);
r12install_exit(C,INT8_C(0));
}


void r12set_c_compiler_name(T12* C){
r31put_string((T31*)(oBC14echo),((T0*)se_ms(22,"C compiler selection:\n")));

if((((C)->_c_compiler_name))==((void*)(NULL))){

if(r7same_as(se_ms(6,"Cygwin"),((C)->_system_name))){
(C->_c_compiler_name)=((T0*)se_ms(3,"gcc"));
r7copy((T7*)(((T0*)ms12_0)),((T0*)se_ms(3,"-O2")));
}
 else if(r7same_as(se_ms(5,"Elate"),((C)->_system_name))){
(C->_c_compiler_name)=((T0*)se_ms(4,"vpcc"));
}
 else if(r7same_as(se_ms(7,"OpenVMS"),((C)->_system_name))){
(C->_c_compiler_name)=((T0*)se_ms(10,"OpenVMS_CC"));
}
 else if(!(((C)->_interactive))){

if(r7same_as(se_ms(4,"UNIX"),((C)->_system_name))){
(C->_c_compiler_name)=((T0*)se_ms(3,"gcc"));

if(r7same_as(se_ms(7,"linux.c"),((C)->_garbage_collector))){
r7copy((T7*)(((T0*)ms12_0)),((T0*)se_ms(5,"-pipe")));
}
 else if(r7same_as(se_ms(7,"sparc.c"),((C)->_garbage_collector))){
r7copy((T7*)(((T0*)ms12_0)),((T0*)se_ms(5,"-pipe")));
}

}

}

}


if((((C)->_c_compiler_name))==((void*)(NULL))){
(C->_c_compiler_name)=r12choice_in(((T0*)se_ms(20,"C compiler selection")),oBC34compiler_list);
}

r31put_string((T31*)(oBC14echo),((T0*)se_ms(24,"Selected C compiler is \"")));
r31put_string((T31*)(oBC14echo),((C)->_c_compiler_name));
r31put_string((T31*)(oBC14echo),((T0*)se_ms(3,"\".\n")));
r31put_string((T31*)(oBC14echo),((T0*)se_ms(15,"Try to update \"")));
r31put_string((T31*)(oBC14echo),((C)->_compiler_se_path));
r31put_string((T31*)(oBC14echo),((T0*)se_ms(3,"\".\n")));
r31tfw_connect((T31*)(oBC14echo),oBC12tfw,((C)->_compiler_se_path));
r12tfw_check_is_connected(C,((C)->_compiler_se_path));
r48put_string((T48*)(oBC12tfw),((C)->_c_compiler_name));

if(((C)->_interactive)){

if(((((T7*)(((T0*)ms12_0)))->_count))==(INT8_C(0))){
r12interactive_c_compiler_linker_options(C);
}

}


if(!(((((T7*)(((T0*)ms12_0)))->_count))==(INT8_C(0)))){
r48put_character((T48*)(oBC12tfw),((T3)'\40'));
r48put_string((T48*)(oBC12tfw),((T0*)ms12_0));
}

r48put_character((T48*)(oBC12tfw),((T3)'\n'));
r48disconnect((T48*)(oBC12tfw));
r31put_string((T31*)(oBC14echo),((T0*)se_ms(11,"Update of \"")));
r31put_string((T31*)(oBC14echo),((C)->_compiler_se_path));
r31put_string((T31*)(oBC14echo),((T0*)se_ms(8,"\" done.\n")));
r31put_string((T31*)(oBC14echo),((T0*)se_ms(139,"Hint: It is possible to change some default option(s) for the C\ncompiler just after the compiler name in the very first line of \nthe file \"")));
r31put_string((T31*)(oBC14echo),((C)->_compiler_se_path));
r31put_string((T31*)(oBC14echo),((T0*)se_ms(143,"\". For example, the very first line can be \"gcc -pipe -O3\".\n       (If you are not an expert of C compilation, do not add any options.)\n       ")));
r34set_c_compiler((T34*)(oBC12system_tools),NULL);
r34default_c_compiler_options((T34*)(oBC12system_tools),(T6)(1));
}


void r12set_system_se_path(T12* C){
T0* _string=NULL;
r31put_string((T31*)(oBC14echo),((T0*)se_ms(45,"Checking \"SmartEiffel\" environment variable:\n")));
(C->_system_se_path)=r31getenv(((T0*)ms15_1072344038),NULL);

if((T6)(((((C)->_system_se_path))==((void*)(NULL)))||((T6)(((((T7*)(((C)->_system_se_path)))->_count))==(INT8_C(0)))))){
_string=r7twin((T7*)(((T0*)ms15_1072344038)));
r7to_upper(((T7*)_string));
(C->_system_se_path)=r31getenv(_string,NULL);
}


if((T6)(((((C)->_system_se_path))==((void*)(NULL)))||((T6)(((((T7*)(((C)->_system_se_path)))->_count))==(INT8_C(0)))))){
((((T31*)((T31*)(oBC14echo))))->_verbose)=(1);

r31put_string((T31*)(oBC14echo),((T0*)se_ms(219,"*** Fatal problem during installation of SmartEiffel.\n    Read carefully the following information before starting\n    again the `install\' -debug command.\n***************************************************************\n")));

r31put_string((T31*)(oBC14echo),((T0*)se_ms(151,"Environment variable \"SmartEiffel\" is not set.\n       Please, set this variable with the absolute path of \n       the \"SmartEiffel/sys/system.se\" file.")));
r12fatal_problem_description_end(C);
}


if(!(r7has_suffix((T7*)(((C)->_system_se_path)),((T0*)se_ms(9,"system.se"))))){
((((T31*)((T31*)(oBC14echo))))->_verbose)=(1);

r31put_string((T31*)(oBC14echo),((T0*)se_ms(219,"*** Fatal problem during installation of SmartEiffel.\n    Read carefully the following information before starting\n    again the `install\' -debug command.\n***************************************************************\n")));

r31put_string((T31*)(oBC14echo),((T0*)se_ms(52,"Value of the Environment variable \"SmartEiffel\"\nis \"")));
r31put_string((T31*)(oBC14echo),((C)->_system_se_path));
r31put_string((T31*)(oBC14echo),((T0*)se_ms(3,"\".\n")));
r31put_string((T31*)(oBC14echo),((T0*)se_ms(298,"Please, set this variable with the absolute path of\nthe \"SmartEiffel/sys/system.se\" file.\nFor example, on Linux, the value is\noften \"/usr/lib/SmartEiffel/sys/system.se\".\nOn Windows, \"C:\\SmartEiffel\\sys\\system.se\" is a correct value\nwhen the SmartEiffel directory is at toplevel of the C hard disk.\n")));
r12fatal_problem_description_end(C);
}


if(!(r12file_exists(((C)->_system_se_path)))){
((((T31*)((T31*)(oBC14echo))))->_verbose)=(1);

r31put_string((T31*)(oBC14echo),((T0*)se_ms(219,"*** Fatal problem during installation of SmartEiffel.\n    Read carefully the following information before starting\n    again the `install\' -debug command.\n***************************************************************\n")));

r31put_string((T31*)(oBC14echo),((T0*)se_ms(58,"Value of the Environment variable \"SmartEiffel\" value\nis \"")));
r31put_string((T31*)(oBC14echo),((C)->_system_se_path));
r31put_string((T31*)(oBC14echo),((T0*)se_ms(30,"\".\nThere is no readable file \"")));
r31put_string((T31*)(oBC14echo),((C)->_system_se_path));
r31put_string((T31*)(oBC14echo),((T0*)se_ms(56,"\".\nCheck this absolute path as well as read permission.\n")));
r12fatal_problem_description_end(C);
}

r31put_string((T31*)(oBC14echo),((T0*)se_ms(94,"Value of the Environment variable \"SmartEiffel\" is correctly set\nto some existing file\npath (\"")));
r31put_string((T31*)(oBC14echo),((C)->_system_se_path));
r31put_string((T31*)(oBC14echo),((T0*)se_ms(4,"\").\n")));
r35reset_notation_using(((C)->_system_se_path));
r31put_string((T31*)(oBC14echo),((T0*)se_ms(36,"File/directory path handling with a ")));

if(r35unix_notation()){
r31put_string((T31*)(oBC14echo),((T0*)se_ms(4,"UNIX")));
}
 else if(r35windows_notation()){
r31put_string((T31*)(oBC14echo),((T0*)se_ms(7,"Windows")));
}
 else if(r35cygwin_notation()){
r31put_string((T31*)(oBC14echo),((T0*)se_ms(14,"Cygwin/Windows")));
}
 else if(r35amiga_notation()){
r31put_string((T31*)(oBC14echo),((T0*)se_ms(5,"Amiga")));
}
 else if(r35macintosh_notation()){
r31put_string((T31*)(oBC14echo),((T0*)se_ms(9,"Macintosh")));
}
 else if(r35openvms_notation()){
r31put_string((T31*)(oBC14echo),((T0*)se_ms(7,"OpenVMS")));
}
else{
r31put_string((T31*)(oBC14echo),((T0*)se_ms(15,"?not_yet_known?")));
}

r31put_string((T31*)(oBC14echo),((T0*)se_ms(11," notation.\n")));
}


void r12call_clean(T0* a1){
((((T7*)((T7*)(oBC12command))))->_count)=((T2)(INT8_C(0)));

r34command_path_in((T34*)(oBC12system_tools),oBC12command,((T0*)se_ms(5,"clean")));
r7extend((T7*)(oBC12command),((T3)'\40'));
r7append((T7*)(oBC12command),a1);
r29put_string((T29*)(oBC19std_output),oBC12command);
r29put_string((T29*)(oBC19std_output),((T0*)se_ms(1,"\n")));
r31system_call((T31*)(oBC14echo),oBC12command);
}


void r12fatal_problem_description_end(T12* C){
r31put_string((T31*)(oBC14echo),((T0*)se_ms(129,"***************************************************************\nFix the previously described problem and launch again `install\'.\n")));
r12restore_current_working_directory(C);
r12install_exit(C,INT8_C(1));
}


void r12restore_current_working_directory(T12* C){

if((((C)->_cwd))!=((void*)(NULL))){
r35change_current_working_directory(&(((C)->_basic_directory)),((C)->_cwd));
}

}


void r12garbage_collector_selection(T12* C){
T0* _cmd=NULL;
int _s=0;
r31put_string((T31*)(oBC14echo),((T0*)se_ms(29,"Garbage collector selection:\n")));

if(r7same_as(se_ms(4,"UNIX"),((C)->_system_name))){
_cmd=r7twin((T7*)(((C)->_system_se_path)));
{T7* C1=((T7*)_cmd);
T0* b1=((T0*)se_ms(13,"sys/system.se"));
r7remove_last(C1,((((T7*)b1))->_count));
}
r7append(((T7*)_cmd),((T0*)se_ms(10,"misc/GC.SH")));
r31put_string((T31*)(oBC14echo),((T0*)se_ms(18,"Launching script \"")));
r31put_string((T31*)(oBC14echo),_cmd);
r31put_string((T31*)(oBC14echo),((T0*)se_ms(3,"\".\n")));
r32execute_command_line(_cmd);
}
 else if(r7same_as(se_ms(5,"Amiga"),((C)->_system_name))){
(C->_garbage_collector)=((T0*)se_ms(14,"m68k-amigaos.c"));
}
 else if(r7is_equal((T7*)(((C)->_system_name)),((T0*)se_ms(5,"Elate")))){
(C->_garbage_collector)=((T0*)se_ms(7,"elate.c"));
}
 else if(r7same_as(se_ms(7,"Windows"),((C)->_system_name))){
(C->_garbage_collector)=((T0*)se_ms(9,"windows.c"));
}
 else if(r7same_as(se_ms(4,"BeOS"),((C)->_system_name))){
(C->_garbage_collector)=((T0*)se_ms(10,"beos_x86.c"));
}
 else if(r7same_as(se_ms(3,"DOS"),((C)->_system_name))){
(C->_garbage_collector)=((T0*)se_ms(9,"windows.c"));
}
 else if(r7same_as(se_ms(9,"Macintosh"),((C)->_system_name))){
(C->_garbage_collector)=((T0*)se_ms(14,"MacintoshPPC.c"));
}
 else if(r7same_as(se_ms(3,"OS2"),((C)->_system_name))){
(C->_garbage_collector)=((T0*)se_ms(9,"windows.c"));
}
 else if(r7same_as(se_ms(7,"OpenVMS"),((C)->_system_name))){
(C->_garbage_collector)=((T0*)se_ms(9,"generic.c"));
}
 else if(r7same_as(se_ms(6,"Cygwin"),((C)->_system_name))){
(C->_garbage_collector)=((T0*)se_ms(9,"windows.c"));
}


if((((C)->_garbage_collector))==((void*)(NULL))){
r31tfr_connect((T31*)(oBC14echo),oBC12tfr,((C)->_garbage_collector_file_path));
(C->_garbage_collector)=r31read_word_in((T31*)(oBC14echo),oBC12tfr);
r36disconnect((T36*)(oBC12tfr));
r31put_string((T31*)(oBC14echo),((T0*)se_ms(17,"Selected GC for \"")));
r31put_string((T31*)(oBC14echo),((C)->_garbage_collector));
r31put_string((T31*)(oBC14echo),((T0*)se_ms(3,"\".\n")));
}
else{
r31put_string((T31*)(oBC14echo),((T0*)se_ms(17,"Selected GC for \"")));
r31put_string((T31*)(oBC14echo),((C)->_garbage_collector));
r31put_string((T31*)(oBC14echo),((T0*)se_ms(3,"\".\n")));
r31tfw_connect((T31*)(oBC14echo),oBC12tfw,((C)->_garbage_collector_file_path));
r12tfw_check_is_connected(C,((C)->_garbage_collector_file_path));
r48put_string((T48*)(oBC12tfw),((C)->_garbage_collector));
r48put_character((T48*)(oBC12tfw),((T3)'\n'));
r48disconnect((T48*)(oBC12tfw));
}

}
T0*oBC12command=NULL;


void r12c_compile_splitted_command_list(T12* C){
T0* _item=NULL;
T2 _i=0;
_i=(T2)(INT8_C(1));
while (!((_i)>(r41count((T41*)(oBC12splitted_command_list)))))
{
_item=r41item((T41*)(oBC12splitted_command_list),_i);
r12split_mode_c_compile(C,_item);
_i=(_i)+((T2)(INT8_C(1)));
}
}


void r12set_system_name(T12* C){
r31put_string((T31*)(oBC14echo),((T0*)se_ms(23,"System name detection:\n")));

if(((C)->_interactive)){
(C->_system_name)=r12choice_in(((T0*)se_ms(21,"System name selection")),oBC34system_list);
}
 else if(r12file_exists(((T0*)se_ms(7,"/sys/rc")))){
r31put_string((T31*)(oBC14echo),((T0*)se_ms(43,"System seems to be an Amiga on Taos Elate.\n")));
(C->_system_name)=((T0*)se_ms(5,"Elate"));
}
 else if(r12file_exists(((T0*)se_ms(18,"s:startup-sequence")))){
r31put_string((T31*)(oBC14echo),((T0*)se_ms(29,"System seems to be an Amiga.\n")));
(C->_system_name)=((T0*)se_ms(5,"Amiga"));
}
 else if(r12file_exists(((T0*)se_ms(25,"/boot/beos/system/Tracker")))){
r31put_string((T31*)(oBC14echo),((T0*)se_ms(25,"System seems to be BeOS.\n")));
(C->_system_name)=((T0*)se_ms(4,"BeOS"));
}
 else if(r12file_exists(((T0*)se_ms(11,"/bin/ls.exe")))){
r31put_string((T31*)(oBC14echo),((T0*)se_ms(27,"System seems to be Cygwin.\n")));
(C->_system_name)=((T0*)se_ms(6,"Cygwin"));
}
 else if(r12file_exists(((T0*)se_ms(7,"/bin/ls")))){
r31put_string((T31*)(oBC14echo),((T0*)se_ms(25,"System seems to be UNIX.\n")));
(C->_system_name)=((T0*)se_ms(4,"UNIX"));
}
else{

if(r35system_notation_detected()){

if(r35unix_notation()){
(C->_system_name)=((T0*)se_ms(4,"UNIX"));
}
 else if(r35windows_notation()){
(C->_system_name)=((T0*)se_ms(7,"Windows"));
}
 else if(r35cygwin_notation()){
(C->_system_name)=((T0*)se_ms(6,"Cygwin"));
}
 else if(r35amiga_notation()){
(C->_system_name)=((T0*)se_ms(5,"Amiga"));
}
 else if(r35macintosh_notation()){
(C->_system_name)=((T0*)se_ms(9,"Macintosh"));
}
 else if(r35openvms_notation()){
(C->_system_name)=((T0*)se_ms(7,"OpenVMS"));
}

}


if((((C)->_system_name))==((void*)(NULL))){
r35connect_to(&(((C)->_basic_directory)),((T0*)se_ms(3,"C:\\")));

if((NULL!=((((C)->_basic_directory))._directory_stream))){
(C->_system_name)=((T0*)se_ms(7,"Windows"));
r35disconnect(&(((C)->_basic_directory)));
}
else{
r29put_string((T29*)(oBC19std_output),((T0*)se_ms(43,"Automatic system detection failed (sorry).\n")));
(C->_system_name)=r12choice_in(((T0*)se_ms(21,"System name selection")),oBC34system_list);
}

}

}

r31put_string((T31*)(oBC14echo),((T0*)se_ms(11,"System is \"")));
r31put_string((T31*)(oBC14echo),((C)->_system_name));
r31put_string((T31*)(oBC14echo),((T0*)se_ms(23,"\".\nTry to update file \"")));
r31put_string((T31*)(oBC14echo),((C)->_system_se_path));
r31put_string((T31*)(oBC14echo),((T0*)se_ms(3,"\".\n")));
r31tfw_connect((T31*)(oBC14echo),oBC12tfw,((C)->_system_se_path));
r12tfw_check_is_connected(C,((C)->_system_se_path));
r48put_string((T48*)(oBC12tfw),((C)->_system_name));
r48put_character((T48*)(oBC12tfw),((T3)'\n'));
r48disconnect((T48*)(oBC12tfw));
r31put_string((T31*)(oBC14echo),((T0*)se_ms(11,"Update of \"")));
r31put_string((T31*)(oBC14echo),((C)->_system_se_path));
r31put_string((T31*)(oBC14echo),((T0*)se_ms(8,"\" done.\n")));
r34make((T34*)(oBC12system_tools));

if(!(r7same_as((T7*)(((C)->_system_name)),(((T34*)(oBC12system_tools))->_system_name)))){
((((T31*)((T31*)(oBC14echo))))->_verbose)=(1);

r31put_string((T31*)(oBC14echo),((T0*)se_ms(219,"*** Fatal problem during installation of SmartEiffel.\n    Read carefully the following information before starting\n    again the `install\' -debug command.\n***************************************************************\n")));

r31put_string((T31*)(oBC14echo),((T0*)se_ms(33,"Unkown SYSTEM_TOOLS.system_name \"")));
r31put_string((T31*)(oBC14echo),((C)->_system_name));
r31put_string((T31*)(oBC14echo),((T0*)se_ms(3,"\".\n")));
r12fatal_problem_description_end(C);
}

}


void r12no_split_mode_c_compile(T12* C,T0* a1){
T0* _c_name=NULL;
_c_name=r7twin(((T7*)a1));
r7append(((T7*)_c_name),((T0*)se_ms(2,".c")));
((((T50*)((T50*)(oBC14ace))))->_executable_name)=(a1);

r34no_split_mode_command((T34*)(oBC12system_tools),oBC12command,_c_name);
r29put_string((T29*)(oBC19std_output),oBC12command);
r29put_character((T29*)(oBC19std_output),((T3)'\n'));
r31system_call((T31*)(oBC14echo),oBC12command);
r12move_executable_for(C,a1);
}
T0*oBC12no_split_command_list=NULL;


void r12set_compiler_se_path(T12* C){
T0* _path=NULL;
_path=r7twin((T7*)(((C)->_installation_path)));
r35compute_subdirectory_with(_path,((T0*)se_ms(3,"sys")));
_path=r7twin((T7*)(oBC35last_entry));
r35compute_file_path_with(_path,((T0*)se_ms(11,"compiler.se")));
(C->_compiler_se_path)=r7twin((T7*)(oBC35last_entry));
}


void r12split_mode_c_compile(T12* C,T0* a1){
T0* _entry=NULL;
T2 _i=0;
T2 _max=0;
T0* _directory=NULL;
r31put_string((T31*)(oBC14echo),((T0*)se_ms(13,"C compiling \"")));
r31put_string((T31*)(oBC14echo),a1);
r31put_string((T31*)(oBC14echo),((T0*)se_ms(12,"*.c\" files.\n")));
((((T50*)((T50*)(oBC14ace))))->_executable_name)=(a1);

{T44*n=((T44*)se_malloc(sizeof(*n)));
*n=M44;
r44scan_current_working_directory(n);
_directory=((T0*)n);
}

if(!(((((T44*)_directory))->_last_scan_status))){
((((T31*)((T31*)(oBC14echo))))->_verbose)=(1);

r31put_string((T31*)(oBC14echo),((T0*)se_ms(219,"*** Fatal problem during installation of SmartEiffel.\n    Read carefully the following information before starting\n    again the `install\' -debug command.\n***************************************************************\n")));

r31put_string((T31*)(oBC14echo),((T0*)se_ms(42,"Unable to open current working directory.\n")));
r12fatal_problem_description_end(C);
}

_i=INT8_C(1);
while (!((_i)>(r44upper(((T44*)_directory)))))
{
_entry=r7twin((T7*)((((((T47*)(((((T44*)_directory))->_name_list))))->_storage))[(_i)-(INT8_C(1))]));
r12echo_variable(((T0*)se_ms(5,"entry")),_entry);
r12open_vms_entry_patch(C,_entry);

if(!(r7has_prefix(((T7*)_entry),a1))){
}
 else if(!(r7has_suffix(((T7*)_entry),((T0*)se_ms(2,".c"))))){
}
else{
_max=(_max)+((T2)(INT8_C(1)));
r34split_mode_c_compiler_command((T34*)(oBC12system_tools),oBC12command,_entry);
r29put_string((T29*)(oBC19std_output),oBC12command);
r29put_string((T29*)(oBC19std_output),((T0*)se_ms(1,"\n")));
r31system_call((T31*)(oBC14echo),oBC12command);
}

_i=(_i)+((T2)(INT8_C(1)));
}
r34split_mode_linker_command((T34*)(oBC12system_tools),oBC12command,a1,_max);
r29put_string((T29*)(oBC19std_output),oBC12command);
r29put_string((T29*)(oBC19std_output),((T0*)se_ms(1,"\n")));
r31system_call((T31*)(oBC14echo),oBC12command);
r34remove_other_extra_files((T34*)(oBC12system_tools),a1);
r12move_executable_for(C,a1);
}


void r12install_exit(T12* C,T2 a1){

if((T6)(((((C)->_system_name))==((void*)(NULL)))||((T6)(r7same_as(se_ms(7,"Windows"),((C)->_system_name)))))){
r29put_string((T29*)(oBC19std_output),((T0*)se_ms(26,"Type <Enter> to continue.\n")));
r26read_character((T26*)(oBC19std_input));
}

exit(a1);
}


void r12echo_usage_exit(T12* C){
((((T31*)((T31*)(oBC14echo))))->_verbose)=(1);

r31put_string((T31*)(oBC14echo),((T0*)se_ms(7,"usage: ")));
r31put_string((T31*)(oBC14echo),((T0*)ms12_2073823));
r31put_string((T31*)(oBC14echo),((T0*)se_ms(60," [-interactive] [-skip_c_compilation] [-cc <name>] [-debug]\n")));
r12restore_current_working_directory(C);
r12install_exit(C,INT8_C(1));
}


void r12echo_tfw_put_string(T0* a1){
r31put_string((T31*)(oBC14echo),a1);
r48put_string((T48*)(oBC12tfw),a1);
}


void r12write_default_loadpath_se_file(T12* C){
T0* _path=NULL;
T0* _directory=NULL;
T0* _tools_directory=NULL;
T0* _list=NULL;
T2 _i=0;
r31put_string((T31*)(oBC14echo),((T0*)se_ms(34,"Writing default loadpath.se file:\n")));
_path=r7twin((T7*)(((C)->_installation_path)));
r35compute_subdirectory_with(_path,((T0*)se_ms(3,"sys")));

if(((((T7*)(oBC35last_entry))->_count))==(INT8_C(0))){
((((T31*)((T31*)(oBC14echo))))->_verbose)=(1);

r31put_string((T31*)(oBC14echo),((T0*)se_ms(219,"*** Fatal problem during installation of SmartEiffel.\n    Read carefully the following information before starting\n    again the `install\' -debug command.\n***************************************************************\n")));

r31put_string((T31*)(oBC14echo),((T0*)se_ms(41,"Unable to compute subdirectory \"sys\" of \"")));
r31put_string((T31*)(oBC14echo),_path);
r31put_string((T31*)(oBC14echo),((T0*)se_ms(3,"\".\n")));
r12fatal_problem_description_end(C);
}

r7copy(((T7*)_path),oBC35last_entry);
r35compute_file_path_with(_path,((T0*)se_ms(9,"loadpath.")));
r7copy(((T7*)_path),oBC35last_entry);
r7append(((T7*)_path),((C)->_system_name));
r31tfw_connect((T31*)(oBC14echo),oBC12tfw,_path);
r12tfw_check_is_connected(C,_path);
r31put_string((T31*)(oBC14echo),((T0*)se_ms(21,"--- Written data ---\n")));

if(r7same_as(se_ms(4,"UNIX"),((C)->_system_name))){
_directory=((T0*)se_ms(3,"./\n"));
}
 else if(r7same_as(se_ms(6,"Cygwin"),((C)->_system_name))){
_directory=((T0*)se_ms(3,"./\n"));
}
 else if(r7same_as(se_ms(3,"DOS"),((C)->_system_name))){
_directory=((T0*)se_ms(3,".\\\n"));
}
 else if(r7same_as(se_ms(7,"Windows"),((C)->_system_name))){
_directory=((T0*)se_ms(3,".\\\n"));
}
 else if(r7same_as(se_ms(4,"BeOS"),((C)->_system_name))){
_directory=((T0*)se_ms(3,"./\n"));
}
 else if(r7same_as(se_ms(9,"Macintosh"),((C)->_system_name))){
_directory=((T0*)se_ms(2,":\n"));
}
 else if(r7same_as(se_ms(7,"OpenVMS"),((C)->_system_name))){
_directory=((T0*)se_ms(3,"[]\n"));
}
 else if(r7same_as(se_ms(3,"OS2"),((C)->_system_name))){
_directory=((T0*)se_ms(3,".\\\n"));
}
 else if(r7same_as(se_ms(5,"Amiga"),((C)->_system_name))){
_directory=((T0*)se_ms(1,"\n"));
}
 else if(r7same_as(se_ms(5,"Elate"),((C)->_system_name))){
_directory=((T0*)se_ms(3,"./\n"));
}


if((_directory)!=((void*)(NULL))){
r12echo_tfw_put_string(_directory);
}

_list=se_ma41(10,
((T0*)se_ms(6,"kernel")),
((T0*)se_ms(4,"base")),
((T0*)se_ms(2,"io")),
((T0*)se_ms(8,"iterator")),
((T0*)se_ms(6,"random")),
((T0*)se_ms(6,"number")),
((T0*)se_ms(7,"sorting")),
((T0*)se_ms(4,"time")),
((T0*)se_ms(5,"scoop")),
((T0*)se_ms(4,"misc")));
_i=((((T41*)_list))->_lower);
while (!((_i)>(((((T41*)_list))->_upper))))
{
_directory=r7twin((T7*)(((C)->_installation_path)));
r35compute_subdirectory_with(_directory,((T0*)se_ms(3,"lib")));
r7copy(((T7*)_directory),oBC35last_entry);
r35compute_subdirectory_with(_directory,r41item(((T41*)_list),_i));
r7copy(((T7*)_directory),oBC35last_entry);
r7extend(((T7*)_directory),((T3)'\n'));
r12echo_tfw_put_string(_directory);
_i=(_i)+((T2)(INT8_C(1)));
}
_tools_directory=r7twin((T7*)(((C)->_installation_path)));
r35compute_subdirectory_with(_tools_directory,((T0*)se_ms(5,"tools")));
r7copy(((T7*)_tools_directory),oBC35last_entry);
r12echo_tfw_put_string(_tools_directory);
r12echo_tfw_put_string(((T0*)se_ms(1,"\n")));
_list=se_ma41(6,
((T0*)se_ms(10,"expression")),
((T0*)se_ms(11,"instruction")),
((T0*)se_ms(6,"e_type")),
((T0*)se_ms(7,"feature")),
((T0*)se_ms(11,"run_feature")),
((T0*)se_ms(4,"misc")));
_i=((((T41*)_list))->_lower);
while (!((_i)>(((((T41*)_list))->_upper))))
{
_directory=r7twin(((T7*)_tools_directory));
r35compute_subdirectory_with(_directory,r41item(((T41*)_list),_i));
r7copy(((T7*)_directory),oBC35last_entry);
r7extend(((T7*)_directory),((T3)'\n'));
r12echo_tfw_put_string(_directory);
_i=(_i)+((T2)(INT8_C(1)));
}
_directory=r7twin((T7*)(((C)->_installation_path)));
r35compute_subdirectory_with(_directory,((T0*)se_ms(8,"tutorial")));
r7copy(((T7*)_directory),oBC35last_entry);
r12echo_tfw_put_string(_directory);
r31put_string((T31*)(oBC14echo),((T0*)se_ms(22,"\n--- Written data ---\n")));
r48disconnect((T48*)(oBC12tfw));
r31put_string((T31*)(oBC14echo),((T0*)se_ms(11,"Update of \"")));
r31put_string((T31*)(oBC14echo),_path);
r31put_string((T31*)(oBC14echo),((T0*)se_ms(41,"\" done.\nThe default loadpath is updated.\n")));
}


void r12clean_bin_c_directory_path(T12* C){
T2 _i=0;
T0* _item=NULL;
T0* _directory=NULL;
_i=(T2)(INT8_C(1));
while (!((_i)>(r41count((T41*)(oBC12no_split_command_list)))))
{
_item=r41item((T41*)(oBC12no_split_command_list),_i);
r12call_clean(_item);
_i=(_i)+((T2)(INT8_C(1)));
}
_i=(T2)(INT8_C(1));
while (!((_i)>(r41count((T41*)(oBC12splitted_command_list)))))
{
_item=r41item((T41*)(oBC12splitted_command_list),_i);

if(!(r7is_equal(((T7*)_item),((T0*)se_ms(12,"compile_to_c"))))){
r12call_clean(_item);
}

_i=(_i)+((T2)(INT8_C(1)));
}
{T44*n=((T44*)se_malloc(sizeof(*n)));
*n=M44;
r44scan_current_working_directory(n);
_directory=((T0*)n);
}
_i=INT8_C(1);
while (!((_i)>(r44upper(((T44*)_directory)))))
{
_item=r7twin((T7*)((((((T47*)(((((T44*)_directory))->_name_list))))->_storage))[(_i)-(INT8_C(1))]));
r12open_vms_entry_patch(C,_item);

if(r7has_prefix(((T7*)_item),((T0*)se_ms(12,"compile_to_c")))){

{int z1=r7last(((T7*)_item));
switch(z1){
case 67:
case 72:
case 99:
case 104:
break;
default:;
r31file_removing((T31*)(oBC14echo),_item);
}
}
}

_i=(_i)+((T2)(INT8_C(1)));
}

if(r7same_as(se_ms(9,"lcc-win32"),((C)->_c_compiler_name))){
r31put_string((T31*)(oBC14echo),((T0*)se_ms(44,"In order to reset \"compile_to_c\" -no_gc in \"")));
r31put_string((T31*)(oBC14echo),((C)->_bin_c_directory_path));
r31put_string((T31*)(oBC14echo),((T0*)se_ms(3,"\".\n")));
r12call_clean(((T0*)se_ms(12,"compile_to_c")));
r12call_compile_to_c(((T0*)se_ms(13,"-boost -no_gc")),((T0*)se_ms(12,"compile_to_c")));
{T0* b1=((T0*)se_ms(16,"compile_to_c.bat"));
r45delete(b1);
}
}

}


T0* r12argument(T2 a1){
T0* R=NULL;
R=((((T47*)(r12command_arguments()))->_storage))[a1];
return R;
}


void r12move_executable_for(T12* C,T0* a1){
T0* _executable=NULL;
T0* _old_path=NULL;
T0* _new_path=NULL;
_executable=r7twin(((T7*)a1));
r34add_x_suffix((T34*)(oBC12system_tools),_executable);
r35compute_file_path_with(((C)->_bin_c_directory_path),_executable);
_old_path=r7twin((T7*)(oBC35last_entry));
r35compute_file_path_with(((C)->_bin_directory_path),_executable);
_new_path=r7twin((T7*)(oBC35last_entry));

if(!(r12file_exists(_old_path))){
((((T31*)((T31*)(oBC14echo))))->_verbose)=(1);

r31put_string((T31*)(oBC14echo),((T0*)se_ms(219,"*** Fatal problem during installation of SmartEiffel.\n    Read carefully the following information before starting\n    again the `install\' -debug command.\n***************************************************************\n")));

r31put_string((T31*)(oBC14echo),((T0*)se_ms(27,"Unable to find executable \"")));
r31put_string((T31*)(oBC14echo),_old_path);
r31put_string((T31*)(oBC14echo),((T0*)se_ms(3,"\".\n")));
r12fatal_problem_description_end(C);
}


if(!(r7same_as(se_ms(5,"Elate"),((C)->_system_name)))){
r31file_renaming((T31*)(oBC14echo),_old_path,_new_path);
}
else{
r7copy((T7*)(oBC12command),((T0*)se_ms(4,"cpt ")));
r7append((T7*)(oBC12command),_old_path);
r7extend((T7*)(oBC12command),((T3)'\40'));
r7append((T7*)(oBC12command),_new_path);
r29put_string((T29*)(oBC19std_output),oBC12command);
r29put_string((T29*)(oBC19std_output),((T0*)se_ms(1,"\n")));
r31system_call((T31*)(oBC14echo),oBC12command);
}

}


void r12check_system_path_variable_warning(T12* C){
T6 _do_warning=0;
T0* _bin_directory=NULL;
T0* _variable=NULL;
T0* _content=NULL;
_do_warning=((T6)(1));
_bin_directory=r7twin((T7*)(((C)->_bin_directory_path)));

if((T6)(((T6)((r7same_as(se_ms(4,"UNIX"),((C)->_system_name)))||((T6)(r7same_as(se_ms(6,"Cygwin"),((C)->_system_name))))))||((T6)(r7same_as(se_ms(5,"Elate"),((C)->_system_name)))))){

if(r7same_as(se_ms(5,"Elate"),((C)->_system_name))){
_variable=((T0*)se_ms(10,"shell.path"));
}
else{
_variable=((T0*)se_ms(4,"PATH"));
}

_content=r31getenv(_variable,NULL);

if((_content)!=((void*)(NULL))){

if((r7last(((T7*)_bin_directory)))==(((T3)'\57'))){
r7remove_last(((T7*)_bin_directory),(T2)(INT8_C(1)));
}

_content=r7twin(((T7*)_content));
while (!((((((T7*)_content))->_count))==(INT8_C(0))))
{

if(r7has_prefix(((T7*)_content),_bin_directory)){
r7remove_first(((T7*)_content),((((T7*)_bin_directory))->_count));

if((((((T7*)_content))->_count))==(INT8_C(0))){
_do_warning=((T6)(0));
}
 else if(((((((T7*)_content))->_storage))[INT8_C(0)])==(((T3)'\72'))){
((((T7*)(((T7*)_content))))->_count)=((T2)(INT8_C(0)));

_do_warning=((T6)(0));
}
 else if(((((((T7*)_content))->_storage))[INT8_C(0)])==(((T3)'\57'))){
r7remove_first(((T7*)_content),(T2)(INT8_C(1)));

if((((((T7*)_content))->_count))==(INT8_C(0))){
_do_warning=((T6)(0));
}
 else if(((((((T7*)_content))->_storage))[INT8_C(0)])==(((T3)'\72'))){
((((T7*)(((T7*)_content))))->_count)=((T2)(INT8_C(0)));

_do_warning=((T6)(0));
}

}

}
else{
r7remove_first(((T7*)_content),(T2)(INT8_C(1)));
}

}
}

}
 else if(r7same_as(se_ms(7,"Windows"),((C)->_system_name))){
_content=r31getenv(((T0*)se_ms(4,"PATH")),NULL);

if((_content)!=((void*)(NULL))){

if((r7last(((T7*)_bin_directory)))==(((T3)'\134'))){
r7remove_last(((T7*)_bin_directory),(T2)(INT8_C(1)));
}

r7to_lower(((T7*)_bin_directory));
_content=r7twin(((T7*)_content));
r7to_lower(((T7*)_content));
while (!((((((T7*)_content))->_count))==(INT8_C(0))))
{

if(r7has_prefix(((T7*)_content),_bin_directory)){
r7remove_first(((T7*)_content),((((T7*)_bin_directory))->_count));

if((((((T7*)_content))->_count))==(INT8_C(0))){
_do_warning=((T6)(0));
}
 else if(((((((T7*)_content))->_storage))[INT8_C(0)])==(((T3)'\73'))){
((((T7*)(((T7*)_content))))->_count)=((T2)(INT8_C(0)));

_do_warning=((T6)(0));
}
 else if(((((((T7*)_content))->_storage))[INT8_C(0)])==(((T3)'\134'))){
r7remove_first(((T7*)_content),(T2)(INT8_C(1)));

if((((((T7*)_content))->_count))==(INT8_C(0))){
_do_warning=((T6)(0));
}
 else if(((((((T7*)_content))->_storage))[INT8_C(0)])==(((T3)'\73'))){
((((T7*)(((T7*)_content))))->_count)=((T2)(INT8_C(0)));

_do_warning=((T6)(0));
}

}

}
else{
r7remove_first(((T7*)_content),(T2)(INT8_C(1)));
}

}
}

}
else{
_do_warning=((T6)(0));
}


if(_do_warning){
r29put_string((T29*)(oBC19std_output),((T0*)se_ms(22,"Do not forget to add \"")));
r29put_string((T29*)(oBC19std_output),((C)->_bin_directory_path));
r29put_string((T29*)(oBC19std_output),((T0*)se_ms(12,"\" in \nyour \"")));

if((_variable)!=((void*)(NULL))){
r29put_string((T29*)(oBC19std_output),_variable);
}
else{
r29put_string((T29*)(oBC19std_output),((T0*)se_ms(6,"<PATH>")));
}

r29put_string((T29*)(oBC19std_output),((T0*)se_ms(19,"\" system variable.\n")));
}

}


void r12tfw_check_is_connected(T12* C,T0* a1){

if(!(((((T48*)(oBC12tfw))->_path))!=(NULL))){
((((T31*)((T31*)(oBC14echo))))->_verbose)=(1);

r31put_string((T31*)(oBC14echo),((T0*)se_ms(219,"*** Fatal problem during installation of SmartEiffel.\n    Read carefully the following information before starting\n    again the `install\' -debug command.\n***************************************************************\n")));

r31put_string((T31*)(oBC14echo),((T0*)se_ms(19,"Cannot write file \"")));
r31put_string((T31*)(oBC14echo),a1);
r31put_string((T31*)(oBC14echo),((T0*)se_ms(27,"\".\nCheck write permissions.")));
r12fatal_problem_description_end(C);
}

}


T0* r12choice_in(T0* a1,T0* a2){
T0* R=NULL;
T2 _i=0;
T0* _w=NULL;
T0* _n=NULL;
while (!((R)!=((void*)(NULL))))
{
r29put_string((T29*)(oBC19std_output),a1);
r29put_string((T29*)(oBC19std_output),((T0*)se_ms(4,":\n  ")));
_i=(T2)(INT8_C(1));
while (!((_i)>(((((T41*)a2))->_upper))))
{
r29put_string((T29*)(oBC19std_output),r41item(((T41*)a2),_i));
_i=(_i)+((T2)(INT8_C(1)));

if((_i)<=(((((T41*)a2))->_upper))){
r29put_string((T29*)(oBC19std_output),((T0*)se_ms(2,", ")));
}

}
r29put_string((T29*)(oBC19std_output),((T0*)se_ms(3,"\n? ")));
r29flush((T29*)(oBC19std_output));
r26read_word((T26*)(oBC19std_input));
_i=((((T41*)a2))->_lower);
_w=r7twin((T7*)(oBC27last_string));
r7to_lower(((T7*)_w));
while (!((_i)>(((((T41*)a2))->_upper))))
{
_n=r7twin((T7*)(r41item(((T41*)a2),_i)));
r7to_lower(((T7*)_n));

if(r7same_as(((T7*)_w),_n)){
R=r41item(((T41*)a2),_i);
_i=((((T41*)a2))->_upper);
}
 else if(r7has_prefix(((T7*)_n),_w)){

if((R)!=((void*)(NULL))){
R=NULL;
}
else{
R=r41item(((T41*)a2),_i);
}

}

_i=(_i)+((T2)(INT8_C(1)));
}

if((R)==((void*)(NULL))){
r29put_string((T29*)(oBC19std_output),((T0*)se_ms(1,"\"")));
r29put_string((T29*)(oBC19std_output),_w);
r29put_string((T29*)(oBC19std_output),((T0*)se_ms(25,"\" is not a valid choice.\n")));
}

}
r29put_string((T29*)(oBC19std_output),((T0*)se_ms(10,"selected: ")));
r29put_string((T29*)(oBC19std_output),R);
r29put_string((T29*)(oBC19std_output),((T0*)se_ms(1,"\n")));
return R;
}


void r32execute_command_line(T0* a1){

if((r32execute_command(a1))==(INT8_C(0))){
}

}


T2 r32execute_command(T0* a1){
T2 R=0;
T8 _p=NULL;
_p=r7to_external(((T7*)a1));
R=basic_system_execute_command(_p);
return R;
}


T0* r32get_environment_variable(T0* a1){
T0* R=NULL;
T8 _p=NULL;
T8 _null=NULL;
_p=r7to_external(((T7*)a1));
_p=basic_getenv(_p);

if((_p)!=(_null)){
{T7*n=((T7*)se_malloc(sizeof(*n)));
*n=M7;
r7from_external_copy(n,_p);
R=((T0*)n);
}
}

return R;
}


void r35set_notation_using(T0* a1){

{int z1=(((((T7*)a1))->_storage))[INT8_C(0)];
switch(z1){
case 46:
case 47:
case 126:
((((T7*)(((T0*)ms35_63)))->_storage))[((T2)(INT8_C(1)))-(INT8_C(1))]=(((T3)'U'));


if((((((T7*)a1))->_count))>=((T2)(INT8_C(4)))){

if(((((((T7*)a1))->_storage))[((T2)(INT8_C(2)))-(INT8_C(1))])==(((T3)'\57'))){

if(((((((T7*)a1))->_storage))[((T2)(INT8_C(4)))-(INT8_C(1))])==(((T3)'\57'))){
((((T7*)(((T0*)ms35_63)))->_storage))[((T2)(INT8_C(1)))-(INT8_C(1))]=(((T3)'C'));

}

}

}

break;
case 92:
((((T7*)(((T0*)ms35_63)))->_storage))[((T2)(INT8_C(1)))-(INT8_C(1))]=(((T3)'W'));

break;
case 58:
((((T7*)(((T0*)ms35_63)))->_storage))[((T2)(INT8_C(1)))-(INT8_C(1))]=(((T3)'M'));

break;
case 91:
((((T7*)(((T0*)ms35_63)))->_storage))[((T2)(INT8_C(1)))-(INT8_C(1))]=(((T3)'V'));

break;
case 65:
case 66:
case 67:
case 68:
case 69:
case 70:
case 71:
case 72:
case 73:
case 74:
case 75:
case 76:
case 77:
case 78:
case 79:
case 80:
case 81:
case 82:
case 83:
case 84:
case 85:
case 86:
case 87:
case 88:
case 89:
case 90:
case 97:
case 98:
case 99:
case 100:
case 101:
case 102:
case 103:
case 104:
case 105:
case 106:
case 107:
case 108:
case 109:
case 110:
case 111:
case 112:
case 113:
case 114:
case 115:
case 116:
case 117:
case 118:
case 119:
case 120:
case 121:
case 122:

if((((((T7*)a1))->_count))>=((T2)(INT8_C(2)))){

{int z2=(((((T7*)a1))->_storage))[((T2)(INT8_C(2)))-(INT8_C(1))];
switch(z2){
case 58:

if((((((T7*)a1))->_count))==(INT8_C(2))){
((((T7*)(((T0*)ms35_63)))->_storage))[((T2)(INT8_C(1)))-(INT8_C(1))]=(((T3)'W'));

}
 else if(r7has(((T7*)a1),((T3)'\134'))){
((((T7*)(((T0*)ms35_63)))->_storage))[((T2)(INT8_C(1)))-(INT8_C(1))]=(((T3)'W'));

}
 else if(r7has(((T7*)a1),((T3)'\77'))){
((((T7*)(((T0*)ms35_63)))->_storage))[((T2)(INT8_C(1)))-(INT8_C(1))]=(((T3)'A'));

}
 else if(r7has(((T7*)a1),((T3)'\57'))){
((((T7*)(((T0*)ms35_63)))->_storage))[((T2)(INT8_C(1)))-(INT8_C(1))]=(((T3)'C'));

}

break;
case 65:
case 66:
case 67:
case 68:
case 69:
case 70:
case 71:
case 72:
case 73:
case 74:
case 75:
case 76:
case 77:
case 78:
case 79:
case 80:
case 81:
case 82:
case 83:
case 84:
case 85:
case 86:
case 87:
case 88:
case 89:
case 90:
case 97:
case 98:
case 99:
case 100:
case 101:
case 102:
case 103:
case 104:
case 105:
case 106:
case 107:
case 108:
case 109:
case 110:
case 111:
case 112:
case 113:
case 114:
case 115:
case 116:
case 117:
case 118:
case 119:
case 120:
case 121:
case 122:

if(r7has(((T7*)a1),((T3)'\133'))){
((((T7*)(((T0*)ms35_63)))->_storage))[((T2)(INT8_C(1)))-(INT8_C(1))]=(((T3)'V'));

}
 else if(r7has(((T7*)a1),((T3)'\72'))){

if(r7has(((T7*)a1),((T3)'\57'))){
((((T7*)(((T0*)ms35_63)))->_storage))[((T2)(INT8_C(1)))-(INT8_C(1))]=(((T3)'A'));

}
 else if(r7has(((T7*)a1),((T3)'\133'))){
((((T7*)(((T0*)ms35_63)))->_storage))[((T2)(INT8_C(1)))-(INT8_C(1))]=(((T3)'V'));

}
else{
((((T7*)(((T0*)ms35_63)))->_storage))[((T2)(INT8_C(1)))-(INT8_C(1))]=(((T3)'A'));

}

}
 else if(r7has(((T7*)a1),((T3)'\57'))){
((((T7*)(((T0*)ms35_63)))->_storage))[((T2)(INT8_C(1)))-(INT8_C(1))]=(((T3)'U'));

}
 else if(r7has(((T7*)a1),((T3)'\134'))){
((((T7*)(((T0*)ms35_63)))->_storage))[((T2)(INT8_C(1)))-(INT8_C(1))]=(((T3)'U'));

}

break;
}
}
}

break;
}
}
}


T6 r35amiga_notation(void){
T6 R=0;
R=((T6)((((((T7*)(((T0*)ms35_63)))->_storage))[INT8_C(0)])==(((T3)'A'))));
return R;
}


void r35connect_to_current_working_directory(T35* C){
T8 _path=NULL;
_path=basic_directory_current_working_directory;

if((NULL!=_path)){
r7from_external_copy((T7*)(oBC35last_entry),_path);
(C->_directory_stream)=basic_directory_open(_path);
(C->_current_entry)=((*C)._directory_stream);

if(r8is_null(((*C)._directory_stream))){
((((T7*)((T7*)(oBC35last_entry))))->_count)=((T2)(INT8_C(0)));

}

}
else{
((((T7*)((T7*)(oBC35last_entry))))->_count)=((T2)(INT8_C(0)));

}

}


void r35disconnect(T35* C){
T8 _null=NULL;

if(basic_directory_close(((*C)._directory_stream))){
(C->_directory_stream)=_null;
(C->_current_entry)=_null;
}

}


void r35compute_subdirectory_with(T0* a1,T0* a2){
r7copy((T7*)(oBC35last_entry),a1);

if((T6)((r35unix_notation())||((T6)(r35cygwin_notation())))){

if(r7is_equal(ms35_46,a2)){
((((T7*)((T7*)(oBC35last_entry))))->_count)=((T2)(INT8_C(0)));

}
 else if(r7is_equal(ms35_276,a2)){
((((T7*)((T7*)(oBC35last_entry))))->_count)=((T2)(INT8_C(0)));

}
else{
r7extend_unless((T7*)(oBC35last_entry),((T3)'\57'));

if(((((((T7*)a2))->_storage))[INT8_C(0)])==(((T3)'\57'))){
r7remove_last((T7*)(oBC35last_entry),(T2)(INT8_C(1)));
}

r7append((T7*)(oBC35last_entry),a2);
r7extend_unless((T7*)(oBC35last_entry),((T3)'\57'));
}

}
 else if(r35windows_notation()){

if(r7is_equal(ms35_46a,a2)){
((((T7*)((T7*)(oBC35last_entry))))->_count)=((T2)(INT8_C(0)));

}
 else if(r7is_equal(ms35_276a,a2)){
((((T7*)((T7*)(oBC35last_entry))))->_count)=((T2)(INT8_C(0)));

}
else{
r7extend_unless((T7*)(oBC35last_entry),((T3)'\134'));

if(((((((T7*)a2))->_storage))[INT8_C(0)])==(((T3)'\134'))){
r7remove_last((T7*)(oBC35last_entry),(T2)(INT8_C(1)));
}

r7append((T7*)(oBC35last_entry),a2);
r7extend_unless((T7*)(oBC35last_entry),((T3)'\134'));
}

}
 else if(r35amiga_notation()){

{int z1=r7last((T7*)(oBC35last_entry));
switch(z1){
case 47:

if(((((((T7*)a2))->_storage))[INT8_C(0)])==(((T3)'\57'))){
r7remove_last((T7*)(oBC35last_entry),(T2)(INT8_C(1)));
}

break;
case 58:
break;
default:;

if(((((((T7*)a2))->_storage))[INT8_C(0)])!=(((T3)'\57'))){
r7add_last((T7*)(oBC35last_entry),((T3)'\57'));
}

}
}
r7append((T7*)(oBC35last_entry),a2);
r7extend_unless((T7*)(oBC35last_entry),((T3)'\57'));
}
 else if(r35macintosh_notation()){
r7extend_unless((T7*)(oBC35last_entry),((T3)'\72'));

if(((((((T7*)a2))->_storage))[INT8_C(0)])==(((T3)'\72'))){
r7remove_last((T7*)(oBC35last_entry),(T2)(INT8_C(1)));
}

r7append((T7*)(oBC35last_entry),a2);
r7extend_unless((T7*)(oBC35last_entry),((T3)'\72'));
}
 else if(r35openvms_notation()){

if(((((T7*)(oBC35last_entry))->_count))==(INT8_C(1))){
((((T7*)((T7*)(oBC35last_entry))))->_count)=((T2)(INT8_C(0)));

}
 else if((r7last((T7*)(oBC35last_entry)))==(((T3)'\135'))){
r7remove_last((T7*)(oBC35last_entry),(T2)(INT8_C(1)));

if((r7last((T7*)(oBC35last_entry)))==(((T3)'\133'))){
r7append((T7*)(oBC35last_entry),a2);
r7extend((T7*)(oBC35last_entry),((T3)'\135'));
}
else{
r7extend((T7*)(oBC35last_entry),((T3)'\56'));
r7append((T7*)(oBC35last_entry),a2);
r7extend((T7*)(oBC35last_entry),((T3)'\135'));
}

}
 else if((r7last((T7*)(oBC35last_entry)))==(((T3)'\72'))){
r7extend((T7*)(oBC35last_entry),((T3)'\133'));
r7append((T7*)(oBC35last_entry),a2);
r7extend((T7*)(oBC35last_entry),((T3)'\135'));
}
else{
((((T7*)((T7*)(oBC35last_entry))))->_count)=((T2)(INT8_C(0)));

}

}
 else if(r35system_notation_detected()){
((((T7*)((T7*)(oBC35last_entry))))->_count)=((T2)(INT8_C(0)));

}
else{
r35set_notation_using(a1);

if(r35system_notation_detected()){
r35compute_subdirectory_with(a1,a2);
}
else{
((((T7*)((T7*)(oBC35last_entry))))->_count)=((T2)(INT8_C(0)));

}

}

}


T6 r35system_notation_detected(void){
T6 R=0;
R=((T6)((((((T7*)(((T0*)ms35_63)))->_storage))[INT8_C(0)])!=(((T3)'\77'))));
return R;
}


T6 r35windows_notation(void){
T6 R=0;
R=((T6)((((((T7*)(((T0*)ms35_63)))->_storage))[INT8_C(0)])==(((T3)'W'))));
return R;
}


T6 r35unix_notation(void){
T6 R=0;
R=((T6)((((((T7*)(((T0*)ms35_63)))->_storage))[INT8_C(0)])==(((T3)'U'))));
return R;
}


void r35reset_notation_using(T0* a1){
((((T7*)(((T0*)ms35_63)))->_storage))[((T2)(INT8_C(1)))-(INT8_C(1))]=(((T3)'\77'));

r35set_notation_using(a1);
}
T0*oBC35last_entry=NULL;


T6 r35macintosh_notation(void){
T6 R=0;
R=((T6)((((((T7*)(((T0*)ms35_63)))->_storage))[INT8_C(0)])==(((T3)'M'))));
return R;
}


void r35change_current_working_directory(T35* C,T0* a1){
T8 _p=NULL;
_p=r7to_external(((T7*)a1));

if(basic_directory_chdir(_p)){
r35connect_to_current_working_directory(C);

if((NULL!=((*C)._directory_stream))){
r35disconnect(C);
}
else{
((((T7*)((T7*)(oBC35last_entry))))->_count)=((T2)(INT8_C(0)));

}

}
else{
((((T7*)((T7*)(oBC35last_entry))))->_count)=((T2)(INT8_C(0)));

}

}


void r35compute_parent_directory_of(T0* a1){
r7copy((T7*)(oBC35last_entry),a1);

if(r35unix_notation()){
r7remove_last((T7*)(oBC35last_entry),(T2)(INT8_C(1)));
while (!((T6)((((((T7*)(oBC35last_entry))->_count))==(INT8_C(0)))||((T6)((r7last((T7*)(oBC35last_entry)))==(((T3)'\57')))))))
{
r7remove_last((T7*)(oBC35last_entry),(T2)(INT8_C(1)));
}
}
 else if(r35windows_notation()){
r7remove_last((T7*)(oBC35last_entry),(T2)(INT8_C(1)));
while (!((T6)((((((T7*)(oBC35last_entry))->_count))==(INT8_C(0)))||((T6)((r7last((T7*)(oBC35last_entry)))==(((T3)'\134')))))))
{
r7remove_last((T7*)(oBC35last_entry),(T2)(INT8_C(1)));
}
}
 else if(r35cygwin_notation()){
r7remove_last((T7*)(oBC35last_entry),(T2)(INT8_C(1)));
while (!((T6)(((T6)((((((T7*)(oBC35last_entry))->_count))==(INT8_C(0)))||((T6)((r7last((T7*)(oBC35last_entry)))==(((T3)'\57'))))))||((T6)((r7last((T7*)(oBC35last_entry)))==(((T3)'\72')))))))
{
r7remove_last((T7*)(oBC35last_entry),(T2)(INT8_C(1)));
}

if(((((T7*)(oBC35last_entry))->_count))==(INT8_C(0))){
}
 else if((((((T7*)(oBC35last_entry))->_storage))[INT8_C(0)])==(((T3)'\57'))){

if(((((T7*)(oBC35last_entry))->_count))==(INT8_C(2))){

if((((((T7*)(oBC35last_entry))->_storage))[((T2)(INT8_C(2)))-(INT8_C(1))])==(((T3)'\57'))){
r7remove_last((T7*)(oBC35last_entry),(T2)(INT8_C(1)));
}

}

}

}
 else if(r35amiga_notation()){

if((r7last((T7*)(oBC35last_entry)))==(((T3)'\72'))){
((((T7*)((T7*)(oBC35last_entry))))->_count)=((T2)(INT8_C(0)));

}
else{
r7remove_last((T7*)(oBC35last_entry),(T2)(INT8_C(1)));
while (!((T6)(((T6)((((((T7*)(oBC35last_entry))->_count))==(INT8_C(0)))||((T6)((r7last((T7*)(oBC35last_entry)))==(((T3)'\57'))))))||((T6)((r7last((T7*)(oBC35last_entry)))==(((T3)'\72')))))))
{
r7remove_last((T7*)(oBC35last_entry),(T2)(INT8_C(1)));
}
}

}
 else if(r35macintosh_notation()){
r7remove_last((T7*)(oBC35last_entry),(T2)(INT8_C(1)));
while (!((T6)((((((T7*)(oBC35last_entry))->_count))==(INT8_C(0)))||((T6)((r7last((T7*)(oBC35last_entry)))==(((T3)'\72')))))))
{
r7remove_last((T7*)(oBC35last_entry),(T2)(INT8_C(1)));
}
}
 else if(r35openvms_notation()){

if((r7last((T7*)(oBC35last_entry)))==(((T3)'\135'))){
r7remove_last((T7*)(oBC35last_entry),(T2)(INT8_C(1)));
while (!((T6)(((T6)((((((T7*)(oBC35last_entry))->_count))==(INT8_C(0)))||((T6)((r7last((T7*)(oBC35last_entry)))==(((T3)'\56'))))))||((T6)((r7last((T7*)(oBC35last_entry)))==(((T3)'\133')))))))
{
r7remove_last((T7*)(oBC35last_entry),(T2)(INT8_C(1)));
}

if(((((T7*)(oBC35last_entry))->_count))>((T2)(INT8_C(0)))){

{int z1=r7last((T7*)(oBC35last_entry));
switch(z1){
case 46:
r7remove_last((T7*)(oBC35last_entry),(T2)(INT8_C(1)));
r7extend((T7*)(oBC35last_entry),((T3)'\135'));
break;
default:;

if(((((T7*)(oBC35last_entry))->_count))==((((((T7*)a1))->_count))-((T2)(INT8_C(1))))){
r7remove_last((T7*)(oBC35last_entry),(T2)(INT8_C(1)));
}
else{
r7extend((T7*)(oBC35last_entry),((T3)'\135'));
}

}
}
}

}
 else if((r7last((T7*)(oBC35last_entry)))==(((T3)'\72'))){
((((T7*)((T7*)(oBC35last_entry))))->_count)=((T2)(INT8_C(0)));

}
else{
r7remove_last((T7*)(oBC35last_entry),(T2)(INT8_C(1)));
while (!((T6)((((((T7*)(oBC35last_entry))->_count))==(INT8_C(0)))||((T6)((r7last((T7*)(oBC35last_entry)))==(((T3)'\135')))))))
{
r7remove_last((T7*)(oBC35last_entry),(T2)(INT8_C(1)));
}

if(((((T7*)(oBC35last_entry))->_count))==(INT8_C(0))){
((((T7*)((T7*)(oBC35last_entry))))->_count)=((T2)(INT8_C(0)));

}

}

}
 else if(r35system_notation_detected()){
((((T7*)((T7*)(oBC35last_entry))))->_count)=((T2)(INT8_C(0)));

}
else{
r35set_notation_using(a1);

if(r35system_notation_detected()){
r35compute_parent_directory_of(a1);
}
else{
((((T7*)((T7*)(oBC35last_entry))))->_count)=((T2)(INT8_C(0)));

}

}

}


void r35read_entry(T35* C){
T8 _name=NULL;
(C->_current_entry)=basic_directory_read_entry(((*C)._directory_stream));

if((NULL!=((*C)._current_entry))){
_name=basic_directory_get_entry_name(((*C)._current_entry));
r7from_external_copy((T7*)(oBC35last_entry),_name);
}

}


void r35connect_to(T35* C,T0* a1){
T8 _path_pointer=NULL;
_path_pointer=r7to_external(((T7*)a1));
(C->_directory_stream)=basic_directory_open(_path_pointer);
(C->_current_entry)=((*C)._directory_stream);
((((T7*)((T7*)(oBC35last_entry))))->_count)=((T2)(INT8_C(0)));

}


T6 r35create_new_directory(T0* a1){
T6 R=0;
T8 _p=NULL;
_p=r7to_external(((T7*)a1));
R=((T6)(basic_directory_mkdir(_p)));
return R;
}


void r35compute_file_path_with(T0* a1,T0* a2){
r7copy((T7*)(oBC35last_entry),a1);

if((T6)((r35unix_notation())||((T6)(r35cygwin_notation())))){
r7extend_unless((T7*)(oBC35last_entry),((T3)'\57'));

if(((((((T7*)a2))->_storage))[INT8_C(0)])==(((T3)'\57'))){
r7remove_last((T7*)(oBC35last_entry),(T2)(INT8_C(1)));
}

r7append((T7*)(oBC35last_entry),a2);
}
 else if(r35windows_notation()){
r7extend_unless((T7*)(oBC35last_entry),((T3)'\134'));

if(((((((T7*)a2))->_storage))[INT8_C(0)])==(((T3)'\134'))){
r7remove_last((T7*)(oBC35last_entry),(T2)(INT8_C(1)));
}

r7append((T7*)(oBC35last_entry),a2);
}
 else if(r35amiga_notation()){

{int z1=r7last((T7*)(oBC35last_entry));
switch(z1){
case 58:
break;
case 47:

if(((((((T7*)a2))->_storage))[INT8_C(0)])==(((T3)'\57'))){
r7remove_last((T7*)(oBC35last_entry),(T2)(INT8_C(1)));
}

break;
default:;

if(((((((T7*)a2))->_storage))[INT8_C(0)])!=(((T3)'\57'))){
r7extend((T7*)(oBC35last_entry),((T3)'\57'));
}

}
}
r7append((T7*)(oBC35last_entry),a2);
}
 else if(r35macintosh_notation()){
r7extend_unless((T7*)(oBC35last_entry),((T3)'\72'));

if(((((((T7*)a2))->_storage))[INT8_C(0)])==(((T3)'\72'))){
r7remove_last((T7*)(oBC35last_entry),(T2)(INT8_C(1)));
}

r7append((T7*)(oBC35last_entry),a2);
}
 else if(r35openvms_notation()){

{int z1=r7last((T7*)(oBC35last_entry));
switch(z1){
case 93:
break;
case 46:
r7remove_last((T7*)(oBC35last_entry),(T2)(INT8_C(1)));
r7extend((T7*)(oBC35last_entry),((T3)'\135'));
break;
default:;
r7extend((T7*)(oBC35last_entry),((T3)'\135'));
}
}

if(((((((T7*)a2))->_storage))[INT8_C(0)])==(((T3)'\135'))){
r7remove_last((T7*)(oBC35last_entry),(T2)(INT8_C(1)));
}

r7append((T7*)(oBC35last_entry),a2);
}
 else if(r35system_notation_detected()){
((((T7*)((T7*)(oBC35last_entry))))->_count)=((T2)(INT8_C(0)));

}
else{
r35set_notation_using(a1);

if(r35system_notation_detected()){
r35compute_file_path_with(a1,a2);
}
else{
((((T7*)((T7*)(oBC35last_entry))))->_count)=((T2)(INT8_C(0)));

}

}

}


T6 r35openvms_notation(void){
T6 R=0;
R=((T6)((((((T7*)(((T0*)ms35_63)))->_storage))[INT8_C(0)])==(((T3)'V'))));
return R;
}


T6 r35cygwin_notation(void){
T6 R=0;
R=((T6)((((((T7*)(((T0*)ms35_63)))->_storage))[INT8_C(0)])==(((T3)'C'))));
return R;
}
T12*eiffel_root_object=NULL;
int se_argc;
char**se_argv;
T7* g[56];
T7* t[56];

void std_output_flush(void){
void*C=(void*)oBC19std_output;
r29flush(((T29*)C));
}

void initialize_eiffel_runtime(int argc,char*argv[]){
se_argc=argc;
se_argv=argv;
atexit(std_output_flush);
g[25]=se_string("SAFE_EQUAL");
g[30]=se_string("OUTPUT_STREAM");
g[18]=se_string("PLATFORM");
g[22]=se_string("INTEGER_GENERAL");
g[13]=se_string("COMMAND_LINE_TOOLS");
g[2]=se_string("INTEGER");
g[7]=se_string("STRING");
g[20]=se_string("COMPARABLE");
g[1]=se_string("INTEGER_8");
g[50]=se_string("ACE");
g[17]=se_string("ANY");
g[46]=se_string("FIXED_ARRAY");
g[29]=se_string("STD_OUTPUT");
g[23]=se_string("NUMERIC");
g[35]=se_string("BASIC_DIRECTORY");
g[16]=se_string("ALIASED_STRING_LIST");
g[36]=se_string("TEXT_FILE_READ");
g[19]=se_string("GENERAL");
g[40]=se_string("TUPLE");
g[32]=se_string("SYSTEM");
g[33]=se_string("STD_ERROR");
g[10]=se_string("INTEGER_16");
g[11]=se_string("INTEGER_64");
g[37]=se_string("ARRAY");
g[45]=se_string("FILE_TOOLS");
g[14]=se_string("GLOBALS");
g[21]=se_string("HASHABLE");
g[52]=se_string("PARSER");
g[44]=se_string("DIRECTORY");
g[8]=se_string("POINTER");
g[48]=se_string("TEXT_FILE_WRITE");
g[49]=se_string("MEMORY");
g[34]=se_string("SYSTEM_TOOLS");
g[24]=se_string("NATIVE_ARRAY");
g[15]=se_string("FROZEN_STRING_LIST");
g[39]=se_string("COLLECTION");
g[26]=se_string("STD_INPUT");
g[51]=se_string("ASSERTION_LEVEL_NUMBERING");
g[3]=se_string("CHARACTER");
g[28]=se_string("STRING_HANDLER");
g[27]=se_string("INPUT_STREAM");
g[6]=se_string("BOOLEAN");
g[0]=se_string("NONE");
g[31]=se_string("ECHO");
g[12]=se_string("INSTALL");
g[38]=se_string("ARRAYED_COLLECTION");
g[55]=se_string("SMART_EIFFEL");
g[47]=g[46];
g[42]=g[24];
g[9]=g[24];
g[43]=g[25];
g[41]=g[37];
t[8]=g[8];
t[45]=g[45];
t[6]=g[6];
t[3]=g[3];
t[1]=g[1];
t[26]=g[26];
t[50]=g[50];
t[12]=g[12];
t[32]=g[32];
t[47]=se_string("FIXED_ARRAY[STRING]");
t[31]=g[31];
t[36]=g[36];
t[42]=se_string("NATIVE_ARRAY[STRING]");
t[34]=g[34];
t[7]=g[7];
t[9]=se_string("NATIVE_ARRAY[CHARACTER]");
t[35]=g[35];
t[43]=se_string("SAFE_EQUAL[STRING]");
t[55]=g[55];
t[44]=g[44];
t[2]=g[2];
t[41]=se_string("ARRAY[STRING]");
t[11]=g[11];
t[10]=g[10];
t[48]=g[48];
t[29]=g[29];
t[33]=g[33];
#ifdef SIGINT
signal(SIGINT,se_signal_handler);
#endif
#ifdef SIGQUIT
signal(SIGQUIT,se_signal_handler);
#endif
#ifdef SIGTERM
signal(SIGTERM,se_signal_handler);
#endif
#ifdef SIGBREAK
signal(SIGBREAK,se_signal_handler);
#endif
#ifdef SIGKILL
signal(SIGKILL,se_signal_handler);
#endif
se_msi1();

{T55*n=((T55*)se_malloc(1));
oBC14smart_eiffel=((T0*)n);
}

{T36*n=((T36*)se_malloc(sizeof(*n)));
*n=M36;
oBC12tfr=((T0*)n);

}

{T48*n=((T48*)se_malloc(sizeof(*n)));
*n=M48;
oBC12tfw=((T0*)n);
r48make(n);
}

oBC34compiler_list=se_ma41(13,
((T0*)ms34_3169),
((T0*)ms34_51699930),
((T0*)ms34_594),
((T0*)ms34_448859),
((T0*)ms34_76405),
((T0*)ms34_603),
((T0*)ms34_674),
((T0*)ms34_15721),
((T0*)ms34_17794),
((T0*)ms34_3069),
((T0*)ms34_18144),
((T0*)ms34_207986277),
((T0*)ms34_3494));

{T7*n=((T7*)se_malloc(sizeof(*n)));
*n=M7;
oBC27last_string=((T0*)n);
r7make(n,(T2)(INT16_C(1024)));
}

{T50*n=((T50*)se_malloc(sizeof(*n)));
*n=M50;
oBC14ace=((T0*)n);
}


{T7*n=((T7*)se_malloc(sizeof(*n)));
*n=M7;
oBC34token_buffer=((T0*)n);
r7make(n,(T2)(INT16_C(128)));
}

{T7*n=((T7*)se_malloc(sizeof(*n)));
*n=M7;
oBC7string_buffer=((T0*)n);
r7make(n,(T2)(INT16_C(256)));
}

{T41*n=((T41*)se_malloc(sizeof(*n)));
*n=M41;
oBC7split_buffer=((T0*)n);
r41with_capacity(n,(T2)(INT8_C(4)),(T2)(INT8_C(1)));
}

{T7*n=((T7*)se_malloc(sizeof(*n)));
*n=M7;
oBC30tmp_string=((T0*)n);
r7make(n,(T2)(INT16_C(512)));
}

oBC12no_split_command_list=se_ma41(5,
((T0*)se_ms(5,"clean")),
((T0*)se_ms(7,"compile")),
((T0*)se_ms(6,"finder")),
((T0*)se_ms(9,"ace_check")),
((T0*)se_ms(15,"print_jvm_class")));

oBC12splitted_command_list=se_ma41(4,
((T0*)se_ms(12,"compile_to_c")),
((T0*)se_ms(5,"short")),
((T0*)se_ms(6,"pretty")),
((T0*)se_ms(14,"compile_to_jvm")));

{T36*n=((T36*)se_malloc(sizeof(*n)));
*n=M36;
oBC45tfr1=((T0*)n);

}

{T34*n=((T34*)se_malloc(sizeof(*n)));
*n=M34;
oBC12system_tools=((T0*)n);

}

{T7*n=((T7*)se_malloc(sizeof(*n)));
*n=M7;
oBC12command=((T0*)n);
r7make(n,(T2)(INT16_C(512)));
}

{T7*n=((T7*)se_malloc(sizeof(*n)));
*n=M7;
oBC14tmp_path=((T0*)n);
r7make(n,(T2)(INT16_C(512)));
}

{T29*n=((T29*)se_malloc(sizeof(*n)));
*n=M29;
oBC19std_output=((T0*)n);
r29make(n);
}

{T31*n=((T31*)se_malloc(sizeof(*n)));
*n=M31;
oBC14echo=((T0*)n);

}

oBC34system_list=se_ma41(10,
((T0*)ms34_13028),
((T0*)ms34_1772235),
((T0*)ms34_301485),
((T0*)ms34_11253),
((T0*)ms34_39617954),
((T0*)ms34_57487),
((T0*)ms34_2178),
((T0*)ms34_2440),
((T0*)ms34_1663868),
((T0*)ms34_59731));

{T36*n=((T36*)se_malloc(sizeof(*n)));
*n=M36;
oBC14tmp_file_read=((T0*)n);

}

{T7*n=((T7*)se_malloc(sizeof(*n)));
*n=M7;
oBC35last_entry=((T0*)n);
r7make(n,(T2)(INT16_C(256)));
}

{T33*n=((T33*)se_malloc(1));
oBC19std_error=((T0*)n);

}

{T26*n=((T26*)se_malloc(sizeof(*n)));
*n=M26;
oBC19std_input=((T0*)n);
r26make(n);
}

{
T12*n=((T12*)se_malloc(sizeof(*n)));
*n=M12;
eiffel_root_object=n;
}
}
int main(int argc,char*argv[]){
initialize_eiffel_runtime(argc,argv);
{T12*n=eiffel_root_object;
r12make(n);
}
exit(0);
return 0;}
T7*ms34_968120;
T7*ms35_46;
T7*ms35_63;
T7*ms31_210310269;
T7*ms15_216;
T7*ms35_276;
T7*ms34_84381;
T7*ms35_46a;
T7*ms31_203714719;
T7*ms34_128214728;
T7*ms34_91157;
T7*ms15_1090;
T7*ms34_9073a;
T7*ms34_1721407046;
T7*ms34_1106932385;
T7*ms15_3085;
T7*ms34_1772235;
T7*ms15_3595;
T7*ms34_683870135a;
T7*ms34_0aaaaaaa;
T7*ms34_530877013;
T7*ms34_466551816;
T7*ms12_2073823;
T7*ms34_17494489;
T7*ms35_276a;
T7*ms34_301485;
T7*ms31_1071750288;
T7*ms34_426884100;
T7*ms34_270309168;
T7*ms15_1072344038;
T7*ms31_136264778;
T7*ms34_1236979201;
T7*ms34_447734;
T7*ms34_11253;
T7*ms34_1102814319;
T7*ms31_1520107011;
T7*ms34_1631212670;
T7*ms34_448859;
T7*ms34_13028;
T7*ms31_1635864124;
T7*ms34_12782;
T7*ms31_210141519;
T7*ms34_262628264;
T7*ms31_1974940930;
T7*ms12_0;
T7*ms34_721564652;
T7*ms34_616914401;
T7*ms34_15721;
T7*ms34_15828;
T7*ms34_0aaaa;
T7*ms34_16702;
T7*ms34_2075119688;
T7*ms34_0;
T7*ms55_983674906;
T7*ms34_18144;
T7*ms34_17794;
T7*ms34_9073aa;
T7*ms34_39617954;
T7*ms34_1038797513;
T7*ms34_1091987;
T7*ms31_141444;
T7*ms34_51699930;
T7*ms34_467476687;
T7*ms34_72020566;
T7*ms15_56612951;
T7*ms31_354654986;
T7*ms34_0aaaaaaaa;
T7*ms34_1361085152;
T7*ms34_373286592;
T7*ms34_39204698;
T7*ms34_876917780;
T7*ms34_683870135;
T7*ms34_1335;
T7*ms34_561720547;
T7*ms34_1438;
T7*ms34_1570;
T7*ms34_2178;
T7*ms34_1744;
T7*ms34_1494914262;
T7*ms34_2440;
T7*ms31_3556890;
T7*ms34_2565;
T7*ms34_3069;
T7*ms34_3094;
T7*ms34_3169;
T7*ms34_146157;
T7*ms34_2833;
T7*ms31_1293738877;
T7*ms34_3294;
T7*ms34_1663868;
T7*ms34_333a;
T7*ms34_340a;
T7*ms34_3494;
T7*ms31_113009969;
T7*ms31_1800535743;
T7*ms34_179868158;
T7*ms14_8897;
T7*ms31_1662662954;
T7*ms34_581585530;
T7*ms34_146157a;
T7*ms34_6687;
T7*ms34_355003;
T7*ms34_57487;
T7*ms13_118;
T7*ms34_9107;
T7*ms34_9121;
T7*ms34_9073;
T7*ms13_1042405932;
T7*ms34_8976;
T7*ms34_59731;
T7*ms34_0aaa;
T7*ms34_0aaaaa;
T7*ms15_2248290;
T7*ms34_698995372;
T7*ms34_836475934;
T7*ms34_0aaaaaa;
T7*ms34_415107;
T7*ms15_300594;
T7*ms34_98806116;
T7*ms31_1430004157;
T7*ms13_142550;
T7*ms34_207986277;
T7*ms14_329;
T7*ms34_109;
T7*ms31_44975894;
T7*ms34_304;
T7*ms34_324;
T7*ms34_326;
T7*ms34_333;
T7*ms34_329;
T7*ms34_340;
T7*ms34_336;
T7*ms34_341;
T7*ms34_297;
T7*ms34_218174;
T7*ms34_603;
T7*ms34_594;
T7*ms34_674;
T7*ms34_689;
T7*ms31_27561173;
T7*ms34_69851;
T7*ms34_0aa;
T7*ms34_19761224;
T7*ms31_1711985232;
T7*ms34_76405;
T7*ms34_1327525317;
T7*ms34_0a;

T7*se_ms(int c,char*e){

T7*s=((T7*)se_malloc(sizeof(T7)));
s->_count=c;
s->_capacity=c+1;
s->_storage=((T9)se_malloc(c+1));
memcpy(s->_storage,e,c+1);
return s;}

T7*se_string(char*e){

int c=strlen(e);
T7*s=((T7*)se_malloc(sizeof(T7)));
s->_count=c;
s->_capacity=c+1;
s->_storage=((T9)se_malloc(c+1));
memcpy(s->_storage,e,c+1);
return s;}


EIF_STRING se_ms_trace(int count, char* c_string, int li, int co, char* path) {
  int i;
  fprintf(SE_ERR,"\"");
  for (i = 0; i < count ; i++) {
    fprintf(SE_ERR,"%c",c_string[i]);
  }
  fprintf(SE_ERR,"\" (-manifest_string_trace: line %d column %d %s)\n",
   li,co,path);
  return se_ms(count,c_string);
}

void se_msi1(void){
ms34_968120=se_ms(7,"-DAMIGA");
ms35_46=se_ms(1,".");
ms35_63=se_ms(1,"?");
ms31_210310269=se_ms(10,"Removing \"");
ms15_216=se_ms(2,"\".");
ms35_276=se_ms(2,"..");
ms34_84381=se_ms(5,"mieee");
ms35_46a=se_ms(1,".");
ms31_203714719=se_ms(10,"Obsolete \"");
ms34_128214728=se_ms(27,"Hope this is a VMS system.\n");
ms34_91157=se_ms(5,"wlink");
ms15_1090=se_ms(3,"\".\n");
ms34_9073a=se_ms(4,".lib");
ms34_1721407046=se_ms(34,"Math=IEEE Parameters=Both Code=Far");
ms34_1106932385=se_ms(13,"Last chance.\n");
ms15_3085=se_ms(3,"bin");
ms34_1772235=se_ms(7,"Windows");
ms15_3595=se_ms(3,"sys");
ms34_683870135a=se_ms(45,"cc/warning=disable=(embedcomment,longextern) ");
ms34_0aaaaaaa=se_ms(0,"");
ms34_530877013=se_ms(11," StripDebug");
ms34_466551816=se_ms(11,"$ link/exe=");
ms12_2073823=se_ms(7,"install");
ms34_17494489=se_ms(15,"compile_to_c: \"");
ms35_276a=se_ms(2,"..");
ms34_301485=se_ms(6,"Cygwin");
ms31_1071750288=se_ms(11,"SmallEiffel");
ms34_426884100=se_ms(22,"Optimize OptimizerTime");
ms34_270309168=se_ms(34,"Currently handled compiler names:\n");
ms15_1072344038=se_ms(11,"SmartEiffel");
ms31_136264778=se_ms(21,"Reading one word in \"");
ms34_1236979201=se_ms(11,"compiler.se");
ms34_447734=se_ms(6,"wcc386");
ms34_11253=se_ms(4,"BeOS");
ms34_1102814319=se_ms(11,"System is \"");
ms31_1520107011=se_ms(39,"Unexpected end_of_input while reading \"");
ms34_1631212670=se_ms(38,"Hope this is a Macintosh like system.\n");
ms34_448859=se_ms(6,"wcl386");
ms34_13028=se_ms(4,"UNIX");
ms31_1635864124=se_ms(20,"SmartEiffelDirectory");
ms34_12782=se_ms(4,"Link");
ms31_210141519=se_ms(10,"Renaming \"");
ms34_262628264=se_ms(10,"linkit.com");
ms31_1974940930=se_ms(15,"\" variable used");
ms12_0=se_ms(0,"");
ms34_721564652=se_ms(18," NoVersion NoIcons");
ms34_616914401=se_ms(11,"-O2 -nologo");
ms34_15721=se_ms(4,"dice");
ms34_15828=se_ms(4,"cpml");
ms34_0aaaa=se_ms(0,"");
se_msi2();
}

void se_msi2(void){
ms34_16702=se_ms(4,"mcr ");
ms34_2075119688=se_ms(22,"#1#2#3#4#5#6#7#8#9#?.o");
ms34_0=se_ms(0,"");
ms55_983674906=se_ms(246,"SmartEiffel The GNU Eiffel Compiler, Eiffel tools and libraries\nRelease 1.0 (Friday December 6th 2002)\nCopyright (C), 1994-2002 - LORIA - UHP - INRIA - FRANCE\nDominique COLNET and Suzanne COLLIN - SmartEiffel@loria.fr\nhttp://SmartEiffel.loria.fr\n");
ms34_18144=se_ms(4,"vpcc");
ms34_17794=se_ms(4,"vbcc");
ms34_9073aa=se_ms(4,".lib");
ms34_39617954=se_ms(9,"Macintosh");
ms34_1038797513=se_ms(13,"SmartEiffel=\"");
ms34_1091987=se_ms(7,"-mD -mC");
ms31_141444=se_ms(6,"\" as \"");
ms34_51699930=se_ms(9,"lcc-win32");
ms34_467476687=se_ms(33,"Hope this is a Unix like system.\n");
ms34_72020566=se_ms(10,"\nlink/exe=");
ms15_56612951=se_ms(9,"system.se");
ms31_354654986=se_ms(23,"Environment variable $\173""");
ms34_0aaaaaaaa=se_ms(0,"");
ms34_1361085152=se_ms(30,"@linkit.com\ndelete linkit.com;");
ms34_373286592=se_ms(35,"\".\nCurrently handled system names:\n");
ms34_39204698=se_ms(9,"SCOPTIONS");
ms34_876917780=se_ms(31,"Unknown compiler name in file\n\"");
ms34_683870135=se_ms(45,"cc/warning=disable=(embedcomment,longextern) ");
ms34_1335=se_ms(3,",-\n");
ms34_561720547=se_ms(62,"\": unknown C compiler name after -cc flag or in the ACE file.\n");
ms34_1438=se_ms(3,".00");
ms34_1570=se_ms(3,"-O2");
ms34_2178=se_ms(3,"DOS");
ms34_1744=se_ms(3,".cc");
ms34_1494914262=se_ms(18," Ignore=93,194,304");
ms34_2440=se_ms(3,"OS2");
ms31_3556890=se_ms(8,"\" file.\n");
ms34_2565=se_ms(3,"[1-");
ms34_3069=se_ms(3,"ccc");
ms34_3094=se_ms(3,"dcc");
ms34_3169=se_ms(3,"gcc");
ms34_146157=se_ms(6," /link");
ms34_2833=se_ms(3,"g++");
ms31_1293738877=se_ms(13," is not set.\n");
ms34_3294=se_ms(3,"lcc");
ms34_1663868=se_ms(7,"OpenVMS");
ms34_333a=se_ms(2,"-l");
ms34_340a=se_ms(2,"-s");
ms34_3494=se_ms(3,"tcc");
ms31_113009969=se_ms(10," in file \"");
ms31_1800535743=se_ms(13,"System call \"");
ms34_179868158=se_ms(29,"Unknown system name in file\n\"");
ms14_8897=se_ms(4,".cpp");
ms31_1662662954=se_ms(20,"SmallEiffelDirectory");
ms34_581585530=se_ms(36,"Hope this is a Windows like system.\n");
ms34_146157a=se_ms(6," /link");
se_msi3();
}

void se_msi3(void){
ms34_6687=se_ms(4," To ");
ms34_355003=se_ms(6,"][0-9]");
ms34_57487=se_ms(5,"Amiga");
ms13_118=se_ms(1,"v");
ms34_9107=se_ms(4,".lnk");
ms34_9121=se_ms(4,".obj");
ms34_9073=se_ms(4,".lib");
ms13_1042405932=se_ms(20,"Version of command \"");
ms34_8976=se_ms(4,".exe");
ms34_59731=se_ms(5,"Elate");
ms34_0aaa=se_ms(0,"");
ms34_0aaaaa=se_ms(0,"");
ms15_2248290=se_ms(7,"version");
ms34_698995372=se_ms(19,"SmallCode SmallData");
ms34_836475934=se_ms(32,"-5 -w-aus -w-par -w-rvl -O2 -O-v");
ms34_0aaaaaa=se_ms(0,"");
ms34_415107=se_ms(6,"lcclnk");
ms15_300594=se_ms(6,"File \"");
ms34_98806116=se_ms(10," Data=Auto");
ms31_1430004157=se_ms(15," used in file \"");
ms13_142550=se_ms(6,"\" is:\n");
ms34_207986277=se_ms(10,"OpenVMS_CC");
ms14_329=se_ms(2,".c");
ms34_109=se_ms(1,"m");
ms31_44975894=se_ms(9,"Writing \"");
ms34_304=se_ms(2,"-O");
ms34_324=se_ms(2,"-c");
ms34_326=se_ms(2,"-e");
ms34_333=se_ms(2,"-l");
ms34_329=se_ms(2,".c");
ms34_340=se_ms(2,"-s");
ms34_336=se_ms(2,"-o");
ms34_341=se_ms(2,".o");
ms34_297=se_ms(2,".C");
ms34_218174=se_ms(6,"-s -d1");
ms34_603=se_ms(2,"cl");
ms34_594=se_ms(2,"cc");
ms34_674=se_ms(2,"sc");
ms34_689=se_ms(2,"vc");
ms31_27561173=se_ms(21,"Trying to read file \"");
ms34_69851=se_ms(5,"a.out");
ms34_0aa=se_ms(0,"");
ms34_19761224=se_ms(9," Data=Far");
ms31_1711985232=se_ms(19,"Cannot write file \"");
ms34_76405=se_ms(5,"bcc32");
ms34_1327525317=se_ms(74,"System environment variable \"SmartEiffel\" not set.\nTrying default value: \"");
ms34_0a=se_ms(0,"");
}

void*se_ma41(int argc,...){
T41*m;
va_list pa;
T0**s;
m=se_malloc(sizeof(*m));
*m=M41;
if(argc){
s=se_malloc(argc*sizeof(*s));
m->_storage=s;
m->_capacity=argc;
m->_lower=1;
m->_upper=argc;
va_start(pa,argc);
while(argc--){
*(s++)=va_arg(pa,T0*);
}
va_end(pa);
}
else{
m->_storage=NULL;
m->_capacity=0;
m->_lower=1;
m->_upper=0;
}
return m;
}

#ifdef __cplusplus
}
#endif
