#ifdef __cplusplus
extern "C" {
#endif




#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>
#include <signal.h>
#include <stddef.h>
#include <stdarg.h>
#include <limits.h>
#include <float.h>
#include <setjmp.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#if defined __USE_POSIX || defined __unix__ || defined _POSIX_C_SOURCE
#  include <unistd.h>
#endif
#if !defined(WIN32) && \
       (defined(WINVER) || defined(_WIN32_WINNT) || defined(_WIN32) || \
 defined(__WIN32__) || defined(__TOS_WIN__) || defined(_MSC_VER))
#  define WIN32 1
#endif
#ifdef WIN32
#  include <windows.h>
#else
#  ifndef O_RDONLY
#    include <sys/file.h>
#  endif
#  ifndef O_RDONLY
#    define O_RDONLY 0000
#  endif
#endif

#if defined(_MSC_VER) && (_MSC_VER < 1400) 
typedef signed char int8_t;
typedef signed short int16_t;
typedef signed int int32_t;
typedef signed __int64 int64_t;
#  define PRId8 "d"
#  define PRId16 "d"
#  define PRId32 "d"
#  define PRId64 "I64d"
#  define INT8_C(c) c
#  define INT16_C(c) c
#  define INT32_C(c) c
#  define INT64_C(c) c ## i64
#elif defined(__WATCOMC__) && (__WATCOMC__ <= 1100) 
typedef signed char int8_t;
typedef signed short int16_t;
typedef signed long int int32_t;
typedef signed __int64 int64_t;
#  define PRId8 "d"
#  define PRId16 "d"
#  define PRId32 "d"
#  define PRId64 "Ld"
#  define INT8_C(c) c
#  define INT16_C(c) c
#  define INT32_C(c) c ## L
#  define INT64_C(c) c ## i64
#elif defined(__BORLANDC__) && (__BORLANDC__ < 0x600) 
typedef signed char int8_t;
typedef signed short int16_t;
typedef signed long int int32_t;
typedef signed __int64 int64_t;
#  define PRId8 "d"
#  define PRId16 "d"
#  define PRId32 "Ld"
#  define PRId64 "I64Ld"
#  define INT8_C(c) c
#  define INT16_C(c) c
#  define INT32_C(c) c ## L
#  define INT64_C(c) c ## i64
#elif defined(__FreeBSD__) && (__FreeBSD__ < 5)  && !defined (_SYS_INTTYPES_H_)
typedef signed char int8_t;
typedef signed short int16_t;
typedef signed long int int32_t;
typedef signed long long int int64_t;
#elif defined(__CYGWIN__) && defined(__BIT_TYPES_DEFINED__) 
#else
#  include <inttypes.h>
#  if !defined(INT8_MAX) && defined(INT16_MAX)

typedef int_least8_t int8_t;
#  endif
#endif

#if !defined(PRId16)
#  define PRId8 "d"
#  define PRId16 "d"
#  define PRId32 "ld"
#  define PRId64 "lld"
#elif !defined(PRId8)
#  define PRId8 "d"
#endif
#if !defined(INT16_C)
#  define INT8_C(c) c
#  define INT16_C(c) c
#  define INT32_C(c) c ## L
#  define INT64_C(c) c ## LL
#elif !defined(INT8_C)
#  define INT8_C(c) c
#endif
#if !defined(INT16_MIN)
#  define INT8_MIN (-INT8_C(127)-1)
#  define INT8_MAX (INT8_C(127))
#  define INT16_MIN (-INT16_C(32767)-1)
#  define INT16_MAX (INT16_C(32767))
#  define INT32_MIN (-INT32_C(2147483647)-1)
#  define INT32_MAX (INT32_C(2147483647))
#  define INT64_MIN (-INT64_C(9223372036854775807)-1)
#  define INT64_MAX (INT64_C(9223372036854775807))
#elif !defined(INT8_MIN)
#  define INT8_MIN (-INT8_C(127)-1)
#endif


#ifndef EXIT_FAILURE
#  define EXIT_FAILURE 1
#endif
#ifndef EXIT_SUCCESS
#  define EXIT_SUCCESS 0
#endif


#ifdef _SIGSET_H_types
#  define JMP_BUF    sigjmp_buf
#  define SETJMP(x)  sigsetjmp( (x), 1)
#  define LONGJMP    siglongjmp
#else
#  define JMP_BUF    jmp_buf
#  define SETJMP(x)  setjmp( (x) )
#  define LONGJMP    longjmp
#endif


typedef int Tid;
typedef struct S0 T0;
struct S0{Tid id;};


#define SE_ERR stderr


typedef int8_t T1;
#define EIF_INTEGER_8 T1
#define M1 (INT8_C(0))
#define EIF_INTEGER_8_BITS (CHAR_BIT)
#define EIF_MINIMUM_INTEGER_8 (INT8_MIN)
#define EIF_MAXIMUM_INTEGER_8 (INT8_MAX)


typedef int16_t T10;
#define EIF_INTEGER_16 T10
#define M10 (INT16_C(0))
#define EIF_INTEGER_16_BITS (CHAR_BIT*sizeof(T10t))
#define EIF_MINIMUM_INTEGER_16 (INT16_MIN) 
#define EIF_MAXIMUM_INTEGER_16 (INT16_MAX) 


typedef int32_t T2;
#define EIF_INTEGER T2
#define EIF_INTEGER_32 T2
#define M2 (INT32_C(0))
#define EIF_INTEGER_BITS ((T2)(CHAR_BIT*sizeof(T2)))
#define EIF_INTEGER_32_BITS EIF_INTEGER_BITS
#define EIF_MINIMUM_INTEGER (INT32_MIN)
#define EIF_MAXIMUM_INTEGER (INT32_MAX)


typedef int64_t T11;
#define EIF_INTEGER_64 T11
#define M11 (INT64_C(0))
#define EIF_INTEGER_64_BITS (CHAR_BIT*sizeof(T11))
#define EIF_MINIMUM_INTEGER_64 (INT64_MIN)
#define EIF_MAXIMUM_INTEGER_64 (INT64_MAX)


typedef unsigned char T3;
#define EIF_CHARACTER T3
#define M3 (0)
#define EIF_CHARACTER_BITS (CHAR_BIT)
#define EIF_MINIMUM_CHARACTER_CODE (0)
#define EIF_MAXIMUM_CHARACTER_CODE (255)
#define T3code(x) ((T2)(x))
#define T3to_integer(x) ((T2)((signed char)(x)))
#define T3to_bit(x) (x)


typedef float T4;
#define EIF_REAL T4
#define M4 (0.0)
#define EIF_REAL_BITS (CHAR_BIT*sizeof(float))
#define EIF_MINIMUM_REAL (-(FLT_MAX))
#define EIF_MAXIMUM_REAL (FLT_MAX)


typedef double T5;
#define EIF_DOUBLE T5
#define M5 (0.0)
#define EIF_DOUBLE_BITS (CHAR_BIT*sizeof(double))
#define EIF_MINIMUM_DOUBLE (-(DBL_MAX))
#define EIF_MAXIMUM_DOUBLE (DBL_MAX)


typedef char T6;
#define EIF_BOOLEAN T6
#define M6 (0)
#define EIF_BOOLEAN_BITS (CHAR_BIT)


typedef void* T8;
#define EIF_POINTER T8
#define M8 (NULL)
#define EIF_POINTER_BITS (CHAR_BIT*sizeof(void*))


#define EIF_STRING T7*


#define eif_access(x) ((char*)(x))
#define EIF_REFERENCE T0*
#define EIF_OBJ T0*
#define EIF_OBJECT EIF_OBJ


void* se_malloc(size_t size);
void* se_calloc(size_t nmemb, size_t size);
#define SE_BOOST 1


typedef int T45;
typedef struct S26 T26;
typedef struct S50 T50;
typedef struct S12 T12;
typedef int T32;
typedef struct S47 T47;
typedef struct S31 T31;
typedef struct S36 T36;
typedef struct S7 T7;
typedef struct S34 T34;
typedef struct S35 T35;
typedef int T43;
typedef void*T55;
typedef struct S44 T44;
typedef struct S41 T41;
typedef struct S48 T48;
typedef struct S29 T29;
typedef void*T33;


typedef T0**T42;
typedef T3*T9;


struct S35{T8 _directory_stream;T8 _current_entry;};
int se_cmpT35(T35 o1,T35 o2);
extern T43 M43;


extern T45 M45;
struct S26{T6 _push_back_flag;T3 _last_character;T6 _end_of_input;T9 _buffer;T6 _end_reached;T2 _buffer_position;T2 _buffer_size;T2 _capacity;};
extern T26 M26;
struct S50{T0* _executable_name;T0* _root_class_name;};
extern T50 M50;
struct S12{T6 _help_flag;T6 _version_flag;T6 _interactive;T6 _skip_c_compilation;T0* _system_se_path;T0* _installation_path;T0* _system_name;T0* _compiler_se_path;T0* _garbage_collector_file_path;T0* _garbage_collector;T0* _c_compiler_name;T0* _bin_directory_path;T0* _bin_c_directory_path;T35 _basic_directory;T0* _cwd;};
extern T12 M12;
extern T32 M32;
struct S47{T42 _storage;T2 _capacity;T2 _upper;};
extern T47 M47;
struct S31{T6 _verbose;};
extern T31 M31;
struct S36{T0* _path;T3 _last_character;T6 _end_of_input;T6 _push_back_flag;T8 _input_stream;T9 _buffer;T6 _end_reached;T2 _buffer_position;T2 _buffer_size;T2 _capacity;};
extern T36 M36;
struct S34{T0* _system_name;T0* _sys_directory;T0* _bin_directory;T6 _no_strip;T35 _basic_directory;T0* _c_compiler;};
extern T34 M34;
struct S7{T9 _storage;T2 _count;T2 _capacity;};
extern T7 M7;
extern T35 M35;
extern T55 M55;
struct S44{T0* _path;T6 _last_scan_status;T35 _basic_directory;T0* _name_list;};
extern T44 M44;
struct S41{T42 _storage;T2 _capacity;T2 _upper;T2 _lower;};
extern T41 M41;
struct S48{T0* _path;T9 _buffer;T2 _buffer_position;T2 _capacity;T8 _output_stream;};
extern T48 M48;
struct S29{T2 _buffer_position;T9 _buffer;T2 _capacity;};
extern T29 M29;
extern T33 M33;



#define SE_BOOST 1
void se_print_run_time_stack (void);
void se_signal_handler(int sig);


#ifndef WIN32
#  include <dirent.h>
#endif
#ifndef WIN32
#  include <unistd.h>
#endif

EIF_POINTER basic_directory_open(EIF_POINTER path);
EIF_POINTER basic_directory_read_entry(EIF_POINTER dirstream);
EIF_POINTER basic_directory_get_entry_name(EIF_POINTER entry);
EIF_BOOLEAN basic_directory_close(EIF_POINTER dirstream);
#define basic_directory_current_working_directory (basic_directory_cwd())
EIF_POINTER basic_directory_cwd(void);
EIF_BOOLEAN basic_directory_chdir(EIF_POINTER destination);
EIF_BOOLEAN basic_directory_mkdir(EIF_POINTER directory_path);
EIF_BOOLEAN basic_directory_rmdir(EIF_POINTER directory_path);



#define basic_io_stdin (stdin)
#define basic_io_stdout (stdout)
#define basic_io_stderr (stderr)
#define basic_io_eof (EOF)
#define basic_io_text_file_read_open(p) (fopen(((char*)(p)),"r"))
#define basic_io_text_file_write_open(p) (fopen(((char*)(p)),"w"))
#define basic_io_text_file_write_append(p) (fopen(((char*)(p)),"a"))
#define basic_io_text_file_read_write_open(p) (fopen(((char*)(p)),"r+"))
#define basic_io_text_file_read_write_append(p) (fopen(((char*)(p)),"a+"))
#define basic_io_binary_file_read_open(p) (fopen(((char*)(p)),"rb"))
#define basic_io_binary_file_write_open(p) (fopen(((char*)(p)),"wb"))
#define basic_io_binary_file_write_append(p) (fopen(((char*)(p)),"ab"))
#define basic_io_fclose(p) (fclose((FILE*)(p)))
#define basic_io_flush(p) (fflush((FILE*)(p)))
#define basic_io_getc(f) (getc(((FILE*)(f))))
#define basic_io_putc(b, f) (putc((b),((FILE*)(f))))
#define basic_io_fread(b, n, f) (fread((void *)(b),(size_t)(1), (size_t)(n),(FILE*)(f)))
#define basic_io_fwrite(b, n, f) (fwrite((void *)(b),(size_t)(1), (size_t)(n),(FILE*)(f)))
#define basic_io_feof(f) (feof(((FILE*)(f))))
#define basic_io_rename(o, n) (rename(((char*)(o)),((char*)(n))))
#define basic_io_remove(f) (remove(((char*)(f))))

#if defined __USE_POSIX || defined __unix__ || defined _POSIX_C_SOURCE
#  define basic_io_read_stdin(b, s) (read(STDIN_FILENO, b, s))
#else
  extern int basic_io_read_stdin(char *buffer, int size);
#endif




#define basic_getenv(v) (getenv((char*)v))



#define basic_system_execute_command(p) (system(((char*)(p))))

T6 r8is_null(T8 C);

T6 r6_px_not(T6 C);

T6 r3is_separator(T3 C);

T6 r3is_decimal_digit(T3 C);

T6 r3_ix_6061(T3 C,T3 a1);

T6 r3same_as(T3 C,T3 a1);

T6 r3_ix_6261(T3 C,T3 a1);

T3 r3to_upper(T3 C);

T3 r3to_lower(T3 C);

T2 r2max(T2 C,T2 a1);

T6 r2in_range(T2 C,T2 a1,T2 a2);

T2 r2min(T2 C,T2 a1);

void r2append_in(T2 C,T0* a1);

T3 r11digit(T11 C);

void r11append_in(T11 C,T0* a1);

T6 r42safe_equal(T0* a1,T0* a2);

T42 r42realloc(T42 C,T2 a1,T2 a2);

T2 r42index_of(T42 C,T0* a1,T2 a2);

void r42clear(T42 C,T2 a1,T2 a2);

void r42copy_from(T42 C,T42 a1,T2 a2);

void r9copy_slice(T9 C,T2 a1,T9 a2,T2 a3,T2 a4);

T9 r9realloc(T9 C,T2 a1,T2 a2);

T6 r9fast_memcmp(T9 C,T9 a1,T2 a2);

T6 r9fast_has(T9 C,T3 a1,T2 a2);

void r9copy_at(T9 C,T2 a1,T9 a2,T2 a3);

void r9clear(T9 C,T2 a1,T2 a2);

void r9copy_from(T9 C,T9 a1,T2 a2);

T2 r7first_index_of(T7* C,T3 a1);

void r7copy(T7* C,T0* a1);

T0* r7substring(T7* C,T2 a1,T2 a2);

void r7remove_first(T7* C,T2 a1);

T3 r7last(T7* C);

void r7remove_between(T7* C,T2 a1,T2 a2);

T6 r7is_equal(T7* C,T0* a1);
extern T0*oBC7string_buffer;
extern T0*oBC7split_buffer;

T0* r7split(T7* C);

T6 r7valid_index(T7* C,T2 a1);

void r7append(T7* C,T0* a1);

T6 r7has_substring(T7* C,T0* a1);

T2 r7index_of(T7* C,T3 a1,T2 a2);

T6 r7has_suffix(T7* C,T0* a1);

void r7make(T7* C,T2 a1);

T6 r7has_prefix(T7* C,T0* a1);

void r7append_string(T7* C,T0* a1);

void r7extend(T7* C,T3 a1);

void r7remove_last(T7* C,T2 a1);

T6 r7has(T7* C,T3 a1);

void r7append_character(T7* C,T3 a1);

void r7extend_unless(T7* C,T3 a1);

T6 r7same_as(T7* C,T0* a1);

void r7add_last(T7* C,T3 a1);

void r7shrink(T7* C,T2 a1,T2 a2);

void r7resize(T7* C,T2 a1);

void r7to_upper(T7* C);

T2 r7substring_index(T7* C,T0* a1,T2 a2);

void r7from_external_copy(T7* C,T8 a1);

T8 r7to_external(T7* C);

void r7to_lower(T7* C);

T0* r7twin(T7* C);

T0* r7_ix_43(T7* C,T0* a1);

void r7split_in(T7* C,T0* a1);

void r7swap(T7* C,T2 a1,T2 a2);

T6 r47valid_index(T47* C,T2 a1);

void r47make(T47* C,T2 a1);

void r47add_last(T47* C,T0* a1);

void r47with_capacity(T47* C,T2 a1);

void r41copy(T41* C,T0* a1);

T2 r41count(T41* C);

T0* r41item(T41* C,T2 a1);

T6 r41valid_index(T41* C,T2 a1);

T2 r41index_of(T41* C,T0* a1);

T6 r41is_empty(T41* C);

void r41add_last(T41* C,T0* a1);

void r41clear(T41* C);

T0* r41twin(T41* C);

void r41with_capacity(T41* C,T2 a1,T2 a2);

void r26read_character(T26* C);

void r26fill_buffer(T26* C);

void r26make(T26* C);

void r26skip_separators(T26* C);

void r26read_line_in(T26* C,T0* a1);

void r26read_word(T26* C);

void r26read_line(T26* C);
extern T0*oBC19std_output;
extern T0*oBC27last_string;

void r26unread_character(T26* C);

void r31file_removing(T31* C,T0* a1);

T6 r31file_exists(T0* a1);

void r31file_renaming(T31* C,T0* a1,T0* a2);
extern T0*oBC14system_tools;
extern int fBC14system_tools;

T0* r31system_tools(void);

void r31tfw_connect(T31* C,T0* a1,T0* a2);

void r31w_put_character(T3 a1);

void r31tfr_connect(T31* C,T0* a1,T0* a2);

T0* r31getenv(T0* a1,T0* a2);

T0* r31read_word_in(T31* C,T0* a1);

void r31tfr_connect_or_exit(T31* C,T0* a1,T0* a2);
extern T45 oBC19file_tools;

void r31w_put_string(T0* a1);

void r31system_call(T31* C,T0* a1);

void r31put_string(T31* C,T0* a1);
extern T0*oBC19std_error;

void r36disconnect(T36* C);

void r36read_character(T36* C);

void r36fill_buffer(T36* C);

void r36skip_separators(T36* C);

void r36read_line_in(T36* C,T0* a1);

void r36connect_to(T36* C,T0* a1);

void r36read_word(T36* C);

void r36read_line(T36* C);

void r36unread_character(T36* C);

void r34append_token(T0* a1,T0* a2);

void r34set_c_compiler(T34* C,T0* a1);
extern T0*oBC34system_list;
extern T0*oBC14tmp_file_read;
extern T6 oBC34Scoptions_exists;
extern int fBC34Scoptions_exists;

T6 r34Scoptions_exists(void);

void r34no_split_mode_command(T34* C,T0* a1,T0* a2);

void r34add_executable_name(T34* C,T0* a1);

void r34add_x_suffix(T34* C,T0* a1);

void r34external_c_files_for_lcc_win32(T34* C,T0* a1);
extern T0*oBC14tmp_path;
extern T0*oBC34token_buffer;

void r34split_mode_c_compiler_command(T34* C,T0* a1,T0* a2);

void r34add_objects_(T34* C,T0* a1,T0* a2,T2 a3,T2 a4);

void r34default_c_compiler_options(T34* C,T6 a1);
extern T0*oBC34object_suffix;
extern int fBC34object_suffix;

T0* r34object_suffix(T34* C);

void r34subdirectory(T34* C,T0* a1,T0* a2);

void r34make(T34* C);

void r34parent_directory(T34* C,T0* a1);

void r34show_compiler_list_then_exit(T34* C);
extern T0*oBC14echo;

void r34add_external_lib(T34* C,T0* a1);

void r34command_path_in(T34* C,T0* a1,T0* a2);

T6 r34is_c_plus_plus_file_path(T0* a1);
extern T0*oBC14ace;
extern T0*oBC34x_suffix;
extern int fBC34x_suffix;

T0* r34x_suffix(T34* C);
extern T0*oBC34compiler_list;
extern int fBC34add_lib_math;

void r34add_lib_math(T34* C);

void r34add_objects(T34* C,T0* a1,T0* a2,T2 a3);

void r34do_add_external_lib(T0* a1);
extern int fBC34set_basic_directory_notation;

void r34set_basic_directory_notation(T34* C);

T0* r34sas_c_compiler_options(T6 a1);

void r34split_mode_linker_command(T34* C,T0* a1,T0* a2,T2 a3);

void r34remove_other_extra_files(T34* C,T0* a1);

T2 r44upper(T44* C);

void r44make(T44* C);

void r44scan_current_working_directory(T44* C);

void r48disconnect(T48* C);
extern T0*oBC30tmp_string;

void r48make(T48* C);

void r48connect_to(T48* C,T0* a1);

void r48put_integer(T48* C,T11 a1);

void r48write_buffer(T48* C);

void r48put_character(T48* C,T3 a1);

void r48put_string(T48* C,T0* a1);

void r29make(T29* C);

void r29flush(T29* C);

void r29write_buffer(T29* C);

void r29put_character(T29* C,T3 a1);

void r29put_string(T29* C,T0* a1);

void r33put_string(T0* a1);

T6 r45file_exists(T0* a1);

void r45rename_to(T0* a1,T0* a2);
extern T0*oBC45tfr1;

void r45delete(T0* a1);

T6 r45is_readable(T0* a1);

void r12prepare_bin_c_directory(T12* C);

T6 r12is_version_flag(T12* C,T0* a1);

void r12echo_variable(T0* a1,T0* a2);

void r12gathered_information_summary(T12* C);

T6 r12yes_or_no(T0* a1,T6 a2);

T6 r12file_exists(T0* a1);

void r12set_bin_c_directory_path(T12* C);
extern T0*oBC14smart_eiffel;
extern T0*oBC12system_tools;

void r12call_compile_to_c(T0* a1,T0* a2);
extern T0*oBC19command_arguments;
extern int fBC19command_arguments;

T0* r12command_arguments(void);

void r12interactive_c_compiler_linker_options(T12* C);

void r12set_installation_path(T12* C);
extern T0*oBC12tfr;

void r12c_compile_no_split_command_list(T12* C);
extern T0*oBC19std_input;
extern T0*oBC12tfw;

T6 r12flag_match(T0* a1,T0* a2);

void r12set_garbage_collector_file_path(T12* C);

void r12open_vms_entry_patch(T12* C,T0* a1);
extern T0*oBC12splitted_command_list;

void r12set_bin_directory_path(T12* C);

void r12make(T12* C);

void r12set_c_compiler_name(T12* C);

void r12set_system_se_path(T12* C);

void r12call_clean(T0* a1);

void r12fatal_problem_description_end(T12* C);

void r12restore_current_working_directory(T12* C);

void r12garbage_collector_selection(T12* C);
extern T0*oBC12command;

void r12c_compile_splitted_command_list(T12* C);

void r12set_system_name(T12* C);

void r12no_split_mode_c_compile(T12* C,T0* a1);
extern T0*oBC12no_split_command_list;

void r12set_compiler_se_path(T12* C);

void r12split_mode_c_compile(T12* C,T0* a1);

void r12install_exit(T12* C,T2 a1);

void r12echo_usage_exit(T12* C);

void r12echo_tfw_put_string(T0* a1);

void r12write_default_loadpath_se_file(T12* C);

void r12clean_bin_c_directory_path(T12* C);

T0* r12argument(T2 a1);

void r12move_executable_for(T12* C,T0* a1);

void r12check_system_path_variable_warning(T12* C);

void r12tfw_check_is_connected(T12* C,T0* a1);

T0* r12choice_in(T0* a1,T0* a2);

void r32execute_command_line(T0* a1);

T2 r32execute_command(T0* a1);

T0* r32get_environment_variable(T0* a1);

void r35set_notation_using(T0* a1);

T6 r35amiga_notation(void);

void r35connect_to_current_working_directory(T35* C);

void r35disconnect(T35* C);

void r35compute_subdirectory_with(T0* a1,T0* a2);

T6 r35system_notation_detected(void);

T6 r35windows_notation(void);

T6 r35unix_notation(void);

void r35reset_notation_using(T0* a1);
extern T0*oBC35last_entry;

T6 r35macintosh_notation(void);

void r35change_current_working_directory(T35* C,T0* a1);

void r35compute_parent_directory_of(T0* a1);

void r35read_entry(T35* C);

void r35connect_to(T35* C,T0* a1);

T6 r35create_new_directory(T0* a1);

void r35compute_file_path_with(T0* a1,T0* a2);

T6 r35openvms_notation(void);

T6 r35cygwin_notation(void);
extern T12*eiffel_root_object;
extern int se_argc;
extern char**se_argv;
#define SE_MAXID 56
extern T7* g[];
extern T7* t[];
void std_output_flush(void);
void initialize_eiffel_runtime(int argc,char*argv[]);
extern T7*ms34_968120;
extern T7*ms35_46;
extern T7*ms35_63;
extern T7*ms31_210310269;
extern T7*ms15_216;
extern T7*ms35_276;
extern T7*ms34_84381;
extern T7*ms35_46a;
extern T7*ms31_203714719;
extern T7*ms34_128214728;
extern T7*ms34_91157;
extern T7*ms15_1090;
extern T7*ms34_9073a;
extern T7*ms34_1721407046;
extern T7*ms34_1106932385;
extern T7*ms15_3085;
extern T7*ms34_1772235;
extern T7*ms15_3595;
extern T7*ms34_683870135a;
extern T7*ms34_0aaaaaaa;
extern T7*ms34_530877013;
extern T7*ms34_466551816;
extern T7*ms12_2073823;
extern T7*ms34_17494489;
extern T7*ms35_276a;
extern T7*ms34_301485;
extern T7*ms31_1071750288;
extern T7*ms34_426884100;
extern T7*ms34_270309168;
extern T7*ms15_1072344038;
extern T7*ms31_136264778;
extern T7*ms34_1236979201;
extern T7*ms34_447734;
extern T7*ms34_11253;
extern T7*ms34_1102814319;
extern T7*ms31_1520107011;
extern T7*ms34_1631212670;
extern T7*ms34_448859;
extern T7*ms34_13028;
extern T7*ms31_1635864124;
extern T7*ms34_12782;
extern T7*ms31_210141519;
extern T7*ms34_262628264;
extern T7*ms31_1974940930;
extern T7*ms12_0;
extern T7*ms34_721564652;
extern T7*ms34_616914401;
extern T7*ms34_15721;
extern T7*ms34_15828;
extern T7*ms34_0aaaa;
extern T7*ms34_16702;
extern T7*ms34_2075119688;
extern T7*ms34_0;
extern T7*ms55_983674906;
extern T7*ms34_18144;
extern T7*ms34_17794;
extern T7*ms34_9073aa;
extern T7*ms34_39617954;
extern T7*ms34_1038797513;
extern T7*ms34_1091987;
extern T7*ms31_141444;
extern T7*ms34_51699930;
extern T7*ms34_467476687;
extern T7*ms34_72020566;
extern T7*ms15_56612951;
extern T7*ms31_354654986;
extern T7*ms34_0aaaaaaaa;
extern T7*ms34_1361085152;
extern T7*ms34_373286592;
extern T7*ms34_39204698;
extern T7*ms34_876917780;
extern T7*ms34_683870135;
extern T7*ms34_1335;
extern T7*ms34_561720547;
extern T7*ms34_1438;
extern T7*ms34_1570;
extern T7*ms34_2178;
extern T7*ms34_1744;
extern T7*ms34_1494914262;
extern T7*ms34_2440;
extern T7*ms31_3556890;
extern T7*ms34_2565;
extern T7*ms34_3069;
extern T7*ms34_3094;
extern T7*ms34_3169;
extern T7*ms34_146157;
extern T7*ms34_2833;
extern T7*ms31_1293738877;
extern T7*ms34_3294;
extern T7*ms34_1663868;
extern T7*ms34_333a;
extern T7*ms34_340a;
extern T7*ms34_3494;
extern T7*ms31_113009969;
extern T7*ms31_1800535743;
extern T7*ms34_179868158;
extern T7*ms14_8897;
extern T7*ms31_1662662954;
extern T7*ms34_581585530;
extern T7*ms34_146157a;
extern T7*ms34_6687;
extern T7*ms34_355003;
extern T7*ms34_57487;
extern T7*ms13_118;
extern T7*ms34_9107;
extern T7*ms34_9121;
extern T7*ms34_9073;
extern T7*ms13_1042405932;
extern T7*ms34_8976;
extern T7*ms34_59731;
extern T7*ms34_0aaa;
extern T7*ms34_0aaaaa;
extern T7*ms15_2248290;
extern T7*ms34_698995372;
extern T7*ms34_836475934;
extern T7*ms34_0aaaaaa;
extern T7*ms34_415107;
extern T7*ms15_300594;
extern T7*ms34_98806116;
extern T7*ms31_1430004157;
extern T7*ms13_142550;
extern T7*ms34_207986277;
extern T7*ms14_329;
extern T7*ms34_109;
extern T7*ms31_44975894;
extern T7*ms34_304;
extern T7*ms34_324;
extern T7*ms34_326;
extern T7*ms34_333;
extern T7*ms34_329;
extern T7*ms34_340;
extern T7*ms34_336;
extern T7*ms34_341;
extern T7*ms34_297;
extern T7*ms34_218174;
extern T7*ms34_603;
extern T7*ms34_594;
extern T7*ms34_674;
extern T7*ms34_689;
extern T7*ms31_27561173;
extern T7*ms34_69851;
extern T7*ms34_0aa;
extern T7*ms34_19761224;
extern T7*ms31_1711985232;
extern T7*ms34_76405;
extern T7*ms34_1327525317;
extern T7*ms34_0a;
T7*se_ms(int c,char*e);
T7*se_string(char*e);



EIF_STRING se_ms_trace(int count, char* c_string, int li, int co, char* path);
void se_msi1(void);
void se_msi2(void);
void se_msi3(void);
void*se_ma41(int argc,...);

#ifdef __cplusplus
}
#endif
