--          This file is part of SmartEiffel The GNU Eiffel Compiler.
--       Copyright (C) 1994-2002 LORIA - INRIA - U.H.P. Nancy 1 - FRANCE
--          Dominique COLNET and Suzanne COLLIN - SmartEiffel@loria.fr
--                       http://SmartEiffel.loria.fr
-- SmartEiffel is  free  software;  you can  redistribute it and/or modify it
-- under the terms of the GNU General Public License as published by the Free
-- Software  Foundation;  either  version  2, or (at your option)  any  later
-- version. SmartEiffel is distributed in the hope that it will be useful,but
-- WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
-- or  FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License
-- for  more  details.  You  should  have  received a copy of the GNU General
-- Public  License  along  with  SmartEiffel;  see the file COPYING.  If not,
-- write to the  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
-- Boston, MA 02111-1307, USA.
--
deferred class TYPE_OF_AGENT
   --
   -- Common for all TYPEs of agents: TYPE_ROUTINE, TYPE_PROCEDURE,
   -- and TYPE_FUNCTION.
   --

inherit E_TYPE

feature

   is_reference: BOOLEAN is true

   is_any,
   is_none,
   is_expanded,
   is_separate,
   is_anchored,
   is_like_current,
   is_array,
   is_basic_eiffel_expanded,
   is_integer,
   is_real,
   is_double,
   is_character,
   is_boolean,
   is_pointer,
   is_bit,
   is_string: BOOLEAN is False
   
   start_position: POSITION

   base_class_name: CLASS_NAME
	 -- Either ROUTINE, PROCEDURE or FUNCTION.
   
   base: E_TYPE
	 -- Type to which the feature belongs.

   open: TYPE_TUPLE
	 -- Tuple of the types of open operands, if any.

   res: E_TYPE
	 -- If any, the type of the `Result'.

   c_sizeof: INTEGER is
      do
         Result := c_sizeof_pointer
      end

   frozen c_type_for_target_in(buffer: STRING) is
      do
	 buffer.extend('T')
	 id.append_in(buffer)
	 buffer.extend('*')
      end

   frozen c_type_for_argument_in,
   frozen c_type_for_result_in(buffer: STRING) is
      do
	 buffer.append(once "/*agent*/T0*")
      end

   frozen start_lookup_name: CLASS_NAME is
      do
	 Result := base_class_name
      end

   is_like_feature: BOOLEAN is False

   frozen is_a(other: E_TYPE): BOOLEAN is
      local
	 type_of_agent: TYPE_OF_AGENT
      do
	 type_of_agent ?= other.run_type
	 if type_of_agent /= Void then
	    Result := is_a_(type_of_agent)
	 end
         if not Result then
            error_handler.type_error(Current,other)
         end
      end

   frozen generic_list: ARRAY[E_TYPE] is
      do
	 check False end
      end

   frozen local_from_separate: E_TYPE is
      do
	 check False end
      end

   is_generic: BOOLEAN is False

   c_initialize_in(str: STRING) is
      do
	 str.append(fz_null)
      end

   c_initialize is
      do
	 cpp.put_string(fz_null)
      end

   frozen c_header_pass1 is
      do
	 cpp.put_string(once "typedef T0 T")
	 cpp.put_integer(id)
	 cpp.put_character(';')
	 cpp.put_character('%N')
      end

   frozen c_header_pass2 is
      do
      end

   frozen c_header_pass3 is
      do
      end

   frozen c_header_pass4 is
      do
         standard_c_print_function
      end

   just_before_gc_mark_in(str: STRING) is do end

   frozen gc_define1 is
      do
	 cpp.put_string("#define gc_mark")
	 cpp.put_integer(id)
	 cpp.put_string("(x) gc_mark_agent((x))%N")
      end

   frozen gc_define2 is do end

   is_user_expanded: BOOLEAN is False

   need_gc_mark_function: BOOLEAN is true

   stupid_switch(run_time_set: RUN_TIME_SET): BOOLEAN is do end

   gc_info_in(str: STRING) is do end

   is_dummy_expanded: BOOLEAN is False

   need_c_struct: BOOLEAN is False

   actual_reference(destination: E_TYPE): E_TYPE is
      do
	 check False end
      end

   actual_separate(destination: E_TYPE): E_TYPE is
      do
	 check False end
      end

   is_like_argument: BOOLEAN is False

   smallest_ancestor(other: E_TYPE): E_TYPE is
      do
	 not_yet_implemented
      end

   pretty_print is
      do
         pretty_printer.put_string(written_mark)
      end

   frozen id: INTEGER is
      do
	 Result := run_class.id
      end

   frozen jvm_xnewarray is
      local
         idx: INTEGER
      do
         idx := constant_pool.idx_jvm_root_class
         code_attribute.opcode_anewarray(idx)
      end

   frozen jvm_check_class_invariant is
      do
         standard_jvm_check_class_invariant
      end

   frozen jvm_if_x_ne: INTEGER is
      do
         Result := code_attribute.opcode_if_acmpne
      end

   frozen jvm_return_code is
      do
         code_attribute.opcode_areturn
      end

   frozen jvm_convert_to(destination: E_TYPE): INTEGER is
      do
         Result := 1
      end

   frozen jvm_target_descriptor_in(str: STRING) is
      do
      end

   frozen jvm_push_local(offset: INTEGER) is
      do
         code_attribute.opcode_aload(offset)
      end

   frozen jvm_xaload is
      do
         code_attribute.opcode_aaload
      end

   frozen jvm_write_local_creation, jvm_write_local(offset: INTEGER) is
      do
         code_attribute.opcode_astore(offset)
      end

   frozen jvm_expanded_from_reference(other: E_TYPE): INTEGER is
      do
	 check False end
      end

   frozen jvm_push_default: INTEGER is
      do
         code_attribute.opcode_aconst_null
         Result := 1
      end

   frozen jvm_descriptor_in(str: STRING) is
      do
	      str.append(jvm_root_descriptor)
      end

   frozen jvm_method_flags: INTEGER is 17

   frozen jvm_standard_is_equal is
       local
         rc: RUN_CLASS; wa: ARRAY[RUN_FEATURE_2]
      do
         rc := run_class
         wa := rc.writable_attributes
         jvm.std_is_equal(rc,wa)
      end

   frozen jvm_xastore is
      do
         code_attribute.opcode_aastore
      end

   frozen jvm_if_x_eq: INTEGER is
      do
         Result := code_attribute.opcode_if_acmpeq
      end

feature {TYPE_OF_AGENT}

   run_type_memory: like Current

feature {E_AGENT}

   load_builtin_features is
	 -- Load the built-in predefined appropriate features (`call' 
	 -- for PROCEDURE  `item' and `call' for FUNCTION, etc.). 
      require
	 is_run_type
      deferred
      end

feature {NONE}

   written_mark_memory: STRING

   run_time_mark_memory: STRING

   is_a_(other: TYPE_OF_AGENT): BOOLEAN is
      deferred
      end

   tmp_mark: STRING is
      once
	 create Result.make(128)
      end
   
invariant

   base /= Void

   open /= Void

end -- TYPE_OF_AGENT
