#!/usr/bin/env python
# Copyright (c) 2002 Nathan Sharfi
# Copyright terms are included in a file called 'license.txt'.

import os, xreadlines, sys, copy

from dicts import InsensitiveMultiDict, InsensitiveDict

class Comments(InsensitiveMultiDict):
    """I represent a vorbis comment structure.
    Internally, I store comments in a dict that maps strings to lists
    of strings (in C++: map<string, vector<string>).
    """

    def __init__(self, other=None):
        InsensitiveMultiDict.__init__(self, other or {})
        
    def merge(self, other):
        """Copies a second instance of Comments into this one.
        XXX: this thing might not make a clean copy of what it's inserting,
        resulting in funny business due to shared contents.
        """
        for pair in other.items():
            #print pair
            self.insert(pair)

    def __iadd__(self, other):
        self.merge(other)
        return self
    
    def __add__(self, other):
        tmp = copy.deepcopy(self)
        tmp += other
        return tmp
  


class Pragmas(InsensitiveDict):
    """I am a pragma dictionary."""
    pass


def _stripBom(s):
    """Strips the BOM out of a string."""
    if s[0:3] == '\xef\xbb\xbf': s = s[3:]
    return s
