/*
 * Philips I2C interface definition.
 *
 * Copyright (c) 1995, Jim Lowe.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met: 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer. 2.
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Version 1.2, Apr 25, 1995.
 */

/*
 *
 * Data Format:
 *
 * ----------------------------------------------------------------------------
 * | S | Slave Address | A | Subaddress | A | Data0 | A | ... | DataN | A | P |
 * ----------------------------------------------------------------------------
 *
 * S		 = start condition
 * Slave Address = 1000 101X (IICSA = low) or 1000 111X (IICSA = high)
 *	X	 = read/write control bit
 *		   X = 0, order to write (the circuit is slave receiver)
 *		   X = 1, order to read ( the circuit is slave transmitter)
 * A		 = Acknowledge, generated by slave
 * Subaddress	 = subaddress byte (see table below)
 * data byte	 = See table below
 * P		 = stop condition
 * 
 *  Note: If more that one data byte is transmitted, then auto-increment
 *	of the subaddress is performed.
 *
 */

/*
 * Sub address, depend on system address line pin 43.  If the line is
 * grounded, then use SA_LOW addresses, else use SA_HIGH addresses.
 */
#define	SLAVE_ADDRESS_READ_SA_HIGH	0x8f
#define	SLAVE_ADDRESS_WRITE_SA_HIGH	0x8e
#define	SLAVE_ADDRESS_READ_SA_LOW	0x8b
#define	SLAVE_ADDRESS_WRITE_SA_LOW	0x8a

#define	SLAVE_ADDRESS_READ	SLAVE_ADDRESS_READ_SA_LOW
#define	SLAVE_ADDRESS_WRITE	SLAVE_ADDRESS_WRITE_SA_LOW

/*
 * Read Status byte:
 * STTC HLCK FIDT X X X X CODE
 *
 * STTC:
 *	Horizontal time constant information for future application with
 *	logical combfilter only.
 *	0 = TV time constant (slow).
 *	1 = VCR time constant (fast).
 * HLCK:
 *	Horizontal PLL information.
 *	0 = HPLL locked.
 *	1 = HPLL unlocked.
 * FIDT:
 *	Field information.
 *	0 = 50hz system detected.
 *	1 = 60hz system detected.
 * CODE:
 *	Colour information.
 *	0 = no colour detected.
 *	1 = colour detected.
 */
#define	STATUS_STTC	0x80	
#define	STATUS_HLCK	0x40
#define	STATUS_FIDT	0x20
#define	STATUS_CODE	0x01

/*
 * IDEL7 to IDEL0:
 *	Increment delay time (dependent on application), step size = 4 / LLC.
 *	The delay time is selectable from -4 / LLC (-1 decimal multiplier) to
 *	-1024 / LLC (-256 decimal multiplier) equals data 0xff to 0x00.
 *	Different processing times in the chrominance channel and the clock
 *	generation could result in phase errors in the chrominance
 *	processing by transients in clock frequency.  An adjustable delay
 *	(IDEL) is necessary if the processing time in the clock generation
 *	is unknown.
 *	Suggested default value: 0x50.
 */
#define	SUB_INC_DELAY			0x00
/*
 * HSBY7 to HSYB0:
 *	Horizontal sync begin for 50hz, step size = 2 / LLC.  The delay time
 *	is selectable from -382/LLC (+191 decimal multiplier) to +128/LLC
 *	(-64 decimal multiplier) equals data 0xbf to 0xc0.  Two's complement
 *	numbers with ``hidden'' sign-bit.  The sign-bit is generated
 *	internally by evaluating the MSB and the MSB-1 bits.
 *	Suggested default value: 0x30.
 */
#define SUB_H_SYNC_BEGIN_50_HZ		0x01
/*
 * HSYS7 to HSYS0:
 *	Horizontal sync stop for 50hz, step size = 2/LLC.  The delay time
 *	is slectable from -386/LLC (+191 decimal multiplier) to +128/LLC
 *	(-64 decimal multiplier) equals data 0xbf to 0xc0.  Two's complement
 *	numbers with ``hidden'' sign-bit.  The sign-bit is generated
 *	internally by evaluating the MSB and the MSB-1 bits.
 *	Suggested default value: 0x00.
 */
#define	SUB_H_SYNC_STOP_50_HZ		0x02
/*
 * HCLB7 to HCLB0:
 *	Horizontal clamp start for 50hz, step size = 2/LLC.  The delay time
 *	is selectable from -254/LLC (+127 decimal multiplier) to +256/LLC
 *	(-128 decimal multiplier) equals data 0x7f to 0x80.
 *	Suggested default value: 0xe8.
 */
#define	SUB_H_CLAMP_BEGIN_50_HZ		0x03
/*
 * HCLS7 to HCLS0:
 *	Horizontal clamp stop for 50hz, step size = 2/LLC.  The delay time
 *	is selectable from -254/LLC (+127 decimal multiplier) to +256/LLC
 *	(-128 decimal multiplier) equals data 0x7f to 0x80.
 *	Suggested default value: 0xb6.
 */
#define	SUB_H_CLAMP_STOP_50_HZ		0x04
/*
 * HPHI7 to HPHI0:
 *	Horizontal sync adter PHI1 for 50hz, step size = 8/LLC.  The delay time
 *	is selectable from -936/LLC (+117 decimal multiplier) to +944/LLC
 *	(-118 decimal multiplier) equals data 0x75 to 0x8a.
 *	Suggested default value: 0xf4.
 */
#define	SUB_H_SYNC_AFTER_PHI1_50_HZ	0x05
/*
 * BYPS PREF BPSS1 BPSS0 CORI1 CORI0 APER1 APER0:
 *	Luminance bandwidth control
 * BYPS:
 *	Input mode select: 	0 = CVBS mode (chrominance trap active).
 *				1 = S-Video mode (chromiance trap bypassed).
 * PREF:
 *	Use of pre-filter:	0 = pre-filter off.
 *				1 = pre-filter on.
 *	May be used if chrominance trap is active.
 * BPSS1 BPSS0:
 *	Aperture bandpass to select different characteristics with maximums
 *	(0.2 to 0.3 x LLC / 2).
 *	See technical specs for desired characteristics.
 * CORI1 CORI2:
 *	Coring range for high frequency components according to 8-bit
 *	luminance.
 *	CORI1	CORI2	coring
 *	-----	-----	----------
 *	0	0	coring off
 *	0	1	+-1 LSB
 *	1	0	+-2 LSB
 *	1	1	+-3 LSB
 * APER1 APER0:
 *	Aperture bandpass filter weights high frequency components of 
 *	luminance signal:
 *	APER1	APER0	factor
 *	-----	-----	------
 *	0	0	0
 *	0	1	0.25
 *	1	0	0.5
 *	1	1	1.0
 *
 * Suggested default value: 0x1 (dependent on application).
 */
#define	SUB_LUMINANCE_CONTROL		0x06
/*
 * HUE7 to HUE0:
 *	Hue control from +178.6 degrees to -180.0 degrees, equals data bytes
 *	0x7f to 0x80; 0 degrees equals 0x00.
 *	Suggested default value: 00
 */
#define	SUB_HUE_CONTROL			0x07
/*
 * CKTQ4 CKTQ3 CKTQ2 CKTQ1 CKTQ0 0 0 0:
 *	Colour-killer threshold QAM from approximately -30db to -18db, equals
 *	data bytes 0xf8 to 0x07.
 *	Suggested default value: 0xf8.
 */
#define	SUB_COLOUR_KILLER_THRES_QAM	0x08
/*
 * CKTS4 CKTS3 CKTS2 CKTS1 CKTS0 0 0 0:
 *	Colour-killer threshold SECAM from approcimately -30db to -18db, equals
 *	data bytes 0xf8 to 0x07.
 *	Suggested default value: 0xf8.
 */
#define	SUB_COLOUR_KILLER_THRES_SECAM	0x09
/*
 * PLSE7 to PLSE0:
 *	PAL switch sensitivity from LOW-to-HIGH (HIGH means immediate sequence
 *	correction), equals 0xff to 0x00, MEDIUM equals 0x80.
 *	Suggested default value: 0x90.
 */
#define	SUB_PAL_SWITCH_SENS		0x0a
/*
 * SESE7 to SESE0:
 *	SECAM switch sensitivity from LOW-to-HIGH (HIGH means immediate sequence
 *	correction), equals 0xff to 0x00, MEDIUM equals 0x80.
 *	Suggested default value: 0x90.
 */
#define	SUB_SECAM_SWITCH_SENS		0x0b
/*
 * COL0 LFIS1 LFIS0 0 0 0 0 0:
 *	COL0:
 *	Colour on bit:	0 = automatic colour-killer enabled
 *			1 = forced colour on.
 *	LFIS1 LFIS0:
 *	Chrominance gain control (AGC filter):
 *	LFIS1	LFIS0	loop filter time constant
 *	-----	-----	-------------------------
 *	0	0	slow
 *	0	1	medium
 *	1	0	fast
 *	1	1	actual gain, stored for test purposes only.
 *
 *	Suggested default value: 0x00.
 */
#define	SUB_CHROMA_GAIN_CONTROL		0x0c
/*
 * VTRC 0 0 0 NFEN HRMV GPSW0 SECS:
 *	Standard/Mode control.
 * VTRC:
 *	VTR/TV mode bit:	0 = TV mode (slow time constant)
 *				1 = VTR mode (fast time constant)
 * NFEN:
 *	SAA7191B-specific functions enable (RTC0, ODD and GPSW0 outputs)
 *	0 = outputs set to high-impedance (circuit equals SAA7191)
 *	1 = outputs active.
 * HRMV:
 *	HREF generation.
 *	0 = like SAA7191
 *	1 = HREF is 8 x LLC2 clocks earlier
 * GPSW0:
 *	General purpose switch 0:
 *	0 = output pin 65 is LOW.
 *	1 = output ping 65 is HIGH.
 * SECS:
 *	SECAM mode bit.
 *	0 = other standards.
 *	1 = SECAM.
 *
 * Suggested default value:
 *	0x00 for QUAM standards, HPLL is in TV mode; value for VCR mode is
 *		0x80 (0x81 for SECAM VCR mode).
 *	0x01 for SECAM, HPLL is in TV mode; value for VCR mode is
 *		0x80 (0x81 for SECAM VCR mode).
 */
#define	SUB_STANDARD_MODE_CONTROL	0x0d
/*
 * HPLL OEDC OEHS OEVS OEDY CHRS GPSW2 GPSW1
 *
 * HPLL:
 * 	Horizontal clock PLL:	0 = PLL closed
 *				1 = PLL circuit open and horizontal frequency
 *					fixed.
 * OEDC:
 *	Colour-difference output enable:
 *	0 = data outputs UV7 to UV0 can be set to high-impedance via FEIN.
 *	1 = data outputs UV7 to UV0 active.
 * OEHS:
 *	H-sync output enable (pins 31 and 42):
 *	0 = HS and HREF outputs high-impedance.
 *	1 = HS and HREF outputs active.
 *
 * OEVS:
 *	V-sync output enable (pin 30):
 *	0 = VS output high-impedance.
 *	1 = VS output active.
 * OEDY:
 *	Luminance output enable:
 *	0 = data outputs Y7 to Y0 can be set to high-impedance via FEIN.
 *	1 = data outputs Y7 to Y0 active.
 * CHRS:
 *	S-VHS bit (chrominance from CVBS or from chrominance input):
 *	0 = controlled by BYPS-bit (subaddress 0x06).
 *	1 = chrominance from chrominance input (CHR7 to CHR0).
 * GPSW2 GPSW1:
 *	General purpose switches:
 *	set port output pins 24 (GPSW2) and 25 (GPSW1).
 *
 * Suggested default value: 0x79,
 *			    0x7E for Y/C mode.
 */
#define	SUB_I_O_AND_CLOCK_CONTROL	0x0e
/*
 * AUFD FSEL SXCR SCEN OFTS YDEL2 YDEL1 YDEL0
 * AUFD:
 *	Automatic field detection:
 *	0 = field selection by FSEL-bit.
 *	1 = automatic field detection.
 * FSEL:
 *	Field select (AUFD=bit = 0)
 *	0 = 50 hz (625 lines).
 *	1 = 60 hz (525 lines).
 * SXCR:
 *	SECAM cross-colour reduction:
 *	0 = reduction off.
 *	1 = reduction on.
 * SCEN:
 *	Sync and clamping pulse generation:
 *	0 = HCL and HSY outputs HIGH (pins 26 and 29).
 *	1 = HCL and HSY outputs active.
 * OFTS:
 *	Select output format:
 *	0 = YUV 4 : 1 : 1 format
 *	1 = YUV 4 : 2 : 2 format
 * YDEL2 YDEL0:
 *	Luminance delay compensation:
 *	YDEL2	YDEL1	YDEL0	figure
 *	-----	-----	-----	-----------
 *	0	0	0	 0 x 2 / LLC
 *	0	0	1	+1 x 2 / LLC
 *	0	1	0	+2 x 2 / LLC
 *	0	1	1	+3 x 2 / LLC	step size = 2 / LLC =
 *	1	0	0	-4 x 2 / LLC	67.8ns for 50hz
 *	1	0	1	-2 x 2 / LLC	81.5ns for 60hz
 *	1	1	0	-3 x 2 / LLC
 *	1	1	1	-1 x 2 / LLC
 *
 * Suggested default value:	0x91	for 4:1:1 format
 *				0x99	for 4:2:2 format
 */
#define	SUB_CONTROL_1			0x0f
/*
 * 0 0 0 0 0 HRFS VNOI1 VNOI0
 * HRFS:
 *	Select HREF position:
 *	0 = normal, HREF is matched to YUV output port.
 *	1 = HREF is matched to CVBS input port.
 * VNOI1 VNOI0
 *	Vertical noise reduction
 *	VNOI1	VNOI0	mode
 *	-----	-----	----
 *	0	0	normal
 *	0	1	searching window
 *	1	0	auto-deflection
 *	1	1	vertical noise reduction bypassed.
 *
 * Suggested default value: 0x00
 */
#define	SUB_CONTROL_2			0x10
/*
 * CHCV7 to CHCV0:
 * UV
 *	Chromiance gain control (nominal values) for QAM-modulated input
 *	signals, effects output amplitude (SECAM with fixed gain):
 *	D7 D6 D5 D4 D3 D2 D1 D0	gain
 *	-- -- -- -- -- -- -- --	---------------
 *	1  1  1  1  1  1  1  1	Maximum gain
 *	   .	       .	    to
 *	0  1  0  1  1  0  0  1	CCIR level for PAL
 *	   .	       .	    to
 *	0  0  1  0  1  1  0  0	CCIR level for NTSC
 *	   .	       .	    to
 *	0  0  0  0  0  0  0  0	Minimum gain
 *
 * Suggested default value:
 *		0x2c nominal value for UV, CCIR level with NTSC source.
 *		0x59 nominal value for UV, CCIR level with PAL source.
 */
#define	SUB_CHROMA_GAIN_REF		0x11
/*
 * 0 0 0 0 0 0 0 0
 */
#define	SUB_NOT_USED_IS_ACKED_1		0x12
/*
 * 0 0 0 0 0 0 0 0
 */
#define	SUB_NOT_USED_IS_ACKED_2		0x13
/*
 * HS6B7 to HS6B0:
 *	Horizontal sync begin for 60hz, step size = 2 / LLC.  The delay time
 *	is selectable from -382/LLC (+191 decimal multiplier) to +128/LLC
 *	(-64 decimal multiplier) equals data 0xbf to 0xc0.  Two's complement
 *	numbers with ``hidden'' sign-bit.  The sign-bit is generated
 *	internally by evaluating the MSB and the MSB-1 bits.
 *
 * Suggested default value: 0x34
 */
#define	SUB_H_SYNC_BEGIN_60_HZ		0x14
/*
 * HS6S7 to HS6S0:
 *	Horizontal sync stop for 60hz, step size = 2 / LLC.  The delay time
 *	is selectable from -382/LLC (+191 decimal multiplier) to +128/LLC
 *	(-64 decimal multiplier) equals data 0xbf to 0xc0.  Two's complement
 *	numbers with ``hidden'' sign-bit.  The sign-bit is generated
 *	internally by evaluating the MSB and the MSB-1 bits.
 *
 * Suggested default value: 0x0a
 */
#define	SUB_H_SYNC_STOP_60_HZ		0x15
/*
 * HC6B7 to HC6B0:
 *	Horizontal clamp begin fro 60hz, step size is 2 / LLC.  The delay time
 *	is selectable from -254/LLC (+127 decimal multiplier) to +256/LLC
 *	(-128 decimal multiplier) equals data 0x7f to 0x80.
 *
 * Suggested default value: 0xf4
 */
#define	SUB_H_CLAMP_BEGIN_60_HZ		0x16
/*
 * HC6S7 to HC6S0:
 *	Horizontal clamp stop fro 60hz, step size is 2 / LLC.  The delay time
 *	is selectable from -254/LLC (+127 decimal multiplier) to +256/LLC
 *	(-128 decimal multiplier) equals data 0x7f to 0x80.
 *
 * Suggested default value: 0xce
 */
#define	SUB_H_CLAMP_STOP_60_HZ		0x17
/*
 * HP6I7 to HP6I0:
 *	Horizontal sync after PHI1 for 60hz, step size = 8 / LLC.  The delay
 *	time is selectable from -776/LLC (+97 decimal multiplier) to
 *	+776/LLC (-97 decimal multiplier) equals data 0x61 to 0x9f.
 *
 * Suggested default value: 0xf4
 */
#define	SUB_H_SYNC_AFTER_PHI1_60_HZ	0x18


/*
 * saa7191 routines.
 */
int		saa7191_init(unsigned char table[], int size);
unsigned char	saa7191_status(void);
int		saa7191_setv(char *name, int value);
int		saa7191_getv(char *name);
