/*=============================================================================
    Semantic actions

    Spirit V1.2
    Copyright (c) 2001, Joel de Guzman

    This software is provided 'as-is', without any express or implied
    warranty. In no event will the copyright holder be held liable for
    any damages arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute
    it freely, subject to the following restrictions:

    1.  The origin of this software must not be misrepresented; you must
        not claim that you wrote the original software. If you use this
        software in a product, an acknowledgment in the product documentation
        would be appreciated but is not required.

    2.  Altered source versions must be plainly marked as such, and must
        not be misrepresented as being the original software.

    3.  This notice may not be removed or altered from any source
        distribution.

    Acknowledgements:

        Special thanks to Dan Nuffer, John (EBo) David, Chris Uzdavinis,
        and Doug Gregor. These people are most instrumental in steering
        Spirit in the right direction.

        Special thanks also to people who have contributed to the code base
        and sample code, ported Spirit to various platforms and compilers,
        gave suggestions, reported and provided bug fixes. Alexander
        Hirner, Andy Elvey, Bogdan Kushnir, Brett Calcott, Bruce Florman,
        Changzhe Han, Colin McPhail, Hakki Dogusan, Jan Bares, Joseph
        Smith, Martijn W. van der Lee, Raghavendra Satish, Remi Delcos, Tom
        Spilman, Vladimir Prus, W. Scott Dillman, David A. Greene, Bob
        Bailey, Hartmut Kaiser.

        Finally special thanks also to people who gave feedback and
        valuable comments, particularly members of Spirit's Source Forge
        mailing list and boost.org.

    URL: http://spirit.sourceforge.net/

=============================================================================*/
#ifndef SPIRIT_ACTION_IPP
#define SPIRIT_ACTION_IPP

///////////////////////////////////////////////////////////////////////////////

#include "boost/spirit/actions.hpp"
#include "boost/spirit/iterators.hpp"
#include "boost/spirit/rule.hpp"

///////////////////////////////////////////////////////////////////////////////
namespace spirit {

///////////////////////////////////////////////////////////////////////////////
//
//  action class implementation
//
///////////////////////////////////////////////////////////////////////////////
template <typename ParserT, typename ActionT>
inline action<ParserT, ActionT>::action(
    ParserT const&  parser,
    ActionT const&   actor_)
:   unary<ParserT>(parser),
    actor(actor_)
{
}

//////////////////////////////////
template <typename ParserT, typename ActionT>
template <typename IteratorT>
inline match
action<ParserT, ActionT>::parse(IteratorT& first, IteratorT const& last) const
{
    typedef impl::strip_scanner<IteratorT> strip_scanner;
    typename strip_scanner::iterator_type
        begin = strip_scanner::get(first);

    match hit = this->subject().parse(first, last);

    if (hit)
        actor(begin, strip_scanner::get(first));
    return hit;
}

///////////////////////////////////////////////////////////////////////////////
//
//  reference_wrapper class implementation
//
///////////////////////////////////////////////////////////////////////////////
template<class T>
inline reference_wrapper<T> const
ref(T& t)
{
    return reference_wrapper<T>(t); //  Generate a reference_wrapper object.
}

//////////////////////////////////
template<typename T>
inline reference_wrapper<T>::reference_wrapper(T& ref_)
:   ref(ref_) {}

//////////////////////////////////
template<typename T>
inline reference_wrapper<T>::operator T&() const
{
    return ref;
}

//////////////////////////////////
template<typename T>
inline void
reference_wrapper<T>::operator()(T const& val) const
{
    ref = val;
}

//////////////////////////////////
template<typename T>
template <typename IteratorT>
inline void
reference_wrapper<T>::operator()(IteratorT const& begin, IteratorT const& end) const
{
    T temp(begin, end); //  Create a T object given begin/end iterators
    ref.swap(temp);     //  Swap the contents.
}

///////////////////////////////////////////////////////////////////////////////
}   //  namespace Spirit

#endif
