/*=============================================================================
    Master header file

    Spirit V1.2
    Copyright (c) 2001, Joel de Guzman

    This software is provided 'as-is', without any express or implied
    warranty. In no event will the copyright holder be held liable for
    any damages arising from the use of this software.

    Permission is granted to anyone to use this software for any purpose,
    including commercial applications, and to alter it and redistribute
    it freely, subject to the following restrictions:

    1.  The origin of this software must not be misrepresented; you must
        not claim that you wrote the original software. If you use this
        software in a product, an acknowledgment in the product documentation
        would be appreciated but is not required.

    2.  Altered source versions must be plainly marked as such, and must
        not be misrepresented as being the original software.

    3.  This notice may not be removed or altered from any source
        distribution.

    Acknowledgements:

        Special thanks to Dan Nuffer, John (EBo) David, Chris Uzdavinis,
        and Doug Gregor. These people are most instrumental in steering
        Spirit in the right direction.

        Special thanks also to people who have contributed to the code base
        and sample code, ported Spirit to various platforms and compilers,
        gave suggestions, reported and provided bug fixes. Alexander
        Hirner, Andy Elvey, Bogdan Kushnir, Brett Calcott, Bruce Florman,
        Changzhe Han, Colin McPhail, Hakki Dogusan, Jan Bares, Joseph
        Smith, Martijn W. van der Lee, Raghavendra Satish, Remi Delcos, Tom
        Spilman, Vladimir Prus, W. Scott Dillman, David A. Greene, Bob
        Bailey, Hartmut Kaiser.

        Finally special thanks also to people who gave feedback and
        valuable comments, particularly members of Spirit's Source Forge
        mailing list and boost.org.

    URL: http://spirit.sourceforge.net/

=============================================================================*/
#ifndef SPIRIT_HPP
#define SPIRIT_HPP

///////////////////////////////////////////////////////////////////////////////
#include "boost/spirit/debug.hpp"
#include "boost/spirit/actions.hpp"
#include "boost/spirit/chset.hpp"
#include "boost/spirit/composite.hpp"
#include "boost/spirit/directives.hpp"
#include "boost/spirit/exceptions.hpp"
#include "boost/spirit/iterators.hpp"
#include "boost/spirit/loops.hpp"
#include "boost/spirit/numerics.hpp"
#include "boost/spirit/operators.hpp"
#include "boost/spirit/parser.hpp"
#include "boost/spirit/primitives.hpp"
#include "boost/spirit/rule.hpp"
#include "boost/spirit/symbols.hpp"

//////////////////////////////////
#include "boost/spirit/impl/actions.ipp"
#include "boost/spirit/impl/directives.ipp"
#include "boost/spirit/impl/chset.ipp"
#include "boost/spirit/impl/exceptions.ipp"
#include "boost/spirit/impl/iterators.ipp"
#include "boost/spirit/impl/loops.ipp"
#include "boost/spirit/impl/numerics.ipp"
#include "boost/spirit/impl/operators.ipp"
#include "boost/spirit/impl/parser.ipp"
#include "boost/spirit/impl/primitives.ipp"
#include "boost/spirit/impl/rule.ipp"
#include "boost/spirit/impl/symbols.ipp"

#endif

